function regniaux(typ)
%REGNIAUX Auxiliary file for graphic management related to regnich.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96.

global pbs gr MAG PHI OM VV repco gi gj NPKK datacar datacar1...
 prfx prfy ABIL TRF1 TRF2 zpl ppl kpl zcomp pcomp kcomp TT stkn1 stkd1...
 stkn2 stkd2 stkn3 stkd3 stkn4 stkd4 stkn5 stkd5 stkn6 stkd6 stktype...
 had hha1 vcol1 vcol2 ax str car car1 HALEG LABLEG

aA=setstr(224); oA=setstr(242); EA=setstr(200);
xxtt=pbs(54); legen=pbs(58); islegen=pbs(59); TSAMP=pbs(55); hold off
ABIL=1; flgrip=0; flgset=0; flaxis=0;
if typ==1, flgrip=1; set(pbs(27),'Visible','on'), end % continue
rop=(typ==4)|(typ==21)|(typ==22)|(typ==23)|(flgrip==1);
rop=rop|(typ==35)|(typ==36)|(typ==37)|(typ==38)|(typ==41);
rop=rop|(typ==25)|(typ==26)|(typ==27)|(typ==28)|(typ==29);
rop=rop|(typ==45)|(typ==46)|(typ==47)|(typ==48);
if rop
 kdatap=datacar(1); kregt=datacar(2);
 l1=datacar(3); l2=datacar(4); l3=datacar(5); l4=datacar(6);
 zdatap=[]; pdatap=[]; zregt=[]; pregt=[];
 if l1>0, zdatap=datacar1(1:l1); end
 if l2>l1, pdatap=datacar1(l1+1:l2); end
 if l3>l2, zregt=datacar1(l2+1:l3); end
 if l4>l3, pregt=datacar1(l3+1:l4); end
end
if typ==1 % continue
 if str=='s'
  zd=[zregt;pcomp]; pd=[pregt;zcomp]; kregt=kregt/kcomp;
 else
  [zcompd,pcompd,kcompd]=inwplane(zcomp,pcomp,kcomp,TSAMP);
  zd=[zregt;pcompd]; pd=[pregt;zcompd]; kregt=kregt/kcompd;
 end
%   elimination of common zeros and poles
 tol=10^(-8);
 md=length(zd); nd=length(pd);
 iz=ones(md,1); ip=ones(nd,1);
 for kk=1:md
  for kh=1:nd
   if (abs(zd(kk)-pd(kh))<=tol)&(ip(kh)~=0)
    iz(kk)=0; ip(kh)=0; break
   end
  end
 end
 zd=zd(find(iz)); pd=pd(find(ip));
 zregt=zd; pregt=pd;
 ii=find(stktype(pbs(1),:)~=0);
 if ~isempty(ii), stktype(pbs(1),length(ii))=0; end
 datacar(2)=kregt; datacar1=datacar1(1:datacar(4));
 datacar1=[datacar1;zregt]; datacar(5)=length(datacar1);
 datacar1=[datacar1;pregt]; datacar(6)=length(datacar1);
end
if (typ==21)|(typ==22)|(typ==23)|(typ==1)
 title('')
 set(pbs(20),'Visible','on','Callback','')
 set(pbs(53),'Visible','off')
 set(pbs(18),'Visible','off')
end
if (typ==0)|(typ==3)|(typ==4)
 title('compensatori ad anticipo o ritardo con il diagramma di Nichols',...
 'Fontsize',12), set(ax(1),'Fontsize',10)
 if typ==0
  pbs(1)=1;
 elseif typ==3
  zpl=[zpl;zcomp]; ppl=[ppl;pcomp]; kpl=kpl*kcomp;
  zcomp=[]; pcomp=[]; kcomp=1;
 elseif typ==4
  if pbs(1)<6, pbs(1)=pbs(1)+1; end % flcomp
  pbs(28)=0;
  if str=='s'
   zpl=zdatap; ppl=pdatap; kpl=kdatap;
  else
   [zpl,ppl,kpl]=diwplane(zdatap,pdatap,kdatap,TSAMP);
  end
  zcomp=[]; pcomp=[]; kcomp=1;
  zregt=[]; pregt=[]; kregt=1;
  car1=[];
  aa=importf([],[],1,gj);
  datacar(2)=kregt; datacar1=datacar1(1:datacar(4));
  datacar1=[datacar1;zregt]; datacar(5)=length(datacar1);
  datacar1=[datacar1;pregt]; datacar(6)=length(datacar1);
  axes(ax(2)), cla
  set(ax(2),'FontSize',8)
  title('uscita del sistema controllato','FontSize',10);
  axes(ax(3)), cla
  set(ax(3),'FontSize',8)
  title('uscita del regolatore','FontSize',10);
  axes(ax(1))
 end
 set(pbs(60)','Visible','on'), drawnow
 set(pbs(27),'ForegroundColor',vcol2(pbs(1),:),...
 'String',['Regolatore N. ',int2str(pbs(1))],'Visible','on')
 car1=[]; TRF2=[gj,repco(pbs(1))];
 set(pbs(2),'Enable','on')   % mens (change of axis uimenu)
 set(pbs(3),'Enable','on')   % men_gr (grid uimenu)
 for kk=30:38, set(pbs(kk),'Visible','on'), end
 for kk=31:33, set(pbs(kk),'Enable','on'), end
 for kk=34:38, set(pbs(kk),'Enable','off'), end
 axes(ax(2)), cla, axes(ax(3)), cla, axes(ax(1))
 [mag,phi,om]=frespc(zpl,ppl,kpl,4,repco(7)); hold off
 VV=axis; VV(1)=-360; VV(2)=0;
 if VV(3)>-20, VV(3)=-20; end
 if VV(4)<20, VV(4)=20; end
 VV(3)=20*floor(VV(3)/20+.0001); VV(4)=20*ceil(VV(4)/20-.0001);
 [mag,phi,om]=frespc(zpl,ppl,kpl,4,repco(7)); hold off
 MAG=mag; PHI=phi; OM=om;
 [gm,pm,omgm,ompm]=gpcross(mag,phi,om,1,-180);
 if isnan(gm) | isnan(pm)
  [gm1,pm1,omg1,omp1]=gpcross1(zpl,ppl,kpl,1,-180);
  if isnan(gm), gm=gm1; omgm=omg1; end
  if isnan(pm), pm=pm1; ompm=omp1; end
 end
 if isnan(gm), gm=inf; omgm=eps; end
 if isnan(pm), ompm=eps; end
 phm0=pm+180; gm0=gm; omg0=omgm; omp0=ompm;
 if isfinite(gm)
  mess1=sprintf('margine di ampiezza: %.4g db',-20*log10(gm0));
 else
  mess1=sprintf('margine di ampiezza: infinito');
 end
 if isnan(phm0)
  mess2=sprintf('margine di fase non determinabile');
 else
  mess2=sprintf('margine di fase: %.4g gradi',phm0);
 end
 set(pbs(21),'String',mess1,'ForegroundColor',vcol2(7,:))
 set(pbs(22),'String',mess2,'ForegroundColor',vcol2(7,:))
end
if (typ==0)|(typ==3)|(typ==4)|((typ>=11)&(typ<=20))
 mag=MAG; phi=PHI; om=OM;
 mag1=20*log10(mag); phi1=phi; om1=om;
 if (mag1(1)<VV(4)) & (phi(1)<-45)
  mag1=[linspace(VV(4)+20,mag1(1),20)';mag1];
  phi1=[linspace(90*round(phi(1)/90),phi1(1),20)';phi];
  om1=[linspace(om(1)/100,om(1),20),om];
 end
 xx1=[-10^4 10^4]; xx2=[0 0]; xx3=[-180 -180]; xx4=[-90 -90]; xx5=[-270 -270];
 xx6=[-360 -360];
 ha=plot(xx1,xx2,xx3,xx1,xx2,xx1,xx4,xx1,xx5,xx1,xx6,xx1,phi1,mag1);
 set(ha(1),'Color',vcol1(7,:),'LineStyle','--')
 set(ha(2),'Color',vcol1(7,:),'LineStyle','--')
 set(ha(3),'Color',vcol1(7,:),'LineStyle',':')
 set(ha(4),'Color',vcol1(7,:),'LineStyle',':')
 set(ha(5),'Color',vcol1(7,:),'LineStyle',':')
 set(ha(6),'Color',vcol1(7,:),'LineStyle',':')
 set(ha(7),'Color',vcol1(7,:),'LineStyle','-')
end
if (typ==0)|(typ==3)|(typ==4)
 axis(VV)
elseif typ==11
 VV(1)=VV(1)+30; if VV(1)>=VV(2), VV(1)=VV(1)-30; end, axis(VV)
elseif typ==12
 VV(1)=VV(1)-30; if VV(1)>=VV(2), VV(1)=VV(1)+30; end, axis(VV)
elseif typ==13
 VV(2)=VV(2)+30; if VV(1)>=VV(2), VV(2)=VV(2)-30; end, axis(VV)
elseif typ==14
 VV(2)=VV(2)-30; if VV(1)>=VV(2), VV(2)=VV(2)+30; end, axis(VV)
elseif typ==15
 VV(4)=VV(4)+20; if VV(3)>=VV(4), VV(4)=VV(4)-20; end, axis(VV)
elseif typ==16
 VV(4)=VV(4)-20; if VV(3)>=VV(4), VV(4)=VV(4)+20; end, axis(VV)
elseif typ==17
 VV(3)=VV(3)+20; if VV(3)>=VV(4), VV(3)=VV(3)-20; end, axis(VV)
elseif typ==18
 VV(3)=VV(3)-20; if VV(3)>=VV(4), VV(3)=VV(3)+20; end, axis(VV)
elseif typ==19
 VV=[-360 0 -40 40]; axis(VV)
elseif typ==20
 if pbs(28)==0
  axis(VV), hold on, eval('nigrid'), pbs(28)=1;
 else
  axis(VV), pbs(28)=0;
 end
elseif typ==25
 TT1=TT; TT1(2)=TT1(2)/2+.001*(TT1(2)/2-TT1(1)); flaxis=1;
elseif typ==26
 TT1=TT; TT1(2)=TT1(2)/5+.001*(TT1(2)/5-TT1(1)); flaxis=1;
elseif typ==27
 TT1=TT; TT1(2)=TT1(2)/10+.001*(TT1(2)/10-TT1(1)); flaxis=1;
elseif typ==28
 TT1=TT; TT1(2)=TT1(2)/20+.001*(TT1(2)/20-TT1(1)); flaxis=1;
elseif typ==29
 TT1=TT; flaxis=1;
end
if (typ==0)|(typ==3)|(typ==4)|((typ>=11)&(typ<=20))
 xtick=VV(1):30:VV(2); ytick=VV(3):20:VV(4);
 set(gca,'Xtick',xtick), set(gca,'Ytick',ytick)
 xxt=VV(2)+.02*(VV(2)-VV(1));
 for kk=1:length(ytick)
  text(xxt,ytick(kk),int2str(ytick(kk)),'FontSize',10)
 end
 mg=mag; ph=phi; omg=om; x3n=ph; y3n=20*log10(mg); hha1=[];
 hha1=prnaux(x3n,y3n,omg,hha1,7,repco,VV,mg); hha1=[];
 set(pbs(21),'Visible','on'), set(pbs(22),'Visible','on')
 if islegen
  VV=axis; xx=2*VV(1)-VV(2); yy=2*VV(3)-VV(4);
  LABLEG=['''',gi,''',''',[gi,' ',gj],''''];
  hold on, HAL=plot(xx,yy,xx,yy);
  set(HAL(1),'Color',vcol1(7,:)), set(HAL(2),'Color',vcol1(pbs(1),:))
  hold off
  if legen==1, eval(['legend(HAL,',LABLEG,',4)']); end
 end
 if gr==0, grid off, else, grid on, end
 title('compensatori ad anticipo o ritardo con il diagramma di Nichols',...
 'Fontsize',12), set(ax(1),'Fontsize',10)
 if (typ~=20)&(pbs(28)==1), eval('nigrid'), end
 set(pbs(60),'Visible','off')
end
%
if typ==21
set(pbs(2),'Enable','off')   % mens (change of axis uimenu)
set(pbs(3),'Enable','off')   % men_gr (grid uimenu)
set(pbs(31),'Value',1)
xxtt=1; pbs(54)=xxtt;
mess='ANTICIPO: scegliere il punto TO con il mouse (pulsante 1)';
set(pbs(5),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',mess)
mess=['Si pu',oA,' ripetere la scelta (pulsante 2 per accettare)'];
set(pbs(6),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',mess)
for kk=30:38, set(pbs(kk),'Visible','off'), end
set(pbs(7),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String','TO:')
bb=1; hh=0; hold on, ha=[];
while bb==1
 if legen, legend, end
 [x1s,y1s,bb]=ginput(1);
 if isempty(bb), bb=2; end
 if (x1s<VV(1))&(bb==1)
  set(pbs(20),'Visible','off'), had=[had;ha]; prnaux(2)
  if legen, legend, end, return
 end
 if hh==0, bb=1; end
 if bb==1
  x1=x1s; y1=y1s;
  if hh~=0, delete(ha), end
  xx1=x1-prfx; yy1=y1-prfy;
  xx2=[x1 x1]; yy2=[-10^4 y1];
  ha=plot(xx1,yy1,xx2,yy2);
  set(ha(1),'Color',vcol1(pbs(1),:),'LineStyle',':')
  set(ha(2),'Color',vcol1(pbs(1),:),'LineStyle',':')
  sely=sprintf('M=%.3g db',y1s);
  set(pbs(8),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',sely)
  selx=sprintf('phi=%.3g gradi',x1s);
  set(pbs(9),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',selx)
 end
 hh=1;
end
set(pbs(5),'Visible','off')
set(pbs(6),'Visible','off')
%
elseif typ==22
set(pbs(2),'Enable','off')   % mens (change of axis uimenu)
set(pbs(3),'Enable','off')   % men_gr (grid uimenu)
set(pbs(32),'Value',1)
xxtt=2; pbs(54)=xxtt;
mess='RITARDO: scegliere il punto TO con il mouse (pulsante 1)';
set(pbs(5),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',mess)
mess=['Si pu',oA,' ripetere la scelta (pulsante 2 per accettare)'];
set(pbs(6),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',mess)
for kk=30:38, set(pbs(kk),'Visible','off'), end
set(pbs(7),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String','TO:')
bb=1; hh=0; hold on, ha=[];
while bb==1
 if legen, legend, end
 [x1s,y1s,bb]=ginput(1);
 if isempty(bb), bb=2; end
 if (x1s<VV(1))&(bb==1)
  set(pbs(20),'Visible','off'), had=[had;ha]; prnaux(2)
  if legen, legend, end, return
 end
 if hh==0, bb=1; end
 if bb==1
  x1=x1s; y1=y1s;
  if hh~=0, delete(ha), end
  xx1=x1+prfx; yy1=y1+prfy;
  xx2=[x1 x1]; yy2=[y1 10^4];
  ha=plot(xx1,yy1,xx2,yy2);
  set(ha(1),'Color',vcol1(pbs(1),:),'LineStyle',':')
  set(ha(2),'Color',vcol1(pbs(1),:),'LineStyle',':')
  sely=sprintf('M=%.3g db',y1s);
  set(pbs(8),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',sely)
  selx=sprintf('phi=%.3g gradi',x1s);
  set(pbs(9),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',selx)
 end
 hh=1;
end
set(pbs(5),'Visible','off')
set(pbs(6),'Visible','off')
end
%
if (typ==21)|(typ==22)|((flgrip==1)&((xxtt==1)|(xxtt==2)))
if flgrip==0
 had=[had;ha]; ha=[]; hha=[]; hhav=[]; hha1=[];
 mess='Scegliere il punto FROM con il mouse sul diagramma di Nichols';
 set(pbs(5),'ForegroundColor',vcol2(7,:),'Visible','on','String',mess)
 mess=['Si pu',oA,' ripetere la scelta (pulsante 2 per accettare)'];
 set(pbs(6),'ForegroundColor',vcol2(7,:),'Visible','on','String',mess)
 set(pbs(10),'ForegroundColor',vcol2(7,:),'Visible','on','String','FROM:')
else
 x1=pbs(41); y1=pbs(42); ha=pbs(43); hha=pbs(44); hhav=pbs(45);
 eval('delete(ha)','err=1;'), eval('delete(hha1)','err=1;'), hha1=[];
 eval('delete(hhav)','err=1;'), hhav=hha; set(hhav,'Color',vcol2(9,:))
 for kk=30:38, set(pbs(kk),'Visible','off'), end
 for kk=5:13, set(pbs(kk),'Visible','on'), end
 for kk=21:25, set(pbs(kk),'Visible','on'), end
 hold on
end
mg=MAG; ph=PHI; omg=OM; lw=length(omg); omj=j*omg; flgset=1;
x1n=ph; y1n=20*log10(mg);
bb=1; hh=0; hha1=[];
if isempty(car1)
 t1old=0; ymold=10^8; yMold=-10^8; y1mold=10^8; y1Mold=-10^8;
else
 t1old=car(1); ymold=car(2); yMold=car(3); y1mold=car(4); y1Mold=car(5);
 kold=car(6); k1old=car(7); l1=car(8); l2=car(9); l3=car(10); l4=car(11);
 zold=[]; pold=[]; z1old=[]; p1old=[];
 if l1>0, zold=car1(1:l1); end, if l2>l1, pold=car1(l1+1:l2); end
 if l3>l2, z1old=car1(l2+1:l3); end, if l4>l3, p1old=car1(l3+1:l4); end
end
while bb==1
 if legen, legend, end
 [x2s,y2s,bb]=ginput(1);
 if isempty(bb), bb=2; end
 if (x2s<VV(1))&(bb==1)
  set(pbs(20),'Visible','off'), had=[had;ha;hha;hhav;hha1];
  prnaux(2), if legen, legend, end, return
 end
 if hh==0, bb=1; end
 if bb==1
  x2=x2s; y2=y2s;
  if hh~=0
   delete(ha), hh=0; eval('delete(hhav)','err=1;')
   hhav=hha; set(hhav,'Color',vcol2(9,:)), delete(hha1), hha1=[];
   for kk=23:25, set(pbs(kk),'Visible','on','String',''), end
   hold on
  end
  dmod=y2-y1; dphi=x2-x1;
  if xxtt==1, dmod=-dmod; dphi=-dphi; end
  rop=1;
  rop=rop & (dphi>0) & (dphi<90) & (dmod>0);
  if rop
   ii=find(prfx>dphi); prfy1=prfy(ii(1));
   rop=rop & (dmod>prfy1);
  end
  if isempty(rop), rop=0; end
  if ~rop
   set(pbs(17),'Visible','on','ForegroundColor',[1 0 0])
   xyx=waitforbuttonpress; set(pbs(17),'Visible','off')
  else
   mxf=1; myf=1; [zzf,kkf]=min(myf*abs(x1n-x2)+mxf*abs(y1n-y2));
   kk1f=kkf-1; kk2f=kkf+1; if kkf==1, kk1f=1; end, if kkf==lw, kk2f=lw; end
   ww1=omg(kk1f); ww2=omg(kk2f);
   x1n1=x1n(kk1f); x1n2=x1n(kk2f); y1n1=y1n(kk1f); y1n2=y1n(kk2f);
   xx1=linspace(x1n1,x1n2,100); yy1=linspace(y1n1,y1n2,100);
   [zz,kh]=min(myf*abs(xx1-x2)+mxf*abs(yy1-y2)); ww=ww1+(ww2-ww1)*kh/100;
   % the adjusted selection
   x2=x1n1+(x1n2-x1n1)*kh/100; y2=y1n1+(y1n2-y1n1)*kh/100;
   hha=plot(x2,y2,'Color',vcol1(pbs(1),:),'LineStyle','none',...
   'Marker','o','LineWidth',2,'MarkerSize',5);
   sely=sprintf('M=%.3g db',y2);
   set(pbs(11),'ForegroundColor',vcol2(7,:),'Visible','on','String',sely)
   selx=sprintf('phi=%.3g gradi',x2);
   set(pbs(12),'ForegroundColor',vcol2(7,:),'Visible','on','String',selx)
   selz=sprintf('omega=%.3g',ww);
   set(pbs(13),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',selz)
   dmod=y2-y1; dphi=x2-x1;
   if xxtt==1, dmod=-dmod; dphi=-dphi; end
   dphir=dphi*pi/180;
   MM=10^(abs(dmod)/20);
   alpha=(MM*cos(dphir)-1)/(MM*(MM-cos(dphir)));
   if xxtt==1, tol=.001; else, tol=10^(-12); end
   if (alpha<tol)&(str=='s'), alpha=0; end % PD controller
   otau=sqrt((MM^2-1)/(1-(MM*alpha)^2));
   tau=otau/ww;
   alphas=sprintf('alfa=%.3g',alpha);
   set(pbs(14),'ForegroundColor',vcol2(pbs(1),:),...
   'Visible','on','String',alphas)
   taus=sprintf('tau=%.3g',tau);
   set(pbs(15),'ForegroundColor',vcol2(pbs(1),:),...
   'Visible','on','String',taus)
   y=ones(1,lw);
   if xxtt==1
    if alpha~=0
     kcomp=1/alpha; zcomp=-1/tau; pcomp=-1/(alpha*tau);
    else
     kcomp=tau; zcomp=-1/tau; pcomp=[];
    end
    y=y./(1+omj*alpha*tau);
    y=y.*(1+omj*tau);
   elseif xxtt==2
    if alpha~=0
     kcomp=alpha; zcomp=-1/(alpha*tau); pcomp=-1/tau;
    else
     kcomp=1/tau; zcomp=[]; pcomp=-1/tau;
    end
    y=y./(1+omj*tau);
    y=y.*(1+omj*alpha*tau);
   end
   magc=abs(y)'; phic=((angle(y))*180/pi)';
   x2n=phic; y2n=20*log10(magc);
   x3n=x1n+x2n; y3n=y1n+y2n; magsc=mg.*magc;
   if omg(1)==0, x3n(1)=x3n(2); y3n(1)=y3n(2); end
   ha=plot(x3n,y3n,'Color',vcol1(pbs(1),:),'LineStyle','-');
   hh=1;
   [gm,pm,omgm,ompm]=gpcross(magsc,x3n,omg,1,-180);
   if isnan(gm) | isnan(pm)
    [gm1,pm1,omg1,omp1]=gpcross1([zpl;zcomp],[ppl;pcomp],kpl*kcomp,1,-180);
    if isnan(gm), gm=gm1; omgm=omg1; end
    if isnan(pm), pm=pm1; ompm=omp1; end
   end
   if isnan(gm), gm=inf; omgm=eps; end
   if isnan(pm), ompm=eps; end
   phm0=pm+180; gm0=gm; omg0=omgm; omp0=ompm;
   if isfinite(gm)
    mess1=sprintf('margine di ampiezza: %.4g db',-20*log10(gm0));
   else
    mess1=sprintf('margine di ampiezza: infinito');
   end
   if isnan(phm0)
    mess2=sprintf('margine di fase non determinabile');
   else
    mess2=sprintf('margine di fase: %.4g gradi',phm0);
   end
   [num,den]=dezpk(zpl,ppl,kpl);
   [numc,denc]=dezpk(zcomp,pcomp,kcomp);
   pcloop=roots(sumpol(conv(num,numc),conv(den,denc)));
   settime=-3/max(real(pcloop));
   if settime<0, settime=NaN; end
   if str=='z', settime=TSAMP*ceil(settime/TSAMP); end
   mess3=sprintf('tempo di assestam.: %.4g sec',settime);
   set(pbs(23),'Visible','on','String',mess1)
   set(pbs(24),'Visible','on','String',mess2)
   set(pbs(25),'Visible','on','String',mess3)
   for kk=23:25, set(pbs(kk),'ForegroundColor',vcol2(pbs(1),:)), end
   hha1=prnaux(x3n,y3n,omg,hha1,pbs(1),repco,VV,mg); % drawnow
   if str=='s'
    zco=[zregt;zcomp]; pco=[pregt;pcomp]; kco=kregt*kcomp;
   else
    [zcompd,pcompd,kcompd]=inwplane(zcomp,pcomp,kcomp,TSAMP);
    zco=[zregt;zcompd]; pco=[pregt;pcompd]; kco=kregt*kcompd;
   end
   [num,den]=dezpk(zdatap,pdatap,kdatap);
   [numc,denc]=dezpk(zco,pco,kco);
   num0=conv(num,numc);
   num0reg=conv(numc,den);
   den0=sumpol(conv(num,numc),conv(den,denc));
   axes(ax(2)), reset(gca)
   set(ax(2),'FontSize',8)
   title('uscita del sistema controllato','FontSize',10);
   [z0,p0,k0]=tozpk(num0,den0);
   VA1=zeros(1,4);
   if str=='s'
    [y,t]=prnaux(z0,[p0;0],k0,201,-1);
    t1=t(length(t)); t1m=max(t1old,t1);
    [y,t]=prnaux(z0,[p0;0],k0,201,t1m);
    VA1(2)=t1m;
   else
    [y,t]=prnaux([z0;0],[p0;1],k0,-1,-1);
    t1=t(length(t)); t1m=max(t1old,t1);
    [y,t]=prnaux([z0;0],[p0;1],k0,-1,t1m); t=t*TSAMP;
    VA1(2)=t1m*TSAMP;
   end
   ym=min(y); yM=max(y);
   if (isnan(ym))|(isnan(yM)), ym=0; yM=1; end
   VA1(3)=min([0,ymold,ym]); VA1(4)=1.2*max([yMold,yM]);
   fff=0; if t1old~=0, fff=1; end
   if fff==1
    if str=='s'
     if all(real(pold)<0)
      [yr,tr]=prnaux(zold,[pold;0],kold,201,t1m);
     else
      yr=0; tr=0; ymold=0; yMold=0;
     end
    else
     if all(abs(pold)<1)
      [yr,tr]=prnaux([zold;0],[pold;1],kold,-1,t1m); tr=tr*TSAMP;
     else
      yr=0; tr=0; ymold=0; yMold=0;
     end
    end
    VA1(3)=min([0,ymold,ym]); VA1(4)=1.2*max([yMold,yM]);
    plot(tr,yr,'Color',vcol1(9,:),'LineStyle','-'), axis(VA1), hold on
    plot(t,y,'Color',vcol1(pbs(1),:),'LineStyle','-'), hold off
   else
    plot(t,y,'Color',vcol1(pbs(1),:),'LineStyle','-'), axis(VA1)
   end
   t1old=t1; ymold=ym; yMold=yM; zold=z0; pold=p0; kold=k0;
   set(ax(2),'FontSize',8)
   title('uscita del sistema controllato','FontSize',10);
   axes(ax(3)), reset(gca)
   set(ax(3),'FontSize',8)
   title('uscita del regolatore','FontSize',10);
   [z1,p1,k1]=tozpk(num0reg,den0);
   VA2=VA1;
   if str=='s'
    [y,t]=prnaux(z1,[p1;0],k1,201,t1m);
   else
    [y,t]=prnaux([z1;0],[p1;1],k1,-1,t1m); t=t*TSAMP;
   end
   y1m=min(y); y1M=max(y);
   if (isnan(y1m))|(isnan(y1M)), y1m=0; y1M=1; end
   VA2(3)=min([0,y1mold,y1m]); VA2(4)=1.2*max([y1Mold,y1M]);
   if fff==1
    if str=='s'
     if all(real(p1old)<0)
      [yr,tr]=prnaux(z1old,[p1old;0],k1old,201,t1m);
     else
      yr=0; tr=0; y1mold=0; y1Mold=0;
     end
    else
     if all(abs(p1old)<1)
      [yr,tr]=prnaux([z1old;0],[p1old;1],k1old,-1,t1m); tr=tr*TSAMP;
     else
      yr=0; tr=0; y1mold=0; y1Mold=0;
     end
    end
    VA2(3)=min([0,y1mold,y1m]); VA2(4)=max([y1Mold,y1M]);
    plot(tr,yr,'Color',vcol1(9,:),'LineStyle','-'), axis(VA2), hold on
    plot(t,y,'Color',vcol1(pbs(1),:),'LineStyle','-'), hold off
   else
    plot(t,y,'Color',vcol1(pbs(1),:),'LineStyle','-'), axis(VA2)
   end
   y1mold=y1m; y1Mold=y1M; z1old=z1; p1old=p1; k1old=k1;
   set(ax(3),'FontSize',8)
   title('uscita del regolatore','FontSize',10);
   axes(ax(1))
  end % if ~rop
 end  % if bb==1
end   % while bb==1
hold off
had=[had;ha;hha;hhav;hha1];
end % if (typ==21)|(typ==22)|((flgrip==1)&((xxtt==1)|(xxtt==2)))
%
if (typ==23)|((flgrip==1)&(xxtt==3))
set(pbs(2),'Enable','off')   % mens (change of axis uimenu)
set(pbs(3),'Enable','off')   % men_gr (grid uimenu)
set(pbs(33),'Value',1)
xxtt=3; pbs(54)=xxtt;
if flgrip==0
 had=[]; ha=[]; hha=[]; hhav=[]; hha1=[];
 mess='GUADAGNO: scegliere il punto TO con il mouse (pulsante 1)';
 set(pbs(5),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',mess)
 mess=['Si pu',oA,' ripetere la scelta (pulsante 2 per accettare)'];
 set(pbs(6),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',mess)
 for kk=30:38, set(pbs(kk),'Visible','off'), end
 set(pbs(10),'ForegroundColor',vcol2(7,:),'Visible','on','String','FROM:')
 set(pbs(7),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String','TO:')
else
 x1=pbs(41); y1=pbs(42); ha=pbs(43); hha=pbs(44); hhav=pbs(45);
 eval('delete(ha)','err=1;'), eval('delete(hha1)','err=1;'), hha1=[];
 eval('delete(hhav)','err=1;'), hhav=hha; set(hhav,'Color',vcol2(9,:))
 for kk=30:38, set(pbs(kk),'Visible','off'), end
 for kk=5:13, set(pbs(kk),'Visible','on'), end
 for kk=21:25, set(pbs(kk),'Visible','on'), end
 hold on
end
bb=1; hh=0; hha1=[]; hold on
if isempty(car1)
 t1old=0; ymold=10^8; yMold=-10^8; y1mold=10^8; y1Mold=-10^8;
else
 t1old=car(1); ymold=car(2); yMold=car(3); y1mold=car(4); y1Mold=car(5);
 kold=car(6); k1old=car(7); l1=car(8); l2=car(9); l3=car(10); l4=car(11);
 zold=[]; pold=[]; z1old=[]; p1old=[];
 if l1>0, zold=car1(1:l1); end, if l2>l1, pold=car1(l1+1:l2); end
 if l3>l2, z1old=car1(l2+1:l3); end, if l4>l3, p1old=car1(l3+1:l4); end
end
mg=MAG; ph=PHI; omg=OM; lw=length(omg); omj=j*omg; flgset=1;
while bb==1
 if legen, legend, end
 [x1s,y1s,bb]=ginput(1);
 if isempty(bb), bb=2; end
 if (x1s<VV(1))&(bb==1)
  set(pbs(20),'Visible','off'), had=[had;ha;hha;hhav;hha1];
  prnaux(2), if legen, legend, end, return
 end
 if hh==0, bb=1; end
 if bb==1
  x1=x1s; y1=y1s;
  if hh~=0
   delete(ha), hh=0; eval('delete(hhav)','err=1;')
   hhav=hha; set(hhav,'Color',vcol2(9,:))
   for krx=1:length(hha1), delete(hha1(krx)), end, hha1=[];
   set(pbs(23),'Visible','on','String','')
   set(pbs(24),'Visible','on','String','')
   set(pbs(25),'Visible','on','String','')
   for kk=23:25, set(pbs(kk),'ForegroundColor',vcol2(pbs(1),:)), end
   hold on
  end
  rop=(x1>min(ph))&(x1<max(ph));
  if ~rop
   set(pbs(17),'Visible','on','ForegroundColor',[1 0 0])
   xyx=waitforbuttonpress; set(pbs(17),'Visible','off')
  else
   xx1=[-10^4 10^4]; yy1=[y1 y1];
   xx2=[x1 x1]; yy2=[-10^4 10^4];
   harr=plot(xx1,yy1,xx2,yy2);
   set(harr(1),'Color',vcol1(pbs(1),:),'LineStyle',':')
   set(harr(2),'Color',vcol1(pbs(1),:),'LineStyle',':')
   hha1=[hha1;harr];
   sely=sprintf('M=%.3g db',y1);
   set(pbs(8),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',sely)
   selx=sprintf('phi=%.3g gradi',x1);
   set(pbs(9),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',selx)
   x1n=ph; y1n=20*log10(mg);
   mxf=1; myf=1; [zzf,kkf]=min(myf*abs(x1n-x1));
   kk1f=kkf-1; kk2f=kkf+1; if kkf==1, kk1f=1; end, if kkf==lw, kk2f=lw; end
   ww1=omg(kk1f); ww2=omg(kk2f);
   x1n1=x1n(kk1f); x1n2=x1n(kk2f); y1n1=y1n(kk1f); y1n2=y1n(kk2f);
   xx1=linspace(x1n1,x1n2,100); yy1=linspace(y1n1,y1n2,100);
   [zz,kh]=min(myf*abs(xx1-x1)); ww=ww1+(ww2-ww1)*kh/100;
% the adjusted selection on the nichols diagram
   x2=x1n1+(x1n2-x1n1)*kh/100; y2=y1n1+(y1n2-y1n1)*kh/100;
   hha=plot(x2,y2,'Color',vcol1(pbs(1),:),'LineStyle','none',...
   'Marker','o','LineWidth',2,'MarkerSize',5);
   sely=sprintf('M=%.3g db',y2);
   set(pbs(11),'ForegroundColor',vcol2(7,:),'Visible','on','String',sely)
   selx=sprintf('phi=%.3g gradi',x2);
   set(pbs(12),'ForegroundColor',vcol2(7,:),'Visible','on','String',selx)
   selz=sprintf('omega=%.3g',ww);
   set(pbs(13),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',selz)
   dmod=y1-y2;
   dgain=sprintf('dM=%.3g db',dmod);
   set(pbs(14),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',dgain)
   kcomp=10^(dmod/20); zcomp=[]; pcomp=[];
   x2n=0; y2n=dmod;
   x3n=x1n+x2n; y3n=y1n+y2n; magsc=mg*kcomp;
   ha=plot(x3n,y3n,'Color',vcol1(pbs(1),:),'LineStyle','-');
   hh=1;
   [gm,pm,omgm,ompm]=gpcross(magsc,x3n,omg,1,-180);
   if isnan(gm) | isnan(pm)
    [gm1,pm1,omg1,omp1]=gpcross1([zpl;zcomp],[ppl;pcomp],kpl*kcomp,1,-180);
    if isnan(gm), gm=gm1; omgm=omg1; end
    if isnan(pm), pm=pm1; ompm=omp1; end
   end
   if isnan(gm), gm=inf; omgm=eps; end
   if isnan(pm), ompm=eps; end
   phm0=pm+180; gm0=gm; omg0=omgm; omp0=ompm;
   if isfinite(gm)
    mess1=sprintf('margine di ampiezza: %.4g db',-20*log10(gm0));
   else
    mess1=sprintf('margine di ampiezza: infinito');
   end
   if isnan(phm0)
    mess2=sprintf('margine di fase non determinabile');
   else
    mess2=sprintf('margine di fase: %.4g gradi',phm0);
   end
   [num,den]=dezpk(zpl,ppl,kpl);
   [numc,denc]=dezpk(zcomp,pcomp,kcomp);
   pcloop=roots(sumpol(conv(num,numc),conv(den,denc)));
   settime=-3/max(real(pcloop));
   if settime<0, settime=NaN; end
   if str=='z', settime=TSAMP*ceil(settime/TSAMP); end
   mess3=sprintf('tempo di assestam.: %.4g sec',settime);
   set(pbs(23),'Visible','on','String',mess1)
   set(pbs(24),'Visible','on','String',mess2)
   set(pbs(25),'Visible','on','String',mess3)
   for kk=23:25, set(pbs(kk),'ForegroundColor',vcol2(pbs(1),:)), end
   hha1=prnaux(x3n,y3n,omg,hha1,pbs(1),repco,VV,mg);
   if str=='s'
    zco=[zregt;zcomp]; pco=[pregt;pcomp]; kco=kregt*kcomp;
   else
    [zcompd,pcompd,kcompd]=inwplane(zcomp,pcomp,kcomp,TSAMP);
    zco=[zregt;zcompd]; pco=[pregt;pcompd]; kco=kregt*kcompd;
   end
   [num,den]=dezpk(zdatap,pdatap,kdatap);
   [numc,denc]=dezpk(zco,pco,kco);
   num0=conv(num,numc);
   num0reg=conv(numc,den);
   den0=sumpol(conv(num,numc),conv(den,denc));
   axes(ax(2)), reset(gca)
   set(ax(2),'FontSize',8)
   title('uscita del sistema controllato','FontSize',10);
   [z0,p0,k0]=tozpk(num0,den0);
   VA1=zeros(1,4);
   if str=='s'
    [y,t]=prnaux(z0,[p0;0],k0,201,-1);
    t1=t(length(t)); t1m=max(t1old,t1);
    [y,t]=prnaux(z0,[p0;0],k0,201,t1m);
    VA1(2)=t1m;
   else
    [y,t]=prnaux([z0;0],[p0;1],k0,-1,-1);
    t1=t(length(t)); t1m=max(t1old,t1);
    [y,t]=prnaux([z0;0],[p0;1],k0,-1,t1m); t=t*TSAMP;
    VA1(2)=t1m*TSAMP;
   end
   ym=min(y); yM=max(y);
   if (isnan(ym))|(isnan(yM)), ym=0; yM=1; end
   VA1(3)=min([0,ymold,ym]); VA1(4)=1.2*max([yMold,yM]);
   fff=0; if t1old~=0, fff=1; end
   if fff==1
    if str=='s'
     if all(real(pold)<0)
      [yr,tr]=prnaux(zold,[pold;0],kold,201,t1m);
     else
      yr=0; tr=0;
     end
    else
     if all(abs(pold)<1)
      [yr,tr]=prnaux([zold;0],[pold;1],kold,-1,t1m); tr=tr*TSAMP;
     else
      yr=0; tr=0;
     end
    end
    plot(tr,yr,'Color',vcol1(9,:),'LineStyle','-'), axis(VA1), hold on
    plot(t,y,'Color',vcol1(pbs(1),:),'LineStyle','-'), hold off
   else
    plot(t,y,'Color',vcol1(pbs(1),:),'LineStyle','-'), axis(VA1)
   end
   t1old=t1; ymold=ym; yMold=yM; zold=z0; pold=p0; kold=k0;
   set(ax(2),'FontSize',8)
   title('uscita del sistema controllato','FontSize',10);
   axes(ax(3)), reset(gca)
   set(ax(3),'FontSize',8)
   title('uscita del regolatore','FontSize',10);
   [z1,p1,k1]=tozpk(num0reg,den0);
   VA2=VA1;
   if str=='s'
    [y,t]=prnaux(z1,[p1;0],k1,201,t1m);
   else
    [y,t]=prnaux([z1;0],[p1;1],k1,-1,t1m); t=t*TSAMP;
   end
   y1m=min(y); y1M=max(y);
   if (isnan(y1m))|(isnan(y1M)), y1m=0; y1M=1; end
   VA2(3)=min([0,y1mold,y1m]); VA2(4)=max([y1Mold,y1M]);
   if fff==1
    if str=='s'
     if all(real(p1old)<0)
      [yr,tr]=prnaux(z1old,[p1old;0],k1old,201,t1m);
     else
      yr=0; tr=0;
     end
    else
     if all(abs(p1old)<1)
      [yr,tr]=prnaux([z1old;0],[p1old;1],k1old,-1,t1m); tr=tr*TSAMP;
     else
      yr=0; tr=0;
     end
    end
    plot(tr,yr,'Color',vcol1(9,:),'LineStyle','-'), axis(VA2), hold on
    plot(t,y,'Color',vcol1(pbs(1),:),'LineStyle','-'), hold off
   else
    plot(t,y,'Color',vcol1(pbs(1),:),'LineStyle','-'), axis(VA2)
   end
   y1mold=y1m; y1Mold=y1M; z1old=z1; p1old=p1; k1old=k1;
   set(ax(3),'FontSize',8)
   title('uscita del regolatore','FontSize',10);
   axes(ax(1))
  end % if ~rop
 end % if bb==1
end % while bb==1
hold off
had=[had;ha;hha;hhav;hha1];
end % if (typ==23)|((flgrip==1)&(xxtt==3))
if flgset==1
 for kk=5:16, set(pbs(kk),'Visible','off'), end
 for kk=21:25, set(pbs(kk),'Visible','off'), end
 set(pbs(18),'Visible','off')
 car=zeros(1,11); car1=[];
 car(1)=t1old; car(2)=ymold; car(3)=yMold; car(4)=y1mold; car(5)=y1Mold;
 car(6)=kold; car(7)=k1old;
 car1=zold; car(8)=length(car1);
 car1=[car1;pold]; car(9)=length(car1);
 car1=[car1;z1old]; car(10)=length(car1);
 car1=[car1;p1old]; car(11)=length(car1);
 for kk=5:16, set(pbs(kk),'Visible','off'), end
 for kk=21:25, set(pbs(kk),'Visible','off'), end
 set(pbs(27),'Visible','off'), set(pbs(20),'Visible','off')
 for kk=30:38, set(pbs(kk),'Visible','on'), end
 for kk=31:33, set(pbs(kk),'Enable','off'), end
 for kk=34:38, set(pbs(kk),'Enable','on'), end
 set(pbs(53),'Visible','on'), set(pbs(18),'Visible','off')
 if isempty(ha), ha=0; end
 if isempty(hha), hha=0; end
 if isempty(hhav), hhav=0; end
 pbs(41)=x1; pbs(42)=y1; pbs(43)=ha; pbs(44)=hha; pbs(45)=hhav;
% car=zeros(1,11); car1=[];
% if str=='s'
%  zregt=[zregt;zcomp]; pregt=[pregt;pcomp]; kregt=kregt*kcomp;
% else
%  [zcompd,pcompd,kcompd]=inwplane(zcomp,pcomp,kcomp,TSAMP);
%  zregt=[zregt;zcompd]; pregt=[pregt;pcompd]; kregt=kregt*kcompd;
% end
 rr=pbs(1);
 zregt=zco; pregt=pco; kregt=kco;
 [numc,denc]=dezpk(zregt,pregt,kregt);
 eval(['stkn',int2str(rr),'=numc;'])
 eval(['stkd',int2str(rr),'=denc;'])
 ii=find(stktype(rr,:)==0);
 if xxtt==3
  if ~any(stktype(rr,:)==3), stktype(rr,ii(1))=3; end
 else
  stktype(rr,ii(1))=xxtt;
 end
 if str=='s'
  aa=importf(zregt,pregt,kregt,gj);
 else
  aa=importf(zregt,pregt,kregt,gj,1);
 end
 datacar(2)=kregt; datacar1=datacar1(1:datacar(4));
 datacar1=[datacar1;zregt]; datacar(5)=length(datacar1);
 datacar1=[datacar1;pregt]; datacar(6)=length(datacar1);
 title('compensatori ad anticipo o ritardo con il diagramma di Nichols',...
 'Fontsize',12), set(ax(1),'Fontsize',10)
 set(pbs(20),'Visible','off')
end % if flgset
%
if typ==31
 for kk=34:38, set(pbs(kk),'Enable','off'), end
 set(pbs(39),'Style','push','String','Uscita sistema','Visible','on',...
 'Callback','regniaux(35)')
 set(pbs(40),'Style','push','String','Uscita regolatore','Visible','on',...
 'Callback','regniaux(36)')
elseif typ==32
 for kk=34:38, set(pbs(kk),'Enable','off'), end
 set(pbs(39),'Style','push','String','Anello aperto','Visible','on',...
 'Callback','regniaux(37)')
 set(pbs(40),'Style','push','String','Anello chiuso','Visible','on',...
 'Callback','regniaux(38)')
 set(pbs(81),'Style','push','String',['Funz. di sensibilit',aA],...
 'Visible','on','Callback','regniaux(41)')
end
if (typ==35)|(typ==36)|((typ>=25)&(typ<=29))
 if typ==35, is1=0; elseif typ==36, is1=1; end
 if (typ==35)|(typ==36), pbs(82)=is1; else, is1=pbs(82); end
 if (typ>=25)&(typ<=29), flaxis=1; end
 nfig=pbs(29); nfig1=nfig+1; cc=get(0,'Children');
 if ~any(cc==nfig1)
  disp(' '), disp(['   ',EA,' STATA CANCELLATA UNA FIGURA!']), ordf, return
 end
 figure(nfig1), zoom off, cla, set(gca,'Box','on')
 if pbs(95)==0
  set(pbs(51),'Enable','on')
  for kk=92:94, set(pbs(kk),'Enable','on'), pbs(95)=1; end
 end
 set(pbs(47),'Visible','on'), set(pbs(48),'Visible','on')
 flcomp=pbs(1);
 for kk=1:flcomp
  rr=pbs(60+kk); eval('delete(rr)','err=1;')
  ii=length(find(stktype(kk,:)~=0));
  messx=[];
  for hh=1:ii
   if stktype(kk,hh)==1
    messx1='ANTICIPO';
   elseif stktype(kk,hh)==2
    messx1='RITARDO';
   elseif stktype(kk,hh)==3
    messx1='GUADAGNO';
   end
   if isempty(messx), messx=messx1; else, messx=[messx,', ',messx1]; end
  end
  mess=[gj,', colore ',repco(kk),', tipo ',messx];
  if str=='s'
   cbk=['ccregaux(6,',int2str(kk),',.1)'];
  else
   cbk=['ccregaux(6,',int2str(kk),',.1,1)'];
  end
  pbs(60+kk)=uimenu(pbs(51),'Label',mess,'Callback',cbk);
 end
%
 drawnow, reset(gca), NPKK=0;
 [num,den]=dezpk(zdatap,pdatap,kdatap);
 if flcomp==1
  [numc,denc]=dezpk(zregt,pregt,kregt);
  if is1==0
   num0=conv(num,numc);
  else
   num0=conv(numc,den);
  end
  den0=sumpol(conv(num,numc),conv(den,denc));
  [z0,p0,k0]=tozpk(num0,den0);
  if str=='s'
   if flaxis==0
    [y,t]=trespc(z0,[p0;0],k0,repco(flcomp)); TT=axis;
   else
    [y,t]=trespc(z0,[p0;0],k0,TT1(2),repco(flcomp));
   end
  else
   if flaxis==0
    [y,t]=trespd([z0;0],[p0;1],k0,repco(flcomp)); TT=axis;
    TT(2)=TT(2)*TSAMP; axis(TT)
    [y,t]=trespd([z0;0],[p0;1],k0,TSAMP,TT(2),repco(flcomp)); TT=axis;
   else
    [y,t]=trespd([z0;0],[p0;1],k0,TSAMP,TT1(2),repco(flcomp));
   end
  end
  if is1==0
   title('risposta al gradino ad anello chiuso')
  else
   title('uscita del regolatore')
  end
 else % flcomp~=1
  if flaxis==0
   TTM=0; YYm=0; YYM=0;
   for kk=1:flcomp
    eval(['numc=stkn',int2str(kk),';'])
    eval(['denc=stkd',int2str(kk),';'])
    if is1==0
     num0=conv(num,numc);
    else
     num0=conv(numc,den);
    end
    den0=sumpol(conv(num,numc),conv(den,denc));
    [z0,p0,k0]=tozpk(num0,den0);
    if str=='s'
     [y,t]=trespc(z0,[p0;0],k0,repco(kk)); TT=axis; reset(gca)
     TTM=max([TTM,TT(2)]);
    else
     [y,t]=trespd([z0;0],[p0;1],k0,repco(kk)); TT=axis; reset(gca)
     TTM=max([TTM,TT(2)*TSAMP]);
    end
    YYm=min([YYm,TT(3)]); YYM=max([YYM,TT(4)]);
   end
   TT=[0,TTM,YYm,YYM]; axis(TT), TT2=TT;
  else
   TT2=TT1;
  end
  for kk=1:flcomp
   eval(['numc=stkn',int2str(kk),';'])
   eval(['denc=stkd',int2str(kk),';'])
   if is1==0
    num0=conv(num,numc);
   else
    num0=conv(numc,den);
   end
   den0=sumpol(conv(num,numc),conv(den,denc));
   [z0,p0,k0]=tozpk(num0,den0);
   if kk==1, axis(TT2), end
   if str=='s'
    [y,t]=trespc(z0,[p0;0],k0,repco(kk));
   else
    [y,t]=trespd([z0;0],[p0;1],k0,TSAMP,TT2(2),repco(kk));
   end
   if kk==1
    if is1==0
     title('risposta al gradino ad anello chiuso')
    else
     title('uscita del regolatore')
    end
    axis(TT2)
   end
   hold on
  end
  hold off
 end
 if pbs(85)==1, grid on, end
 for kk=34:38, set(pbs(kk),'Enable','on'), end
 set(pbs(39),'Visible','off'), set(pbs(40),'Visible','off')
 set(pbs(47),'Visible','off'), set(pbs(81),'Visible','off')
end
if (typ==37)|(typ==38)|(typ==41)|((typ>=45)&(typ<=48))
 if typ==37, if1=0; elseif typ==38, if1=1; elseif typ==41, if1=2; end
 if (typ==37)|(typ==38)|(typ==41), pbs(82)=if1; else, if1=pbs(82); end
 if (typ>=45)&(typ<=48), flaxis=1; end
 nfig=pbs(29); nfig2=nfig+2; cc=get(0,'Children');
 if ~any(cc==nfig2)
  disp(' '), disp(['   ',EA,' STATA CANCELLATA UNA FIGURA!']), ordf, return
 end
 figure(nfig2)
 if pbs(100)==0
  set(pbs(52),'Enable','on')
  for kk=97:99, set(pbs(kk),'Enable','on'), pbs(100)=1; end
 end
 set(pbs(49),'Visible','on'), set(pbs(50),'Visible','on')
 subplot(2,1,1), GG=axis; zoom off, cla, set(gca,'Box','on')
 subplot(2,1,2), PP=axis; zoom off, cla, set(gca,'Box','on')
 flcomp=pbs(1);
 for kk=1:flcomp
  rr=pbs(70+kk); eval('delete(rr)','err=1;')
  ii=length(find(stktype(kk,:)~=0));
  messx=[];
  for hh=1:ii
   if stktype(kk,hh)==1
    messx1='ANTICIPO';
   elseif stktype(kk,hh)==2
    messx1='RITARDO';
   elseif stktype(kk,hh)==3
    messx1='GUADAGNO';
   end
   if isempty(messx), messx=messx1; else, messx=[messx,', ',messx1]; end
  end
  mess=[gj,', colore ',repco(kk),', tipo ',messx];
  if str=='s'
   cbk=['ccregaux(8,',int2str(kk),',.1)'];
  else
   cbk=['ccregaux(8,',int2str(kk),',.1,1)'];
  end
  pbs(70+kk)=uimenu(pbs(52),'Label',mess,'Callback',cbk);
 end
 drawnow, subplot(2,1,1), reset(gca), subplot(2,1,2), reset(gca)
 [num,den]=dezpk(zdatap,pdatap,kdatap);
 if flaxis==1
  rrr=(1.001); if typ==45, GG(1)=10^(round(log10(GG(1)/10)))/rrr;
  elseif typ==46, GG(1)=10^(round(log10(GG(1)*10)))/rrr;
  elseif typ==47, GG(2)=10^(round(log10(GG(2)*10)))*rrr;
  elseif typ==48, GG(2)=10^(round(log10(GG(2)/10)))*rrr; end
  PP(1)=GG(1); PP(2)=GG(2); OMm=GG(1); OMM=GG(2);
 end
 if flcomp==1
  [numc,denc]=dezpk(zregt,pregt,kregt);
  if if1~=2, num0=conv(num,numc); else, num0=conv(den,denc); end
  if if1==0
   den0=conv(den,denc);
  else
   den0=sumpol(conv(num,numc),conv(den,denc));
  end
  [z0,p0,k0]=tozpk(num0,den0);
  if flaxis==0
   if str=='s'
    [mag,phi,om]=frespc(z0,p0,k0,3,repco(flcomp));
   else
    ii=find(abs(z0-1)<10^(-8)); z0(ii)=ones(1,length(ii))';
    ii=find(abs(p0-1)<10^(-8)); p0(ii)=ones(1,length(ii))';
    [mag,phi,om]=frespd(z0,p0,k0,TSAMP,3,repco(flcomp));
   end
  else
   if str=='s'
    [mag,phi,om]=frespc(z0,p0,k0,3,OMm,OMM,repco(flcomp));
   else
    ii=find(abs(z0-1)<10^(-8)); z0(ii)=ones(1,length(ii))';
    ii=find(abs(p0-1)<10^(-8)); p0(ii)=ones(1,length(ii))';
    [mag,phi,om]=frespd(z0,p0,k0,TSAMP,3,OMm,repco(flcomp));
   end
  end
  subplot(2,1,1), GG=axis; GG(1)=om(1); GG(2)=om(length(om)); axis(GG)
  subplot(2,1,2), PP=axis; PP(1)=om(1); PP(2)=om(length(om)); axis(PP)
 else % flcomp~=1
  GGm=10^8; GGM=-10^8; PPm=10^8; PPM=-10^8;
  if flaxis==0, OMm=10^30; OMM=0; end
  for kk=1:flcomp
   eval(['numc=stkn',int2str(kk),';'])
   eval(['denc=stkd',int2str(kk),';'])
   if if1~=2, num0=conv(num,numc); else, num0=conv(den,denc); end
   if if1==0
    den0=conv(den,denc);
   else
    den0=sumpol(conv(num,numc),conv(den,denc));
   end
   [z0,p0,k0]=tozpk(num0,den0);
   if str=='s'
    if flaxis==0
     [mag,phi,om]=frespc(z0,p0,k0,3,repco(flcomp));
    else
     [mag,phi,om]=frespc(z0,p0,k0,3,OMm,OMM,repco(flcomp));
    end
   else
    ii=find(abs(z0-1)<10^(-8)); z0(ii)=ones(1,length(ii))';
    ii=find(abs(p0-1)<10^(-8)); p0(ii)=ones(1,length(ii))';
    if flaxis==0
     [mag,phi,om]=frespd(z0,p0,k0,TSAMP,3,repco(flcomp));
    else
     [mag,phi,om]=frespd(z0,p0,k0,TSAMP,3,OMm,repco(flcomp));
    end
   end
   subplot(2,1,1), GG=axis; subplot(2,1,2), PP=axis;
   GGm=min([GGm,GG(3)]); GGM=max([GGM,GG(4)]);
   PPm=min([PPm,PP(3)]); PPM=max([PPM,PP(4)]);
   if flaxis==0, OMm=min([OMm,GG(1)]); OMM=max([OMM,GG(2)]); end
   subplot(2,1,1), reset(gca), subplot(2,1,2), reset(gca)
  end % for kk
  GG=[OMm,OMM,GGm,GGM]; PP=[OMm,OMM,PPm,PPM];
  for hh=1:2
   for kk=1:flcomp
    eval(['numc=stkn',int2str(kk),';'])
    eval(['denc=stkd',int2str(kk),';'])
    if if1~=2, num0=conv(num,numc); else, num0=conv(den,denc); end
    if if1==0
     den0=conv(den,denc);
    else
     den0=sumpol(conv(num,numc),conv(den,denc));
    end
    [z0,p0,k0]=tozpk(num0,den0);
    if str=='s'
     [mag,phi,om]=frespc(z0,p0,k0,3.5,OMm,OMM,repco(1));
    else
     ii=find(abs(z0-1)<10^(-8)); z0(ii)=ones(1,length(ii))';
     ii=find(abs(p0-1)<10^(-8)); p0(ii)=ones(1,length(ii))';
     [mag,phi,om]=frespd(z0,p0,k0,TSAMP,3.5,OMm,repco(1));
    end
    ssn=[0 0]; ss2=[-180 -180];
    aat=setstr(32*ones(1,120)); aam=sprintf('rad/sec');
    mess=[aat(1:120-length(aam)),aam];
    if hh==1
     if kk==1, subplot(2,1,1), end
     mag1=20*log10(mag);
     semilogx(om,mag1,'Color',vcol1(kk,:),'LineStyle','-')
     if kk==1, axis(GG), hold on, end
     if kk==flcomp
      rr=[GG(1),GG(2)];
      semilogx(rr,ssn,'Color',vcol1(7,:),'LineStyle','--'), title('ampiezza')
      xlabel(mess)
      aat=setstr(32*ones(1,40)); aam=sprintf('db');
      mess1=[aat(1:40-length(aam)),aam]; ylabel(mess1), hold off
     end
    else
     if kk==1, subplot(2,1,2), end
     semilogx(om,phi,'Color',vcol1(kk,:),'LineStyle','-')
     if kk==1, axis(PP), hold on, end
     if kk==flcomp
      rr=[PP(1),PP(2)];
      semilogx(rr,ss2,'Color',vcol1(7,:),'LineStyle','--'), title('fase')
      xlabel(mess)
      aat=setstr(32*ones(1,40)); aam=sprintf('gradi');
      mess1=[aat(1:40-length(aam)),aam]; ylabel(mess1), hold off
     end
    end
   end % for kk
  end  % for hh
 end   % if flcomp==1
 if pbs(86)==1, subplot(2,1,1), grid on, subplot(2,1,2), grid on, end
 for kk=34:38, set(pbs(kk),'Enable','on'), end
 set(pbs(39),'Visible','off'), set(pbs(40),'Visible','off')
 set(pbs(49),'Visible','off'), set(pbs(81),'Visible','off')
end
%
if typ==39
 nfig=pbs(29);
% set(pbs(48),'Visible','off'), set(pbs(50),'Visible','off')
 set(pbs(53),'Visible','on'), set(pbs(18),'Visible','off')
 figure(nfig)
elseif typ==40
 for kk=31:38, set(pbs(kk),'Enable','off'), end
 set(pbs(53),'Visible','off'), set(pbs(18),'Visible','on')
end
% --- last line of regniaux ---
