function regdph(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8)
%REGDPH   Sintesi di regolatore per allocazione dei poli (TFI).
%   REGDPH,g1,g2,g3,g4 - da TFI
%   REGDPH('g1','g2','g3','g4') - da Matlab
%   con g1, g2 e g3 ingressi, g4 uscita
%   g1: funzione di trasferimento del sistema controllato (con n poli)
%   g2: funzione di trasferimento della parte fissa del regolatore
%	(con mr zeri ed nr poli)
%   g3: funzione di trasferimento con gli nt poli voluti
%	(nt >= 2n+mr+nr-1); gli zeri e il guadagno sono ininfluenti
%   g4: funzione di trasferimento voluta, tale che g4*g1/(1+g4*g1)
%	abbia gli stessi poli di g3.
%   NOTA: REGDPH,g1,g2 da TFI -- o REGDPH('g1','g2') da Matlab --
%	  visualizza il numero minimo di poli da assegnare (in g3) per
%	  ottenere la causalita' del regolatore g4.

% TFI Environment - 1996. Matlab5 version, 1997.

aA=setstr(224); eA=setstr(232);
err='err'; z5=[]; p5=[];
nargs=nargin;
if (nargs==1)|(nargs==3)|(nargs>4)
 disp(' **** errore: numero di argomenti non valido in regdph'), return
end
xxx=nargs;
if xxx==0
 mess='\n   f.d.t. del sistema controllato (ingresso) : ';
 arg1=input(mess,'s'); if isempty(arg1), arg1='0'; end
 if arg1=='0', return, end
 mess='\n   f.d.t. della parte fissa del regolatore (ingresso) : ';
 arg2=input(mess,'s'); if isempty(arg2), arg2='0'; end
 if arg2=='0', return, end
 mess='\n   f.d.t. con i poli ad anello chiuso da allocare (ingresso) : ';
 arg3=input(mess,'s'); if isempty(arg3), arg3='0'; end
 if arg3=='0', return, end
 mess='\n   f.d.t. del regolatore (uscita) : ';
 arg4=input(mess,'s'); if isempty(arg4), arg4='0'; end
 if arg4=='0', return, end
 nargs=4;
end
if ~exist([arg1,'.mat'])
 disp([' **** errore: ',arg1,'.mat non esiste']), return
end
if nargs>2
 if ~exist([arg3,'.mat'])
  disp([' **** errore: ',arg3,'.mat non esiste']), return
 end
end
[num1,den1,str1]=exportf(arg1,1);
[z1,p1,k1]=exportf(arg1); if isempty(k1), return, end
st1=arg2(1);
rop=(abs(st1)>=48)&(abs(st1)<=57);
if rop
 st=eval(arg2,'err');
 if isstr(st)
  disp(' **** errore di ingresso in regdph'), return
 end
else
 if ~exist([arg2,'.mat'])
  disp([' **** errore: ',arg2,'.mat non esiste']), return
 end
 st=arg2;
end
if isstr(st)
 [num2,den2,str2]=exportf(arg2,1);
 [z2,p2,k2]=exportf(arg2); if isempty(k2), return, end
else
 num2=abs(st);den2=1; str2=str1; z2=[]; p2=[]; k2=abs(st);
end
if nargs>2
 [num3,den3,str3]=exportf(arg3,1); if isempty(den3), return, end
 if str2~=str1 | str3~=str1
  disp(' **** errore: misto di f.d.t. a tempo continuo e discreto'), return
 end
 figure, tfblocks(3,arg4,arg1,'','','','','','','',''), delete(gcf), g4=arg4;
else
 if str2~=str1
  disp(' **** errore: misto di f.d.t. a tempo continuo e discreto'), return
 end
end
%
%   selection of common factors
%
tol=10^(-8);
md=length(z2); nd=length(p1);
iz=ones(md,1); ip=ones(nd,1);
for kk=1:md
 for kh=1:nd
  if (abs(z2(kk)-p1(kh))<=tol)&(ip(kh)~=0)
   iz(kk)=0; ip(kh)=0; z5=[z5;z2(kk)]; break
  end
 end
end
z2=z2(find(iz)); p1=p1(find(ip));
md=length(p2); nd=length(z1);
iz=ones(md,1); ip=ones(nd,1);
for kk=1:md
 for kh=1:nd
  if (abs(p2(kk)-z1(kh))<=tol)&(ip(kh)~=0)
   iz(kk)=0; ip(kh)=0; p5=[p5;p2(kk)]; break
  end
 end
end
p2=p2(find(iz)); z1=z1(find(ip));
if (length(z5)>0) | (length(p5)>0)
 [num1,den1]=dezpk(z1,p1,k1);
 [num2,den2]=dezpk(z2,p2,k2);
 tfm(z5,p5,1,'   fattori cancellati e ripristinati')
 disp(' '), disp('   **** premere un tasto per proseguire'), pause
end
%
if length(num1)>length(den1)
 disp(' '), disp('   **** attenzione: m > n')
end
np=length(p1); nz2=length(z2); np2=length(p2);
nz5=length(z5); np5=length(p5); ll3=2*np+nz2+np2-1+nz5-np5;
if nargs==2
 mess=['   minimo numero di poli da assegnare ',...
 'per la causalit',aA,': ',int2str(ll3)]; disp(' '), disp(mess)
 return
end
np3=length(den3)-1;
if np3 < ll3
 disp(' '), disp('   **** attenzione: regolatore non proprio')
elseif np3 > ll3
 disp(' ')
 mess=['   grado relativo positivo: i poli assegnati si possono ',...
 'ridurre di ',int2str(np3-ll3)]; disp(mess)
end
%
%   Solution of the Diophantine equation
%
aa=conv(den1,den2); bb=conv(num1,num2); cc=den3;
[xx,yy]=diopha(aa,bb,cc);
if ~any(xx)
 disp(['   **** soluzione impossibile: il denominatore dedotto ',eA,' nullo !'])
 return
end
num4=conv(yy,num2); den4=conv(xx,den2);
[z4,p4,k4]=tozpk(num4,den4);
%
%   recovering the selected common factors
%
z4=[z4;z5]; p4=[p4;p5];
%
if str1=='s'
 aa=importf(z4,p4,k4,g4);
else
 aa=importf(z4,p4,k4,g4,1);
end
if aa==1, tfg(g4), end
% --- last line of regdph ---
