function [Num,Den,k]=prodg(Num1,Den1,k1,Num2,Den2,k2,opt)
%PRODG	  Product or quotient of transfer functions (aux for TFI).
%   [Num,Den,k]=PRODG(Num1,Den1,k1,Num2,Den2,k2,opt)
%   if opt=0, PRODG gives the product G1*G2,
%   if opt=1, PRODG gives the quotient G1/G2,
%   with G1=k1*Num1/Den1;  G2=k2*Num2/Den2.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(7,7,nargs));
ln1=size(Num1); ld1=size(Den1);
ln2=size(Num2); ld2=size(Den2);
l=max([ln1(2),ld1(2),ln2(2),ld2(2)]);
if l>ln1(2), Num1=[zeros(ln1(1),l-ln1(2)) Num1]; end
if l>ld1(2), Den1=[zeros(ld1(1),l-ld1(2)) Den1]; end
if l>ln2(2), Num2=[zeros(ln2(1),l-ln2(2)) Num2]; end
if l>ld2(2), Den2=[zeros(ld2(1),l-ld2(2)) Den2]; end
if opt==0	       %multiplication
 Num=[Num1;Num2];
 Den=[Den1;Den2];
 k=k1*k2;
elseif opt==1 %  division
 Num=[Num1;Den2];
 Den=[Den1;Num2];
 k=k1/k2;
end
[Num,Den,k]=ridg(Num,Den,k);
% --- last line of prodg ---
