function prninfo(flag)
%PRNINFO  Auxiliary file for information on design of regulators.
%    **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

aA=setstr(224); eA=setstr(232); iA=setstr(236); oA=setstr(242); uA=setstr(249);
[vcol1,vcol2,repco,repcos]=coltbl;
ms2='   **** premere un tasto per proseguire';
%
if flag==1 % information on pidnich
%
 clc
 disp(' '), disp(' ')
 disp('   FUNZIONI DI TRASFERIMENTO DEI REGOLATORI')
 disp(' ')
 disp(' ')
 disp('   1 - PD :    gc(s) = Kc (1 + Td s) ;')
 disp(' ')
 disp(' ')
 disp('                                1')
 disp('   2 - PI :    gc(s) = Kc (1 + ----) ;')
 disp('                               Ti s')
 disp(' ')
 disp(' ')
 disp('                                1')
 disp('   3 - PID :   gc(s) = Kc (1 + ---- + Td s) .')
 disp('                               Ti s')
 disp(' '), disp(' ')
 disp(ms2), pause
 clc
 disp(' '), disp(' ')
 disp('   PROGETTO CON LE FORMULE DI INVERSIONE')
 disp(' ')
 disp('   Il progetto dei regolatori PD, PI o PID si effettua come segue:')
 disp(' ')
 disp('   1 - Scegliere con il mouse un punto "TO" sul piano del diagramma')
 disp('       di Nichols, corrispondente a buoni margini di ampiezza e fase:')
 disp('       siano M2, phi2 l''ampiezza e la fase corrispondenti.')
 disp(' ')
 disp('   2 - Scegliere con il mouse un punto "FROM" sul diagramma di Nichols:')
 disp('       siano M1, phi1 l''ampiezza e la fase corrispondenti, e omega0 la')
 disp('       pulsazione corrispondente sul diagramma di Nichols.')
 disp(' ')
 disp(['   NOTA: la seconda scelta ',eA,' vincolata ad appartenere ad un'])
 disp('   opportuno dominio D, dipendente dalla prima.')
 disp(' ')
 disp('   Siano M:=M2/M1, phi:=phi2-phi1 il modulo e la fase del vettore FROM-TO.')
 disp(' '), disp(' ')
 disp(ms2), pause
 clc
 disp(' '), disp(' ')
 disp('   1 - PD')
 disp(' ')
 disp(['   Il dominio D al quale M e phi devono appartenere ',eA,...
 ' definito da:'])
 disp(' ')
 disp('          0 <= phi< pi/2 .')
 disp(' ')
 disp('   Le formule di inversione del regolatore PD sono:')
 disp(' ')
 disp('          Kc = M cos(phi) ,  (omega Td) = tan(phi) ;')
 disp(' ')
 disp('   Td viene determinato come (omega Td)/omega0.')
 disp(' '), disp(' ')
 disp(ms2), pause
 clc
 disp(' '), disp(' ')
 disp('   2 - PI')
 disp(' ')
 disp(['   Il dominio D al quale M e phi devono appartenere ',eA,...
 ' definito da:'])
 disp(' ')
 disp('          -pi/2 < phi<= 0 .')
 disp(' ')
 disp('   Le formule di inversione del regolatore PI sono:')
 disp(' ')
 disp('          Kc = M cos(phi) ,  (omega Ti) = -1/tan(phi) ;')
 disp(' ')
 disp('   Ti viene determinato come (omega Ti)/omega0.')
 disp(' '), disp(' ')
 disp(ms2), pause
 clc
 disp(' '), disp(' ')
 disp('   3 - PID')
 disp(' ')
 disp(['   Il dominio D al quale M e phi devono appartenere ',eA,...
 ' definito da:'])
 disp(' ')
 disp('          -pi/2 < phi< pi/2 .')
 disp(' ')
 disp('   Le formule di inversione del regolatore PID sono:')
 disp(' ')
 disp('          Kc = M cos(phi) ,')
 disp(' ')
 disp('                       1 Ti')
 disp('          (omega Ti) = - -- [tan(phi)+sqrt(tan(phi)^2+4 (Td/Ti)] ;')
 disp('                       2 Td')
 disp(' ')
 disp('   Ti viene determinato come (omega Ti)/omega0.')
 disp(' ')
 disp(['   NOTA: ',eA,' necessario specificare il rapporto Ti/Td, il quale'])
 disp(['         rappresenta un grado di libert',aA,' nel progetto.'])
 disp(' ')
 disp(ms2), pause
%
elseif flag==2 % information on regnich
%
 nfig=gcf; clf, ordf(3), nfigs=int2str(nfig);
 clc
 disp(' '), disp(' ')
 disp('   FUNZIONI DI TRASFERIMENTO DELLE RETI CORRETTRICI')
 disp(' ')
 disp('   1 - RETE ANTICIPATRICE')
 disp(' ')
 disp('                    1 + tau s')
 disp('          gc(s) = -------------- ;')
 disp('                  1 + alfa tau s')
 disp(' ')
 disp(' ')
 disp('   2 - RETE RITARDATRICE')
 disp(' ')
 disp('                  1 + alfa tau s')
 disp('          gc(s) = -------------- .')
 disp('                    1 + tau s')
 disp(' '), disp(' ')
 disp(ms2), pause
 clc
 disp(' '), disp(' ')
 disp('   PROGETTO CON LE FORMULE DI INVERSIONE')
 disp(' ')
 disp('   Il progetto delle reti correttrici si effettua come segue:')
 disp(' ')
 disp('   1 - Scegliere con il mouse un punto "TO" sul piano del diagramma')
 disp('       di Nichols, corrispondente a buoni margini di ampiezza e fase:')
 disp('       siano M2, phi2 l''ampiezza e la fase corrispondenti.')
 disp(' ')
 disp('   2 - Scegliere con il mouse un punto "FROM" sul diagramma di Nichols:')
 disp('       siano M1, phi1 l''ampiezza e la fase corrispondenti, e omega0 la')
 disp('       pulsazione corrispondente sul diagramma di Nichols.')
 disp(' ')
 disp(['   NOTA: la seconda scelta ',eA,' vincolata ad appartenere ad un'])
 disp('   opportuno dominio D, dipendente dalla prima.')
 disp(' ')
 disp('   Siano M:=M2/M1, phi:=phi2-phi1 il modulo e la fase del vettore FROM-TO.')
 disp(' '), disp(' ')
 disp(ms2), pause
 clc
 disp(' '), disp(' ')
 disp('   1 - RETE ANTICIPATRICE')
 disp(' ')
 disp(['   Il dominio D al quale M e phi devono appartenere ',eA,...
 ' definito da:'])
 disp(' ')
 disp('          M>1, phi<=arcos(1/M) .')
 disp(' ')
 disp('   Le formule di inversione della rete anticipatrice sono:')
 disp(' ')
 disp('                 M cos(phi) - 1                  M - cos(phi)')
 disp('          alfa = -------------- ,  (omega tau) = ------------ ;')
 disp('                 M [M-cos(phi)]                    sen(phi)')
 disp(' ')
 disp('   tau viene determinato come (omega tau)/omega0.')
 disp(' '), disp(' ')
 disp(ms2), pause
 clc
 disp(' '), disp(' ')
 disp('   2 - RETE RITARDATRICE')
 disp(' ')
 disp(['   Il dominio D al quale M e phi devono appartenere ',eA,...
 ' definito da:'])
 disp(' ')
 disp('          M<1, phi>=-arcos(M) .')
 disp(' ')
 disp('   Le formule di inversione della rete ritardatrice sono:')
 disp(' ')
 disp('                 M [cos(phi)-M]                  1 - M cos(phi)')
 disp('          alfa = -------------- ,  (omega tau) = -------------- ;')
 disp('                 1 - M cos(phi)                   M sen(-phi)')
 disp(' ')
 disp('   tau viene determinato come (omega tau)/omega0.')
 disp(' '), disp(' ')
 disp(ms2), pause
 clc
 disp(' '), disp(' ')
 disp('   3 - GUADAGNO')
 disp(' ')
 disp('   In questo caso si sceglie con il mouse solo il punto "TO";')
 disp('   il punto "FROM" viene determinato automaticamente come quello')
 disp('   sul diagramam di Nichols sulla stessa verticale, che deve esistere')
 disp('   ed essere unico. La scelta definisce il fattore di guadagno:')
 disp(' ')
 disp('          Kc = M2/M1 ,')
 disp(' ')
 disp('   che viene incluso nel regolatore complessivo.')
 disp(' '), disp(' ')
 disp(ms2), pause
 clc
 disp(' '), disp(' ')
 disp('   ALCUNI DIAGRAMMI DI NICHOLS DELLA RETE ANTICIPATRICE')
 disp(' ')
 disp('   La figura riporta diagrammi di Nichols delle rete anticipatrice.')
 disp('   Per la rete ritardatrice vale la simmetria rispetto all''origine.')
 cc1=deblank(repcos(1,:)); cc2=deblank(repcos(2,:));
 mess=['   Colori: ',cc1,' = alfa costante; ',cc2,...
 ' a tratti = (omega tau) costante.'];
 disp(mess)
 disp(['   La graduazione ',eA,' in valori veri e in db (fra parentesi).'])
 disp(' ')
 disp(ms2), pause
 j=sqrt(-1);
 %alpha=logspace(0,-3,25);
 alpha=logspace(0,-3,13);
 alpha=alpha(2:length(alpha)); alpha=[alpha,0];
 %alpha=[.1,.01,.001];
 nal=length(alpha);
 nt=2000;
 ot=logspace(-3,6,nt);
 VV=[0,90,0,60]; ddx=(VV(2)-VV(1))/100; ddy=(VV(4)-VV(3))/100;
 vv=zeros(1,nt);
 plot(0,0,'Color',vcol1(8,:),'LineStyle','none','Marker','.')
 axis(VV), set(gca,'PlotBoxAspectRatioMode','manual')
 set(gca,'PlotBoxAspectRatio',[1.1,1,1])
 xtick=0:5:90; set(gca,'Xtick',xtick)
 ytick=0:5:60; set(gca,'Ytick',ytick)
 grid
 hold on
 for hh=1:nal
  for kk=1:nt
   vv(kk)=(1+j*ot(kk))/(1+j*alpha(hh)*ot(kk));
  end
  M=20*log10(abs(vv)); phi=angle(vv)*180/pi;
  plot(phi,M,'Color',vcol1(1,:),'LineStyle','-')
  if alpha(hh)~=0
   aa=alpha(hh);
   ee=floor(log10(aa)); ff=10^ee; aadb=20*log10(aa);
   mess=sprintf('%.2g',aa/ff); mess=[mess,'e',int2str(ee)];
   mess1=sprintf('%.2g',aadb); mess=[mess,' (',mess1,')'];
   ii1=find(M<=VV(4)); mt=ii1(length(ii1));
   mx=phi(mt)+4*ddx; my=M(mt)-2.6*ddy;
   text(mx,my,mess,'FontSize',8,'FontWeight','bold','Interpreter','none')
  else
   mess='\alpha=0';
   mx=VV(2)-5*ddx; my=VV(4)-5*ddy;
   text(mx,my,mess,'FontSize',8,'FontWeight','bold','Interpreter','Tex')
  end
 end
 ott=logspace(0,4,17);
 ottl=length(ott);
 nt=400;
 alt=logspace(2,-6,nt);
 vv=zeros(1,nt);
 for hh=1:ottl
  for kk=1:nt
   vv(kk)=(1+j*ott(hh))/(1+j*alt(kk)*ott(hh));
  end
  M=20*log10(abs(vv)); phi=angle(vv)*180/pi;
  plot(phi,M,'Color',vcol1(2,:),'LineStyle','--')
  aa=ott(hh)+10^(-8);
  ee=round(floor(log10(aa))); ff=10^ee; aadb=20*log10(aa);
  if aadb<10^(-4); aadb=0; end
  mess=sprintf('%.2g',aa/ff); if ee~=0, mess=[mess,'e',int2str(ee)]; end
  mess1=sprintf('%.2g',aadb); mess=[mess,' (',mess1,')'];
  ii1=find(M<=VV(4)); mt=ii1(length(ii1));
  if (aa-10^(-4))<1000
   mx=phi(mt)-28*ddx; my=M(mt)-2.6*ddy;
  else
   mx=phi(mt)+2*ddx; my=VV(4)+2.6*ddy;
   if hh==16, mx=mx-3*ddx; end
   if hh==17, mx=mx-8*ddx; end
  end
  if hh==1, mx=mx-6*ddx; my=my-.5*ddy; end
  if hh==2, mx=mx-2.5*ddx; my=my-.5*ddy; end
  text(mx,my,mess,'FontSize',8,'FontWeight','bold','Interpreter','none')
 end
 xlabel('diagrammi di Nichols della rete anticipatrice',...
 'Color',vcol2(7,:),'FontWeight','normal')
 ha=text(-.1,.84,'<<   alfa','Units','normalized','Rotation',90);
 set(ha,'Color',vcol2(1,:),'FontWeight','normal','Interpreter','none')
 ha=text(1.05,.5,'<<   omega tau','Units','normalized','Rotation',-90);
 set(ha,'Color',vcol2(2,:),'FontWeight','normal','Interpreter','none')
 hold off
 uimenu(nfig,'Label','Reticolo on/off','Callback','grid');
 figure(nfig)
 xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
%
elseif flag==3 % information on lagc
%
 nfig=gcf; clf, ordf(3), nfigs=int2str(nfig);
 wfont='normal'; % wfont='bold';
 clc
 disp(' '), disp(' ')
 disp('   RETE RITARDATRICE')
 disp(' ')
 disp('                                      1 + alfa tau s')
 disp('   Funzione di trasferimento: gc(s) = -------------- .')
 disp('                                        1 + tau s')
 disp(' ')
 disp('   Pulsazione di centro banda: om_0 = 1/(tau sqrt(alfa)) .')
 disp(' ')
 disp('                                                      1 - alfa')
 disp('   Massimo ritardo di fase (ad om_0): phi_0 = -arcsen -------- .')
 disp('                                                      1 + alfa')
 disp(' ')
 disp(' ')
 disp('   **** premere un tasto per vedere i diagrammi di Bode ');
 pause
 VV=[10^(-2),10^2,-60,20]; axis(VV)
 om1=VV(1); om2=VV(2); phi1=-90; phi2=30; alpha=.1; omc=1;
 num1=[sqrt(alpha)/omc,1]; den1=[1/(omc*sqrt(alpha)),1];
 [z1,p1,k1]=tozpk(num1,den1);
 [pho1,pho2,mag,phi,om]=bodec(z1,p1,k1,om1,om2,repco(2),phi2,phi1);
 VV=axis; axis(VV), hold on
 [oa,ga]=asymga(z1,p1,k1,om1,om2);
 semilogx(oa,20*log10(ga),'Color',vcol1(2,:),'LineStyle','-')
 phi1=pho1; phi2=pho2;
%
 alphacc=[.005 .01 .02 .05 .2 .5];
 for kk=1:6
  num1=[sqrt(alphacc(kk))/omc,1]; den1=[1/(omc*sqrt(alphacc(kk))),1];
  [z1,p1,k1]=tozpk(num1,den1);
  [pho1,pho2,mag,phi,om]=bodec(z1,p1,k1,om1,om2,repco(1),phi1,phi2);
 end
 mess='risposta in frequenza di alcune reti ritardatrici';
 ha=text(.02,.96,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Interpreter','none')
 mess='pulsazione di centro banda: 1 rad/sec per tutte';
 ha=text(.02,.91,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Interpreter','none')
 mess='alfa=0.1';
 ha=text(.02,.86,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Color',vcol2(2,:),'Interpreter','none')
 mess='alfa=0.005, 0.01, 0.02, 0.05, 0.2, 0.5';
 ha=text(.02,.81,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Color',vcol2(1,:),'Interpreter','none')
 uimenu(nfig,'Label','Reticolo on/off','Callback','grid');
 axis(VV), figure(nfig)
 xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
 clc
 disp(' ')
 disp(' ')
 disp('   PROCEDIMENTO DI PROGETTO DELLA RETE RITARDATRICE:')
 disp(' ')
 disp('   1 - vengono calcolati e mostrati il margine di fase phm e la')
 disp('       corrispondente pulsazione omm del sistema controllato;')
 disp('   2 - specificato dall''utente il margine di fase richiesto phd,')
 disp('       vengono calcolati e mostrati il valore della riduzione di')
 disp(['       guadagno alfa_0 che d',aA,' luogo a tale margine di fase e la'])
 disp('       corrispondente pulsazione om_0;')
 disp('   3 - per il primo tentativo si assume alfa=(alfa_0)/2;')
 disp('   4 - tau viene variato fra 100/(om_0*alfa_0) e 1/(10*om_0*alfa_0)')
 disp('       (400 passi) e viene scelto il valore corrispondente al')
 disp(['       margine di fase del sistema complessivo pi',uA,' vicino a phd.'])
 disp(' ')
 disp(['   In interattivo si pu',oA,' modificare il valore di alfa.'])
 disp(' ')
%
elseif flag==4 % information on leadc
%
 nfig=gcf; clf, ordf(3), nfigs=int2str(nfig);
 wfont='normal'; % wfont='bold';
 clc
 disp(' '), disp(' ')
 disp('   RETE ANTICIPATRICE')
 disp(' ')
 disp('                                        1 + tau s')
 disp('   Funzione di trasferimento: gc(s) = -------------- .')
 disp('                                      1 + alfa tau s')
 disp(' ')
 disp('   Pulsazione di centro banda: om_0 = 1/(tau sqrt(alfa)) .')
 disp(' ')
 disp('                                                      1 - alfa')
 disp('   Massimo anticipo di fase (ad om_0): phi_0 = arcsen -------- .')
 disp('                                                      1 + alfa')
 disp(' ')
 disp(' ')
 disp('   **** premere un tasto per vedere i diagrammi di Bode ');
 pause
 VV=[10^(-2),10^2,-20,60]; axis(VV)
 om1=VV(1); om2=VV(2); phi1=-30; phi2=90; alpha=.1; omc=1;
 num1=[1/(omc*sqrt(alpha)),1]; den1=[sqrt(alpha)/omc,1];
 [z1,p1,k1]=tozpk(num1,den1);
 [pho1,pho2,mag,phi,om]=bodec(z1,p1,k1,om1,om2,repco(2),phi2,phi1);
 VV=axis; axis(VV), hold on
 [oa,ga]=asymga(z1,p1,k1,om1,om2);
 semilogx(oa,20*log10(ga),'Color',vcol1(2,:),'LineStyle','-')
 phi1=pho1; phi2=pho2;
%
 alphacc=[.005 .01 .02 .05 .2 .5];
 for kk=1:6
  num1=[1/(omc*sqrt(alphacc(kk))),1]; den1=[sqrt(alphacc(kk))/omc,1];
  [z1,p1,k1]=tozpk(num1,den1);
  [pho1,pho2,mag,phi,om]=bodec(z1,p1,k1,om1,om2,repco(1),phi1,phi2);
 end
 mess='risposta in frequenza di alcune reti anticipatrici';
 ha=text(.02,.19,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Interpreter','none')
 mess='pulsazione di centro banda: 1 rad/sec per tutte';
 ha=text(.02,.14,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Interpreter','none')
 mess='alfa=0.1';
 ha=text(.02,.09,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Color',vcol2(2,:),'Interpreter','none')
 mess='alfa=0.005, 0.01, 0.02, 0.05, 0.2, 0.5';
 ha=text(.02,.04,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Color',vcol2(1,:),'Interpreter','none')
 uimenu(nfig,'Label','Reticolo on/off','Callback','grid');
 axis(VV), figure(nfig)
 xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
 clc
 disp(' ')
 disp('   PROCEDIMENTO DI PROGETTO DELLA RETE ANTICIPATRICE:')
 disp(' ')
 disp('   1 - vengono calcolati e mostrati il margine di fase phm e la')
 disp('       corrispondente pulsazione omm del sistema controllato;')
 disp('   2 - specificato dall''utente il margine di fase richiesto phd,')
 disp('       viene calcolato e mostrato il valore alfa_0 corrispondente')
 disp('       ad un anticipo di fase a centro banda pari a phd-phm;')
 disp('   3 - per il primo tentativo si assume alfa=(alfa_0)/2;')
 disp('   4 - tau viene variato fra sqrt(alfa)/omm e 1/(omm*sqrt(alfa))')
 disp('       (100 passi) e viene scelto il valore corrispondente al')
 disp('       massimo margine di fase del sistema complessivo.')
 disp(' ')
 disp(['   In interattivo si pu',oA,' modificare il valore di alfa.'])
 disp(' ')
%
elseif flag==5 % information on pidc
%
 nfig=gcf; clf, ordf(3), nfigs=int2str(nfig);
 wfont='normal'; % wfont='bold';
 clc
 disp(' '), disp(' ')
 disp('   REGOLATORE PROPORZIONALE-INTEGRALE-DERIVATIVO (PID)')
 disp(' ')
 disp('                                                1')
 disp('   Funzione di trasferimento: gc(s) = Kc ( 1 + ---- + Td s ) .')
 disp('                                               Ti s')
 disp(' ')
 disp(['   Guadagno (sensibilit',aA,' proporzionale) : Kc .'])
 disp(' ')
 disp('   Pulsazione di centro banda: om0 : 1/sqrt(Ti Td) .')
 disp(' ')
 disp('   Rapporto delle costanti di tempo ro : Ti/Td .')
 disp(' ')
 disp('   Il porre l''azione derivativa sulla sola retroazione equivale')
 disp(['   a suddividere il regolatore in due unit',aA,':'])
 disp('                                                 1')
 disp('   un regolatore di tipo PI : gcd(s) = Kc ( 1 + ---- ) ;')
 disp('                                                Ti s')
 disp(' ')
 disp('                                      Ti Td s^2 + Ti s + 1')
 disp(['   un''unit',aA,' in retroazione : gcf(s) = -------------------- .'])
 disp('                                           1 + Ti s')
 disp(' ')
 disp('   **** premere un tasto per vedere i diagrammi di Bode ');
 pause
 VV=[10^(-3),10^3,-40,40]; axis(VV)
 om1=VV(1); om2=VV(2); phi1=-120; phi2=90;
 kc=1; omc=1; rho=4; taui=sqrt(rho)/omc; taud=1/(sqrt(rho)*omc);
 num1=[taui*taud,taui,1]; den1=[taui,0]; [z1,p1,k1]=tozpk(num1,den1);
 [pho1,pho2,mag,phi,om]=bodec(z1,p1,k1,om1,om2,repco(2),phi2,phi1);
 VV=axis; axis(VV), hold on
 phi1=pho1; phi2=pho2; om1=10^VV(1); om2=10^VV(2);
%
 rhocc=[10000,1000,100,10,1];
 for kk=1:5
  kc=1; omc=1; taui=sqrt(rhocc(kk))/omc; taud=1/(sqrt(rhocc(kk))*omc);
  num1=kc*[taui*taud,taui,1]; den1=[taui,0]; [z1,p1,k1]=tozpk(num1,den1);
  [pho1,pho2,mag,phi,om]=bodec(z1,p1,k1,om1,om2,repco(1),phi1,phi2);
 end
 mess='risposta in frequenza di alcuni regolatori PID';
 ha=text(.02,.19,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Interpreter','none')
 mess='pulsazione di centro banda: 1 rad/sec per tutti';
 ha=text(.02,.14,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Interpreter','none')
 mess='Kc=1, Ti=2, Td=1/2';
 ha=text(.02,.09,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Color',vcol2(2,:),'Interpreter','none')
 mess='Kc=1, Ti=10^k, k=0,1,2,3,4, Td=1/Ti';
 ha=text(.02,.04,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Color',vcol2(1,:),'Interpreter','none')
 uimenu(nfig,'Label','Reticolo on/off','Callback','grid');
 axis(VV), figure(nfig)
 xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
 clc
 disp(' ')
 disp('   PROCEDIMENTO DI PROGETTO DEL REGOLATORE PID:')
 disp(' ')
 disp('   1 - vengono calcolati e mostrati il margine di fase phm e la')
 disp('       corrispondente pulsazione omm del sistema controllato;')
 disp('   2 - specificato dall''utente il margine di fase richiesto phd,')
 disp('       viene calcolata la pulsazione corrispondente alla fase')
 disp('       -180+phd nella risposta in frequenza dell''impianto;')
 disp('   3 - viene determinato un regolatore PID avente tale pulsazione')
 disp('       come quella di centro banda e (Ti/Td)=4;')
 disp('   4 - il margine di fase phd per il sistema complessivo viene')
 disp('       ottenuto scegliendo opportunamente il valore di Kc.')
 disp(' ')
 disp('   NOTE:')
 disp(' ')
 disp(['   1 - se l''impianto ',eA,' di tipo 1 il programma fornisce un'])
 disp(['       regolatore PD evitando cos',iA,' la doppia integrazione;'])
 disp('   2 - pertanto, se si divide per s la funzione di trasferimento')
 disp('       dell''impianto prima di usarla in PIDC si ottiene un')
 disp('       regolatore PI con Kc''=Kc Td, Ti''=Td.')
 disp(' ')
 disp('   In interattivo si possono modificare i valori di Ti e Td.')
 disp(' ')
%
elseif flag==6 % information on pidd
%
 clc
 disp(' '), disp(' ')
 disp('   REGOLATORE PROPORZIONALE-INTEGRALE-DERIVATIVO (PID) DIGITALE')
 disp(' ')
 disp(['   La funzione di trasferimento del regolatore ',eA,':'])
 disp(' ')
 disp('                     1  T z      z-1')
 disp('   gc(z) = Kc ( 1 + --- --- + Td --- ) ,')
 disp('                    Ti  z-1      T z')
 disp(' ')
 disp('   in cui T indica il tempo di campionamento.')
 disp(' ')
 disp('   NOTE:')
 disp(' ')
 disp(['   1 - se l''impianto ',eA,' di tipo 1 il programma fornisce un'])
 disp(['       regolatore PD evitando cos',iA,' la doppia integrazione;'])
 disp('   2 - pertanto, se si moltiplica per (T z)/(z-1) la funzione di')
 disp('       trasferimento dell''impianto prima di usarla in PIDD si')
 disp('       ottiene un regolatore PI con Kc''=Kc Td, Ti''=Td.')
 disp(' ')
 disp(' ')
 disp('   **** premere un tasto per proseguire')
 disp(' ')
 pause
 clc
 disp(' ')
 disp('   Il porre l''azione derivativa sulla sola retroazione equivale')
 disp(['   a suddividere il regolatore in due unit',aA,':'])
 disp(' ')
 disp('   un regolatore di tipo PI:')
 disp(' ')
 disp('                      1  T z        Ti (z-1) + T z')
 disp('   gcd(z) = Kc ( 1 + --- --- ) = Kc -------------- ;')
 disp('                     Ti  z-1           Ti (z-1)')
 disp(' ')
 disp(['   un''unit',aA,' in retroazione:'])
 disp(' ')
 disp('            Ti Td (z-1)^2 + T z [Ti (z-1) + T z]')
 disp('   gcf(z) = ------------------------------------ .')
 disp('                  T z [Ti (z-1)+ T z]')
 disp(' ')
 disp(' ')
 disp('   **** premere un tasto per proseguire')
 disp(' ')
 pause
 clc
 disp(' ')
 disp('   PROCEDIMENTO DI PROGETTO DEL REGOLATORE PID DIGITALE:')
 disp(' ')
 disp('   Il progetto viene condotto nel piano w con la stessa procedura')
 disp('   impiegata nel caso del regolatore PID analogico. Dato che')
 disp(' ')
 disp('   T z   T w + 2')
 disp('   --- = ------- ,')
 disp('   z-1     2 w')
 disp(' ')
 disp(['   il regolatore equivalente nel piano w ',eA,':'])
 disp(' ')
 disp('                       1  T w + 2        2 w')
 disp('   gc(w) = Kc * ( 1 + --- ------- + Td ------- ) .')
 disp('                      Ti    2 w        T w + 2')
end
% --- last line of prninfo ---
