function [out1,out2]=prnaux(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8)
%PRNAUX   Auxiliary file for pidnich and regnich.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global pbs had ax

if nargin==5
 z=arg1; p=arg2; k=arg3; nt=arg4; t1=arg5;
 if nt>0
  [a,b,c,d]=jorcf(z,p,k);
  if t1<0
   tol=10^(-4)*max(abs(p)); ii=find(abs(p)>tol);
   if isempty(ii)
    t1=10;
   else
    p1=p(ii); pr=abs(real(p1)); pi=abs(imag(p1));
    pir=pi./(pr+10^(-8)); pi=pi(find(pir>.1));
    pr=pr(find(pr>tol)); pi=pi(find(pi>tol)); sig=min([pr;pi]); tt=4/sig;
    vv=log10([1,1.2,1.6,2,2.5,3,4,5,8,10]);
    uu=log10(tt); uu1=floor(uu); uu2=uu-uu1;
    [ww,ii]=min(abs(vv-uu2)); t1=10^(uu1+vv(ii));
   end
  end
%
  t0=0; dt=t1/(nt-1); t=t0:dt:t1;
  ad=expm(a*dt); u=zeros(nt,1);
  if length(ad) > 0
   x=ltitr(ad,b,u,b); y=c*x.';
  else
   y=zeros(1,nt);
  end
 else
  [num,den]=dezpk(z,p,k);
  k1=t1;
  if k1<0
   pd=p(find(p~=0)); npo=length(p)-length(pd); p1=log(pd);
   tol=10^(-4)*max(abs(p1)); ii=find(abs(p1)>tol);
   if isempty(ii)
    k1=10;
   else
    p1=p1(ii); pr=abs(real(p1)); pi=abs(imag(p1));
    pir=pi./(pr+10^(-8)); pi=pi(find(pir>.1));
    pr=pr(find(pr>tol)); pi=pi(find(pi>tol)); sig=min([pr;pi]); tt=4/sig+npo;
    vv=log10([1,1.2,1.6,2,2.5,3,4,5,8,10]);
    uu=log10(tt); uu1=floor(uu); uu2=uu-uu1;
    [ww,ii]=min(abs(vv-uu2)); k1=10^(uu1+vv(ii));
   end
  end
  k0=0; k=k0:1:k1; nk=length(k);
  ttt=[zeros(1,length(den)-length(num)),num];
  y=filter(ttt,den,[1,zeros(1,nk-1)]);
  ks=zeros(1,2*nk-1); ys=zeros(1,2*nk-1); in=1;
  ks(1)=k(1); ys(1)=y(1);
  for kk=1:nk-1
   in=in+1; ks(in)=k(kk+1); ys(in)=y(kk); in=in+1;
   ks(in)=k(kk+1); ys(in)=y(kk+1);
  end
  t=ks; y=ys;
 end
 out1=y; out2=t;
 return
elseif nargin==1
 typ=arg1; hold off
 set(pbs(2),'Enable','on')   % mens (change of axis uimenu)
 set(pbs(3),'Enable','on')   % men_gr (grid uimenu)
 for kk=5:19, set(pbs(kk),'Visible','off'), end
 for kk=21:26, set(pbs(kk),'Visible','off'), end
 if typ==1 % pidnich
  title('regolatore PD, PI o PID con il diagramma di Nichols','FontSize',12)
  set(ax(1),'Fontsize',10)
  for kk=31:38, set(pbs(kk),'Visible','on'), end
  for kk=32:34, set(pbs(kk),'Enable','on'), end
  for kk=35:38, set(pbs(kk),'Enable','off'), end
 else	   % regnich
  title('compensatori ad anticipo o ritardo con il diagramma di Nichols',...
  'Fontsize',12), set(ax(1),'Fontsize',10)
  for kk=30:38, set(pbs(kk),'Visible','on'), end
  for kk=31:33, set(pbs(kk),'Enable','on'), end
  for kk=34:38, set(pbs(kk),'Enable','off'), end
 end
 for kk=1:length(had), eval('delete(had(kk))','err=1;'); end, had=[];
 axes(ax(2)), cla
 set(ax(2),'FontSize',8)
 title('uscita del sistema controllato','FontSize',10);
 axes(ax(3)), cla
 set(ax(2),'FontSize',8)
 title('uscita del regolatore','FontSize',10);
 axes(ax(1))
 set(pbs(53),'Visible','on')
 set(pbs(18),'Visible','off')
 return
else
 x3n=arg1; y3n=arg2; omg=arg3; hha1=arg4;
 ncol=arg5; repco=arg6; VV=arg7; mg=arg8;
 cfsize=get(gca,'FontSize'); fsize=8; lw=length(omg);
 rx=(VV(2)-VV(1))/(2*25); ry=(VV(4)-VV(3))/(1.5*25);
 ii=find((VV(1)<x3n)&(x3n<VV(2))&(VV(3)<y3n)&(y3n<VV(4))&(omg'>0));
 if length(ii)~=0
  hold on
  om1=omg(ii(1)); om2=omg(ii(length(ii)));
  omm=10^floor(log10(om1)); omi=omm;
  ve=[1.2,1.5,1.8,2.2,2.7,3.3,3.9,4.7,5.6,6.8,8.2,10];
  hhr=1; xv=x3n(1); yv=y3n(1); x=xv; y=yv;
  rrp=mg(2)>=mg(1);
  while (omm < om2)
   mx=1; my=1; [zz,kk]=min(abs(omg-omm));
   kk1=kk-1; kk2=kk+1; if kk==1, kk1=1; end, if kk==lw, kk2=lw; end
   ww1=omg(kk1); ww2=omg(kk2); ww=linspace(ww1,ww2,100);
   xx1=x3n(kk1); xx2=x3n(kk2); yy1=y3n(kk1); yy2=y3n(kk2);
   [zz,kh]=min(abs(ww-omm));
   if kh==1, kh=2; end
   x=xx1+(xx2-xx1)*kh/100; y=yy1+(yy2-yy1)*kh/100;
   x0=xx1+(xx2-xx1)*(kh-1)/100; y0=yy1+(yy2-yy1)*(kh-1)/100;
   stri=sprintf(' %.3g',omm);
   rop=(abs(x-xv)>length(stri)*(fsize/cfsize)*.8*rx);
   rop=rop|(abs(y-yv)>(fsize/cfsize)*1.2*ry);
   rop=rop & (omm > om1) & ((abs(x)>rx/2)|(abs(y)>ry/2)|rrp);
   rop=rop & (x>VV(1)) & (x<VV(2)) & (y>VV(3)) & (y<VV(4));
   if rop
    [han1,han2]=arrowl(x0,y0,x,y,rx/2,ry/2,repco(ncol),1);
    hha1=[hha1;han1]; hha1=[hha1;han2];
    xo=x+.5*(fsize/cfsize)*rx; yo=y-.5*(fsize/cfsize)*ry;
    if (x+length(stri)*(fsize/cfsize)*.75*rx)>VV(2)
     xo=x-length(stri)*(fsize/cfsize)*.75*rx; % yo=y+ry;
    end
    nnn=text(xo,yo,stri,'FontSize',fsize); hha1=[hha1;nnn];
    xv=x; yv=y;
   end
   if hhr==length(ve)
    omi=10*omi; omm=omi; hhr=1;
   else
    omm=ve(hhr)*omi; hhr=hhr+1;
   end
  end
 end  % length(ii)
 hold off
 if nargout==0, return, end
 out1=hha1;
end
% --- last line of prnaux ---
