function pidniaux(arg1)
%PIDNIAUX  Auxiliary file for graphic management related to pidnich.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global pbs gr MAG PHI OM VV repco gi gj NPKK...
 prfx prfy ABIL TRF1 TRF2 zpl ppl kpl zcomp pcomp kcomp TT Kc Ti Td...
 stkkc stktaud stktaui stktype vcol1 vcol2 ax had hha1 car car1...
 HALEG LABLEG

aA=setstr(224); oA=setstr(242); EA=setstr(200);
typ=arg1; ABIL=1; wfont='normal'; xxtt=pbs(54); flaxis=0; ha=[]; hold off
legen=pbs(58); islegen=pbs(59);
if typ==2, set(pbs(27),'Visible','on'), end
if (typ==21)|(typ==22)|(typ==23)|(typ==2)
 title('')
 set(pbs(20),'Visible','on','Callback','')
 set(pbs(53),'Visible','off')
 set(pbs(18),'Visible','off')
end
if typ==1
 title('regolatore PD, PI o PID con il diagramma di Nichols','FontSize',12)
 set(ax(1),'Fontsize',10)
 if pbs(1)<6, pbs(1)=pbs(1)+1; end % flcomp
 set(pbs(27),'ForegroundColor',vcol2(pbs(1),:),...
 'String',['Regolatore N. ',int2str(pbs(1))],'Visible','on')
 car1=[]; TRF2=[gj,repco(pbs(1))];
 set(pbs(2),'Enable','on')   % mens (change of axis uimenu)
 set(pbs(3),'Enable','on')   % men_gr (grid uimenu)
 [mag,phi,om]=frespc(zpl,ppl,kpl,4,repco(8)); hold off
 VV=axis; VV(1)=-360; VV(2)=0;
 if VV(3)>-20, VV(3)=-20; end
 if VV(4)<20, VV(4)=20; end
 VV(3)=20*floor(VV(3)/20+.0001); VV(4)=20*ceil(VV(4)/20-.0001);
 [mag,phi,om]=frespc(zpl,ppl,kpl,4,repco(8)); hold off
 MAG=mag; PHI=phi; OM=om;
 for kk=32:38, set(pbs(kk),'Visible','on'), end
 for kk=32:34, set(pbs(kk),'Enable','on'), end
 for kk=35:38, set(pbs(kk),'Enable','off'), end
 axes(ax(2)), cla, axes(ax(3)), cla, axes(ax(1))
 [gm,pm,omgm,ompm]=gpcross(mag,phi,om,1,-180);
 if isnan(gm) | isnan(pm)
  [gm1,pm1,omg1,omp1]=gpcross1(zpl,ppl,kpl,1,-180);
  if isnan(gm), gm=gm1; omgm=omg1; end
  if isnan(pm), pm=pm1; ompm=omp1; end
 end
 if isnan(gm), gm=inf; omgm=eps; end
 if isnan(pm), ompm=eps; end
 phm0=pm+180; gm0=gm; omg0=omgm; omp0=ompm;
 if isfinite(gm)
  mess1=sprintf('margine di ampiezza: %.4g db',-20*log10(gm0));
 else
  mess1=sprintf('margine di ampiezza: infinito');
 end
%
 if isnan(phm0)
  mess2=sprintf('margine di fase non determinabile');
 else
  mess2=sprintf('margine di fase: %.4g gradi',phm0);
 end
 set(pbs(21),'String',mess1,'ForegroundColor',vcol2(7,:))
 set(pbs(22),'String',mess2,'ForegroundColor',vcol2(7,:))
 set(pbs(60),'Visible','on'), drawnow
 pbs(28)=0;
end
if (typ==1)|((typ>=11)&(typ<=20))
 mag=MAG; phi=PHI; om=OM;
 mag1=20*log10(mag); phi1=phi; om1=om;
 if (mag1(1)<VV(4)) & (phi(1)<-45)
  mag1=[linspace(VV(4)+20,mag1(1),20)';mag1];
  phi1=[linspace(90*round(phi(1)/90),phi1(1),20)';phi];
  om1=[linspace(om(1)/100,om(1),20),om];
 end
 xx1=[-10^4 10^4]; xx2=[0 0]; xx3=[-180 -180]; xx4=[-90 -90]; xx5=[-270 -270];
 xx6=[-360 -360];
 ha=plot(xx1,xx2,xx3,xx1,xx2,xx1,xx4,xx1,xx5,xx1,xx6,xx1,phi1,mag1);
 set(ha(1),'Color',vcol1(7,:),'LineStyle','--')
 set(ha(2),'Color',vcol1(7,:),'LineStyle','--')
 set(ha(3),'Color',vcol1(7,:),'LineStyle',':')
 set(ha(4),'Color',vcol1(7,:),'LineStyle',':')
 set(ha(5),'Color',vcol1(7,:),'LineStyle',':')
 set(ha(6),'Color',vcol1(7,:),'LineStyle',':')
 set(ha(7),'Color',vcol1(7,:),'LineStyle','-')
end
if typ==1
 axis(VV)
elseif typ==11
 VV(1)=VV(1)+30; if VV(1)>=VV(2), VV(1)=VV(1)-30; end, axis(VV)
elseif typ==12
 VV(1)=VV(1)-30; if VV(1)>=VV(2), VV(1)=VV(1)+30; end, axis(VV)
elseif typ==13
 VV(2)=VV(2)+30; if VV(1)>=VV(2), VV(2)=VV(2)-30; end, axis(VV)
elseif typ==14
 VV(2)=VV(2)-30; if VV(1)>=VV(2), VV(2)=VV(2)+30; end, axis(VV)
elseif typ==15
 VV(4)=VV(4)+20; if VV(3)>=VV(4), VV(4)=VV(4)-20; end, axis(VV)
elseif typ==16
 VV(4)=VV(4)-20; if VV(3)>=VV(4), VV(4)=VV(4)+20; end, axis(VV)
elseif typ==17
 VV(3)=VV(3)+20; if VV(3)>=VV(4), VV(3)=VV(3)-20; end, axis(VV)
elseif typ==18
 VV(3)=VV(3)-20; if VV(3)>=VV(4), VV(3)=VV(3)+20; end, axis(VV)
elseif typ==19
 VV=[-360 0 -40 40]; axis(VV)
elseif typ==20
 if pbs(28)==0
  axis(VV), hold on, eval('nigrid'), pbs(28)=1;
 else
  axis(VV), pbs(28)=0;
 end
elseif typ==25
 TT1=TT; TT1(2)=TT1(2)/2+.001*(TT1(2)/2-TT1(1)); flaxis=1;
elseif typ==26
 TT1=TT; TT1(2)=TT1(2)/5+.001*(TT1(2)/5-TT1(1)); flaxis=1;
elseif typ==27
 TT1=TT; TT1(2)=TT1(2)/10+.001*(TT1(2)/10-TT1(1)); flaxis=1;
elseif typ==28
 TT1=TT; TT1(2)=TT1(2)/20+.001*(TT1(2)/20-TT1(1)); flaxis=1;
elseif typ==29
 TT1=TT; flaxis=1;
end
if (typ==1)|((typ>=11)&(typ<=20))
 xtick=VV(1):30:VV(2); ytick=VV(3):20:VV(4);
 set(gca,'Xtick',xtick), set(gca,'Ytick',ytick)
 xxt=VV(2)+.02*(VV(2)-VV(1));
 for kk=1:length(ytick)
  text(xxt,ytick(kk),int2str(ytick(kk)),'FontSize',10)
 end
 mg=mag; ph=phi; omg=om; x3n=ph; y3n=20*log10(mg); hha1=[];
 hha1=prnaux(x3n,y3n,omg,hha1,7,repco,VV,mg); hha1=[];
 set(pbs(21),'Visible','on'), set(pbs(22),'Visible','on')
 if gr==0, grid off, else, grid on, end
 if islegen
  VV=axis; xx=2*VV(1)-VV(2); yy=2*VV(3)-VV(4);
  LABLEG=['''',gi,''',''',[gi,' ',gj],''''];
  hold on, HAL=plot(xx,yy,xx,yy);
  set(HAL(1),'Color',vcol1(7,:)), set(HAL(2),'Color',vcol1(pbs(1),:))
  hold off
  if legen==1, eval(['legend(HAL,',LABLEG,',4)']); end
 end
 title('regolatore PD, PI o PID con il diagramma di Nichols','FontSize',12)
 set(ax(1),'Fontsize',10)
 set(pbs(60),'Visible','off')
 if (typ~=20)&(pbs(28)==1), eval('nigrid'), end
end
%
if typ==21
set(pbs(2),'Enable','off')   % mens (change of axis uimenu)
set(pbs(3),'Enable','off')   % men_gr (grid uimenu)
set(pbs(32),'Value',1)
xxtt=1; pbs(54)=xxtt;
mess='PD/P: scegliere il punto TO con il mouse (pulsante 1)';
set(pbs(5),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',mess)
mess=['Si pu',oA,' ripetere la scelta (pulsante 2 per accettare)'];
set(pbs(6),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',mess)
for kk=31:38, set(pbs(kk),'Visible','off'), end
set(pbs(7),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String','TO:')
bb=1; hh=0; hold on
while bb==1
 [x1s,y1s,bb]=ginput(1);
 if isempty(bb), bb=2; end
 if (x1s<VV(1))&(bb==1)
  set(pbs(20),'Visible','off'), had=[had;ha]; prnaux(1)
  if legen, legend, end, return
 end
 if hh==0, bb=1; end
 if bb==1
  x1=x1s; y1=y1s;
  if hh~=0, delete(ha), end
  xx1=x1-prfx; yy1=y1-prfy;
  xx2=[x1 x1]; yy2=[-10^4 10^4];
  xx3=[x1-90 x1-90]; yy3=[-10^4 10^4];
  ha=plot(xx1,yy1,xx2,yy2,xx3,yy3);
  for kk=1:3, set(ha(kk),'Color',vcol1(pbs(1),:),'LineStyle',':'), end
  sely=sprintf('M=%.3g db',y1s);
  set(pbs(8),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',sely)
  selx=sprintf('phi=%.3g gradi',x1s);
  set(pbs(9),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',selx)
 end
 hh=1;
end
%
elseif typ==22
set(pbs(2),'Enable','off')   % mens (change of axis uimenu)
set(pbs(3),'Enable','off')   % men_gr (grid uimenu)
set(pbs(33),'Value',1)
xxtt=2; pbs(54)=xxtt;
mess='PI/P: scegliere il punto TO con il mouse (pulsante 1)';
set(pbs(5),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',mess)
mess=['Si pu',oA,' ripetere la scelta (pulsante 2 per accettare)'];
set(pbs(6),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',mess)
for kk=31:38, set(pbs(kk),'Visible','off'), end
set(pbs(7),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String','TO:')
bb=1; hh=0; hold on
while bb==1
 [x1s,y1s,bb]=ginput(1);
 if isempty(bb), bb=2; end
 if (x1s<VV(1))&(bb==1)
  set(pbs(20),'Visible','off'), had=[had;ha]; prnaux(1)
  if legen, legend, end, return
 end
 if hh==0, bb=1; end
 if bb==1
  x1=x1s; y1=y1s;
  if hh~=0, delete(ha), end
  xx1=x1+prfx; yy1=y1-prfy;
  xx2=[x1 x1]; yy2=[-10^4 10^4];
  xx3=[x1+90 x1+90]; yy3=[-10^4 10^4];
  ha=plot(xx1,yy1,xx2,yy2,xx3,yy3);
  for kk=1:3, set(ha(kk),'Color',vcol1(pbs(1),:),'LineStyle',':'), end
  sely=sprintf('M=%.3g db',y1s);
  set(pbs(8),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',sely)
  selx=sprintf('phi=%.3g gradi',x1s);
  set(pbs(9),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',selx)
 end
 hh=1;
end
%
elseif typ==23
set(pbs(2),'Enable','off')   % mens (change of axis uimenu)
set(pbs(3),'Enable','off')   % men_gr (grid uimenu)
set(pbs(33),'Value',1)
xxtt=3; pbs(54)=xxtt;
mess='PID: scegliere il punto TO con il mouse (pulsante 1)';
set(pbs(5),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',mess)
mess=['Si pu',oA,' ripetere la scelta (pulsante 2 per accettare)'];
set(pbs(6),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',mess)
for kk=31:38, set(pbs(kk),'Visible','off'), end
%set(pbs(20),'Visible','on')
set(pbs(7),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String','TO:')
bb=1; hh=0; hold on
while bb==1
 [x1s,y1s,bb]=ginput(1);
 if isempty(bb), bb=2; end
 if (x1s<VV(1))&(bb==1)
  set(pbs(20),'Visible','off'), had=[had;ha]; prnaux(1)
  if legen, legend, end, return
 end
 if hh==0, bb=1; end
 if bb==1
  x1=x1s; y1=y1s;
  if hh~=0, delete(ha), end
  xx1=x1+prfx; yy1=y1-prfy;
  xx2=x1-prfx; yy2=y1-prfy;
  xx3=[x1 x1]; yy3=[-10^4 10^4];
  xx4=[x1+90 x1+90]; yy4=[-10^4 10^4];
  xx5=[x1-90 x1-90]; yy5=[-10^4 10^4];
  ha=plot(xx1,yy1,xx2,yy2,xx3,yy3,xx4,yy4,xx5,yy5);
  for kk=1:5, set(ha(kk),'Color',vcol1(pbs(1),:),'LineStyle',':'), end
  sely=sprintf('M=%.3g db',y1s);
  set(pbs(8),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',sely)
  selx=sprintf('phi=%.3g gradi',x1s);
  set(pbs(9),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',selx)
 end
 hh=1;
end
end
%
if (typ==21)|(typ==22)|(typ==23)
 set(pbs(5),'Visible','off')
 set(pbs(6),'Visible','off')
 pbs(41)=x1; pbs(42)=y1;
end
%
if (typ==21)|(typ==22)|(typ==23)|(typ==2)
if typ~=2
 had=[had;ha]; ha=[]; hha=[]; hhav=[]; hha1=[]; titd=0;
 if xxtt==3
  mess='Scegliere il rapporto Ti/Td - default 4';
  set(pbs(20),'Visible','off')
  set(pbs(5),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',mess)
  set(pbs(19),'Style','popup','BackgroundColor',vcol2(8,:),...
  'ForegroundColor',vcol2(pbs(1),:),'Visible','on',...
  'String','Ti/Td=4|Ti/Td=1|Ti/Td=2|Ti/Td=10|Ti/Td=20|Ti/Td=40|Ti/Td=100',...
  'Callback','pidniaux(3)')
  return
 end
end
end
%
if arg1==3,
 typ=23; x1=pbs(41); y1=pbs(42);
 had=[had;ha]; ha=[]; hha=[]; hhav=[]; hha1=[]; titd=0;
 hold on
end
%
if (typ==21)|(typ==22)|(typ==23)|(typ==2)
if typ~=2
 if xxtt==3
  set(pbs(19),'Visible','off')
  popm=get(pbs(19),'Value');
  if popm==1
   titd=4; mess='Ti/Td=4';
  elseif popm==2
   titd=1; mess='Ti/Td=1';
  elseif popm==3
   titd=2; mess='Ti/Td=2';
  elseif popm==4
   titd=10; mess='Ti/Td=10';
  elseif popm==5
   titd=20; mess='Ti/Td=20';
  elseif popm==6
   titd=40; mess='Ti/Td=40';
  elseif popm==7
   titd=100; mess='Ti/Td=100';
  end
  set(pbs(20),'Visible','on')
  set(pbs(19),'Style','text','Visible','on','BackgroundColor',vcol1(8,:),...
  'String',mess)
 end
%
 mess='Scegliere il punto FROM con il mouse sul diagramma di Nichols';
 set(pbs(5),'ForegroundColor',vcol2(7,:),'Visible','on','String',mess)
 mess=['Si pu',oA,' ripetere la scelta (pulsante 2 per accettare)'];
 set(pbs(6),'ForegroundColor',vcol2(7,:),'Visible','on','String',mess)
 set(pbs(10),'ForegroundColor',vcol2(7,:),'Visible','on','String','FROM:')
else % typ==2
 x1=pbs(41); y1=pbs(42); ha=pbs(43); hha=pbs(44); hhav=pbs(45); titd=pbs(46);
 eval('delete(ha)','err=1;'), delete(hha1), hha1=[];
 eval('delete(hhav)','err=1;'), hhav=hha; set(hhav,'Color',vcol2(9,:))
 for kk=31:38, set(pbs(kk),'Visible','off'), end
 for kk=5:16, set(pbs(kk),'Visible','on'), end
 for kk=21:25, set(pbs(kk),'Visible','on'), end
 hold on
end
mg=MAG; ph=PHI; omg=OM; lw=length(omg); omj=j*omg;
x1n=ph; y1n=20*log10(mg);
bb=1; hh=0; hha1=[];
if isempty(car1)
 t1old=0; ymold=10^8; yMold=-10^8; y1mold=10^8; y1Mold=-10^8;
else
 t1old=car(1); ymold=car(2); yMold=car(3); y1mold=car(4); y1Mold=car(5);
 kold=car(6); k1old=car(7); k2old=car(8);
 l1=car(9); l2=car(10); l3=car(11); l4=car(12); l5=car(13); l6=car(14);
 zold=[]; pold=[]; z1old=[]; p1old=[]; z2old=[]; p2old=[];
 if l1>0, zold=car1(1:l1); end, if l2>l1, pold=car1(l1+1:l2); end
 if l3>l2, z1old=car1(l2+1:l3); end, if l4>l3, p1old=car1(l3+1:l4); end
 if l5>l4, z2old=car1(l4+1:l5); end, if l6>l5, p1old=car1(l5+1:l6); end
end
if xxtt~=2
 set(pbs(26),'Visible','on')
end
while bb==1
 if legen, legend, end
 [x2s,y2s,bb]=ginput(1);
 if isempty(bb), bb=2; end
 if (x2s<VV(1))&(bb==1)
  set(pbs(20),'Visible','off'), had=[had;ha;hha;hhav;hha1];
  prnaux(1); if legen, legend, end, return
 end
 if hh==0, bb=1; end
 if bb==1
  x2=x2s; y2=y2s;
  if hh~=0
   delete(ha), hh=0; eval('delete(hhav)','err=1;')
   hhav=hha; set(hhav,'Color',vcol2(9,:)), delete(hha1), hha1=[];
   for kk=23:25, set(pbs(kk),'Visible','on','String',''), end
   hold on
  end
  dmod=y2-y1; dphi=x2-x1;
  if xxtt==1
   rop=(dphi<1) & (dphi>-90);
  elseif xxtt==2
   rop=(dphi>-1) & (dphi<90);
  elseif xxtt==3
   rop=(dphi<90) & (dphi>-90);
  end
  if ~rop
   set(pbs(17),'Visible','on','ForegroundColor',[1 0 0])
   xyx=waitforbuttonpress; set(pbs(17),'Visible','off')
  else
   mxf=1; myf=1; [zzf,kkf]=min(myf*abs(x1n-x2)+mxf*abs(y1n-y2));
   kk1f=kkf-1; kk2f=kkf+1; if kkf==1, kk1f=1; end, if kkf==lw, kk2f=lw; end
   ww1=omg(kk1f); ww2=omg(kk2f);
   x1n1=x1n(kk1f); x1n2=x1n(kk2f); y1n1=y1n(kk1f); y1n2=y1n(kk2f);
   xx1=linspace(x1n1,x1n2,100); yy1=linspace(y1n1,y1n2,100);
   [zz,kh]=min(myf*abs(xx1-x2)+mxf*abs(yy1-y2)); ww=ww1+(ww2-ww1)*kh/100;
   % the adjusted selection
   x2=x1n1+(x1n2-x1n1)*kh/100; y2=y1n1+(y1n2-y1n1)*kh/100;
   hha=plot(x2,y2,'Color',vcol1(pbs(1),:),'LineStyle','none',...
   'Marker','o','LineWidth',2,'MarkerSize',5);
   sely=sprintf('M=%.3g db',y2);
   set(pbs(11),'ForegroundColor',vcol2(7,:),'Visible','on','String',sely)
   selx=sprintf('phi=%.3g gradi',x2);
   set(pbs(12),'ForegroundColor',vcol2(7,:),'Visible','on','String',selx)
   selz=sprintf('omega=%.3g',ww);
   set(pbs(13),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',selz)
   dmod=y1-y2; dphi=x1-x2; MM=10^(dmod/20); dphir=dphi*pi/180;
   if xxtt==1 % PD inversion formulae
    if abs(dphi)<1, dphir=0; end
    Kc=MM*cos(dphir);
    if dphir==0
     Td=0; kcomp=Kc; zcomp=[]; pcomp=[];
    else
     oTd=tan(dphir); Td=oTd/ww; kcomp=Kc*Td; zcomp=-1/Td; pcomp=[];
    end
    Kcs=sprintf('Kc=%.3g',Kc);
    set(pbs(14),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',Kcs)
    Tds=sprintf('Td=%.3g',Td);
    set(pbs(15),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',Tds)
   elseif xxtt==2 % PI
    if abs(dphi)<1, dphir=0; end
    Kc=MM*cos(dphir);
    if dphir==0
     Ti=Inf; kcomp=Kc; zcomp=[]; pcomp=[];
    else
     oTi=1/tan(-dphir); Ti=oTi/ww; kcomp=Kc; zcomp=-1/Ti; pcomp=0;
    end
    Kcs=sprintf('Kc=%.3g',Kc);
    set(pbs(14),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',Kcs)
    Tis=sprintf('Ti=%.3g',Ti);
    set(pbs(15),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',Tis)
   else  % PID
    Kc=MM*cos(dphir);
    oTi=(tan(dphir)+sqrt(tan(dphir)^2+4/titd))*titd/2;
    Ti=oTi/ww; Td=Ti/titd;
    kcomp=Kc*Td; zcomp=roots([1,1/Td,1/(Ti*Td)]); pcomp=0;
    Kcs=sprintf('Kc=%.3g',Kc);
    set(pbs(14),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',Kcs)
    Tis=sprintf('Ti=%.3g',Ti);
    set(pbs(15),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',Tis)
    Tds=sprintf('Td=%.3g',Td);
    set(pbs(16),'ForegroundColor',vcol2(pbs(1),:),'Visible','on','String',Tds)
   end
   if omg(1)==0 & ~isempty(pcomp), omj(1)=omj(2); end
   y=kcomp*ones(1,lw);
   for kk=1:length(pcomp)
    y=y./(omj-pcomp(kk));
   end
   for kk=1:length(zcomp)
    y=y.*(omj-zcomp(kk));
   end
   magc=abs(y)'; phic=((angle(y))*180/pi)';
   x2n=phic; y2n=20*log10(magc);
   x3n=x1n+x2n; y3n=y1n+y2n; magsc=mg.*magc;
   if omg(1)==0, x3n(1)=x3n(2); y3n(1)=y3n(2); end
   ha=plot(x3n,y3n,'Color',vcol1(pbs(1),:),'LineStyle','-');
   hh=1;
   [gm,pm,omgm,ompm]=gpcross(magsc,x3n,omg,1,-180);
   if isnan(gm) | isnan(pm)
    [gm1,pm1,omg1,omp1]=gpcross1([zpl;zcomp],[ppl;pcomp],kpl*kcomp,1,-180);
    if isnan(gm), gm=gm1; omgm=omg1; end
    if isnan(pm), pm=pm1; ompm=omp1; end
   end
   if isnan(gm), gm=inf; omgm=eps; end
   if isnan(pm), ompm=eps; end
   phm0=pm+180; gm0=gm; omg0=omgm; omp0=ompm;
   if isfinite(gm)
    mess1=sprintf('margine di ampiezza: %.4g db',-20*log10(gm0));
   else
    mess1=sprintf('margine di ampiezza: infinito');
   end
   if isnan(phm0)
    mess2=sprintf('margine di fase non determinabile');
   else
    mess2=sprintf('margine di fase: %.4g gradi',phm0);
   end
   [num,den]=dezpk(zpl,ppl,kpl);
   [numc,denc]=dezpk(zcomp,pcomp,kcomp);
   pcloop=roots(sumpol(conv(num,numc),conv(den,denc)));
   settime=-3/max(real(pcloop));
   if settime<0, settime=NaN; end
   mess3=sprintf('tempo di assestam.: %.4g sec',settime);
   set(pbs(23),'Visible','on','String',mess1)
   set(pbs(24),'Visible','on','String',mess2)
   set(pbs(25),'Visible','on','String',mess3)
   for kk=23:25, set(pbs(kk),'ForegroundColor',vcol2(pbs(1),:)), end
   hha1=prnaux(x3n,y3n,omg,hha1,pbs(1),repco,VV,mg); % drawnow
   [num,den]=dezpk(zpl,ppl,kpl);
   if xxtt==1
    numcloop=Kc*num; numcloopd=Kc*conv(num,[Td 1]);
    numff=Kc;
    dencloop=sumpol(den,Kc*conv(num,[Td 1]));
   elseif xxtt==2
    numcloop=0; numcloopd=Kc*conv(num,[Ti 1]);
    numff=Kc*[Ti 1];
    dencloop=sumpol(conv(den,[Ti 0]),Kc*conv(num,[Ti 1]));
    if ~isfinite(Ti)
     numcloop=0; numcloopd=Kc*num; numff=Kc; dencloop=sumpol(den,Kc*num);
    end
   else
    numcloop=Kc*conv(num,[Ti 1]); numcloopd=Kc*conv(num,[Ti*Td Ti 1]);
    numff=Kc*[Ti 1];
    dencloop=sumpol(conv(den,[Ti 0]),Kc*conv(num,[Ti*Td Ti 1]));
   end
   numreg=conv(numff,den); dencloop1=[dencloop 0];
   axes(ax(2)), reset(gca)
   set(ax(2),'FontSize',8)
   title('uscita del sistema controllato','FontSize',10);
   [z0,p0,k0]=tozpk(numcloopd,dencloop1);
   [y,t]=prnaux(z0,p0,k0,201,-1);
   t1=t(length(t)); t1m=max(t1old,t1);
   [y,t]=prnaux(z0,p0,k0,201,t1m);
   ym=min(y); yM=max(y);
   if (isnan(ym))|(isnan(yM)), ym=0; yM=1; end
   VA1=zeros(1,4); VA1(2)=t1m;
   VA1(3)=min([0,ymold,ym]); VA1(4)=1.2*max([yMold,yM]);
   fff=0; if t1old~=0, fff=1; end
   if fff==1
    [yr,tr]=prnaux(zold,pold,kold,201,t1m);
    plot(tr,yr,'Color',vcol1(9,:),'LineStyle','-'), axis(VA1), hold on
    if xxtt~=2
     [y2,t2]=prnaux(z2old,p2old,k2old,201,t1m);
     plot(t2,y2,'Color',vcol1(9,:),'LineStyle',':')
    end
    plot(t,y,'Color',vcol1(pbs(1),:),'LineStyle','-')
    if xxtt~=2
     [z2,p2,k2]=tozpk(numcloop,dencloop1);
     [y2,t2]=prnaux(z2,p2,k2,201,t1m);
     plot(t2,y2,'Color',vcol1(pbs(1),:),'LineStyle',':')
    end
    hold off
   else
    plot(t,y,'Color',vcol1(pbs(1),:),'LineStyle','-'), axis(VA1)
    if xxtt~=2
     [z2,p2,k2]=tozpk(numcloop,dencloop1);
     [y2,t2]=prnaux(z2,p2,k2,201,t1m); hold on
     plot(t2,y2,'Color',vcol1(pbs(1),:),'LineStyle',':'), hold off
    end
   end
   t1old=t1; ymold=ym; yMold=yM; zold=z0; pold=p0; kold=k0;
   if xxtt~=2
    z2old=z2; p2old=p2; k2old=k2;
   else
    z2old=[]; p2old=[]; k2old=0;
   end
   set(ax(2),'FontSize',8)
   title('uscita del sistema controllato','FontSize',10);
   axes(ax(3)), reset(gca)
   set(ax(3),'FontSize',8)
   title('uscita del regolatore','FontSize',10);
   [z1,p1,k1]=tozpk(numreg,dencloop1);
   [y,t]=prnaux(z1,p1,k1,201,t1m);
   y1m=min(y); y1M=max(y);
   if (isnan(y1m))|(isnan(y1M)), y1m=0; y1M=1; end
   VA2=VA1; VA2(3)=min([0,y1mold,y1m]); VA2(4)=max([y1Mold,y1M]);
   if xxtt==2, stl='-'; else, stl=':'; end
   if fff==1
    [yr,tr]=prnaux(z1old,p1old,k1old,201,t1m);
    plot(tr,yr,'Color',vcol1(9,:),'LineStyle',stl), axis(VA2), hold on
    plot(t,y,'Color',vcol1(pbs(1),:),'LineStyle',stl), hold off
   else
    plot(t,y,'Color',vcol1(pbs(1),:),'LineStyle',stl), axis(VA2)
   end
   y1mold=y1m; y1Mold=y1M; z1old=z1; p1old=p1; k1old=k1;
   set(ax(3),'FontSize',8)
   title('uscita del regolatore','FontSize',10);
   axes(ax(1))
  end
 end
end
hold off
for kk=5:16, set(pbs(kk),'Visible','off'), end
for kk=21:27, set(pbs(kk),'Visible','off'), end
for kk=31:38, set(pbs(kk),'Visible','on'), end
for kk=32:34, set(pbs(kk),'Enable','off'), end
for kk=35:38, set(pbs(kk),'Enable','on'), end
set(pbs(19),'Visible','off')
if isempty(ha), ha=0; end
if isempty(hha), hha=0; end
if isempty(hhav), hhav=0; end
if isempty(titd), titd=0; end
pbs(41)=x1; pbs(42)=y1; pbs(43)=ha; pbs(44)=hha; pbs(45)=hhav; pbs(46)=titd;
car=zeros(1,14); car1=[];
car(1)=t1old; car(2)=ymold; car(3)=yMold; car(4)=y1mold; car(5)=y1Mold;
car(6)=kold; car(7)=k1old; car(8)=k2old;
car1=zold; car(9)=length(car1);
car1=[car1;pold]; car(10)=length(car1);
car1=[car1;z1old]; car(11)=length(car1);
car1=[car1;p1old]; car(12)=length(car1);
car1=[car1;z2old]; car(13)=length(car1);
car1=[car1;p2old]; car(14)=length(car1);
rr=pbs(1);
if xxtt==1
 stkkc(rr)=Kc; stktaui(rr)=NaN; stktaud(rr)=Td; stktype(rr)=1;
elseif xxtt==2
 stkkc(rr)=Kc; stktaui(rr)=Ti; stktaud(rr)=NaN; stktype(rr)=2;
elseif xxtt==3
 stkkc(rr)=Kc; stktaui(rr)=Ti; stktaud(rr)=Td; stktype(rr)=3;
end
aa=importf(zcomp,pcomp,kcomp,gj);
title('regolatore PD, PI o PID con il diagramma di Nichols','FontSize',12)
set(ax(1),'Fontsize',10), set(pbs(20),'Visible','off')
set(pbs(53),'Visible','on'), set(pbs(18),'Visible','off')
for kk=35:37, set(pbs(kk),'Enable','on'), end
end % if (typ==21)|(typ==22)|(typ==23)|(typ==2)
%
if typ==31
 for kk=32:38, set(pbs(kk),'Enable','off'), end
 set(pbs(39),'Style','push','String','Uscita sistema','Visible','on',...
 'Callback','pidniaux(35)')
 set(pbs(40),'Style','push','String','Uscita regolatore','Visible','on',...
 'Callback','pidniaux(36)')
elseif typ==32
 for kk=34:38, set(pbs(kk),'Enable','off'), end
 set(pbs(39),'Style','push','String','Anello aperto','Visible','on',...
 'Callback','pidniaux(37)')
 set(pbs(40),'Style','push','String','Anello chiuso','Visible','on',...
 'Callback','pidniaux(38)')
 set(pbs(81),'Style','push','String',['Funz. di sensibilit',aA],...
 'Visible','on','Callback','pidniaux(41)')
end
if (typ==35)|(typ==36)|((typ>=25)&(typ<=29))
 if typ==35, is1=0; elseif typ==36, is1=1; end
 if (typ==35)|(typ==36), pbs(82)=is1; else, is1=pbs(82); end
 if (typ>=25)&(typ<=29), flaxis=1; end
 nfig=pbs(29); nfig1=nfig+1; cc=get(0,'Children');
 if ~any(cc==nfig1)
  disp(' '), disp(['   ',EA,' STATA CANCELLATA UNA FIGURA!']), ordf, return
 end
 figure(nfig1), zoom off, cla, set(gca,'Box','on')
 if pbs(95)==0
  set(pbs(51),'Enable','on')
  for kk=92:94, set(pbs(kk),'Enable','on'), pbs(95)=1; end
 end
 set(pbs(47),'Visible','on'), set(pbs(48),'Visible','on')
 flcomp=pbs(1);
 for kk=1:flcomp
  eval('delete(pbs(60+kk))','err=1;')
 end
 for kk=1:flcomp
  if stktype(kk)==1
   messx1='PD';
  elseif stktype(kk)==2
   messx1='PI';
  else
   messx1='PID';
  end
  mess=[gj,', colore ',repco(kk),', tipo ',messx1];
  pbs(60+kk)=uimenu(pbs(51),'Label',mess,...
  'Callback',['ccregaux(5,',int2str(kk),',.1)']);
 end
%
 drawnow, reset(gca), NPKK=0;
 [num,den]=dezpk(zpl,ppl,kpl);
 if flcomp==1
  if xxtt==1
   numcloop=Kc*num; numcloopd=Kc*conv(num,[Td 1]);
   numff=Kc;
   dencloop=sumpol(den,Kc*conv(num,[Td 1]));
  elseif xxtt==2
   numcloop=0; numcloopd=Kc*conv(num,[Ti 1]);
   numff=Kc*[Ti 1];
   dencloop=sumpol(conv(den,[Ti 0]),Kc*conv(num,[Ti 1]));
   if ~isfinite(Ti)
    numcloop=0; numcloopd=Kc*num; numff=Kc; dencloop=sumpol(den,Kc*num);
   end
  else
   numcloop=Kc*conv(num,[Ti 1]); numcloopd=Kc*conv(num,[Ti*Td Ti 1]);
   numff=Kc*[Ti 1];
   dencloop=sumpol(conv(den,[Ti 0]),Kc*conv(num,[Ti*Td Ti 1]));
  end
  numreg=conv(numff,den); dencloop1=[dencloop 0];
  if is1==0
   if flaxis==0
    TTM=0; YYm=0; YYM=0;
    [z0,p0,k0]=tozpk(numcloopd,dencloop1);
    [y,t]=trespc(z0,p0,k0,repco(flcomp)); TT=axis; reset(gca)
    TTM=max([TTM,TT(2)]); YYm=min([YYm,TT(3)]); YYM=max([YYM,TT(4)]);
    if stktype(flcomp)~=2
     [z0,p0,k0]=tozpk(numcloop,dencloop1);
     [y,t]=trespc(z0,p0,k0,[repco(flcomp),':']); TT=axis; reset(gca)
    TTM=max([TTM,TT(2)]); YYm=min([YYm,TT(3)]); YYM=max([YYM,TT(4)]);
    end
    TT=[0,TTM,YYm,YYM]; axis(TT); TT2=TT;
   else
    TT2=TT1;
   end
   [z0,p0,k0]=tozpk(numcloopd,dencloop1);
   [y,t]=trespc(z0,p0,k0,TT2(2),repco(flcomp)); axis(TT2), hold on
   if stktype(flcomp)~=2
    [z0,p0,k0]=tozpk(numcloop,dencloop1);
    [y,t]=trespc(z0,p0,k0,[repco(flcomp),':']);
    mess='diagrammi punteggiati: azione derivativa sulla sola retroazione';
    text(.1,.04,mess,'FontWeight',wfont,'Units','normalized')
   end
   title('risposta al gradino ad anello chiuso')
  else
   [z0,p0,k0]=tozpk(numreg,dencloop1);
   if flaxis==0
    [y,t]=trespc(z0,p0,k0,repco(1)); TT=axis;
   else
    [y,t]=trespc(z0,p0,k0,TT1(2),repco(1));
   end
   if stktype(flcomp)~=2
    title('uscita del regolatore (azione derivativa sulla sola retroazione)')
   else
    title('uscita del regolatore')
   end
  end
  hold off
 else % flcomp~=1
  if flaxis==0
   for kk=1:flcomp
    if stktype(kk)==1
     numcloop=stkkc(kk)*num;
     numcloopd=stkkc(kk)*conv(num,[stktaud(kk) 1]);
     numff=stkkc(kk);
     dencloop=sumpol(den,stkkc(kk)*conv(num,[stktaud(kk) 1]));
    elseif stktype(kk)==2
     numcloop=0; numcloopd=stkkc(kk)*conv(num,[stktaui(kk) 1]);
     numff=stkkc(kk)*[stktaui(kk) 1];
     dencloop=sumpol(conv(den,[stktaui(kk) 0]),...
     stkkc(kk)*conv(num,[stktaui(kk) 1]));
     if ~isfinite(stktaui(kk))
      numcloop=0; numcloopd=stkkc(kk)*num;
      numff=stkkc(kk); dencloop=sumpol(den,stkkc(kk)*num);
     end
    else
     numcloop=stkkc(kk)*conv(num,[stktaui(kk) 1]);
     numcloopd=stkkc(kk)*conv(num,[stktaui(kk)*stktaud(kk) stktaui(kk) 1]);
     numff=stkkc(kk)*[stktaui(kk) 1];
     dencloop=sumpol(conv(den,[stktaui(kk) 0]),...
     stkkc(kk)*conv(num,[stktaui(kk)*stktaud(kk) stktaui(kk) 1]));
    end
    numreg=conv(numff,den); dencloop1=[dencloop 0];
    if is1==0
     [z0,p0,k0]=tozpk(numcloopd,dencloop1);
     [y,t]=trespc(z0,p0,k0,repco(kk)); TT=axis; reset(gca)
     TTM=max([TTM,TT(2)]); YYm=min([YYm,TT(3)]); YYM=max([YYM,TT(4)]);
     if stktype(kk)~=2
      [z0,p0,k0]=tozpk(numcloop,dencloop1);
      [y,t]=trespc(z0,p0,k0,repco(kk)); TT=axis; reset(gca)
      TTM=max([TTM,TT(2)]); YYm=min([YYm,TT(3)]); YYM=max([YYM,TT(4)]);
     end
    else
     [z0,p0,k0]=tozpk(numreg,dencloop1);
     [y,t]=trespc(z0,p0,k0,repco(kk)); TT=axis; reset(gca)
     TTM=max([TTM,TT(2)]); YYm=min([YYm,TT(3)]); YYM=max([YYM,TT(4)]);
    end
   end % for kk
   TT=[0,TTM,YYm,YYM]; axis(TT); TT2=TT;
  else
   TT2=TT1;
  end
  imess=0;
  for kk=1:flcomp
   if stktype(kk)==1
    numcloop=stkkc(kk)*num; numcloopd=stkkc(kk)*conv(num,[stktaud(kk) 1]);
    numff=stkkc(kk);
    dencloop=sumpol(den,stkkc(kk)*conv(num,[stktaud(kk) 1]));
   elseif stktype(kk)==2
    numcloop=0; numcloopd=stkkc(kk)*conv(num,[stktaui(kk) 1]);
    numff=stkkc(kk)*[stktaui(kk) 1];
    dencloop=sumpol(conv(den,[stktaui(kk) 0]),...
    stkkc(kk)*conv(num,[stktaui(kk) 1]));
    if ~isfinite(stktaui(kk))
     numcloop=0; numcloopd=stkkc(kk)*num;
     numff=stkkc(kk); dencloop=sumpol(den,stkkc(kk)*num);
    end
   else
    numcloop=stkkc(kk)*conv(num,[stktaui(kk) 1]);
    numcloopd=stkkc(kk)*conv(num,[stktaui(kk)*stktaud(kk) stktaui(kk) 1]);
    numff=stkkc(kk)*[stktaui(kk) 1];
    dencloop=sumpol(conv(den,[stktaui(kk) 0]),...
    stkkc(kk)*conv(num,[stktaui(kk)*stktaud(kk) stktaui(kk) 1]));
   end
   numreg=conv(numff,den); dencloop1=[dencloop 0];
   if kk==1, axis(TT2), end
   if is1==0
    [z0,p0,k0]=tozpk(numcloopd,dencloop1);
    [y,t]=trespc(z0,p0,k0,repco(kk));
    if kk==1
     title('risposta al gradino ad anello chiuso'), axis(TT2)
    end
    hold on
    if stktype(kk)~=2
     [z0,p0,k0]=tozpk(numcloop,dencloop1);
     [y,t]=trespc(z0,p0,k0,[repco(kk),':']);
     if imess==0
      mess='diagrammi punteggiati: azione derivativa sulla sola retroazione';
      text(.1,.04,mess,'FontWeight',wfont,'Units','normalized'), imess=1;
     end
     hold on
    end
   else
    [z0,p0,k0]=tozpk(numreg,dencloop1);
    [y,t]=trespc(z0,p0,k0,repco(kk));
    if kk==1
     mess=['uscita del regolatore ',...
     '(azione derivativa sulla sola retroazione per PD e PID)'];
     title(mess), axis(TT2)
    end
    hold on
   end
  end
  hold off
 end
 if pbs(85)==1, grid on, end
 for kk=35:38, set(pbs(kk),'Enable','on'), end
 set(pbs(39),'Visible','off'), set(pbs(40),'Visible','off')
 set(pbs(47),'Visible','off'), set(pbs(81),'Visible','off')
end
if (typ==37)|(typ==38)|(typ==41)|((typ>=45)&(typ<=48))
 if typ==37, if1=0; elseif typ==38, if1=1; elseif typ==41, if1=2; end
 if (typ==37)|(typ==38)|(typ==41), pbs(82)=if1; else, if1=pbs(82); end
 if (typ>=45)&(typ<=48), flaxis=1; end
 nfig=pbs(29); nfig2=nfig+2; cc=get(0,'Children');
 if ~any(cc==nfig2)
  disp(' '), disp(['   ',EA,' STATA CANCELLATA UNA FIGURA!']), ordf, return
 end
 figure(nfig2)
 if pbs(100)==0
  set(pbs(52),'Enable','on')
  for kk=97:99, set(pbs(kk),'Enable','on'), pbs(100)=1; end
 end
 set(pbs(49),'Visible','on'), set(pbs(50),'Visible','on')
 subplot(2,1,1), GG=axis; zoom off, cla, set(gca,'Box','on')
 subplot(2,1,2), PP=axis; zoom off, cla, set(gca,'Box','on')
 flcomp=pbs(1);
 for kk=1:flcomp
  eval('delete(pbs(70+kk))','err=1;')
 end
 for kk=1:flcomp
  if stktype(kk)==1
   messx1='PD';
  elseif stktype(kk)==2
   messx1='PI';
  else
   messx1='PID';
  end
  mess=[gj,', colore ',repco(kk),', tipo ',messx1];
  pbs(70+kk)=uimenu(pbs(52),'Label',mess,...
  'Callback',['ccregaux(7,',int2str(kk),',.1)']);
 end
 drawnow, subplot(2,1,1), reset(gca), subplot(2,1,2), reset(gca)
 [num,den]=dezpk(zpl,ppl,kpl);
 if flaxis==1
  rrr=(1.001); if typ==45, GG(1)=10^(round(log10(GG(1)/10)))/rrr;
  elseif typ==46, GG(1)=10^(round(log10(GG(1)*10)))/rrr;
  elseif typ==47, GG(2)=10^(round(log10(GG(2)*10)))*rrr;
  elseif typ==48, GG(2)=10^(round(log10(GG(2)/10)))*rrr; end
  PP(1)=GG(1); PP(2)=GG(2); OMm=GG(1); OMM=GG(2);
 end
 if flcomp==1
  if xxtt==1
   if Td~=0
    kcomp=Kc*Td; zcomp=-1/Td; pcomp=[];
   else
    kcomp=Kc; zcomp=[]; pcomp=[];
   end
  elseif xxtt==2
   kcomp=Kc; zcomp=-1/Ti; pcomp=0;
   if ~isfinite(Ti), zcomp=[]; pcomp=[]; end
  else
   kcomp=Kc*Td; zcomp=roots([1,1/Td,1/(Ti*Td)]); pcomp=0;
  end
  [numc,denc]=dezpk(zcomp,pcomp,kcomp);
  if if1~=2, num0=conv(num,numc); else, num0=conv(den,denc); end
  if if1==0
   den0=conv(den,denc);
  else
   den0=sumpol(conv(num,numc),conv(den,denc));
  end
  [z0,p0,k0]=tozpk(num0,den0);
  if flaxis==0
   [mag,phi,om]=frespc(z0,p0,k0,3,repco(flcomp));
  else
   [mag,phi,om]=frespc(z0,p0,k0,3,OMm,OMM,repco(flcomp));
  end
  subplot(2,1,1), GG=axis; GG(1)=om(1); GG(2)=om(length(om)); axis(GG)
  subplot(2,1,2), PP=axis; PP(1)=om(1); PP(2)=om(length(om)); axis(PP)
 else % flcomp~=1
  GGm=10^8; GGM=-10^8; PPm=10^8; PPM=-10^8;
  if flaxis==0, OMm=10^30; OMM=0; end
  for kk=1:flcomp
   if stktype(kk)==1
    if stktaud(kk)~=0
     kcomp=stkkc(kk)*stktaud(kk); zcomp=-1/stktaud(kk); pcomp=[];
    else
     kcomp=stkkc(kk); zcomp=[]; pcomp=[];
    end
   elseif stktype(kk)==2
    kcomp=stkkc(kk); zcomp=-1/stktaui(kk); pcomp=0;
    if ~isfinite(stktaui(kk)), zcomp=[]; pcomp=[]; end
   else
    kcomp=stkkc(kk)*stktaud(kk);
    zcomp=roots([1,1/stktaud(kk),1/(stktaud(kk)*stktaui(kk))]);
    pcomp=0;
   end
   [numc,denc]=dezpk(zcomp,pcomp,kcomp);
   if if1~=2, num0=conv(num,numc); else, num0=conv(den,denc); end
   if if1==0
    den0=conv(den,denc);
   else
    den0=sumpol(conv(num,numc),conv(den,denc));
   end
   [z0,p0,k0]=tozpk(num0,den0);
   if flaxis==0
    [mag,phi,om]=frespc(z0,p0,k0,3,repco(flcomp));
   else
    [mag,phi,om]=frespc(z0,p0,k0,3,OMm,OMM,repco(flcomp));
   end
   subplot(2,1,1), GG=axis; subplot(2,1,2), PP=axis;
   GGm=min([GGm,GG(3)]); GGM=max([GGM,GG(4)]);
   PPm=min([PPm,PP(3)]); PPM=max([PPM,PP(4)]);
   if flaxis==0, OMm=min([OMm,GG(1)]); OMM=max([OMM,GG(2)]); end
   subplot(2,1,1), reset(gca), subplot(2,1,2), reset(gca)
  end % for kk
  GG=[OMm,OMM,GGm,GGM]; PP=[OMm,OMM,PPm,PPM];
  for hh=1:2
   for kk=1:flcomp
    if stktype(kk)==1
     if stktaud(kk)~=0
      kcomp=stkkc(kk)*stktaud(kk); zcomp=-1/stktaud(kk); pcomp=[];
     else
      kcomp=stkkc(kk); zcomp=[]; pcomp=[];
     end
    elseif stktype(kk)==2
     kcomp=stkkc(kk); zcomp=-1/stktaui(kk); pcomp=0;
     if ~isfinite(stktaui(kk)), zcomp=[]; pcomp=[]; end
    else
     kcomp=stkkc(kk)*stktaud(kk);
     zcomp=roots([1,1/stktaud(kk),1/(stktaud(kk)*stktaui(kk))]);
     pcomp=0;
    end
    [numc,denc]=dezpk(zcomp,pcomp,kcomp);
    if if1~=2, num0=conv(num,numc); else, num0=conv(den,denc); end
    if if1==0
     den0=conv(den,denc);
    else
     den0=sumpol(conv(num,numc),conv(den,denc));
    end
    [z0,p0,k0]=tozpk(num0,den0);
    [mag,phi,om]=frespc(z0,p0,k0,3.5,OMm,OMM,repco(8));
    ssn=[0 0]; ss2=[-180 -180];
    aat=setstr(32*ones(1,120)); aam=sprintf('rad/sec');
    mess=[aat(1:120-length(aam)),aam];
    if hh==1
     if kk==1, subplot(2,1,1), end
     mag1=20*log10(mag);
     semilogx(om,mag1,'Color',vcol1(kk,:),'LineStyle','-')
     if kk==1, axis(GG), hold on, end
     if kk==flcomp
      rr=[GG(1),GG(2)];
      semilogx(rr,ssn,'Color',vcol1(7,:),'LineStyle','--'), title('ampiezza')
      xlabel(mess)
      aat=setstr(32*ones(1,40)); aam=sprintf('db');
      mess1=[aat(1:40-length(aam)),aam]; ylabel(mess1), hold off
     end
    else
     if kk==1, subplot(2,1,2), end
     semilogx(om,phi,'Color',vcol1(kk,:),'LineStyle','-')
     if kk==1, axis(PP), hold on, end
     if kk==flcomp
      rr=[PP(1),PP(2)];
      semilogx(rr,ss2,'Color',vcol1(7,:),'LineStyle','--'), title('fase')
      xlabel(mess)
      aat=setstr(32*ones(1,40)); aam=sprintf('gradi');
      mess1=[aat(1:40-length(aam)),aam]; ylabel(mess1), hold off
     end
    end
   end % for kk
  end  % for hh
 end   % if flcomp==1
 if pbs(86)==1, subplot(2,1,1), grid on, subplot(2,1,2), grid on, end
 for kk=35:38, set(pbs(kk),'Enable','on'), end
 set(pbs(39),'Visible','off'), set(pbs(40),'Visible','off')
 set(pbs(49),'Visible','off'), set(pbs(81),'Visible','off')
end
%
if typ==39
 nfig=pbs(29);
% set(pbs(48),'Visible','off'), set(pbs(50),'Visible','off')
 set(pbs(53),'Visible','on'), set(pbs(18),'Visible','off')
 figure(nfig)
elseif typ==40
 for kk=32:38, set(pbs(kk),'Enable','off'), end
 set(pbs(53),'Visible','off'), set(pbs(18),'Visible','on')
end
% --- last line of pidniaux ---
