function pidc(arg1,arg2,arg3,arg4)
%PIDC	  Progetto per tentativi di regolatore PID (TFI).
%    Possibili usi:
%    PIDC,gp,gc - da TFI
%    PIDC('gp','gc') - da Matlab
%    gp: funzione di trasferimento del sistema controllato (ingresso)
%    gc: funzione di trasferimento del regolatore PID (uscita)
%    Se PIDC viene chiamato senza alcun argomento, le f.d.t. gp e gc
%    possono essere specificate in interattivo.
%----------------------------------------------------------------------------
%NOTA: Se l'impianto e' di tipo 1, il programma fornisce un regolatore PD.
%      Pertanto, se si desidera un regolatore PI per un impianto di tipo 0,
%      si puo' introdurre la sua funzione di trasferimento divisa per s e
%      porre Kc'=Kc Td, Ti'=Td (o dividere per s la funzione di trasferimento
%      del regolatore ottenuto).
%----------------------------------------------------------------------------

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global ABIL TRF1 TRF2 stknum1 stkden1 stkkc stktaui stktaud repco flpo...
 TT TT1 NPKK HALEG FIGLEG LABLEG SUBPLEG

aA=setstr(224); eA=setstr(232); oA=setstr(242); EA=setstr(200);
nfig=gcf; nfigs=int2str(nfig); ABIL=0; flgpp=0; NPKK=0; FIGLO=resfiglo;
FIGLEG=nfig; HALEG=[]; LABLEG=[]; SUBPLEG=0;
wfont='normal'; % wfont='bold';
ms1=['\n **** errore: non si pu',oA,' cambiare figura durante l''esecuzione\n'];
if exist('legen#.mat'), load legen#, else, legen=0; islegen=0; end
if nargin==0
 arg1='xx'; flg=0;
 while flg==0
  mess='\n   funzione di trasferimento del sistema controllato (ingresso) : ';
  gi=input(mess,'s');
  if gcf~=nfig, fprintf(ms1), return, end
  if ~isempty(gi)
   if gi=='0', return, end
   if ~exist([gi,'.mat'])
    disp([' **** errore: ',gi,'.mat non esiste'])
   else
    flg=1;
   end
  end
 end
 while flg==1
  mess='\n   funzione di trasferimento del regolatore (uscita) : ';
  gj=input(mess,'s');
  if gcf~=nfig, fprintf(ms1), return, end
  if ~isempty(gj), flg=2; end
 end
 if gj=='0', return, end
elseif nargin>=2
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1; gj=arg2;
 end
else
 disp(' **** errore: numero di argomenti non sufficiente'), return
end
[z,p,k,str1]=exportf(gi,1); if isempty(k), return, end
if str1=='z'
 disp(' **** per sistemi a tempo discreto usare PIDD'), return
end
[num,den]=dezpk(z,p,k);
tfblocks(3,gj,gi,'','','','','','','','')
%
[vcol1,vcol2,repco,repcos]=coltbl; colbg=vcol1(8,:);
%
flgll=0;
ll=input('\n   informazioni sul progetto dei regolatori PID ? (1) : ');
if gcf~=nfig, fprintf(ms1), return, end
if isempty(ll), ll=0; end
if ll==1
 ccc='prninfo(5)';
 eval(ccc)
 flgin=0;
 while flgin==0
  mess='\n   inviare 1 per proseguire con il progetto, 0 per uscire : ';
  xxx=input(mess);
  if gcf~=nfig, fprintf(ms1), return, end
  if isempty(xxx), xxx=4; end
  if xxx==1, flgin=1; elseif xxx==0, ordf(1), return, end
 end
end
%
clf, ordf(3)
if any(FIGLO(3,:))
 erx=0; eval('set(nfig,''Position'',FIGLO(3,1:4))','erx=1;')
end
%
ii=find(abs(p)<10^(-8));
if length(ii)>=2
 disp(' ')
 disp('   **** il programma pidc si applica solo a sistemi di tipo 0 o 1')
 hold off, clf, ordf(1), return
end
%
stknum1=[]; stkden1=[]; stkkc=[]; stktaui=[]; stktaud=[];
%
j=sqrt(-1); HALEG=[];
hold off %5.3
[pho1,pho2,mag,phi,om]=bodec(z,p,k,repco(1));
if islegen
 LABLEG=['''',gi,''''];
 if legen, eval(['legend(HALEG,',LABLEG,')']), end
end
hold on
VV=axis; maxga=VV(4); minga=VV(3);
scale=maxga-minga; scaleph=pho2-pho1;
[gm,pm,omg,omp]=gpcross(mag,phi,om,1,-180);
if isnan(gm) | isnan(pm)
 [gm1,pm1,omg1,omp1]=gpcross1(z,p,k,1,-180);
 if isnan(gm), gm=gm1; omg=omg1; end
 if isnan(pm), pm=pm1; omp=omp1; end
end
if isnan(gm), gm=inf; omg=eps; end
if isnan(pm), omp=eps; end
gm0=gm; phm0=pm+180; omg0=omg; omp0=omp;
mess='sistema controllato:';
ha=text(.02,.14,mess,'Units','normalized');
set(ha,'FontWeight',wfont,'Color',vcol2(1,:),'Interpreter','none')
if isfinite(gm)
 mess=sprintf('margine di ampiezza: %.4g db',-20*log10(gm0));
 semilogx([omg0,omg0],[VV(3),VV(4)],'Color',vcol1(6,:),'LineStyle',':')
else
 mess=sprintf('margine di ampiezza: infinito');
end
ha=text(.02,.09,mess,'Units','normalized');
set(ha,'FontWeight',wfont,'Interpreter','none')
semilogx([VV(1),VV(2)],[0,0],'Color',vcol1(6,:),'LineStyle',':')
if isnan(phm0)
 mess=sprintf('margine di fase non determinabile');
else
 mess=sprintf('margine di fase: %.4g gradi',phm0);
 semilogx([omp0,omp0],[VV(3),VV(4)],'Color',vcol1(2,:),'LineStyle',':')
end
ha=text(.02,.04,mess,'Units','normalized');
set(ha,'FontWeight',wfont,'Interpreter','none')
gp=(-180-pho1)*(scale/scaleph)+minga;
semilogx([VV(1),VV(2)],[gp,gp],'Color',vcol1(2,:),'LineStyle',':')
axis(VV), figure(nfig)
xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
clc, flpo=0;
if length(ii)==1
 disp(' ')
 fprintf(['   NOTA: il sistema ',eA,' di tipo 1; si ricaver',aA,...
 ' un regolatore PD'])
 ccc=input('\n         si vuole comunque ottenere un PID ? (1) : ');
 if isempty(ccc), ccc=0; end
 if ccc~=1, flpo=1; end
end
disp(' ')
fprintf('   margine di fase senza regolatore: %.4g gradi\n',phm0)
frem=omp0; if isnan(phm0), phm0=0; frem=NaN; end
fprintf('                    alla pulsazione: %.4g rad/sec\n',frem)
flin=0;
while flin==0
 dphm=input('\n   specificare il margine di fase voluto : ');
 if ~isempty(dphm)
  if dphm==0, return, end
  if dphm>=phm0, flin=1; end
 end
end
if gcf~=nfig, fprintf(ms1), return, end
[gm,pm,omg,omp]=gpcross(mag,phi,om,1,dphm-180);
if isnan(gm) | isnan(pm)
 [gm1,pm1,omg1,omp1]=gpcross1(z,p,k,1,dphm-180);
 if isnan(gm), gm=gm1; omg=omg1; end
 if isnan(pm), pm=pm1; omp=omp1; end
end
if isnan(gm), gm=1; end
aa1=max([1/gm,gm,1]);
WW(1)=10^(log10(VV(1))-3);
WW(2)=10^(log10(VV(2))+1);
WW(3)=min([-20,VV(3),VV(3)-20*ceil(log10(aa1)+1)]);
WW(4)=max([20*ceil(log10(aa1)),VV(4)+40*ceil(log10(aa1)+1)]);
phi1=pho1-90; phi2=max(pho2+90,90); om1=WW(1); om2=WW(2);
flrip=1; flrop=1; flplot=1; nnrip=0; reins=zeros(1,7);
while flrip==1
 nnrip=nnrip+1; HALEG=[];
 figure(nfig), clf, ordf(3), ABIL=0; %5.3
 TRF1=[gi,repco(1)]; TRF2=[gj,repco(3)];
 men_opt=uimenu(gcf,'Label','Memo','Enable','off');
 mess='regolatore PID';
 uimenu(men_opt,'Label',mess);
 mess=[gi,', sistema controllato'];
 uimenu(men_opt,'Label',mess,'Separator','on',...
 'Callback','tfmaux(1,.3)');
 mess=[gj,', regolatore'];
 men_optt=uimenu(men_opt,'Label',mess);
 uimenu(men_optt,'Label','polinomiale',...
 'Callback','tfmaux(2,.3)');
 uimenu(men_optt,'Label','costanti di tempo',...
 'Callback','tfmaux(2,.3,1,1)');
 drawnow, clc, hold off
 VV=WW; semilogx(om1,-20,'Color',vcol1(8,:),'LineStyle','none',...
 'Marker','.'), axis(VV)
 ytick=VV(3):20:VV(4); set(gca,'ytick',ytick), hold on
 [pho1,pho2,mag,phi,om]=bodec(z,p,k,om1,om2,repco(1),phi2,phi1);
 maxga=VV(4); minga=VV(3); scale=maxga-minga; scaleph=pho2-pho1;
 [gm,pm,omg,omp]=gpcross(mag,phi,om,1,-180);
 if isnan(gm) | isnan(pm)
  [gm1,pm1,omg1,omp1]=gpcross1(z,p,k,1,-180);
  if isnan(gm), gm=gm1; omg=omg1; end
  if isnan(pm), pm=pm1; omp=omp1; end
 end
 if isnan(pm), omp=eps; end
 phm0=pm+180; omp0=omp;
 mess='sistema controllato';
 ha=text(.02,.14,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Color',vcol2(1,:),'Interpreter','none')
 semilogx([omp0,omp0],[VV(3),VV(4)],'Color',vcol1(1,:),'LineStyle',':')
 semilogx([om1,om2],[0,0],'Color',vcol1(6,:),'LineStyle',':')
 gp=(-180-pho1)*(scale/scaleph)+minga;
 semilogx([om1,om2],[gp,gp],'Color',vcol1(2,:),'LineStyle',':')
 if islegen
  LABLEG=['''',gi,''''];
  if legen, eval(['legend(HALEG,',LABLEG,')']), end
 end
 axis(VV), drawnow, pause, figure(nfig)
 nw=length(om); w=j*om;
%
 if flrop==1 % the first trial
%  the angular frequency corresponding to phase dphm-180
  phiref=-180+dphm;
  ii=find(phi>phiref);
  omc=om(ii(length(ii)));
  rho=4;
  taui=sqrt(rho)/omc; taud=1/(sqrt(rho)*omc); flrop=0;
 end
 kc=1;
 if flpo==0
  num1=kc*[taui*taud,taui,1]; den1=[taui,0];
 else
  num1=kc*[taud 1]; den1=1;
 end
 [z1,p1,k1]=tozpk(num1,den1); nz=length(z1); np=length(p1); y=k1*ones(1,nw);
 for kk=1:np
  y=y./(w-p1(kk));
 end
 for kk=1:nz
  y=y.*(w-z1(kk));
 end
 magc=abs(y)'; phic=(angle(y)*180/pi)'; magco=mag.*magc; phico=phi+phic;
 ii=find(phico>phiref);
 if isempty(ii)
  disp(' ')
  disp(['   **** il margine di fase richiesto non pu',oA,' essere ottenuto'])
  [maxphi,ii]=max(phico);
  fprintf(['\n   il margine di fase sar',aA,' di %.4g gradi\n'],180+maxphi)
  xyx=input('\n   **** premere invio per proseguire ','s');
  gm=magco(ii);
 else
  gm=magco(ii(length(ii)));
 end
 kc=1/gm; k1=k1*kc; num1=num1*kc; magc=kc*magc; magco=kc*magco;
 magp=20*log10(magc); phip=(phic-pho1)*(scale/scaleph)+minga;
 ha=semilogx(om,magp,'Color',vcol1(3,:),'LineStyle','-');
 HALEG=[HALEG,ha];
 if islegen
  LABLEG=['''',gi,''',''',gj,''''];
  if legen, eval(['legend(HALEG,',LABLEG,')']), end
 end
 semilogx(om,phip,'Color',vcol1(3,:),'LineStyle','-.')
 [oa,ga]=asymga(z1,p1,k1,om1,om2);
 semilogx(oa,20*log10(ga),'Color',vcol1(3,:),'LineStyle','--')
 if flpo==0
  mess='regolatore PID';
 else
  mess='regolatore PD';
 end
 ha=text(.02,.09,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Color',vcol2(3,:),'Interpreter','none')
 axis(VV), drawnow, pause, figure(nfig)
 magp=20*log10(magco); phip=(phico-pho1)*(scale/scaleph)+minga;
 semilogx(om,magp,'Color',vcol1(5,:),'LineStyle','-')
 semilogx(om,phip,'Color',vcol1(5,:),'LineStyle','-.')
 [gm,pm,omg,omp]=gpcross(magco,phico,om,1,-180);
 phm=pm+180;
 semilogx([omp,omp],[VV(3),VV(4)],'Color',vcol1(5,:),'LineStyle',':')
 mess='sistema complessivo';
 ha=text(.02,.04,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Color',vcol2(5,:),'Interpreter','none')
%
%  step response
%
 if flpo==0
  numcloop=kc*conv(num,[taui,1]); numcloopd=kc*conv(num,[taui*taud,taui,1]);
  dencloop=sumpol(conv(den,[taui,0]),kc*conv(num,[taui*taud,taui,1]));
 else
  numcloop=kc*num; numcloopd=kc*conv(num,[taud 1]);
  dencloop=sumpol(den,kc*conv(num,[taud,1]));
 end
 dencloop1=[dencloop 0];
 stknum1=[stknum1;num1]; stkden1=[stkden1;den1];
 stkkc=[stkkc;kc]; stktaui=[stktaui,taui]; stktaud=[stktaud;taud];
 aa=importf(num1,den1,gj); ABIL=1;
 axis(VV)
 set(men_opt,'Enable','on')
 xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
 hold off
 colc=repco(nnrip);
 if all(real(roots(dencloop))<0)
  reins(nnrip)=1;
  if flplot==1
   figure(nfig+1), clf, ordf(6), nfig1=gcf; %5.3
   if any(FIGLO(3,:))
    eval('set(nfig1,''Position'',FIGLO(3,5:8))','erx=1;')
   end
  else
   figure(nfig1), hold on
  end
  if flplot~=1, axis(TT), end
  [z1,p1,k1]=tozpk(numcloopd,dencloop1);
  [y,t]=trespc(z1,p1,k1,colc); hold on
  [z1,p1,k1]=tozpk(numcloop,dencloop1);
  [y,t]=trespc(z1,p1,k1,[colc,':']);
  if flplot==1, TT=axis; end
  ytick=get(gca,'YTick'); divy=ytick(2)-ytick(1);
  ymax=max(y); ymin=min(y);
  while ymax>=TT(4), TT(4)=TT(4)+divy; end
  while ymin<=TT(3), TT(3)=TT(3)-divy; end
  if flplot==1
   mess='diagrammi punteggiati: azione derivativa sulla sola retroazione';
   ha=text(.12,.09,mess,'Units','normalized');
   set(ha,'FontWeight',wfont,'Interpreter','none')
   mess=['successione dei colori: ',repco(1),', ',repco(2),', ',...
   repco(3),', ',repco(4),', ',repco(5),', ',repco(6),', ',repco(7)];
   ha=text(.12,.04,mess,'Units','normalized');
   set(ha,'FontWeight',wfont,'Interpreter','none')
  end
  TRF1=[gi,repco(1)]; TRF2=[gj,repco(nnrip)];
  if flgpp==0
   men_opt1=uimenu(gcf,'Label','Memo');
   mess='regolatore PID';
   uimenu(men_opt1,'Label',mess);
   mess=[gi,', sistema controllato'];
   uimenu(men_opt1,'Label',mess,'Separator','on',...
   'Callback','tfmaux(1,.3)');
   mess=[gj,', regolatore'];
   men_optt1=uimenu(men_opt1,'Label',mess);
   uimenu(men_optt1,'Label','polinomiale',...
   'Callback','tfmaux(2,.3)');
   uimenu(men_optt1,'Label','costanti di tempo',...
   'Callback','tfmaux(2,.3,1,1)');
   bdx=uimenu(gcf,'Label','Asse tempi');
   uimenu(bdx,'Label','ingrandire x 2',...
   'Callback','ccregaux(11)');
   uimenu(bdx,'Label','ingrandire x 5','Separator','on',...
   'Callback','ccregaux(12)');
   uimenu(bdx,'Label','ingrandire x 10','Separator','on',...
   'Callback','ccregaux(13)');
   uimenu(bdx,'Label','ripristinare la scala iniziale','Separator','on',...
   'Callback','ccregaux(14)');
   uimenu(gcf,'Label','Reticolo on/off','Callback','grid');
   uimenu(gcf,'Label','Zoom on/off','Callback','gridmng(7)');
  end
  if flgpp==0, sepa='on'; else, sepa='off'; end
  mess=[gj,', colore ',repco(nnrip)];
  uimenu(men_opt1,'Label',mess,'Separator',sepa,...
  'Callback',['ccregaux(3,',int2str(nnrip),',.3)']);
  axis(TT), hold off
  nfigs1=int2str(nfig1);
  reset(gca), set(gca,'Box','on')
  title('risposta al gradino ad anello chiuso')
  aat=setstr(32*ones(1,120)); aam=sprintf('secondi');
  messx=[aat(1:100-length(aam)),aam]; xlabel(messx)
  xyx=input(['\n   **** figura ',nfigs1,' **** '],'s');
  zoom off, zoom out
  if flplot==1
   figure(nfig+2), clf, ordf(7), nfig2=gcf; %5.3
   if any(FIGLO(3,:))
    eval('set(nfig2,''Position'',FIGLO(3,9:12))','erx=1;')
   end
  else
   figure(nfig2), hold on
  end
  if flpo==0
   numff=kc*[taui,1];
  else
   numff=kc;
  end
  if flplot~=1, axis(TT1), end
  numreg=conv(numff,den);
  [z1,p1,k1]=tozpk(numreg,dencloop1);
  [y,t]=trespc(z1,p1,k1,colc);
  if flplot==1, TT1=axis; end
  ytick=get(gca,'YTick'); divy=ytick(2)-ytick(1);
  ymax=max(y); ymin=min(y);
  while ymax>=TT1(4), TT1(4)=TT1(4)+divy; end
  while ymin<=TT1(3), TT1(3)=TT1(3)-divy; end
  if flplot==1, flplot=0; end
  if flgpp==0
   men_opt2=uimenu(gcf,'Label','Memo');
   mess='regolatore PID';
   uimenu(men_opt2,'Label',mess);
   mess=[gi,', sistema controllato'];
   uimenu(men_opt2,'Label',mess,'Separator','on',...
   'Callback','tfmaux(1,.3)');
   mess=[gj,', regolatore'];
   men_optt2=uimenu(men_opt2,'Label',mess);
   uimenu(men_optt2,'Label','polinomiale',...
   'Callback','tfmaux(2,.3)');
   uimenu(men_optt2,'Label','costanti di tempo',...
   'Callback','tfmaux(2,.3,1,1)');
   bdx1=uimenu(gcf,'Label','Asse tempi');
   uimenu(bdx1,'Label','ingrandire x 2',...
   'Callback','ccregaux(15)');
   uimenu(bdx1,'Label','ingrandire x 5','Separator','on',...
   'Callback','ccregaux(16)');
   uimenu(bdx1,'Label','ingrandire x 10','Separator','on',...
   'Callback','ccregaux(17)');
   uimenu(bdx1,'Label','ripristinare la scala iniziale','Separator','on',...
   'Callback','ccregaux(18)');
   uimenu(gcf,'Label','Reticolo on/off','Callback','grid');
   uimenu(gcf,'Label','Zoom on/off','Callback','gridmng(7)');
   flgpp=1;
  end
  mess=[gj,', colore ',repco(nnrip)];
  uimenu(men_opt2,'Label',mess,'Separator',sepa,...
  'Callback',['ccregaux(3,',int2str(nnrip),',.3)']);
  axis(TT1), hold off
  nfigs2=int2str(nfig2);
  reset(gca), set(gca,'Box','on')
  title('uscita del regolatore (azione derivativa sulla sola retroazione)')
  xlabel(messx)
  mess=['(colori dei grafici: ',repco(1),', ',repco(2),', ',...
  repco(3),', ',repco(4),', ',repco(5),', ',repco(6),', ',repco(7),')'];
  ylabel(mess)
  xyx=input(['\n   **** figura ',nfigs2,' **** '],'s');
  zoom off, zoom out
 end
 clc
 disp(' ')
 fprintf(['   colore di riferimento: ',repco(nnrip),' ;'])
 fprintf([' f.d.t. del sistema controllato: ',gi])
 fprintf('\n')
 if reins(nnrip)==0
  xyx=input(['   ATTENZIONE: il sistema ',eA,' instabile'],'s');
 end
 disp(' ')
 disp('   il regolatore ottenuto:'), disp(' ')
 fprintf('   Kc = %.4g\n',kc)
 if flpo==0
  fprintf('   Ti = %.4g\n',taui)
 end
 fprintf('   Td = %.4g\n',taud)
 flgin=0;
 while flgin==0
  xxx=input('\n   desiderate cambiare il regolatore ? (1/0) : ');
  if length(xxx)~=0, flgin=1; end
 end
 taui1=0; taud1=0;
 if xxx==1
  flrip=0;
  if nnrip < 7
   fprintf('\n   potete cambiare i valori di Ti e/o Td')
   fprintf(['\n   Kc sar',aA])
   fprintf(' determinato per avere il margine di fase richiesto\n\n')
   if flpo==0
    fprintf('   specificare un nuovo valore di Ti o premere invio')
    taui1=input('\n   Ti = ');
   end
    fprintf('   specificare un nuovo valore di Td o premere invio')
   taud1=input('\n   Td = '); flrip=0;
   if length(taui1)~=0, taui=taui1; flrip=1; end
   if length(taud1)~=0, taud=taud1; flrip=1; end
  else
   disp(' ')
   disp(['   il massimo numero di tentativi ',eA,' 7'])
  end
 else
  flrip=0;
 end
end
if nnrip > 1
 xx=0;
 while xx==0
  col=input('\n   scegliere la funzione specificandone il colore : ','s');
  if isempty(col), col='z'; end
  if col=='0', return, end
  ropc=0; for kk=1:7, ropc=ropc|strcmp(col,repco(kk)); end
  if ropc
   if find(repco==col)<=nnrip
    xx=1;
   end
  end
 end
else
 col=colc;
end
q=find(repco==col);
num1=stknum1(q,:); den1=stkden1(q,:);
if flplot==0
 cc=get(0,'Children');
 if (any(cc==nfig))&(any(cc==nfig1))&(any(cc==nfig2));
  FIGLO(3,1:4)=get(nfig,'Position');
  FIGLO(3,5:8)=get(nfig1,'Position');
  FIGLO(3,9:12)=get(nfig2,'Position');
  save figlo# FIGLO -v4
 else
  disp(' '), disp(['   ',EA,' STATA CANCELLATA UNA FIGURA!']), return
 end
 eval('delete(nfig2)','err=1;'), eval('delete(nfig1)','err=1;')
 figure(nfig)
end
ordf(1), clc, disp(' '), HALEG=HALEG(1:2);
disp('   IL REGOLATORE OTTENUTO :'), disp(' ')
kc=stkkc(q); taui=stktaui(q); taud=stktaud(q);
fprintf('   Kc = %.4g',kc)
if flpo==0
 fprintf(' , Ti = %.4g',taui)
end
fprintf(' , Td = %.4g\n',taud)
aa=importf(num1,den1,gj); if aa==1, tfg(gj), end
flgin=0;
while flgin==0
 mess='\n   azione derivativa sulla sola retroazione ? (1)  : ';
 xxx=input(mess);
 if isempty(xxx), return, end, if xxx~=1, return, end
 if xxx==1
  mess='\n   specificare il nome della f.d.t. in avanti      : ';
  ggd=input(mess,'s'); if isempty(ggd), ggd=4; end, if ggd=='0', return, end
  mess='\n   specificare il nome della f.d.t. in retroazione : ';
  ggf=input(mess,'s');  if isempty(ggf), ggf=4; end
  if ggf=='0', return, end
  if isstr(ggd)&isstr(ggf), flgin=1; end
 end
end
if isstr(arg1)
 mess=[ggd,[', unit',aA,' in avanti']];
 uimenu(men_opt,'Label',mess);
 mess=[ggf,[', unit',aA,' in retroazione']];
 uimenu(men_opt,'Label',mess);
end
figure, tfblocks(4,ggd,gi,ggf,'','','','','','',''), delete(gcf)
if flpo==0
 numff=kc*[taui,1]; denff=[taui,0]; numfb=[taui*taud,taui,1]; denfb=[taui,1];
else
 numff=kc; denff=1; numfb=[taud,1]; denfb=1;
end
[zz,pp,kk]=tozpk(numff,denff);
zz=round(zz*10^14)/10^14;
aa=importf(zz,pp,kk,ggd);
if aa==1, tfg(ggd), end
[zz,pp,kk]=tozpk(numfb,denfb);
pp=round(pp*10^14)/10^14;
aa=importf(zz,pp,kk,ggf);
if aa==1, tfg(ggf), end
% --- last line of pidc ---
