function perftra(arg1,arg2,arg3,arg4)
%PERFTRA Sintesi di un'unita' feedforward per l'inseguimento perfetto (TFI).
%    PERFTRA,g1,g2,g3,g4 - da TFI
%    PERFTRA('g1','g2','g3','g4') - da Matlab
%    g1: f.d.t. del regolatore (ingresso)
%    g2: f.d.t. del sistema controllato (ingresso)
%    g3: f.d.t. del ritardo di preazione (uscita)
%    g4: f.d.t. dell'unita' ad azione in avanti (uscita)
%    progetta come g3 e g4 due unita' ad azione diretta per realizzare
%    l'inseguimento perfetto in sistemi in retroazione digitali.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global ABIL TRF1 TRF2 TRF3 TRF4 TRF5 TRF5 TRF6 TRF7 HALEG FIGLEG LABLEG SUBPLEG

aA=setstr(224); eA=setstr(232); oA=setstr(242); uA=setstr(249);
AA=setstr(192); EA=setstr(200);
nfig=gcf; nfigs=int2str(nfig); ffor=0; fpre=0; flgmen=0; flgf=[]; %5.3
FIGLEG=0; HALEG=[]; LABLEG=[]; SUBPLEG=0;
if exist('legen#.mat'), load legen#, else, legen=0; islegen=0; end
[vcol1,vcol2,repco]=coltbl; FIGLO=resfiglo; ABIL=0;
ms1=['\n **** errore: non si pu',oA,' cambiare figura durante l''esecuzione\n'];
titlenable=1;
xx='   **** premere un tasto per proseguire';
if (nargin~=0)&(nargin~=4)
 disp(' **** errore: numero di argomenti non valido in perftra'), return
end
if nargin==0
 mess='\n   f.d.t. del regolatore (ingresso) : ';
 arg1=input(mess,'s');
 if isempty(arg1), arg1='0'; end, if arg1=='0', return, end
 mess='\n   f.d.t. del sistema controllato (ingresso) : ';
 arg2=input(mess,'s');
 if isempty(arg2), arg2='0'; end, if arg2=='0', return, end
 mess='\n   f.d.t. del ritardo di preazione (uscita) : ';
 arg3=input(mess,'s');
 if isempty(arg3), arg3='0'; end, if arg3=='0', return, end
 mess='\n   f.d.t. del compensatore in avanti (uscita) : ';
 arg4=input(mess,'s');
 if isempty(arg4), arg4='0'; end, if arg4=='0', return, end
end
if ~exist([arg1,'.mat'])
 disp([' **** errore: ',arg1,'.mat non esiste']), return
elseif ~exist([arg2,'.mat'])
 disp([' **** errore: ',arg2,'.mat non esiste']), return
end
[zr,pr,kr,str1]=exportf(arg1,1); if isempty(kr), return, end
[numr,denr]=dezpk(zr,pr,kr);
if (length(zr)==0)&(length(pr)==0), str1='z'; end
[zp,pp,kp,str2]=exportf(arg2,1); if isempty(kp), return, end
[num,den]=dezpk(zp,pp,kp);
if (str1~='z')|(str2~='z')
 disp(' **** errore: perftra si applica solo a sistemi a tempo discreto')
 return
end
g3=arg3; g4=arg4;
figure, tfblff(0,arg1,arg2,arg3,arg4), delete(gcf)

if length(num)>length(den)
 disp(' **** errore: m > n in perftra'), return
end

mess1=[arg1,' regolatore'];
mess2=[arg2,' sistema controllato'];
mess3=[arg3,' ritardo del riferimento'];
mess4=[arg4,' unit',aA,' ad azione in avanti verso l''ingresso del sistema'];

mess='\n   informazioni sul metodo di progetto ? (1) : ';
ll=input(mess);
if gcf~=nfig, fprintf(ms1), return, end
if isempty(ll), ll=0; end
if ll==1
 figure, tfblff(1,arg1,arg2,arg3,arg4)
 nfig1=gcf; nfigs1=int2str(nfig1);
 clc
 disp(' ')
 disp('   PROGETTO DI UN COMPENSATORE DIGITALE PER L''INSEGUIMENTO PERFETTO')
 disp(' ')
 mess=['   Lo schema a blocchi di riferimento ',eA,' mostrato in Fig.'];
 mess=[mess,nfigs1];
 disp(mess)
 disp('   selezionare la figura con il mouse per vedere i dettagli')
 disp('   quindi selezionare command window per rivedere questo testo')
 disp(' ')
 disp(['   Funzione di trasferimento del regolatore : ',arg1]);
 disp(['   Funzione di trasferimento del sistema controllato : ',arg2]);
 disp(' '), disp(xx), pause
 clc
 disp(' ')
 disp('   1) Deduzione del ritardo di grado relativo D_r :')
 disp(' ')
 disp('   Si consideri la f.d.t. del sistema controllato nella forma')
 disp(' ')
 disp('             P(z)    P1(z)')
 disp('      G(z) = ---- = -------- ,   in cui')
 disp('             Q(z)   z^k*Q(z)')
 disp(' ')
 disp(['   1) P(z) ',eA,' monico - quindi Q(z) in generale non monico'])
 disp(['   2) P1(z) ha lo stesso grado di Q(z) - ci',oA,' si ottiene'])
 disp('      moltiplicando e dividendo per z^h, con h opportuno')
 disp(' ')
 disp(['   Il ritardo di grado relativo ',eA,' definito come D_r := 1/z^k'])
 disp(' '), disp(xx), pause
 clc
 disp(' ')
 disp('   2) Deduzione del compensatore degli zeri stabili g_s :')
 disp(' ')
 disp('   Si consideri la fattorizzazione')
 disp(' ')
 disp('      Q(z)     A(z)     B(z)')
 disp('      ----- = ------ + ------ ,')
 disp('      P1(z)   P1m(z)   P1p(z)')
 disp(' ')
 disp('   in cui i moduli delle radici di P1m(z) e P1p(z) sono non')
 disp('   superiori ad 1 e strettamente superiori ad 1 rispettivamente.')
 disp('   A(z) e B(z) si possono ottenere come A(z):=A1(z), B(z):=z*B1(z),')
 disp('   in cui A1(z) e B1(z) si ricavano con l''equazione diofantea')
 disp(' ')
 disp('      A1(z)*P1p(z)+ B1(z)*[z*P1m(z)] = Q(z) .')
 disp(' ')
 disp(['   Il compensatore degli zeri stabili ',eA,...
 ' dato da g_s := A(z)/P1m(z)'])
 disp(' '), disp(xx), pause
 clc
 disp(' ')
 disp('   3) Deduzione del ritardo di preazione D_p :')
 disp(' ')
 disp(['   Sia ro il modulo della radice di P1p(z) pi',uA,' prossima alla'])
 disp('   circonferenza unitaria e kp l''intervallo di preazione.')
 disp('   La riduzione dell''errore ottenibile con il compensatore degli')
 disp(['   zeri instabili ',eA,' data approssimativamente da'])
 disp(' ')
 disp('              1')
 disp('      Er = -------.')
 disp('           ro^(kp)')
 disp(' ')
 disp(['   Questa relazione pu',oA,' essere usata per scegliere kp dato Er.'])
 disp(['   L''istante discreto -kp ',eA,...
 ' il tempo di inizio della preazione.'])
 disp(' ')
 disp(['   Il ritardo di preazione ',eA,' definito come D_p := 1/z^(kp)'])
 disp(' '), disp(xx), pause
 clc
 disp(' ')
 disp('   4) Deduzione del compensatore degli zeri instabili g_p :')
 disp(' ')
 disp('   Si consideri l''equazione diofantea')
 disp(' ')
 disp('      X(z)*z^(kp) + Y(z)*P1p(z) = B1(z) ,')
 disp('  ')
 disp(['   in cui B1(z) ',eA,' lo stesso ottenuto in precedenza (passo 2)'])
 disp(' ')
 disp('                                                           Y(z)')
 disp(['   Il compensatore degli zeri instabili ',eA,' dato da g_p := --------'])
 disp('                                                         z^(kp-1)')
 disp(' '), disp(xx), pause
 clc
 disp(' ')
 disp('   4) Deduzione del compensatore degli zeri instabili g_p :')
 disp(' ')
 disp('   Il compensatore degli zeri instabili si deduce anche come segue:')
 disp('   si sostituisca z con 1/z in B(z)/P1p(z), ottenuta al passo 2')
 disp('   e si indichi con gr(k) la relativa risposta all''impulso')
 disp(' ')
 disp('                                                           Y(z)')
 disp(['   Il compensatore degli zeri instabili ',eA,' dato da g_p := --------'])
 disp('                                                         z^(kp-1)')
 disp(' ')
 disp('   in cui i coefficienti di Y(z) sono gli elementi di gr(k),')
 disp('   riportati come segue: gr(kp)*z^(kp-1)+...+gr(2)*z+gr(1)')
 disp(' '), disp(xx), pause
 clc
 disp(' ')
 disp('   NOTA: Con riferimento alla fattorizzazione presentata al passo 2 :')
 disp(' ')
 disp('      Q(z)     A(z)     B(z)')
 disp('      ----- = ------ + ------ ,')
 disp('      P1(z)   P1m(z)   P1p(z)')
 disp(' ')
 disp(['   se il sistema controllato ',eA,' di tipo p conviene moltiplicare'])
 disp('   il primo membro per z^p/(z-1)^p, e poi moltiplicare la f.d.t.')
 disp('   dei compensatori ottenuti per (z-1)^p/z^p: in tal modo si mantiene')
 disp('   la robustezza dell''inseguimento asintotico da parte dell''anello')
 disp('   di regolazione di un gradino, una rampa, etc. Questo artifizio')
 disp(['   ',eA,' adottato nella procedura di progetto di perftra.'])
 disp(' '), disp(xx), pause
 clc
 disp(' ')
 disp('   IL COMPENSATORE COMPLESSIVO EQUIVALENTE')
 figure, tfblff(2,arg1,arg2,arg3,arg4)
 nfig2=gcf; nfigs2=int2str(nfig2);
 disp(' ')
 mess=['   Lo schema a blocchi del compensatore ',eA,' mostrato in Fig.'];
 mess=[mess,nfigs2];
 disp(mess)
 disp(' ')
 disp(['   Funzione di trasferimento del ritardo complessivo : ',arg3]);
 disp(['   Funzione di trasferimento del compensatore complessivo : ',arg4]);
 disp(' ')
 disp('   Queste funzioni di trasferimento sono definite in funzione di quelle')
 disp('   dedotte in precedenza come mostrato in figura')
 disp(' '), disp(xx), pause
 clc
 disp(' ')
 disp(['   DEDUZIONE DI UNA SOLA UNIT',AA,' AD AZIONE IN AVANTI'])
 figure, tfblff(3,arg1,arg2,arg3,arg4,'FF','bl2')
 nfig3=gcf; nfigs3=int2str(nfig3);
 disp(' ')
 disp(['   Se la funzione di trasferimento del regolatore ',eA,' invertibile,'])
 mess=['   si pu',oA,' usare una sola unit',aA,...
 ' di compensazione, come in Fig.'];
 mess=[mess,nfigs3]; disp(mess)
 disp(' ')
 disp(['   La sua funzione di trasferimento ',eA,' definita in termini di quelle'])
 disp('   dedotte in precedenza come mostrato in figura')
 disp(' '), disp(xx), pause
 delete(nfig1), delete(nfig2), delete(nfig3)
 clc
 flgin=0;
 while flgin==0
  mess='\n   inviare 1 per proseguire con il progetto, 0 per uscire : ';
  xxx=input(mess);
  if isempty(xxx), xxx=4; end
  if gcf~=nfig, fprintf(ms1), return, end
  if xxx==1, flgin=1; elseif xxx==0, ordf(1), return, end
 end
end

% the numerator is made monic
den=den/num(1); num=num/num(1);
m=length(num); n=length(den);

% the relative degree of the plant
k=n-m;

% The transfer function of the plant is: Gp=z^(-k)*num1/den,
% with num1/den strictly proper

num1=[num,zeros(1,k)];

clc, disp(' ')
disp('Funzioni di trasferimento del sistema controllato e del regolatore:')
tfm(zp,pp,kp,arg2,1)

tfm(zr,pr,kr,arg1,1)
disp(' ')

fprintf('NOTA: ')
if any(abs(zp)>1)
 fprintf([arg2,' non ',eA,' invertibile: si richiede la preazione'])
 fpre=1;
else
 fprintf([arg2,' ',eA,' invertibile: non si richiede la preazione'])
end
fprintf('\n      ')
if any(abs(zr)>1)
 fprintf([arg1,' non ',eA,' invertibile: si deve usare il sistema a due'])
else
 fprintf([arg1,' ',eA,' invertibile: si pu',oA,' usare una sola'])
 ffor=1;
end
fprintf([' unit',aA,' ad azione in avanti'])
fprintf('\n      ')
fprintf(['il ritardo dovuto al grado relativo ',eA,' D_r='])
fprintf('%.3g campioni',k)
ordiff=length(find(abs(pp-1)<10^(-8)));
fprintf('\n      ')
fprintf('ai compensatori si invia la differenza di ordine ')
fprintf('%.3g (tipo del sistema)\n\n',ordiff)
disp(xx), pause, disp(' ')

% Definition of the preaction time
if fpre
 abszpl=abs(zp);
 domzero=min(abszpl(find(abszpl>1)));
 alpha=10^(-6);
 kkm=ceil(-log10(alpha)/log10(domzero));
 kk=0:1:kkm;
 err=domzero.^(-kk);
 [xx1,yy1]=stairs(kk,err);
 ordf(2), ff=int2str(gcf); figure(gcf) %5.3
 semilogy(xx1,yy1,'Color',vcol1(1,:),'LineStyle','-'), grid
 VV=[0,kkm,alpha,1]; axis(VV)
 mess=['   La Fig.',ff,' mostra la riduzione dell''errore'];
 mess=[mess,' con il tempo di preazione'];
 disp(mess)
 flgin=0;
 while flgin==0
  hh=input('\n   specificare il tempo di preazione: kp = ');
  if ~isempty(hh), h=round(abs(hh)); flgin=1; end
 end
 ordf(1)
else
 h=0;
end

clc
disp(' ')
fprintf('Ritardo di grado relativo del sistema: D_r=%.3g campioni\n',k)
fprintf('Ritardo di preazione: D_p=%.3g campioni\n',h)

% correction for difference od order ordiff
P=den; Q=num1;
[zd,pd,kd]=tozpk(P,Q);
for kk=1:ordiff
  zd=[zd;0]; pd=[pd;1];
end

% cancellation of equal poles and zeros
md=length(zd); nd=length(pd);
iz=ones(md,1); ip=ones(nd,1);
for kk=1:md
 for kh=1:nd
  if (abs(zd(kk)-pd(kh))<=10^(-8))&(ip(kh)~=0)
   iz(kk)=0; ip(kh)=0; break
  end
 end
end
zd=zd(find(iz)); pd=pd(find(ip));

if length(zd)~=length(pd)
  disp(' ');
  error(' **** errore di scomposizione in perftra'); return
end

[P,Q]=dezpk(zd,pd,kd);
p=[pd;0];
ii=find(abs(p-1)<10^(-8)); p(ii)=ones(length(ii),1);
Im=find(abs(p)<=1); pm=p(Im); Qm=real(poly(pm));
Ip=find(abs(p)>1); pp=p(Ip); Qp=real(poly(pp));
[Pp,Pm]=diopha(Qm,Qp,P);
Pp=[Pp,0]; Qm=Qm(1:length(Qm)-1);
%ii=find(pm==0); pm=[pm(1:ii-1),pm(ii+1:length(pm))];

% the postaction compensator

nums=Pm; dens=Qm;
disp(' ')
disp('Compensatore degli zeri stabili:')
% correction for difference (only in the display)
[zx,px,kx]=tozpk(nums,dens);
for kk=1:ordiff
  zx=[zx;1]; px=[px;0];
end
tfm(zx,px,kx,'g_s',1)

% the preaction compensator

n1=length(Qp); n2=length(Pp);
Pp1=[zeros(1,n1-n2) Pp];
grp=filter([Pp1(n1:-1:1)],Qp(n1:-1:1),[1 zeros(1,h+1)]);
if h>0, nump=grp(h+1:-1:2); else, nump=0; end
denp=[1,zeros(1,h-1)];

disp(' ')
disp('Compensatore degli zeri instabili:')
% correction for difference (only in the display)
nump1=nump; denp1=denp;
for kk=1:ordiff
  nump1=conv(nump1,[1,-1]); denp1=conv(denp1,[1,0]);
end
tfm(nump1,denp1,'g_p',1)
disp(' ')

disp(xx), pause
clc

disp(' ')
disp('Ritardo complessivo:')
DD1=[1,zeros(1,h-1)];
numff1=1; denff1=[1,zeros(1,k+h)];
aa=importf(numff1,denff1,arg3,1);
if aa==1, tfg(arg3), end
disp(' ')

numff2=sumpol(conv(nump,[dens,zeros(1,h)]),conv(denp,nums));
denff2=conv(denp,[dens,zeros(1,h)]);

flgg=0;
while flgg==0
 if (numff2(length(numff2))==0)&(denff2(length(denff2))==0)
  numff2=numff2(1:length(numff2)-1); denff2=denff2(1:length(denff2)-1);
 else
  flgg=1;
 end
end

kff2=numff2(1); numff2=numff2/numff2(1);
kff2=kff2/denff2(1); denff2=denff2/denff2(1);

Numc=numff2; Denc=denff2; kc=kff2;
Num1=[1 -1]; Den1=[1 0]; k1=1;

% correction for difference in the overall feedback compensator
for kk=1:ordiff
  [Numc,Denc,kc]=prodg(Numc,Denc,kc,Num1,Den1,k1,0);
%  zd=[zd;1]; pd=[pd,0]
end
aa=stf(Numc,Denc,kc,'z',arg4);
disp(' ')
disp(['Unit',aA,' ad azione in avanti verso l''ingresso del sistema ',...
'controllato:'])
if aa==1, tfg(arg4), end
disp(' ')

disp(xx)
pause

if ffor==1
 flgf=input(['\n   una sola unit',aA,' ad azione in avanti ? (1) : ']);
end
if isempty(flgf), flgf=0; end
if flgf==1
% clc
 figure, tfblff(3,arg1,arg2,arg3,arg4,'?','bl2')
 nfig3=gcf; nfigs3=int2str(nfig3);
 flin=0;
 while flin==0
  arg5=input('\n   specificare un nome per la sua f.d.t. : ','s');
  if length(arg5)~=0, flin=1; end
 end
 tfblff(3,arg1,arg2,arg3,arg4,arg5,'bl2')
 prodgm(arg4,arg1,arg5,1)
 sumgm(arg3,arg5,arg5,0)
 [numff2,denff2]=exportf(arg5);
 flgg=0;
 while flgg==0
  if (numff2(length(numff2))==0)&(denff2(length(denff2))==0)
   numff2=numff2(1:length(numff2)-1); denff2=denff2(1:length(denff2)-1);
  else
   flgg=1;
  end
 end

 aa=importf(numff2,denff2,arg5,1);
 clc
 disp(' ')
 disp(['Unit',aA,' ad azione in avanti verso la giunzione sommante:'])
 if aa==1, tfg(arg5), end
 disp(' ')
 disp(xx)
 pause
% disp(' ')
 delete(gcf)
 mess5=[arg5,' unica unit',aA,' ad azione',...
 ' in avanti verso la giunzione sommante'];
end

% simulation

flgs=input('\n   verificare il comportamento del sistema ? (1) : ');
if isempty(flgs), flgs=0; end

if flgs==1

num_numr=conv(num,numr);
den_denr=conv(den,denr);
num_denr=conv(num,denr);
denloop=sumpol(num_numr,den_denr);

% The reference profile to be tracked for benchmarks

flgbench=0;
step=1;
nramp=10;
dist1=30;
dist2=20;

while flgbench==0

 U=[[step/nramp:step/nramp:step],step*ones(1,dist1),zeros(1,dist2)];
 nu=length(U);

% Ud: difference of order ordiff of the reference profile
 Ud=U;
 for kk=1:ordiff
   Ud=[diff([0,Ud])];
 end
% UU: input or difference
 UU=Ud;

% total time for plots
 ntt=[-(h+1):1:k+nu-1]; % a sample added to get a better display

% reference versus total time
 x_rif=[zeros(1,h+1) zeros(1,k) U];
 x_rifd=[zeros(1,h+1) zeros(1,k) UU];

% previewed reference versus total time
 px_rif=[0 U zeros(1,h) zeros(1,k)];
 px_rifd=[0 UU zeros(1,h) zeros(1,k)];

 sc=x_rif;
 smax=max(sc); smin=min(sc);
 delta=0.02*abs(smax-smin);
 if abs(smax-smin)<eps, delta=.001; end
 smin=smin-delta; smax=smax+delta;
 clf, ordf(3)
 if any(FIGLO(8,:))
  erx=0; eval('set(nfig,''Position'',FIGLO(8,1:4))','erx=1;')
 end
 [x1,y1]=stairs(ntt,px_rif); [x2,y2]=stairs(ntt,sc);
 subplot(211)
 ha=plot([0,0],[smin,smax],x1,y1,x2,y2);
 set(ha(1),'Color',vcol1(8,:),'LineStyle','none','Marker','.')
 set(ha(2),'Color',vcol1(3,:),'LineStyle','-')
 set(ha(3),'Color',vcol1(1,:),'LineStyle','-')
 VV=axis; VV(1:2)=[min(ntt),max(ntt)]; axis(VV), grid, xlabel(mess)
 aat=setstr(32*ones(1,120)); aam=sprintf('k');
 mess=[aat(1:120-length(aam)),aam]; xlabel(mess)
 if titlenable==1
  title('riferimento preconosciuto (c) e riferimento da inseguire (g)')
 end
 sc=px_rifd;
 smax=max(sc); smin=min(sc);
 delta=0.02*abs(smax-smin);
 if abs(smax-smin)<eps, delta=.001; end
 smin=smin-delta; smax=smax+delta;
 [x1,y1]=stairs(ntt,sc);
 subplot(212)
 ha=plot([0,0],[smin,smax],x1,y1);
 set(ha(1),'Color',vcol1(8,:),'LineStyle','none','Marker,'.')
 set(ha(2),'Color',vcol1(3,:),'LineStyle','-')
 VV=axis; VV(1:2)=[min(ntt),max(ntt)]; axis(VV), grid, xlabel(mess)
 if titlenable==1
  title('differenza usata per i compensatori')
 end
 nfig=gcf; nfigs=int2str(nfig); figure(nfig)
 xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
 FFLOC=get(nfig,'Position');
 clc
 fff=input('\n   cambiare i parametri del profilo ? (1) : ');
 if isempty(fff), fff=0; end
 if fff==1
  mess='\n   valore costante dopo la rampa (default=1) : ';
  step1=input(mess);
  if length(step1)==0, step=1; else, step=step1; end
  mess='\n   numero di campioni nella rampa (default=10) : ';
  nramp1=input(mess);
  if length(nramp1)==0, nramp=10; else, nramp=abs(nramp1); end
  mess='\n   numero di campioni fra la rampa e il gradino (default=30) : ';
  dist11=input(mess);
  if length(dist11)==0, dist1=30; else, dist1=abs(dist11); end
  mess='\n   numero di campioni dopo il gradino (default=20) : ';
  dist21=input(mess);
  if length(dist21)==0, dist2=20; else, dist2=abs(dist21); end
 else
  flgbench=1;
 end
end

subplot(2,1,1), title(''), subplot(2,1,2), title('')

FFLOC=get(nfig,'Position');
% postaction profile
ttt=[zeros(1,length(Qm)-length(Pm)),Pm];
gf=filter(ttt,Qm,[1,zeros(1,nu-1+k)]);

% postaction compensation
ttt=[zeros(1,length(Qm)-length(Pm)),Pm];
u_cpost=filter(ttt,Qm,UU);
u_cpost=[zeros(1,h+1) u_cpost zeros(1,k)];

% preaction profile
Pp1=[zeros(1,n1-n2) Pp];
gr=filter([Pp1(n1:-1:1)],Qp(n1:-1:1),[1 zeros(1,h+k+nu)]);

% preaction compensation
u_cpre=zeros(1,h+k+nu);
for i=1:nu
  u_cpre=u_cpre+[zeros(1,i-1) UU(i)*gr(h+1:-1:2) zeros(1,k) zeros(1,nu-i+1)];
end
u_cpre=[0 u_cpre];
gr=[gr(h+1:-1:1) zeros(1,nu+k-1)];

% total profile
gr=[0 gr];
gf=[zeros(1,h+1) gf];
gtot=gr+gf;

% output without any correction
ttt=[zeros(1,length(denloop)-length(num_numr)),num_numr];
y_rif=filter(ttt,denloop,x_rif);

% input without any correction
numr_den=conv(numr,den);
ttt=[zeros(1,length(denloop)-length(numr_den)),numr_den];
u_rif=filter(ttt,denloop,x_rif);

% error without any correction
e_rif=x_rif-y_rif;

% total input correction
u_ctot=u_cpre+u_cpost;

% output due to the total input correction
ttt=[zeros(1,length(denloop)-length(num_denr)),num_denr];
y_ctot=filter(ttt,denloop,u_ctot);

% output due to reference and total correction
y_rif_ctot=y_rif+y_ctot;

% error due to reference and total correction
e_rif_ctot=x_rif-y_rif_ctot;

% influence of total correction on input (closed-loop)
ttt=[zeros(1,length(denloop)-length(den_denr)),den_denr];
u_cclo=filter(ttt,denloop,u_ctot);

% influence of reference and total correction on input (closed-loop)
u_rif_ctot=u_rif+u_cclo;

% reference names for plots
nome=['x_rif      '];
nome=[nome;'gr         ';'gf         ';'gtot       '];
nome=[nome;'u_cpre     ';'u_cpost    ';'u_ctot     '];
nome=[nome;'u_rif      ';'u_rif_ctot '];
nome=[nome;'y_rif      ';'y_rif_ctot '];
nome=[nome;'e_rif      ';'e_rif_ctot '];

options=[];
options=[options;'riferimento (ritardato del grado relativo dell''impianto)'];
options=[options;'pre-azione per un impulso della differenza scelta       '];
options=[options;'post-azione per un impulso della differenza scelta      '];
options=[options;'correzione per un impulso della differenza scelta       '];
options=[options;'pre-azione per l''intero riferimento                     '];
options=[options;'post-azione per l''intero riferimento                    '];
options=[options;'correzione per l''intero riferimento                     '];
options=[options;'ingresso del sistema controllato senza correzione       '];
options=[options;'ingresso del sistema controllato con correzione         '];
options=[options;'uscita del sistema controllato senza correzione         '];
options=[options;'uscita del sistema controllato con correzione           '];
options=[options;'errore di inseguimento senza correzione                 '];
options=[options;'errore di inseguimento con correzione                   '];
options=[options;'definire una nuova finestra grafica                     '];

vcol=[2;3;3;3;3;3;3;6;6;1;1;5;5];

% managing the available plots

esci=0; flg=0;

while esci==0

clc
disp(' ')
disp('   GRAFICI DISPONIBILI :')
disp(' ')
for kk=1:14
 tit1=options(kk,:); tit1=deblank(tit1);
 if kk<10, sz='    '; else, sz='   '; end
 disp([sz,int2str(kk),' - ',tit1])
end

in=input('\n   operare una scelta (premere invio per uscire) : ');
if isempty(in)
 cc=get(0,'Children');
 if any(cc==gcf)
  FIGLO(8,1:4)=FFLOC;
  save figlo# FIGLO -v4
 else
  disp(' '), disp(['   LA FIGURA ',EA,' STATA CANCELLATA!'])
 end
 eval('delete(men_gr)','err=1;'), eval('delete(men_zoom)','err=1;')
 ordf(1), ABIL=0; return
else
 in=round(in);
 if (in>=1)&(in<=13)
  nome1=nome(in,:); nome1=nome1(find(nome1~=' '));
  tit1=options(in,:); tit1=deblank(tit1); col=vcol(in);
  eval(['s=',nome1,';']); smax=max(s); smin=min(s);
  delta=0.02*abs(smax-smin);
  if abs(smax-smin)<eps, delta=.001; end
  smin=smin-delta; smax=smax+delta;
  if (flg==0)&(flgmen==0)
   men_opt=uimenu(gcf,'Label','Memo');
   mess=['progetto di sistema ad azione in avanti per l''inseguimento'...
   ' perfetto digitale'];
   uimenu(men_opt,'Label',mess);
   TRF1=[arg1,'g'];
   uimenu(men_opt,'Label',mess1,'Separator','on',...
   'Callback','subplot(2,1,1),tfmaux(1,1,0)');
   TRF2=[arg2,'b'];
   uimenu(men_opt,'Label',mess2,...
   'Callback','subplot(2,1,1),tfmaux(2,1,0)');
   TRF3=[arg3,'c'];
   uimenu(men_opt,'Label',mess3,...
   'Callback','subplot(2,1,1),tfmaux(3,1,0)');
   TRF4=[arg4,'c'];
   uimenu(men_opt,'Label',mess4,...
   'Callback','subplot(2,1,1),tfmaux(4,1,0)');
   men_gr=uimenu(gcf,'Label','Reticolo on/off','Callback','gridmng(6)');
   men_zoom=uimenu(gcf,'Label','Zoom on/off','Callback','zoom');
   if flgf==1
    TRF5=[arg5,'c'];
    uimenu(men_opt,'Label',mess5,...
    'Callback','subplot(2,1,1),tfmaux(5,1,0)');
   end
   flgmen=1;
  end
  if flg==0
   ordf(3), set(gcf,'Position',FFLOC)
   subplot(2,1,1), cla, set(gca,'Box','on')
   subplot(2,1,2), cla, set(gca,'Box','on'), title('')
   [x1,y1]=stairs(ntt,s);
   subplot(2,1,1), reset(gca)
   plot([0,0],[smin,smax],'Color',vcol1(8,:),'LineStyle','none','Marker','.')
   hold on, plot(x1,y1,'Color',vcol1(col,:),'LineStyle','-')
   VV=axis; VV(1:2)=[min(ntt),max(ntt)]; axis(VV), grid
   if titlenable==1, title(tit1), end
   aat=setstr(32*ones(1,120)); aam=sprintf('k');
   mess=[aat(1:120-length(aam)),aam]; xlabel(mess)
   figure(gcf)
   nfigs=int2str(gcf); ABIL=2.2;
   xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   flg=1;
  else
   hold off
   [x1,y1]=stairs(ntt,s);
   subplot(2,1,2), reset(gca)
   plot([0,0],[smin,smax],'Color',vcol1(8,:),'LineStyle','none','Marker','.')
   hold on, plot(x1,y1,'Color',vcol1(col,:),'LineStyle','-')
   VV=axis; VV(1:2)=[min(ntt),max(ntt)]; axis(VV), grid
   if titlenable==1, title(tit1), end
   aat=setstr(32*ones(1,120)); aam=sprintf('k');
   mess=[aat(1:120-length(aam)),aam]; xlabel(mess)
   figure(gcf)
   nfigs=int2str(gcf);
   xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   FFLOC=get(gcf,'Position');
   flg=0;
  end
 elseif in==14
  eval('delete(men_gr)','err=1;'), eval('delete(men_zoom)','err=1;')
  ordf(1), figure, ordf(1), flg=0; flgmen=0;
 end
 end % while
end % if length(in)==0
end % if flgs==1
% --- last line of perftra ---
