function [egv1,mul1,egv2,mul2,k]=ordg(Num,Den,k)
%ORDG	  Selection of numerator and denominator factors (aux for TFI).
%   [egv1,mul1,egv2,mul2,k]=ORDG(Num,Den,k) provides factors of Num,Den
%   in egv1,egv2 and their multiplicity in mul1,mul2.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(3,3,nargs));
ln=size(Num); ld=size(Den);
Num1=Num; Den1=Den;
an=ones(1,ln(1)); bn=zeros(1,ln(1));
ad=ones(1,ld(1)); bd=zeros(1,ld(1));
for i=1:ln(1)
 for j=1:ln(1)
  if ~(any(Num(i,:)-Num1(j,:)))
   if bn(i)>=1, an(j)=0; end
   Num1(j,:)=zeros(1,ln(2));
   bn(i)=bn(i)+1;
  end
 end
end
for i=1:ld(1)
 for j=1:ld(1)
  if ~(any(Den(i,:)-Den1(j,:)))
   if bd(i)>=1, ad(j)=0; end
   Den1(j,:)=zeros(1,ld(2));
   bd(i)=bd(i)+1;
  end
 end
end
an=find(an); ad=find(ad);
[ss1,a1]=sort(sum(abs(Num(an,:))'));
egv1=Num(an,:); mul1=bn(an);
egv1=egv1(a1,:); mul1=mul1(a1)';
[ss2,a2]=sort(sum(abs(Den(ad,:))'));
egv2=Den(ad,:); mul2=bd(ad);
egv2=egv2(a2,:); mul2=mul2(a2)';
% --- last line of ordg ---
