function ordf(aa)
%ORDF	  Riduce le figure e le dispone sfalsate in alto a destra.

%   ordf    locates all the defined figures as small.
%   ordf(1) locates the current figure as small at the top of the screen:
%	    location is from right to left by equal steps.
%   ordf(2) produces medium size and location top/right.
%   ordf(3) produces full size.
%   ordf(4) produces 20% reduction.
%   ordf(5) produces 20% enlargement.
%   ordf(6) & ordf(7) shift a large figure towards the left by an amount
%	    related to the screen size.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

if exist('legen#.mat'), load legen#, else, legen=0; islegen=0; end
% the size of the full screen (depending of the Windows screen settings)
VVFULL=get(0,'ScreenSize'); % VVFULL is a [1 times 4] matrix
%
% the reference numbers of the open graphic windows
nfig=get(0,'Children'); % nfig is a [(no-of-figs) times 1] matrix
nfig=sort(nfig');
XL=VVFULL(3); YL=VVFULL(4);
%
%   this parameters can be changed to personalize your installation
%
XS=229; YS=137; % small figure size
XM=400; YM=240; % medium figure size
DX=12;		% step of small figures locations
%
VVL=VVFULL;
% fll=0; DDD=0; xx=version; if strcmp(xx(1:3),'5.3'), fll=1; DDD=10; end %5.3
DDD=0;
VVS=round([XL*.92-XS,YL-DDD-YS-50,XS,YS]);
VVM=round([XL*.92-XM,YL-DDD-YM-50,XM,YM]);
%
VV1=VVS(1);
if nargin==0
 for kk=nfig
  shift=DX*(kk-1);
  if shift<XL-XS
   VVS(1)=VV1-shift;
  else
   VVS(1)=VV1-XL+XS-2*DX;
  end
  set(kk,'Position',VVS), figure(kk)
 end
 return
end
if aa==1
 shift=DX*(gcf-1);
 if shift<XL-XS
  VVS(1)=VV1-shift;
 else
  VVS(1)=VV1-XL+XS-2*DX;
 end
 set(gcf,'Position',VVS);
elseif aa==2
 set(gcf,'Position',VVM);
elseif (aa==3)|(aa==6)|(aa==7)
 if abs(VVL(3)-640)<10
  Pos=[5 6-DDD 630 430];			% 640x480
 elseif abs(VVL(3)-800)<10
  Pos=[5+(760-630) 36-DDD+(520-430) 630 430];	% 800x600
 elseif abs(VVL(3)-1024)<10
  Pos=[5+(980-630) 36-DDD+(690-430) 630 430];	% 1024x768
 else
  Pos=[5+(1180-630) 36-DDD+(940-430) 630 430];	% 1280x1024
 end
 set(gcf,'Position',Pos)
elseif aa==4
 VV=get(gcf,'Position');
 if VV(3)>XS
  if VV(3)==XL, flg=1; else, flg=0; end
  AX=round(.8*VV(3)); AY=round(AX*YL/XL);
  VV=[VV(1)+VV(3)-AX,VV(2)+VV(4)-AY,AX,AY];
  if flg==1, VV(1)=round(XL*.92-AX); VV(2)=round(YL-AY-50); end
  if AX<XS, VV=VVS; end
  set(gcf,'Position',VV);
 end
elseif aa==5
 VV=get(gcf,'Position');
 if VV(3)<XL
  AX=round(1.2*VV(3)); AY=round(AX*YL/XL);
  VV=[VV(1)+VV(3)-AX,VV(2)+VV(4)-AY,AX,AY];
  if AX>XL, VV=VVL; end
  set(gcf,'Position',VV);
 end
end
if aa==6
 if abs(XL-640)>10
  Pos(1)=round(Pos(1)-(.70*(XL-Pos(3)))/2);
  set(gcf,'Position',Pos)
 end
elseif aa==7
 if abs(XL-640)>10
  Pos(1)=round(Pos(1)-(.70*(XL-Pos(3)))/1);
  set(gcf,'Position',Pos)
 end
end
% ----- end line of ordf -----
