function nygrid(s)
%NYGRID   Constant M and N loci for a Nyquist plot.
%   NYGRID(1) clears the graphic window and sets HOLD ON so that the
%   Nyquist diagram can be plot over the grid.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

[tp1,tp2,tp3,tp4]=coltbl;
if tp1(7,1)==1, BW='w'; else, BW='k'; end
status=ishold;
if nargin==1
 VV=[-2 2 -1.5 1.5]; hold off
else
 VV=axis; hold on
end
fsize=get(gca,'FontSize'); fsize=fsize-2;
%
i=sqrt(-1);
plot([VV(1),VV(2)],[0,0],[BW,':']), hold on
plot([-.5,-.5],[VV(3),VV(4)],[BW,':'])
%
%  plot phase lines
%
pp=[-15 -30 -45 -60 -90 -120 -150 150 120 90 60 45 30 15];
%
vv=logspace(-2,0,24);
for kk=1:2
 mx=[0,(-1)^(kk-1)*15*vv]; mx=10 .^(mx/20);
 [p,m]=meshgrid(pp,mx);
 z=m.*exp(i*p/180*pi); g=z./(1-z); xx=real(g); yy=imag(g);
 plot(xx,yy,[BW,':']);
end
vx=18;
for k=1:length(pp)
 x1=xx(vx,k); y1=yy(vx,k);
 if (x1>VV(1))&(x1<VV(2))&(y1>VV(3))&(y1<VV(4))
  text(x1,y1,sprintf('%.3g',pp(k)),'FontSize',fsize)
 end
end
text(-.45,0,sprintf('-180'),'FontSize',fsize)
%
%  plot magnitude lines
%
mm1=[15 12 9.5 7.5 6 4.5 3 1.5 -1.5 -3 -4.5 -6 -7.5 -9.5 -12 -15];
mm=10 .^(mm1/20);
%
px=[0,180*vv];
for kk=1:2
 px=(-1)^(kk-1)*px;
 [p,m]=meshgrid(px,mm);
 z=m.*exp(i*p/180*pi); g=z./(1-z); xx=real(g); yy=imag(g);
 plot(xx',yy',[BW,':']);
end
vx=17;
for k=1:length(mm)
 x1=xx(k,vx); y1=yy(k,vx);
 if (x1>VV(1))&(x1<VV(2))&(y1>VV(3))&(y1<VV(4))
  text(x1,y1,sprintf('%.3g',mm1(k)),'FontSize',fsize)
 end
end
text(-.5,-1.42,'0','FontSize',fsize)
%
if nargin==1
 axis(VV)
else
 axis(axis)
end
%
if (nargin==0)&(~status), hold off, end %  return hold to previous status
%
% --- last line of nygrid ---
