function nlsim(arg1,arg2,arg3,arg4)
%NLSIM    Simulazione di sistema in retroazione non lineare (TFI).
%   Possibili usi:
%   NLSIM,gi,gj,f,gw - da TFI
%   NLSIM('gi','gj','f','gw') - da Matlab
%     gi: f.d.t fra giunzione sommante e blocco non lineare
%     gj: f.d.t del sistema controllato (in cascata al blocco npn lineare)
%     f : f.d.t. del collegamento di retroazione
%     gw: trasformata di Laplace del segnale di riferimento (es., gw=K/s)
%   NOTA: le stringhe gi ed f possono riferirsi a numeri reali positivi,
%   mentre si richiede che gj e gw siano strettamente proprie.
%   Il tipo di nonlinearita' e parametri sono comunicati in interattivo.
%   I tipi sono: saturazione, soglia, saturazione con soglia, qualunque
%   caratteristica ottenuta per interpolazione lineare fra punti dati,
%   rele' ideale, rele' con soglia, rele' con isteresi, gioco.
%   Per percorrere un ciclo limite stabile con ingresso nullo, si puo'
%   perturbare il sistema con un impulso [ad es. ponendo gw=K/(1+s)].

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global ABIL TRF1 TRF2 TRF3 TRF4 gr nfig nfig1 HALEG FIGLEG LABLEG SUBPLEG

ABIL=0; aA=setstr(224); eA=setstr(232); oA=setstr(242); EA=setstr(200);
nfig=gcf; nfigs=int2str(nfig); nfig1=nfig+1; nfigs1=int2str(nfig1);
FIGLEG=nfig; HALEG=[]; LABLEG=[]; SUBPLEG=0; FIGLO=resfiglo;
[vcol1,vcol2,repco]=coltbl;
cs=['r','g','b','c']; % the default color sequence
err='err'; fleg=0; fluim1=0; fluim3=0; izy=0;
ms1=['\n **** errore: non si pu',oA,' cambiare figura durante l''esecuzione\n'];
hold off, clf
if exist('legen#.mat'), load legen#, else, legen=0; islegen=0; end
nargs=nargin; gr=0;
if (nargs~=0)&(nargs~=4)
 disp(' **** errore: numero di argomenti non valido in nlsim'), return
end
if nargs==0
 mess='\n   f.d.t. fra giunzione sommante ed NL (ingresso) : ';
 arg1=input(mess,'s');
 if isempty(arg1), arg1='0'; end, if arg1=='0', return, end
 mess='\n   f.d.t. del sistema controllato (ingresso) : ';
 arg2=input(mess,'s');
 if isempty(arg2), arg2='0'; end, if arg2=='0', return, end
 mess='\n   f.d.t. del collegamento di retroazione (ingresso) : ';
 arg3=input(mess,'s');
 if isempty(arg3), arg3='0'; end, if arg3=='0', return, end
 mess='\n   trasformata di Laplace del riferimento (ingresso) : ';
 arg4=input(mess,'s');
 if isempty(arg4), arg4='0'; end, if arg4=='0', return, end
end
%
st1=arg1(1);
rop=((abs(st1)>=48)&(abs(st1)<=57))|(abs(st1)==46);
if rop
 st=eval(arg1,'err');
 if isstr(st), disp(' **** errore di ingresso in nlsim'), return, end
else
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 end
 st=arg1; fluim1=1;
end
if isstr(st)
 [zr,pr,kr,str1]=exportf(arg1,1); if isempty(kr), return, end
else
 zr=[];, pr=[]; kr=abs(st); str1='s';
end
[ar,br,cr,dr]=jorcf(zr,pr,kr);
if ~exist([arg2,'.mat'])
 disp([' **** error: ',arg2,'.mat non esiste']), return
end
[zp,pp,kp,str2]=exportf(arg2,1); if isempty(kp), return, end
[ap,bp,cp,dp]=jorcf(zp,pp,kp);
if dp~=0
 disp([' **** errore: la f.d.t. ',arg2,' deve essere strettamente propria'])
 return
end
st1=arg3(1);
rop=((abs(st1)>=48)&(abs(st1)<=57))|(abs(st1)==46);
if rop
 st=eval(arg3,'err');
 if isstr(st), disp(' **** errore di ingresso in nlsim'), return, end
 if err==1, disp(' **** errore di ingresso in nlsim'), return, end
else
 if ~exist([arg3,'.mat'])
  disp([' **** errore: ',arg3,'.mat non esiste']), return
 end
 st=arg3; fluim3=1;
end
if isstr(st)
 [zf,pf,kf,str3]=exportf(arg3,1); if isempty(kf), return, end
else
 zf=[];, pf=[]; kf=abs(st); str3='s';
end
[af,bf,cf,df]=jorcf(zf,pf,kf);
if ~exist([arg4,'.mat'])
 disp([' **** errore: ',arg4,'.mat non esiste']), return
end
[ze,pe,ke,str4]=exportf(arg4,1); if isempty(ke), return, end
[ae,be,ce,de]=jorcf(ze,pe,ke);
if de~=0
 disp([' **** errore: la f.d.t. ',arg4,' deve essere strettamente propria'])
 return
end
if (str1=='z')|(str2=='z')|(str3=='z')|(str4=='z')
 disp('   **** il programma nlsim si applica solo a sistemi a tempo continuo')
 return
end
%
tfblocks(6,arg1,'NL',arg2,arg3,arg4,'','','','','')
flg=0; VV=zeros(1,4); clf, ordf(1)
while flg==0
 clc, disp(' ')
 disp('   Scegliere l''elemento non lineare :')
 disp(' ')
 disp('    1 - saturazione')
 disp('    2 - soglia')
 disp('    3 - saturazione con soglia')
 disp(['    4 - qualunque nonlinearit',aA,' interpolata linearmente'])
 disp(['    5 - rel',eA,' ideale'])
 disp(['    6 - rel',eA,' con soglia'])
 disp(['    7 - rel',eA,' con isteresi'])
 disp('    8 - gioco')
 izz=input('\n   operare una scelta (0 per uscire) : '); %5.3
 if isempty(izz), izz=-1; end
 izz=round(izz);
 if izz==0, ordf(1), return, end
 if (izz>=1)&(izz<=8), flg=1; end
end
%
figure(nfig1), ordf(1), clf
if izz==1
 mess1='saturazione';
 flg=0;
 while flg==0
  xd=input(['\n   intervallo di linearit',aA,' [X1 X2] : ']);
  if length(xd)==2
   if xd(2)>xd(1), flg=1; end
  end
 end
 flg=0;
 while flg==0
  yd=input('\n   livelli di saturazione [Y1 Y2] : ');
  if length(yd)==2, flg=1; end
 end
 yx=sort(yd);
 dx=(xd(2)-xd(1))*1.1; VV(1)=xd(1)-.8*dx; VV(2)=xd(2)+.8*dx;
 dy=(yx(2)-yx(1))*1.1; VV(3)=yx(1)-.1*dy; VV(4)=yx(2)+.1*dy;
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 xd=[-10^8,xd,10^8];
 yd=[yd(1),yd,yd(2)];
 x=[VV(1),xd(2:3),VV(2)]; y=yd;
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
%
elseif izz==2
 mess1='soglia';
 flg=0;
 while flg==0
  xd=input('\n   intervallo di soglia [X1 X2] : ');
  if length(xd)==2
   if xd(2)>xd(1), flg=1; end
  end
 end
 flg=0;
 while flg==0
  md=input('\n   guadagno nella zona lineare m : ');
  if length(md)==1, flg=1; end
 end
 dx=(xd(2)-xd(1))*1.1; VV(1)=xd(1)-2*dx; VV(2)=xd(2)+2*dx;
 VV(3)=-1.2*2*dx*abs(md); VV(4)=-VV(3);
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 xd=[-10^8,xd,10^8];
 yd=[(xd(1)-xd(2))*md,0,0,(xd(4)-xd(3))*md];
 x=[VV(1),xd(2:3),VV(2)];  y=[(x(1)-x(2))*md,0,0,(x(4)-x(3))*md];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
%
elseif izz==3
 mess1='saturazione con soglia';
 flg=0;
 while flg==0
  xd=input(['\n   punti di discontinuit',aA,' sull''asse x [X1 X2 X3 X4] : ']);
  if length(xd)==4
   if (xd(2)>xd(1))&(xd(3)>xd(2))&(xd(4)>xd(3)), flg=1; end
  end
 end
 flg=0;
 while flg==0
  yd=input('\n   livelli di saturazione [Y1 Y2] : ');
  if length(yd)==2, flg=1; end
 end
 yx=sort(yd);
 dx=(xd(4)-xd(1))*1.1; VV(1)=xd(1)-dx; VV(2)=xd(4)+dx;
 dy=(yx(2)-yx(1))*1.1; VV(3)=yx(1)-.1*dy; VV(4)=yx(2)+.1*dy;
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 xd=[-10^8,xd,10^8];
 yd=[yd(1),yd(1),0,0,yd(2),yd(2)];
 x=[VV(1),xd(2:5),VV(2)]; y=yd;
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
%
elseif izz==4
 mess1=['nonlinearit',aA,' interpolata linearmente'];
 flg=0; flg1=0;
 while flg==0
  while flg1==0
   xd=input(['\n   punti di discontinuit',aA,' in x [x1 x2 x3 ...] : ']);
   lx=length(xd);
   if lx==1
    if xd==0, eval('delete(nfig1)','err=1;'), ordf(1), return, end
   end
   if lx>=2, flg1=1; else, xd=[1,2]; lx=2; end
   if (abs(xd(1)-xd(2))<eps)|(abs(xd(lx)-xd(lx-1))<eps)
    disp(' '), disp(' **** illegal initial or final slope'), flg1=0;
   end
  end
  yd=input(['\n   punti di discontinuit',aA,' in y [y1 y2 y3 ...] : ']);
  ly=length(yd);
  if lx==ly, flg=1; end
 end
 [xd,ii]=sort(xd); yd=yd(ii);
 m1=(yd(1)-yd(2))/(xd(1)-xd(2)); m2=(yd(lx)-yd(lx-1))/(xd(lx)-xd(lx-1));
 dx=(xd(lx)-xd(1))*1.1; VV(1)=xd(1)-.2*dx; VV(2)=xd(lx)+.2*dx;
 dy=(max(yd)-min(yd))*1.1; VV(3)=min(yd)-.1*dy; VV(4)=max(yd)+.1*dy;
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 xd=[-10^8,xd,10^8]; lx=length(xd);
 yd=[yd(1)+(xd(1)-xd(2))*m1,yd,yd(ly)+(xd(lx)-xd(lx-1))*m2];
 x=[VV(1),xd(2:lx-1),VV(2)];
 y=[yd(2)+(x(1)-x(2))*m1,yd(2:lx-1),yd(lx-1)+(x(lx)-x(lx-1))*m2];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
%
elseif izz==5
 mess1=['rel',eA,' ideale'];
 flg=0;
 while flg==0
  xd=input(['\n   punto di discontinuit',aA,' sull''asse x (default 0) : ']);
  if length(xd)==0, xd=0; end
  if length(xd)==1, flg=1; end
 end
 flg=0;
 while flg==0
  yd=input('\n   livelli di saturazione [Y1 Y2] : ');
  if length(yd)==2, flg=1; end
 end
 yx=sort(yd);
 VV(1)=xd-5; VV(2)=xd+5;
 dy=(yx(2)-yx(1))*1.1; VV(3)=yx(1)-.1*dy; VV(4)=yx(2)+.1*dy;
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 x=[VV(1),xd,xd,VV(2)]; y=[yd(1),yd(1),yd(2),yd(2)];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
%
elseif izz==6
 mess1=['rel',eA,' con soglia'];
 flg=0;
 while flg==0
  xd=input(['\n   punti di discontinuit',aA,' in x [X1 X2] : ']);
  if length(xd)==2
   if xd(2)>xd(1), flg=1; end
  end
 end
 flg=0;
 while flg==0
  yd=input('\n   i tre livelli dell''uscita [Y1 Y2 Y3] : ');
  if length(yd)==3
   yx=sort(yd);
   if yd(2)==yx(2), flg=1; end
  end
 end
 dx=(xd(2)-xd(1))*1.1; VV(1)=xd(1)-2*dx; VV(2)=xd(2)+2*dx;
 dy=(yx(3)-yx(1))*1.1; VV(3)=yx(1)-.1*dy; VV(4)=yx(3)+.1*dy;
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 x=[VV(1),xd(1),xd,xd(2),VV(2)]; y=[yd(1),yd(1),yd(2),yd(2),yd(3),yd(3)];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
%
elseif izz==7
 mess1=['rel',eA,' con isteresi'];
 flg=0;
 while flg==0
  xd=input(['\n   punti di discontinuit',aA,' in x [X1 X2] : ']);
  if length(xd)==2
   if xd(2)>xd(1), flg=1; end
  end
 end
 flg=0;
 while flg==0
  yd=input('\n   i due livelli dell''uscita [Y1 Y2] : ');
  if length(yd)==2, flg=1; end
 end
 yx=sort(yd);
 dx=(xd(2)-xd(1))*1.1; VV(1)=xd(1)-2*dx; VV(2)=xd(2)+2*dx;
 dy=(yx(2)-yx(1))*1.1; VV(3)=yx(1)-.1*dy; VV(4)=yx(2)+.1*dy;
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 x=[VV(1),xd(2),xd(2),VV(2)]; y=[yd(1),yd(1),yd(2),yd(2)];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
 x=[VV(2),xd(1),xd(1),VV(1)]; y=[yd(2),yd(2),yd(1),yd(1)];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-')
%
elseif izz==8
 mess1='backlash';
 flg=0;
 while flg==0
  xd=input('\n   intervallo di gioco [X1 X2] : ');
  if length(xd)==2
   if (xd(1)<0)&(xd(2)>0), flg=1; end
  end
 end
 flg=0;
 while flg==0
  md=input('\n   guadagno nella zona lineare m : ');
  if length(md)==1, flg=1; end
 end
 dx=xd(2)-xd(1); VV(1)=xd(1)-2*dx; VV(2)=xd(2)+2*dx;
 VV(3)=1.1*(VV(1)-xd(1))*abs(md); VV(4)=-VV(3);
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 x=[.8*VV(1),.8*VV(1)+(xd(2)-xd(1)),.8*VV(2)];
 y=[(x(1)-xd(1))*md,(x(1)-xd(1))*md,(x(3)-xd(2))*md];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
 x=[.8*VV(2),.8*VV(2)-(xd(2)-xd(1)),.8*VV(1)];
 y=[(x(1)-xd(2))*md,(x(1)-xd(2))*md,(x(3)-xd(1))*md];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-')
end
%
xa=[VV(1),VV(2)]; ya=[0,0]; xb=[0,0]; yb=[VV(3),VV(4)];
ha=plot(xa,ya,xb,yb);
set(ha(1),'Color',vcol1(7,:),'LineStyle',':')
set(ha(2),'Color',vcol1(7,:),'LineStyle',':')
title('relazione ingresso-uscita di NL')
figure(nfig1), ordf(2), hold off
%
xyx=input('\n   **** premere invio per proseguire ','s'); ordf(1)
%
%   Automatic scaling for the first plot
%
p=[pp;pf;pr;pe];
tol=10^(-4)*max(abs(p)); ii=find(abs(p)>tol);
if isempty(ii)
 t1=10;
else
 p1=p(ii); p1r=abs(real(p1)); p1i=abs(imag(p1));
 pir=p1i./(p1r+10^(-8)); p1i=p1i(find(pir>.1));
 p1r=p1r(find(p1r>tol)); p1i=p1i(find(p1i>tol)); sig=min([p1r;p1i]); tt=8/sig;
 vv=log10([1,1.2,1.6,2,2.5,3,4,5,8,10]);
 uu=log10(tt); uu1=floor(uu); uu2=uu-uu1;
 [ww,ii]=min(abs(vv-uu2)); t1=10^(uu1+vv(ii));
end
%
%   Construction of the state space matrices
%
np=length(ap); nf=length(af); nr=length(ar); ne=length(ae);
%
if (nf~=0)&(nr~=0)
 AA=[ap, zeros(np,nf), zeros(np,nr), zeros(np,ne);...
 bf*cp, af, zeros(nf,nr), zeros(nf,ne);...
 -br*df*cp, -br*cf, ar, br*ce;...
 zeros(ne,np), zeros(ne,nf), zeros(ne,nr), ae];
elseif (nf~=0)&(nr==0)
 AA=[ap, zeros(np,nf), zeros(np,ne);...
 bf*cp, af, zeros(nf,ne);...
 zeros(ne,np), zeros(ne,nf), ae];
elseif (nf==0)&(nr~=0)
 AA=[ap, zeros(np,nr), zeros(np,ne);...
 -br*df*cp, ar, br*ce;...
 zeros(ne,np), zeros(ne,nr), ae];
else
 AA=[ap, zeros(np,ne);...
 zeros(ne,np), ae];
end
%
BB=[bp; zeros(nf,1); zeros(nr,1); zeros(ne,1)];
IS=[zeros(np,1); zeros(nr,1); zeros(nf,1); be];
CC=[cp, zeros(1,nf), zeros(1,nr), zeros(1,ne)];
RR=[zeros(1,np), zeros(1,nf), zeros(1,nr), ce];
EE=[-dr*df*cp, -dr*cf, cr, dr*ce];
%
%   Computation of the time response
%
figure(nfig), clf, ordf(3)
if any(FIGLO(7,:))
 eval('set(nfig,''Position'',FIGLO(7,1:4))','erx=1;') %5.3
end
flg=0; comp=1; fff=0; ffp=1; flx=0; fly=0; flv=1;
nt=6001; t0=0; %   zero is included
ntf=10; ll=(nt-1)/ntf+1;
rr=zeros(1,ll); xnlt=zeros(1,ll); ynlt=zeros(1,ll);
y=zeros(1,ll); ynlr=zeros(1,ll); tr=zeros(1,ll);
while flg==0
 if comp==1
  disp(' ')
  disp('   **** elaborazione in corso ... attendere, prego')
  dt=(t1-t0)/(nt-1); t=t0:dt*ntf:t1;
  [tm,n]=size(AA); [tm,m]=size(BB);
  AAe=expm([[AA,BB]*dt;zeros(m,n+m)]);
  AAd=AAe(1:n,1:n); BBd=AAe(1:n,n+1:n+m);
  x=IS; tcur=0;
  xo=0; yo=0; ynlv=10*eps; ynlr=[]; tr=[];
  kk=1; kp=1;
  for k=1:nt
   xnl=EE*x;
   if izz<=4   % saturation etc.
    ii=find(xnl>=xd); ii1=max(ii);
    ynl=yd(ii1)+(xnl-xd(ii1))*(yd(ii1+1)-yd(ii1))/(xd(ii1+1)-xd(ii1));
   elseif izz==5 % ideal relay
    if xnl<xd, ynl=yd(1); else, ynl=yd(2); end
    if ynl~=ynlv, ynlr=[ynlr,ynlv,ynl]; tr=[tr,tcur,tcur]; end, ynlv=ynl;
   elseif izz==6 % relay with dead zone
    if xnl<xd(1)
     ynl=yd(1);
    elseif (xnl>=xd(1)) & (xnl<xd(2))
     ynl=yd(2);
    else
     ynl=yd(3);
    end
    if ynl~=ynlv, ynlr=[ynlr,ynlv,ynl]; tr=[tr,tcur,tcur]; end, ynlv=ynl;
   elseif izz==7 % relay with hysteresis
    if xnl<xd(1)
     ynl=yd(1);
    elseif (xnl>=xd(1)) & (xnl<xd(2))
     ynl=yo;
    else
     ynl=yd(2);
    end
    yo=ynl;
    if ynl~=ynlv, ynlr=[ynlr,ynlv,ynl]; tr=[tr,tcur,tcur]; end, ynlv=ynl;
   elseif izz==8 % backlash
    y1=(xnl-xd(1))*abs(md); y2=(xnl-xd(2))*abs(md);
    if (xnl-xo)<0
     yt=min(yo,y1);
    else
     yt=max(yo,y2);
    end
    xo=xnl; yo=yt; ynl=yt*sign(md);
   end
   if kk==1
    xnlt(kp)=xnl;
    ynlt(kp)=ynl;
    rr(kp)=RR*x;
    y(kp)=CC*x;
    kp=kp+1;
    kk=kk-ntf;
   end
   kk=kk+1;
   x=AAd*x+BBd*ynl;
   tcur=tcur+dt;
  end % for k
 end % if comp
%
%   Sharpening the NL output
%
 if (izz>=5)&(izz<=7)
  ts=[tr,t1]; ynlts=[ynlr,ynlr(length(ynlr))];
 else
  ts=t; ynlts=ynlt;
 end
 MM2=max(ynlts); MM1=min(ynlts);
 y_m=MM1-.1*(MM2-MM1);
 y_M=MM2+.1*(MM2-MM1);
%
 ii=find(repco==cs(1)); c1=vcol1(ii,:);
 ii=find(repco==cs(2)); c2=vcol1(ii,:);
 ii=find(repco==cs(3)); c3=vcol1(ii,:);
 ii=find(repco==cs(4)); c4=vcol1(ii,:);
 if ffp==1
  HALEG=[];
  s1=get(gca,'XLimMode');
  if fff==0
   if strcmp(s1,'auto')
    ha=plot(t,rr,t,y,ts,ynlts,[t(2),t(2)],[y_m,y_M]);
    set(ha(1),'Color',c1,'LineStyle','-')
    set(ha(2),'Color',c2,'LineStyle','-')
    set(ha(3),'Color',c4,'LineStyle','-')
    set(ha(4),'Color',vcol1(8,:),'LineStyle','none','Marker','.')
    VV=axis; axis(VV)
   end
   ha=plot(t,rr,t,y,t,xnlt,ts,ynlts);
   set(ha(1),'Color',c1,'LineStyle','-')
   set(ha(2),'Color',c2,'LineStyle','-')
   set(ha(3),'Color',c3,'LineStyle','-')
   set(ha(4),'Color',c4,'LineStyle','-'), axis(VV)
   HALEG=ha;
   if islegen
    if legen==1, fleg=1; end
    LABLEG='''riferimento'',''uscita'',''ingresso di NL'',''uscita di NL''';
    if fleg==1, eval(['legend(HALEG,',LABLEG,')']); end
   else
    VV=axis;
    mess=['riferimento (',cs(1),'), uscita (',cs(2),'), ingresso di NL ('...
    ,cs(3),'), uscita di NL (',cs(4),')'];
    text(VV(1)+.3*(VV(2)-VV(1)),VV(3)+.04*(VV(4)-VV(3)),mess,...
    'Interpreter','none')
   end
  elseif fff==1
   ha=plot(t,rr,t,y);
   set(ha(1),'Color',c1,'LineStyle','-')
   set(ha(2),'Color',c2,'LineStyle','-')
   HALEG=ha;
   if ~strcmp(s1,'auto'), axis(VV), end
   if islegen
    LABLEG='''riferimento'',''uscita''';
    if fleg==1, eval(['legend(HALEG,',LABLEG,')']); end
   else
    VV=axis;
    mess=['riferimento (',cs(1),'), uscita (',cs(2),')'];
    text(VV(1)+.3*(VV(2)-VV(1)),VV(3)+.04*(VV(4)-VV(3)),mess,...
    'Interpreter','none')
   end
  elseif fff==2
   ha=plot(t,xnlt,ts,ynlts);
   set(ha(1),'Color',c3,'LineStyle','-')
   set(ha(2),'Color',c4,'LineStyle','-')
   HALEG=ha;
   if ~strcmp(s1,'auto'), axis(VV), end
   if islegen
    LABLEG='''ingresso di NL'',''uscita di NL''';
    if fleg==1, eval(['legend(HALEG,',LABLEG,')']); end
   else
    VV=axis;
    mess=['ingresso di NL (',cs(3),'), uscita di NL (',cs(4),')'];
    text(VV(1)+.3*(VV(2)-VV(1)),VV(3)+.04*(VV(4)-VV(3)),mess,...
    'Interpreter','none')
   end
  end
  if flx==1, set(gca,'xtick',xtick), end
  if fly==1, set(gca,'ytick',ytick), end
  flx=0; fly=0;
  if gr==1, grid on, end
  aat=setstr(32*ones(1,120)); aam=sprintf('secondi');
  mess=[aat(1:100-length(aam)),aam]; xlabel(mess)
  figure(nfig)
  title('simulazione di sistema non lineare')
 end
 if (izy==0)|(izy==3)|(izy==4)|(izy==5)|(izy==7)
  men_opt=uimenu(nfig,'Label','Memo');
  men_gr=uimenu(nfig,'Label','Reticolo on/off','Callback','gridmng(1)');
  men_zoom=uimenu(nfig,'Label','Zoom on/off','Callback','gridmng(7)');
  mess='simulazione di sistema non lineare';
  uimenu(men_opt,'Label',mess);
  mess=['regolatore : ',arg1];
  if fluim1==0
   uimenu(men_opt,'Label',mess,'Separator','on');
  else
   TRF1=[arg1,cs(3)];
   uimenu(men_opt,'Label',mess,'Separator','on',...
   'Callback','tfmaux(1,.5)');
  end
  mess=['NL : ',mess1,'  (vedere il grafico)'];
  uimenu(men_opt,'Label',mess,'Callback','gridmng(3)');
  mess=['sistema controllato : ',arg2];
  TRF2=[arg2,cs(2)];
  uimenu(men_opt,'Label',mess,...
  'Callback','tfmaux(2,.5)');
  mess=['collegamento di retroazione : ',arg3];
  if fluim3==0
   uimenu(men_opt,'Label',mess);
  else
   TRF3=[arg3,cs(4)];
   uimenu(men_opt,'Label',mess,...
   'Callback','tfmaux(3,.5)');
  end
  mess=['trasformata di Laplace dell''ingresso : ',arg4];
  TRF4=[arg4,cs(1)];
  uimenu(men_opt,'Label',mess,...
  'Callback','tfmaux(4,.5)');
  mess=['ingresso di riferimento, colore ',cs(1)];
  uimenu(men_opt,'Label',mess,'Separator','on');
  mess=['uscita complessiva, colore ',cs(2)];
  uimenu(men_opt,'Label',mess);
  mess=['ingresso di NL, colore ',cs(3)];
  uimenu(men_opt,'Label',mess);
  mess=['uscita di NL, colore ',cs(4)];
  uimenu(men_opt,'Label',mess);
 end
 ABIL=1;
 if flv==1, xyx=input(['\n   **** figura ',nfigs,' **** '],'s'); end, flv=1;
 clc, disp(' '), ffp=1;
 disp('   MENU :')
 disp(' ')
 disp('   1 - cambiare gli assi di riferimento')
 if gr==0
  disp('   2 - inserire reticolo')
 else
  disp('   2 - eliminare il reticolo')
 end
 disp('   3 - ingresso di riferimento e uscita complessiva')
 disp('   4 - ingresso ed uscita dell''elemento non lineare')
 disp('   5 - tutti i grafici')
 disp('   6 - rivedere la figura')
 disp('   7 - cambiare i colori')
 zoom off, zoom out
 izy=input('\n   operare una scelta (premere invio per uscire) : ');
 izy=round(izy);
 if gcf~=nfig, fprintf(ms1), return, end
 if isempty(izy)
  cc=get(0,'Children');
  if any(cc==nfig)
   FIGLO(7,1:4)=get(nfig,'Position');
   save figlo# FIGLO -v4
  else
   disp(' '), disp(['   LA FIGURA ',EA,' STATA CANCELLATA!'])
  end
  eval('delete(nfig1)','err=1;')
  eval('delete(men_zoom)','err=1;'), eval('delete(men_gr)','err=1;')
  ordf(1), return
 end
 if izy<1 | izy>7, comp=0; ffp=0; flv=0; end
 if izy==1
  clc, VV=axis;
  xtick=get(gca,'xtick'); ytick=get(gca,'ytick');
  divx=xtick(2)-xtick(1); divy=ytick(2)-ytick(1);
  ndiv=round([(VV(2)-VV(1))/divx,(VV(4)-VV(3))/divy]);
  fprintf(['\n   l''intervallo di tempo ',eA,' [%.4g %.4g];'],VV(1),VV(2))
  indin=0; while indin==0
  TA1=input('\n   premere invio o specificare nuovi valori: [t1 t2] = ');
  ll1=length(TA1); if (ll1==0)|(ll1==2), indin=1; end, end, TA1=sort(TA1);
  fprintf('   numero di divisioni dell''asse x: %.4g;',ndiv(1))
  if ll1==2
   fprintf('\n   premere invio per la messa in scala automatica')
  else
   fprintf('\n   premere invio per conservare la scala precedente')
  end
  indin=0; while indin==0
  ndivt1=input('\n   o specificare un nuovo valore: ndx = ');
  if (length(ndivt1)==0)|(length(ndivt1)==1), indin=1; end, end
  fprintf(['\n   l''intervallo dell''asse y ',eA,' [%.4g %.4g];'],VV(3),VV(4))
  indin=0; while indin==0
  TA2=input('\n   premere invio o specificare nuovi valori: [ym yM] = ');
  ll2=length(TA2); if (ll2==0)|(ll2==2), indin=1; end, end, TA2=sort(TA2);
  fprintf('   numero di divisioni dell''asse y: %.4g;',ndiv(2))
  if ll2==2
   fprintf('\n   premere invio per la messa in scala automatica')
  else
   fprintf('\n   premere invio per conservare la scala precedente')
  end
  indin=0; while indin==0
  ndivt2=input('\n   o specificare un nuovo valore: ndy = ');
  if (length(ndivt2)==0)|(length(ndivt2)==1), indin=1; end, end
  if ll1==2, VV(1)=TA1(1); VV(2)=TA1(2); end
  if ll2==2, VV(3)=TA2(1); VV(4)=TA2(2); end
  if gcf~=nfig, fprintf(ms1), return, end
  rop=(ll1==2)|(ll2==2);
  if rop, axis(VV), end
  if ll1==0, flx=1; end
  if ll2==0, fly=1; end
  if length(ndivt1)~=0
   ndivt1=round(abs(ndivt1)); stepx=(VV(2)-VV(1))/ndivt1;
   xtick=VV(1):stepx:VV(2); flx=1;
  end
  if length(ndivt2)~=0
   ndivt2=round(abs(ndivt2)); stepy=(VV(4)-VV(3))/ndivt2;
   ytick=VV(3):stepy:VV(4); fly=1;
  end
  t1=VV(2);
  if length(TA1)==0, comp=0; else, comp=1; end
 elseif izy==2
  if gr==0
   gr=1; grid on
  else
   gr=0; grid off
  end
  figure(nfig), comp=0; ffp=0;
 elseif izy==3
  fff=1; comp=0; clf
 elseif izy==4
  fff=2; comp=0; clf
 elseif izy==5
  fff=0; comp=0; clf
 elseif izy==6
  figure(nfig), comp=0; ffp=0;
 elseif izy==7
  disp(' '), comp=0;
  mess=['   l''attuale sequenza di colori ',eA,' [',cs(1),',',cs(2),...
  ',',cs(3),',',cs(4),']'];
  ins=repco(7);
  fprintf(mess), fprintf([' - colori ammessi: g,r,c,y,b,m,',ins,'\n'])
  for kk=1:length(cs)
   flg1=0;
   while flg1==0
    cs1=input(['\n   un nuovo colore invece di ',cs(kk),' : '],'s');
    if isempty(cs1)
     flg1=1;
    else
     rop=strcmp(cs1,'g');
     rop=rop|strcmp(cs1,'r');rop=rop|strcmp(cs1,'y');rop=rop|strcmp(cs1,'b');
     rop=rop|strcmp(cs1,'c');rop=rop|strcmp(cs1,'m');rop=rop|strcmp(cs1,ins);
     if rop, cs(kk)=cs1; flg1=1; end
    end
   end
  end
  clf
 end
 if gcf~=nfig, fprintf(ms1), return, end
end
% --- last line of nlsim ---
