function nigrid(s)
%NIGRID   Constant M and N loci for a Nichols plot.
%   NIGRID(1) clears the graphic window and sets HOLD ON so that the
%   Nichols diagram can be plot over the grid.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

[tp1,tp2,tp3,tp4]=coltbl;
if tp1(7,1)==1, BW='w'; else, BW='k'; end
status=ishold;
if nargin==1
 VV=[-360 0 -40 40]; hold off
else
 VV=axis; hold on
end
if VV==[-360 0 -40 40], set(gca,'xtick',(-360:30:0)), end
fsize=get(gca,'FontSize'); fsize=fsize-2;
%
i=sqrt(-1); hold on
%
%  plot phase lines
%
pp=[-1 -2.5 -5 -10 -20 -30 -45 -60 -90 -120 -150];
%
np=36; ii=5; %% 24, 5
db1=-40; db2=12; % from -40 to 12 db
aa=10^(-db1/20); bb=10^(db2/20);
mx1=1+(linspace(0,(aa-1)^(1/ii),np)).^ii; mx1=mx1(np:-1:1);
mx2=1+(linspace(0,(bb-1)^(1/ii),np)).^ii;
mx=[1 ./mx1,mx2(2:length(mx2))];
for kk=1:2
 pp1=pp*(-1)^kk;
 [p,m]=meshgrid(pp1,mx);
 z=m.*exp(i*p/180*pi); g=z./(1-z);
 xx=180*angle(g)/pi; if xx>0, xx=xx-360; end
 yy=20*log10(abs(g));
 plot(xx,yy,[BW,':']);
 vx=np-6; %% -4
 for k=1:length(pp)
  if kk==1, pp2=-360-pp; corrx=-25; else, pp2=pp; corrx=3; end
  if k>5, corry=-(k-5)^1.5; else, corry=2; end
  x1=xx(vx,k)+corrx; y1=yy(vx,k)+corry;
  if (x1>VV(1))&(x1<VV(2))&(y1>VV(3))&(y1<VV(4))
   text(x1,y1,sprintf('%.4g',pp2(k)),'FontSize',fsize)
  end
 end
end
%
p0=-180; m0=bb;
z=m0.*exp(i*p0/180*pi); g=z./(1-z);
xx=180*angle(g)/pi; if xx>0, xx=xx-360; end
yy=20*log10(abs(g));
plot([xx,xx],[yy,VV(3)],[BW,':'])
text(-180,-25,sprintf('-180'),'FontSize',fsize)
%
%  plot magnitude lines
%
mm=[-40 -30 -20 -12 -6 -3 -2 -1 -.5 0 .25 .5 1 2 3 6 12];
%
mm1=10 .^(mm/20);
np=36; ii=4; tol=10*eps; %% 24, 4
pp=180*(linspace(tol,1-tol,np)).^ii; pp1=180-pp;
for kk=1:2
 pp1=pp*(-1)^(kk-1);
 [p,m]=meshgrid(pp1,mm1);
 z=m.*exp(i*p/180*pi); g=z./(1-z);
 xx=180*angle(g)/pi; if xx>0, xx=xx-360; end
 yy=20*log10(abs(g));
 plot(xx',yy',[BW,':']);
end
vx=1;
for k=1:length(mm)
 x1=min(-35,xx(k,vx))+2; y1=min(36,yy(k,vx))+1.5;
 if (x1>VV(1))&(x1<VV(2))&(y1>VV(3))&(y1<VV(4))
  text(x1,y1,sprintf('%.3g',mm(k)),'FontSize',fsize)
 end
end
%
if nargin==1
 axis(VV)
else
 axis(axis)
end
%
if (nargin==0)&(~status), hold off, end %  return hold to previous status
%
% --- last line of nigrid ---
