function [egv,mul]=makest(ord,tol,opt)
%MAKEST   Detection of multiple roots within a given tolerance.
%   [egv,mul] = MAKEST(ord,tol,[0]).
%   Components of the complex vector "ord" whose absolute values are
%   different by no more that "tol" are sorted in "egv" as a unique
%   component and their number is communicated in "mul".
%   Example: ord = [-1+j*.0001 -1-j*.0001 -3+j*.1 -3-j*.1]
%	     tol = .01
%			    --> egv = [-1 -3+j*.1]
%				mul = [ 2     2  ]
%   If called with three arguments, MAKEST gives the complex coniugate
%   pairs as a single complex value. A number is here considered to be
%   complex if its imaginary part is greater than 10^-8 times the
%   absolute value of the real part.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(2,3,nargs));
if tol<eps; tol=eps; end;
j=sqrt(-1);
egv=[]; mul=[];
%
%  sorting complex without conjugate and real
%
[zz,ii]=sort(-real(ord));
ord=ord(ii);
o1=[];o2=[];
llo=length(ord);
inx=ones(1,llo);
ttol=10^(-8);
for idx=1:llo
 if inx(idx)==1
  if abs(imag(ord(idx)))>ttol*abs(real(ord(idx)))
   o1=[o1 real(ord(idx))+j*abs(imag(ord(idx)))];
   o2=[o2 real(ord(idx))-j*abs(imag(ord(idx)))];
   for idy=(idx+1):llo
    if(abs(ord(idy)-conj(ord(idx)))<10*eps)&(inx(idy)~=0)
     inx(idy)=0; break
    end
   end
  else
   o1=[o1 real(ord(idx))]; o2=[o2 real(ord(idx))];
  end
 end
end
%
%  detecting values within tolerance
%
idx=1;
while idx<=length(o1)
 pivot=[];media=0;
%  substituting the mean
 if((abs(real(o1(idx))-real(o2(idx)))<tol)&...
  (abs(imag(o1(idx))-imag(o2(idx)))<tol))
  if (o1(idx)==o2(idx))
%  real value
   pivot=[pivot o1(idx)];
  else
%  complex value
   pivot=[pivot o1(idx) o2(idx)];
  end
  media=(o1(idx)+o2(idx))/2; rl=real(media); ig=imag(media);
  if idx<length(o1)
   while((abs(real(o1(idx+1))-rl)<tol)&(abs(imag(o1(idx+1))-ig)<tol))
    if (o1(idx+1)==o2(idx+1))
%  real value
     pivot=[pivot o1(idx+1)];
    else
%  complex value
     pivot=[pivot o1(idx+1) o2(idx+1)];
    end
    l=length(pivot); tot=sum(pivot); val=tot/l; rl=real(val); ig=imag(val);
    idx=idx+1;
    if idx>=length(o1), break, end
   end %while
  end %if
  l=length(pivot); tot=0;
  for cont=1:l
   tot=tot+pivot(cont);
  end
  val=tot/l; egv=[egv val]; mul=[mul l];
 else
  rl=real(o1(idx)); ig=imag(o1(idx)); pivot=[pivot o1(idx)] ;
  if idx<length(o1)
   while(abs(real(o1(idx+1))-rl)<tol)&(abs(imag(o1(idx+1))-ig)<tol)
    pivot=[pivot o1(idx+1)] ;
    rl=real(sum(pivot)/length(pivot)); ig=imag(sum(pivot)/length(pivot));
    idx=idx+1;
    if idx>=length(o1),break,end
   end %while
   egv=[egv sum(pivot)/length(pivot)]; mul=[mul length(pivot)*2];
  else
   egv=[egv o1(idx)]; mul=[mul 2];
  end
 end
 idx=idx+1;
end %while
%
%  option with three call arguments
%
if (nargs==3)
 for idx=1:length(egv)
  if(abs(imag(egv(idx)))>(ttol*abs(real(egv(idx)))))
   mul(idx)=mul(idx)/2;
  end
 end
%
%   properly sorts the eigenvalues
%
 [v,ii]=sort(abs(real(egv))); egv=egv(ii); mul=mul(ii);
 [v,ii]=sort(abs(imag(egv))); egv=egv(ii); mul=mul(ii);
end
% --- last line of makest ---
