function leadc(arg1,arg2,arg3,arg4)
%LEADC	  Progetto per tentativi di rete anticipatrice (TFI).
%    Possibili usi:
%    LEADC,gp,gc - da TFI
%    LEADC('gp','gc') - da Matlab
%    gp: funzione di trasferimento del sistema controllato (ingresso)
%    gc: funzione di trasferimento della rete correttrice (uscita)
%    Se LEADC viene chiamato senza alcun argomento, le f.d.t. gp e gc
%    possono essere specificate in modo interattivo.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global ABIL TRF1 TRF2 stknum1 stkden1 stkkc stktaui stktaud repco TT TT1...
 HALEG FIGLEG LABLEG SUBPLEG

aA=setstr(224); eA=setstr(232); oA=setstr(242); uA=setstr(249); EA=setstr(200);
nfig=gcf; nfigs=int2str(nfig); ABIL=0; flgpp=0; FIGLO=resfiglo;
FIGLEG=nfig; HALEG=[]; LABLEG=[]; SUBPLEG=0;
wfont='normal'; % wfont='bold';
ms1=['\n **** errore: non si pu',oA,' cambiare figura durante l''esecuzione\n'];
if exist('legen#.mat'), load legen#, else, legen=0; islegen=0; end
if nargin==0
 arg1='xx'; flg=0;
 while flg==0
  mess='\n   funzione di trasferimento del sistema controllato (ingresso) : ';
  gi=input(mess,'s');
  if gcf~=nfig, fprintf(ms1), return, end
  if ~isempty(gi)
   if gi=='0', return, end
   if ~exist([gi,'.mat'])
    disp([' **** errore: ',gi,'.mat non esiste'])
   else
    flg=1;
   end
  end
 end
 while flg==1
  mess='\n   funzione di trasferimento della rete correttrice (uscita) : ';
  gj=input(mess,'s');
  if gcf~=nfig, fprintf(ms1), return, end
  if ~isempty(gj), flg=2; end
 end
 if gj=='0', return, end
elseif nargin>=2
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1; gj=arg2;
 end
else
 disp(' **** errore: numero di argomenti non sufficiente'), return
end
[z,p,k,str1]=exportf(gi,1); if isempty(k), return, end
if str1=='z'
 disp(' **** per sistemi a tempo discreto si converta con wplane'), return
end
[num,den]=dezpk(z,p,k);
tfblocks(3,gj,gi,'','','','','','','','')
%
[vcol1,vcol2,repco,repcos]=coltbl; colbg=vcol1(8,:);
%
flgll=0;
ll=input('\n   informazioni sul progetto della rete anticipatrice ? (1) : ');
if gcf~=nfig, fprintf(ms1), return, end
if isempty(ll), ll=0; end
if ll==1
 ccc='prninfo(4)';
 eval(ccc)
 flgin=0;
 while flgin==0
  mess='\n   inviare 1 per proseguire con il progetto, 0 per uscire : ';
  xxx=input(mess);
  if isempty(xxx), xxx=4; end
  if gcf~=nfig, fprintf(ms1), return, end
  if xxx==1, flgin=1; elseif xxx==0, ordf(1), return, end
 end
end
%
clf, ordf(3)
if any(FIGLO(3,:))
 erx=0; eval('set(nfig,''Position'',FIGLO(3,1:4))','erx=1;')
end
%
stknum1=[]; stkden1=[];
%
j=sqrt(-1); HALEG=[];
hold off %5.3
[pho1,pho2,mag,phi,om]=bodec(z,p,k,repco(1));
if islegen
 LABLEG=['''',gi,''''];
 if legen, eval(['legend(HALEG,',LABLEG,')']), end
end
hold on
VV=axis; maxga=VV(4); minga=VV(3);
scale=maxga-minga; scaleph=pho2-pho1;
[gm,pm,omg,omp]=gpcross(mag,phi,om,1,-180);
if isnan(gm) | isnan(pm)
 [gm1,pm1,omg1,omp1]=gpcross1(z,p,k,1,-180);
 if isnan(gm), gm=gm1; omg=omg1; end
 if isnan(pm), pm=pm1; omp=omp1; end
end
if isnan(gm), gm=inf; omg=eps; end
if isnan(pm), omp=eps; end
phm0=pm+180; gm0=gm; omg0=omg; omp0=omp;
mess='sistema controllato:';
ha=text(.02,.14,mess,'Units','normalized');
set(ha,'FontWeight',wfont,'Color',vcol2(1,:),'Interpreter','none')
if isfinite(gm)
 mess=sprintf('margine di ampiezza: %.4g db',-20*log10(gm0));
 semilogx([omg0,omg0],[VV(3),VV(4)],'Color',vcol1(6,:),'LineStyle',':')
else
 mess=sprintf('margine di ampiezza: infinito');
end
ha=text(.02,.09,mess,'Units','normalized');
set(ha,'FontWeight',wfont,'Interpreter','none')
semilogx([VV(1),VV(2)],[0,0],'Color',vcol1(6,:),'LineStyle',':')
if isnan(phm0)
 mess=sprintf('margine di fase non determinabile');
else
 mess=sprintf('margine di fase: %.4g gradi',phm0);
 semilogx([omp0,omp0],[VV(3),VV(4)],'Color',vcol1(2,:),'LineStyle',':')
end
ha=text(.02,.04,mess,'Units','normalized');
set(ha,'FontWeight',wfont,'Interpreter','none')
gp=(-180-pho1)*(scale/scaleph)+minga;
semilogx([VV(1),VV(2)],[gp,gp],'Color',vcol1(2,:),'LineStyle',':')
axis(VV), figure(nfig)
xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
clc
disp(' ')
fprintf('   margine di fase senza correzione: %.4g gradi\n',phm0)
frem=omp0; if isnan(phm0), phm0=0; frem=NaN; end
fprintf('                    alla pulsazione: %.4g rad/sec\n',frem)
if isnan(phm0), phm0=-90; end
if phm0<0
 disp(' ')
 disp(['   attenzione: margine di fase negativo - in questo caso si pu',oA])
 disp(['   usare una rete a ritardo o due o pi',uA,' reti ad anticipo,'])
 disp(['   richiamando questo stesso programma due o pi',uA,' volte'])
 xxx=input('\n   volete proseguire ? (1/0) : ');
 if isempty(xxx), xxx=2; end
 if xxx ~= 1, ordf(1), return, end
end
flin=0;
while flin==0
 dphm=input('\n   specificare il margine di fase voluto : ');
 if ~isempty(dphm)
  if dphm==0, return, end
  if dphm>=phm0, flin=1; end
 end
end
disp(' ')
phlead=dphm-phm0;
fprintf('   anticipo di fase necessario: %.4g gradi\n',phlead)
if (phlead >90)
 alphamax=.01;
else
 alphamax=(1-sin(phlead*pi/180))/(1+sin(phlead*pi/180));
end
if alphamax>1, alphamax=1; end
if alphamax<.01, alphamax=.01; end
alpha=alphamax/2;
fprintf('   valore di alfa di primo tentativo: %.4g \n',alpha)
disp(' ')
disp('   **** premere un tasto per proseguire')
pause
if gcf~=nfig, fprintf(ms1), return, end
%
nn=10; phmc=zeros(1,nn); ommc=zeros(1,nn);
phmc1=zeros(1,2*nn); ommc1=zeros(1,2*nn);
%WW(1)=10^(log10(VV(1))+floor(log10(alpha)));
WW(1)=VV(1);
WW(2)=10^(log10(VV(2))+1+ceil(log10(1/alpha)));
WW(3)=VV(3);
WW(4)=max([VV(4),20*ceil(log10(1/alpha)),60]);
phi1=pho1; phi2=max(pho2,90); om1=WW(1); om2=WW(2);
flrip=1; flplot=1; nnrip=0;
reins=zeros(1,7);
while flrip==1
 HALEG=[];
 nnrip=nnrip+1;
 figure(nfig), clf, ordf(3), ABIL=0; %5.3
 TRF1=[gi,repco(1)]; TRF2=[gj,repco(3)];
 men_opt=uimenu(gcf,'Label','Memo','Enable','off');
 mess='rete anticipatrice';
 uimenu(men_opt,'Label',mess);
 mess=[gi,', sistema controllato'];
 uimenu(men_opt,'Label',mess,'Separator','on',...
 'Callback','tfmaux(1,.3)');
 mess=[gj,', rete correttrice'];
 men_optt=uimenu(men_opt,'Label',mess);
 uimenu(men_optt,'Label','zeri-poli',...
 'Callback','tfmaux(2,.3)');
 uimenu(men_optt,'Label','costanti di tempo',...
 'Callback','tfmaux(2,.3,1,1)');
 drawnow, clc, hold off
 VV=WW; semilogx(om1,-20,'Color',vcol1(8,:),'LineStyle','none',...
 'Marker','.'), axis(VV)
 ytick=VV(3):20:VV(4); set(gca,'ytick',ytick), hold on
 [pho1,pho2,mag,phi,om]=bodec(z,p,k,om1,om2,repco(1),phi2,phi1);
 maxga=VV(4); minga=VV(3);
 scale=maxga-minga; scaleph=pho2-pho1;
 [gm,pm,omg,omp]=gpcross(mag,phi,om,1,-180);
 if isnan(gm) | isnan(pm)
  [gm1,pm1,omg1,omp1]=gpcross1(z,p,k,1,-180);
  if isnan(gm), gm=gm1; omg=omg1; end
  if isnan(pm), pm=pm1; omp=omp1; end
 end
 if isnan(pm), omp=eps; end
 phm0=pm+180; omp0=omp;
 semilogx([omp0,omp0],[VV(3),VV(4)],'Color',vcol1(1,:),'LineStyle',':')
 semilogx([om1,om2],[0,0],'Color',vcol1(6,:),'LineStyle',':')
 gp=(-180-pho1)*(scale/scaleph)+minga;
 semilogx([om1,om2],[gp,gp],'Color',vcol1(2,:),'LineStyle',':')
 mess='sistema non corretto';
 ha=text(.02,.19,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Color',vcol2(1,:),'Interpreter','none')
 if islegen
  LABLEG=['''',gi,''''];
  if legen, eval(['legend(HALEG,',LABLEG,')']), end
 end
 axis(VV), drawnow, pause, figure(nfig)
 hold on
 nw=length(om); w=j*om;
%
 ommin=omp0*sqrt(alpha); ommax=omp0/sqrt(alpha);
 omvar=logspace(log10(ommin),log10(ommax),nn);
 kc=1/alpha;
 for kk=1:nn
  zc=-omvar(kk); pc=-omvar(kk)/alpha; y=kc*ones(1,nw);
  y=y./(w-pc); y=y.*(w-zc); magc=abs(y)'; phic=(angle(y)*180/pi)';
  if (kk==1) | (kk==nn)
   magp=20*log10(magc); phip=(phic-pho1)*(scale/scaleph)+minga;
   semilogx(om,magp,'Color',vcol1(4,:),'LineStyle','-')
  end
  magov=mag.*magc; phiov=phi+phic;
  [gm,pm,omg,omp]=gpcross(magov,phiov,om,1,-180);
  phm=pm+180; phmc(kk)=phm; ommc(kk)=omp;
 end
 mess='intervallo in cui si opera la ricerca';
 ha=text(.02,.14,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Color',vcol2(4,:),'Interpreter','none')
 axis(VV), drawnow, pause, figure(nfig)
 [phm,ii]=max(phmc); ii1=max(ii-1,1); ii2=min(ii+1,nn);
 ommin=omvar(ii1); ommax=omvar(ii2);
 omvar=logspace(log10(ommin),log10(ommax),(2*nn));
 for kk=1:(2*nn)
  zc=-omvar(kk); pc=-omvar(kk)/alpha; y=kc*ones(1,nw);
  y=y./(w-pc); y=y.*(w-zc); magc=abs(y)'; phic=(angle(y)*180/pi)';
  magov=mag.*magc; phiov=phi+phic;
  [gm,pm,omg,omp]=gpcross(magov,phiov,om,1,-180);
  phm=pm+180; phmc1(kk)=phm; ommc1(kk)=omp;
 end
 [phm,ii]=max(phmc1); omp=ommc1(ii);
 zc=-omvar(ii); pc=-omvar(ii)/alpha;
 y=kc*ones(1,nw); y=y./(w-pc); y=y.*(w-zc);
 magc=abs(y)'; phic=(angle(y)*180/pi)';
 magp=20*log10(magc); phip=(phic-pho1)*(scale/scaleph)+minga;
 ha=semilogx(om,magp,'Color',vcol1(3,:),'LineStyle','-');
 HALEG=[HALEG,ha];
 if islegen
  LABLEG=['''',gi,''',''',gj,''''];
  if legen, eval(['legend(HALEG,',LABLEG,')']), end
 end
 semilogx(om,phip,'Color',vcol1(3,:),'LineStyle','-.')
 [oa,ga]=asymga(zc,pc,kc,om1,om2);
 semilogx(oa,20*log10(ga),'Color',vcol1(3,:),'LineStyle','--')
 mess='rete correttrice';
 ha=text(.02,.09,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Color',vcol2(3,:),'Interpreter','none')
 axis(VV), drawnow, pause, figure(nfig)
 magov=mag.*magc; phiov=phi+phic;
 magp=20*log10(magov); phip=(phiov-pho1)*(scale/scaleph)+minga;
 semilogx(om,magp,'Color',vcol1(5,:),'LineStyle','-')
 semilogx(om,phip,'Color',vcol1(5,:),'LineStyle','-.')
 semilogx([omp,omp],[VV(3),VV(4)],'Color',vcol1(5,:),'LineStyle',':')
 mess='sistema complessivo';
 ha=text(.02,.04,mess,'Units','normalized');
 set(ha,'FontWeight',wfont,'Color',vcol2(5,:),'Interpreter','none')
 tau=-1/zc; num1=[tau,1]; den1=[alpha*tau,1];
 numcloop=conv(num,num1);
 dencloop=sumpol(conv(den,den1),numcloop);
 dencloop1=[dencloop 0];
 stknum1=[stknum1;num1]; stkden1=[stkden1;den1];
 aa=importf(num1,den1,gj); ABIL=1;
 axis(VV)
 set(men_opt,'Enable','on')
 xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
 hold off
 colc=repco(nnrip);
 if all(real(roots(dencloop))<0)
  reins(nnrip)=1;
  if flplot==1
   figure(nfig+1), clf, ordf(6), nfig1=gcf; %5.3
   if any(FIGLO(3,:))
    eval('set(nfig1,''Position'',FIGLO(3,5:8))','erx=1;')
   end
  else
   figure(nfig1), hold on
  end
  if flplot~=1, axis(TT), end
  [z1,p1,k1]=tozpk(numcloop,dencloop1);
  [y,t]=trespc(z1,p1,k1,colc);
  if flplot==1, TT=axis; end
  ytick=get(gca,'YTick'); divy=ytick(2)-ytick(1);
  ymax=max(y); ymin=min(y);
  while ymax>=TT(4), TT(4)=TT(4)+divy; end
  while ymin<=TT(3), TT(3)=TT(3)-divy; end
  if flplot==1
   mess=['successione dei colori: ',repco(1),', ',repco(2),', ',...
   repco(3),', ',repco(4),', ',repco(5),', ',repco(6),', ',repco(7)];
   ha=text(.12,.04,mess,'Units','normalized');
   set(ha,'FontWeight',wfont,'Interpreter','none')
  end
  TRF1=[gi,repco(1)]; TRF2=[gj,repco(nnrip)];
  if flgpp==0
   men_opt1=uimenu(gcf,'Label','Memo');
   mess='rete anticipatrice';
   uimenu(men_opt1,'Label',mess);
   mess=[gi,', sistema controllato'];
   uimenu(men_opt1,'Label',mess,'Separator','on',...
   'Callback','tfmaux(1,.1)');
   mess=[gj,', rete correttrice'];
   men_optt1=uimenu(men_opt1,'Label',mess);
   uimenu(men_optt1,'Label','zeri-poli',...
   'Callback','tfmaux(2,.1)');
   uimenu(men_optt1,'Label','costanti di tempo',...
   'Callback','tfmaux(2,.1,1,1)');
   bdx=uimenu(gcf,'Label','Asse tempi');
   uimenu(bdx,'Label','ingrandire x 2',...
   'Callback','ccregaux(11)');
   uimenu(bdx,'Label','ingrandire x 5','Separator','on',...
   'Callback','ccregaux(12)');
   uimenu(bdx,'Label','ingrandire x 10','Separator','on',...
   'Callback','ccregaux(13)');
   uimenu(bdx,'Label','ripristinare la scala iniziale','Separator','on',...
   'Callback','ccregaux(14)');
   uimenu(gcf,'Label','Reticolo on/off','Callback','grid');
   uimenu(gcf,'Label','Zoom on/off','Callback','gridmng(7)');
  end
  if flgpp==0, sepa='on'; else, sepa='off'; end
  mess=[gj,', colore ',repco(nnrip)];
  uimenu(men_opt1,'Label',mess,'Separator',sepa,...
  'Callback',['ccregaux(1,',int2str(nnrip),',.1)']);
  axis(TT), hold off
  nfigs1=int2str(nfig1);
  reset(gca), set(gca,'Box','on')
  title('risposta al gradino ad anello chiuso')
  aat=setstr(32*ones(1,120)); aam=sprintf('secondi');
  messx=[aat(1:100-length(aam)),aam]; xlabel(messx)
  xyx=input(['\n   **** figura ',nfigs1,' **** '],'s');
  zoom off, zoom out
  if flplot==1
   figure(nfig+2), clf, ordf(7), nfig2=gcf; %5.3
   if any(FIGLO(3,:))
    eval('set(nfig2,''Position'',FIGLO(3,9:12))','erx=1;')
   end
  else
   figure(nfig2), hold on
  end
  numreg=conv(num1,den);
  [z1,p1,k1]=tozpk(numreg,dencloop1);
  if flplot~=1, axis(TT1), end
  [y,t]=trespc(z1,p1,k1,colc);
  if flplot==1, TT1=axis; end
  ytick=get(gca,'YTick'); divy=ytick(2)-ytick(1);
  ymax=max(y); ymin=min(y);
  while ymax>=TT1(4), TT1(4)=TT1(4)+divy; end
  while ymin<=TT1(3), TT1(3)=TT1(3)-divy; end
  if flplot==1, flplot=0; end
  if flgpp==0
   men_opt2=uimenu(gcf,'Label','Memo');
   mess='rete anticipatrice';
   uimenu(men_opt2,'Label',mess);
   mess=[gi,', sistema controllato'];
   uimenu(men_opt2,'Label',mess,'Separator','on',...
   'Callback','tfmaux(1,.8)');
   mess=[gj,', rete correttrice'];
   men_optt2=uimenu(men_opt2,'Label',mess);
   uimenu(men_optt2,'Label','zeri-poli',...
   'Callback','tfmaux(2,.8)');
   uimenu(men_optt2,'Label','costanti di tempo',...
   'Callback','tfmaux(2,.8,1,1)');
   bdx1=uimenu(gcf,'Label','Asse tempi');
   uimenu(bdx1,'Label','ingrandire x 2',...
   'Callback','ccregaux(15)');
   uimenu(bdx1,'Label','ingrandire x 5','Separator','on',...
   'Callback','ccregaux(16)');
   uimenu(bdx1,'Label','ingrandire x 10','Separator','on',...
   'Callback','ccregaux(17)');
   uimenu(bdx1,'Label','ripristinare la scala iniziale','Separator','on',...
   'Callback','ccregaux(18)');
   uimenu(gcf,'Label','Reticolo on/off','Callback','grid');
   uimenu(gcf,'Label','Zoom on/off','Callback','gridmng(7)');
   flgpp=1;
  end
  mess=[gj,', colore ',repco(nnrip)];
  uimenu(men_opt2,'Label',mess,'Separator',sepa,...
  'Callback',['ccregaux(1,',int2str(nnrip),',.8)']);
  axis(TT1), hold off
  nfigs2=int2str(nfig2);
  reset(gca), set(gca,'Box','on')
  title('uscita della rete correttrice')
  xlabel(messx)
  mess=['(colori dei grafici: ',repco(1),', ',repco(2),', ',...
  repco(3),', ',repco(4),', ',repco(5),', ',repco(6),', ',repco(7),')'];
  ylabel(mess)
  xyx=input(['\n   **** figura ',nfigs2,' **** '],'s');
  zoom off, zoom out
 end
 clc
 disp(' ')
 fprintf(['   colore di riferimento: ',repco(nnrip),' ;'])
 fprintf([' f.d.t. del sistema controllato: ',gi])
 fprintf('\n')
 if reins(nnrip)==0
  xyx=input(['   ATTENZIONE: il sistema ',eA,' instabile'],'s');
 end
 disp(' ')
 fprintf('   %.4g passi di ricerca di tau nell''intervallo scelto:\n',nn^2)
 fprintf('   margine di fase massimo trovato al passo: %.4g\n',nn*ii1+ii)
 disp(' ')
 fprintf('   margine di fase senza rete correttrice: %.4g\n',phm0)
 fprintf('   margine di fase con rete correttrice  : %.4g\n',phm)
 disp(' ')
 disp('   la rete correttrice ottenuta:')
 fprintf('   alfa = %.4g , tau = %.4g sec\n',alpha,tau)
 flrip=0;
 if nnrip < 7
  disp(' ')
  disp(['   si pu',oA,' cambiare alfa; verr',aA,' determinato il tau'])
  disp('   corrispondente al margine di fase massimo')
  flgin=0;
  while flgin==0
   mess=sprintf('\n   specificare alfa (min .005, max %.4g),',...
   min(.9,2*alphamax)); mess=[mess,' invio per uscire : '];
   alpha1=input(mess);
   if length(alpha1)~=0, flrip=1; else, flrip=0; alpha1=.01; end
   if (alpha1<.005) | (alpha1>min(.9,2*alphamax))
    disp('   **** valore non ammesso; ripetere')
   else
    alpha=alpha1; flgin=1;
   end
  end
 else
  disp(' ')
  disp(['   il massimo numero di tentativi ',eA,' 7'])
 end
end
if nnrip > 1
 xx=0;
 while xx==0
  col=input('\n   scegliere la funzione specificandone il colore : ','s');
  if isempty(col), col='z'; end
  if col=='0', return, end
  ropc=0; for kk=1:7, ropc=ropc|strcmp(col,repco(kk)); end
  if ropc
   if find(repco==col)<=nnrip
    xx=1;
   end
  end
 end
else
 col=colc;
end
q=find(repco==col);
num1=stknum1(q,:); den1=stkden1(q,:);
tau=num1(1); alpha=den1(1)/tau;
if flplot==0
 cc=get(0,'Children');
 if (any(cc==nfig))&(any(cc==nfig1))&(any(cc==nfig2));
  FIGLO(3,1:4)=get(nfig,'Position');
  FIGLO(3,5:8)=get(nfig1,'Position');
  FIGLO(3,9:12)=get(nfig2,'Position');
  save figlo# FIGLO -v4
 else
  disp(' '), disp(['   ',EA,' STATA CANCELLATA UNA FIGURA!']), return
 end
 eval('delete(nfig2)','err=1;'), eval('delete(nfig1)','err=1;')
 figure(nfig)
end
ordf(1), clc, disp(' '), HALEG=HALEG(1:2);
disp('   LA RETE CORRETTRICE OTTENUTA :'), disp(' ')
fprintf('   alfa = %.4g , tau = %.4g sec\n',alpha,tau)
aa=importf(num1,den1,gj);
if aa==1, tfg(gj), end
% --- last line of leadc ---
