function [a1,b1,c1,d1,egv,mul]=jorcf(arg1,arg2,arg3)
%JORCF    Jordan canonical form of a SISO system.
%   [a1,b1,c1,d1] = JORCF(num,den)
%   [a1,b1,c1,d1] = JORCF(z,p,k) (preferred for multiple poles)
%   If called as [a1,b1,c1,d1,egv,mul] = JORCF(...) it also returns
%   vectors egv and mul of the eigenvalues and multiplicities (note
%   that in egv a single complex value stands for a conjugate pair).

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

j=sqrt(-1); tol=10^(-8);
nargs=nargin; vect=[]; bj=[];
error(nargchk(2,3,nargs));
if nargs==2
 num=arg1;den=arg2; [z,p,k]=tozpk(num,den);
else
 z=arg1;p=arg2;k=arg3; [num,den]=dezpk(z,p,k);
end
nu6=num; de6=den; m6=length(nu6); n6=length(de6);
nu6=[zeros(1,n6-m6),nu6]/de6(1); d6=nu6(1);
if n6==1
 a6=[]; b6=[]; c6=[];
else
 de6=de6(2:n6)/de6(1); a6=[-de6;eye(n6-2,n6-1)];
 b6=eye(n6-1,1); c6=nu6(2:n6)-nu6(1)*de6;
end
a=a6; b=b6; c=c6; d=d6;
ord=sort(p);
tol1=10^(-4);
[egv,mul]=makest(ord,tol1,0);
%
% derivation of the Jordan blocks
%
Aj=[];
for i=1:length(egv)
 if(abs(imag(egv(i)))<=(tol*abs(real(egv(i)))))
  kr=mul(i); l=real(egv(i));
  if kr==1
   ar=diag(l*ones(1,kr));
  else
   ar=diag(ones(1,kr-1),1)+diag(l*ones(1,kr));
  end
  br=[zeros(kr-1,1);1]; vect=[vect egv(i)*ones(1,mul(i))];
 else
  kc=mul(i)*2; s=real(egv(i)); o=imag(egv(i)); v=[]; v(1:2:kc-1)=ones(1,kc/2);
  if kc==2
   ar=diag(s*ones(1,kc),0)+diag(o*v,1)-diag(o*v,-1);
  else
   ar=diag(s*ones(1,kc),0)+diag(ones(1,kc-2),2)+diag(o*v,1)-diag(o*v,-1);
  end
  br=[zeros(kc-1,1) ; 1];
  vect=[vect egv(i)*ones(1,mul(i)) (s-j*o)*ones(1,mul(i))];
 end
%
% construction of the Jordan matrix
%
 m=size(ar); n=size(Aj);
 Aj=[Aj zeros(n(1),m(1)); zeros(m(1),n(1)) ar]; bj=[bj; br];
end %for i=1:length(egv)
a1=Aj; b1=bj; na=length(a); q=b;
for i=1:na-1
 q=[b,a*q];
end
q1=b1;
for i=1:na-1
 q1=[b1,a1*q1];
end
T=q*inv(q1); c1=c*T; d1=d;
% --- last line of jorcf ---
