function [out1,out2,out3]=inwplane(arg1,arg2,arg3,arg4)
%INWPLANE Inverse wplane transform (continuous to discrete time).
%   Possible uses:
%   [numd,dend]=INWPLANE(num,den,T)
%   [zd,pd,kd]=INWPLANE(z,p,k,T)
%   INWPLANE tranforms a discrete-time system to continuous-time
%   according to the wplane equivalences:
%
%	    1 + wT/2	      2 (z - 1)
%      z =  --------  ;  w =  --------- .
%	    1 - wT/2	      T (z + 1)

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

tol=10^(-8);
nargs=nargin;
error(nargchk(3,4,nargs));
if nargs==3
 num=arg1;den=arg2;T=arg3; [z,p,K]=tozpk(num,den);
else
 z=arg1;p=arg2;K=arg3;T=arg4;
end
if T<=0, error(' T illegal in inwplane'); end
%
m=length(z); n=length(p);
if m>n, error(' m > n in inwplane'), end
Kd=K; zd=zeros(m,1); kind=[];
for kk=1:m
 if abs(1-z(kk)*T/2)>tol  % strips zeros at infinity
  zd(kk)=(1+z(kk)*T/2)/(1-z(kk)*T/2); Kd=Kd*(1-z(kk)*T/2); kind=[kind kk];
 else
  Kd=Kd*(-1-z(kk)*T/2);
 end
end
zd=zd(kind);
for kk=1:n-m
 zd=[zd;-1]; Kd=Kd*(T/2);
end
pd=zeros(n,1);
for kk=1:n
 pd(kk)=(1+p(kk)*T/2)/(1-p(kk)*T/2); Kd=Kd/(1-p(kk)*T/2);
end
Kd=real(Kd);
%
%   reduction to the minimal form
%
md=length(zd); nd=length(pd); iz=ones(md,1); ip=ones(nd,1);
tol1=tol*max(abs(zd));
for kk=1:md
 for kh=1:nd
  if (abs(zd(kk)-pd(kh))<=tol1)&(ip(kh)~=0)
   iz(kk)=0; ip(kh)=0; break
  end
 end
end
zd=zd(find(iz)); pd=pd(find(ip));
%
if nargs==3
 dend=real(poly(pd)); numd=Kd*(real(poly(zd)));
 out1=numd; out2=dend; out3=0;
elseif nargs==4
 out1=zd; out2=pd; out3=Kd;
end
% --- last line of inwplane ---
