function out=invtrd(arg1,arg2,arg3,arg4,arg5,arg6)
%INVTRD   Inverse Z transform in finite terms.
%   INVTRD(numd,dend,typ,gi)
%   INVTRD(zd,pd,kd,typ,gi)
%   displays the inverse Z transform of a discrete-time linear
%   SISO system by using the real Jordan form; gi is a string
%   with the name of transfer function only for display use.
%   The integer typ has the following meanings:
%      1. Complex modes in Cartesian form
%      2. Complex modes in polar form (function sine)
%      3. Complex modes in polar form (function cosine)
%   y=INVTRD(numd,dend,typ,gi,k) and y=INVTRD(zd,pd,kd,typ,gi,k) provide the
%   impulse response y versus discrete time k (row vectors) from the
%   internal finite-terms expansion.
%   The following option is available at the beginning of the file:
%   opt=1 (default): modes with small coefficients are not displayed
%   opt=0: all computed modes are displayed.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

j=sqrt(-1);
nargs=nargin; nargs1=nargout; impulses=[];
%
opt=1;	% if opt=1 "small" modes are filtered
%opt=0;  % if opt=0, all computed modes are displayed
%
if nargs1==0, error(nargchk(4,5,nargs)); else, error(nargchk(5,6,nargs)); end
if nargs1>1, error(' illegal number of output arguments'), end
if nargs==4 | (nargs==5 & nargs1==1)
 num=arg1; den=arg2; typ=arg3; gi=arg4;
 if nargs1==1, k=arg5; else, k=0; end
 [z,p,kc]=tozpk(num,den);
elseif nargs==5 | (nargs==6 & nargs1==1)
 z=arg1; p=arg2; kc=arg3; typ=arg4; gi=arg5;
 if nargs1==1, k=arg6; else, k=0; end
end
if (typ<1)|(typ>3), error(' illegal flag'), end
if typ==1; flg=1; flg1=0;
elseif typ==2; flg=2; flg1=1;
else; flg=2; flg1=2; end
%
[a1,b1,c1,d1,egv,mul]=jorcf(z,p,kc);
%
tol=0; tol1=10^(-8);
if opt~=0
 tol=10^(-8)*norm(c1,'fro');
end
fprintf('\n')
lengi=length(gi);
fprintf(['   Antitrasformata Z di ',gi,'(z) :']), fprintf('\n')
fprintf(['   ',setstr(45*ones(1,(26+lengi)))])
fprintf('\n'), fprintf('   ')
fprintf(gi), fprintf('(k) = ')
strbl1=setstr(' '*ones(1,lengi+8));
strbl2=setstr(' '*ones(1,lengi+11));
nil=0;
y=zeros(1,length(k));
cont=0; % index for vector c1
const=0; % balance for impulse
for i1=1:length(mul) % the main loop on the Jordan blocks
 y1=zeros(1,length(k));
 if abs(egv(i1)) <= tol1 % the eigenvalue is zero
  impulses=c1(cont+1:cont+mul(i1));
  cont=cont+mul(i1);
 else
  % data collection for each block
  vectr=zeros(1,mul(i1));
  vecti=zeros(2,mul(i1));
  ddr=1;
  ddi=eye(2);
  for i2=1:mul(i1) % for every Jordan block
   p=i2-1;
   rad=[];
   if (p==0)
    nn=1;dd=1;
   else
    for kkk=1:p
     rad=[rad kkk];
    end
    nn=poly(rad);
    dd=fact(p);
   end
   imp=-(-1)^p;
   if abs(imag(egv(i1))) <= tol1*abs(real(egv(i1))) % (the block is real)
    lam=real(egv(i1));
    ix=cont+mul(i1)-i2+1;
    ddr=ddr*lam;
    if abs(c1(ix))<=tol, c1(ix)=0; end
    datr=c1(ix);
    sumpr=(datr/(ddr*dd))*[zeros(1,mul(i1)-i2) nn];
    vectr=vectr+sumpr;
    const=const+imp*c1(ix)/ddr;
   else % (the block is complex)
    Lam=[real(egv(i1)) imag(egv(i1));-imag(egv(i1)) real(egv(i1))];
    ix=cont+2*(mul(i1)-i2+1)-1;
    ddi=ddi*Lam;
    if abs(c1(ix)+j*c1(ix+1))<=tol, c1(ix)=0; c1(ix+1)=0; end
    dati=[c1(ix) c1(ix+1)];
    sumpi=(dati*inv(ddi)/dd)'*[zeros(1,mul(i1)-i2) nn];
    vecti=vecti+sumpi;
    vvv=dati*inv(ddi);
    const=const+imp*vvv(2);
   end
  end
  % printing for each block
  if abs(imag(egv(i1))) <= tol1*abs(real(egv(i1))) % (the block is real)
   xx1=zeros(1,mul(i1)); xx2=zeros(1,mul(i1));
   xx3=lam; l3=length(sprintf('%.4g',xx3));
   for i2=1:mul(i1)
    ip=mul(i1)-i2+1;
    xx1(i2)=vectr(ip);
    xx2(i2)=(i2-1);
    y1=y1+xx1(i2)*k.^xx2(i2);
    %
    if abs(xx1(i2))<=tol, xx1(i2)=0; end
    %
   end
   if opt==1, ii=find(xx1); else, ii=1:mul(i1); end
   lli=length(ii);
   xv1=xx1(ii); xv2=xx2(ii);
   for i2=1:lli
    xx1=xv1(i2); xx2=xv2(i2);
    if (lli>1)&(i2==1)
     if i1>1
      fprintf('+ (')
     else
      fprintf('  (')
     end
     nil=nil+3;
    end
    if (lli==1)&(xx1>=0)
     if i1>1
      fprintf('+ ')
     else
      fprintf('  ')
     end
     nil=nil+2;
    end
    l1=length(sprintf('%.4g',abs(xx1)));
    l2=length(sprintf('%.4g',xx2));
    if xx2>0 l=2; else, l=0; end
    if xx2>1 l=l+l2+1; end
    if (i2>1)|((i2==1)&(xx1<0)), l=l+2; end
    if nil+l1+l+1>66-lengi
     fprintf('\n'), fprintf(strbl2), nil=0;
    end
    if xx1>=0, sgn=('+ '); else, sgn=('- '); end
    if (i2>1)|((i2==1)&(xx1<0)), fprintf(setstr(sgn)), nil=nil+2; end
    fprintf('%.4g',abs(xx1)), nil=nil+l1;
    if xx2>0, fprintf(' k'), nil=nil+2; end
    if xx2>1, fprintf('^%.4g',xx2), nil=nil+1+l2; end
    if i2~=lli, fprintf(' '), nil=nil+1; end
    if (lli>1)&(i2==lli)
     fprintf(')'), nil=nil+1;
    end
   end
   y=y+y1.*(xx3*ones(1,length(k))).^k;
   if lli~=0
    if abs(xx3-1)>tol1
     if nil+5+l3>66-lengi, fprintf('\n'), fprintf(strbl2), nil=0; end
     fprintf('*(%.4g)^k',xx3), fprintf('\n'), fprintf(strbl1), nil=0;
    else
     fprintf('\n'), fprintf(strbl1), nil=0;
    end
    fprintf(' '), nil=nil+1;
   end
   cont=cont+mul(i1);
  else % (the block is complex)
   Me=abs(egv(i1)); fe=angle(egv(i1));
   xx3=Me; l3=length(sprintf('%.4g',xx3));
   if flg==2   % (polar form)
    xx1=zeros(1,mul(i1)); xx2=zeros(1,mul(i1)); xx5=zeros(1,mul(i1));
    xx4=fe; l4=length(sprintf('%.4g',xx4));
    for i2=1:mul(i1)
     ip=mul(i1)-i2+1;
     cc1=vecti(1,ip);
     cc2=vecti(2,ip);
     if flg1==1
      AB=(cc1+j*cc2); s=(' sen');
     else
      AB=(cc2-j*cc1); s=(' cos');
     end
     M=abs(AB);
     fi=angle(AB);
     if fi>=pi/2
      fi=fi-pi; M=-M;
     elseif fi<-pi/2
      fi=fi+pi; M=-M;
     end
     xx1(i2)=M; xx2(i2)=(i2-1); xx5(i2)=fi;
     if flg1==1
      y1=y1+(xx1(i2)*k.^xx2(i2)).*sin(xx4*k+xx5(i2));
     else
      y1=y1+(xx1(i2)*k.^xx2(i2)).*cos(xx4*k+xx5(i2));
     end
     %
     if abs(xx1(i2))<=tol, xx1(i2)=0; end
     %
    end
    if opt==1, ii=find(xx1); else, ii=1:mul(i1); end
    lli=length(ii);
    xv1=xx1(ii); xv2=xx2(ii); xv5=xx5(ii);
    for i2=1:lli
     xx1=xv1(i2); xx2=xv2(i2); xx5=xv5(i2);
     if (i1>1)&(i2==1)
      fprintf('+ ['), nil=nil+3;
     elseif (i1==1)&(i2==1)
      fprintf('  ['), nil=nil+3;
     end
     l1=length(sprintf('%.4g',abs(xx1)));
     l2=length(sprintf('%.4g',xx2));
     l5=length(sprintf('%.4g',abs(xx5)));
     if xx2>0, l=2; else, l=0; end
     if xx2>1, l=l+l2+1; end
     if xx5~=0, l=l+3+l5; end
     if ((i2==1)&(xx1<0))|(i2>1), l=l+2; end
     if nil+l1+9+l+l4>66-lengi
      fprintf('\n'), fprintf(strbl2), nil=0;
     end
     if xx1>=0, sgn=('+ '); else, sgn=('- '); end
     if xx5>0, sgn1=(' + '); elseif xx5<0, sgn1=(' - '); end
     if ((i2==1)&(xx1<0))|(i2>1), fprintf(setstr(sgn)), nil=nil+2; end
     fprintf('%.4g',abs(xx1)), nil=nil+l1;
     if xx2>0, fprintf(' k'), nil=nil+2; end
     if xx2>1, fprintf('^%.4g',xx2), nil=nil+1+l2; end
     fprintf(setstr(s))
     fprintf('(%.4g k',xx4)
     nil=nil+8+l4;
     if xx5~=0
      fprintf(setstr(sgn1))
      fprintf('%.4g',abs(xx5))
      nil=nil+3+l5;
     end
     fprintf(')')
     if i2~=lli, fprintf(' '), else, fprintf(']'), end
     nil=nil+1;
    end
   else   % (Cartesian form)
    xx1=zeros(1,mul(i1)); xx11=zeros(1,mul(i1)); xx2=zeros(1,mul(i1));
    xx4=fe; l4=length(sprintf('%.4g',xx4));
    for i2=1:mul(i1)
     ip=mul(i1)-i2+1; cc1=vecti(1,ip); cc2=vecti(2,ip);
     xx1(i2)=cc1; xx11(i2)=cc2; xx2(i2)=i2-1;
     y1=y1+(xx1(i2)*sin(xx4*k)+xx11(i2)*cos(xx4*k)).*k.^xx2(i2);
     %
     if abs(xx1(i2))<=tol, xx1(i2)=0; end
     if abs(xx11(i2))<=tol, xx11(i2)=0; end
     %
    end
    xx=[xx1',xx11'];
    if opt==1, ii=find(xx(:,1)|xx(:,2)); else, ii=1:mul(i1); end
    lli=length(ii);
    xv1=xx(ii,:); xv2=xx2(ii);
    for i2=1:lli
     cc1=xv1(i2,1); cc2=xv1(i2,2); xx2=xv2(i2);
     if (i1>1)&(i2==1)
      fprintf('+ ['), nil=nil+3;
     elseif (i1==1)&(i2==1)
      fprintf('  ['), nil=nil+3;
     end
     l2=length(sprintf('%.4g',xx2));
     l6=length(sprintf('%.4g',abs(cc1)));
     l7=length(sprintf('%.4g',abs(cc2)));
     if cc1<0, l=2; else, l=0; end
     if xx2>0, l=l+6; end
     if xx2>1, l=l+l2+1; end
     if (cc1~=0)|(opt==0), l=l+8+l4+l6; end
     if (cc2~=0)|(opt==0), l=l+8+l4+l7; end
     if (cc2>0 & (cc1~=0 | opt==0)) | ((cc2==0) & (opt==0))
      l=l+3;
     elseif cc2<0 & (cc1~=0 | opt==0)
      l=l+3;
     elseif cc2<0 & (cc1==0 & opt==1)
      l=l+2;
     end
     if nil+l+1>66-lengi
      fprintf('\n'), fprintf(strbl2), nil=0;
     end
     if (cc2>0 & (cc1~=0 | opt==0)) | ((cc2==0) & (opt==0))
      sgn1=(' + ');
     elseif cc2<0 & (cc1~=0 | opt==0)
      sgn1=(' - ');
     elseif cc2<0 & (cc1==0 & opt==1)
      sgn1=('- ');
     end
     if xx2>0, fprintf('+ ('), nil=nil+3; end
     if cc1<0, fprintf('- '), nil=nil+2; end
     if (cc1~=0)|(opt==0)
      fprintf('%.4g sen(%.4g k)',abs(cc1),xx4)
      nil=nil+8+l4+l6;
     end
     if (cc2~=0)|(opt==0)
      fprintf(setstr(sgn1)), nil=nil+3;
      fprintf('%.4g cos(%.4g k)',abs(cc2),xx4)
      nil=nil+8+l4+l7;
     end
     if xx2>0, fprintf(') k'), nil=nil+3; end
     if xx2>1, fprintf('^%.4g',xx2), nil=nil+1+l2; end
     if i2~=lli, fprintf(' '), else, fprintf(']'), end
     nil=nil+1;
    end
   end
   y=y+y1.*(xx3*ones(1,length(k))).^k;
   if lli~=0
    if abs(xx3-1)>tol1
     if nil+5+l3>66-lengi, fprintf('\n'), fprintf(strbl2), nil=0; end
     fprintf('*(%.4g)^k',xx3), fprintf('\n'), fprintf(' ')
     fprintf(strbl1), nil=0;
    else
     fprintf('\n'), fprintf(' '), fprintf(strbl1), nil=0;
    end
   end
   cont=cont+2*mul(i1);
  end % if the block referred to is real or complex
 end % if the eigenvalue is zero
end % of the main loop on the Jordan blocks
const=d1+const;
if abs(const)>tol1
 if nil+length(sprintf('%.4g',abs(const)))+12>66-lengi
  fprintf('\n'), fprintf(' '), fprintf(strbl1)
 end
 if const>0, sgn='+'; else, sgn='-'; end
 fprintf(sgn)
 fprintf(' %.4g*delta(k) ',abs(const))
 nil=nil+length(sprintf('%.4g',abs(const)))+13;
 y(1)=y(1)+const;
end
ll=length(impulses);
if (ll==0)&(abs(const)>tol1), fprintf('\n'), end
if length(nil)==0, nil=1; end
for kk=1:ll
 if abs(impulses(ll+1-kk))>tol1
  len=13+length(sprintf('%.4g',abs(impulses(ll+1-kk))));
  len=len+length(sprintf('%1.0f',kk));
  if nil+len>66-lengi, fprintf('\n'), fprintf(' ')
  fprintf(strbl1), nil=1; end
  if impulses(ll+1-kk)>0, sgn='+'; else, sgn='-'; end
  fprintf(sgn)
  fprintf(' %.4g*delta(k-%1.0f) ',abs(impulses(ll+1-kk)),kk)
  nil=nil+len;
  if kk+1<=length(y)
   y(kk+1)=y(kk+1)+impulses(ll+1-kk);
  end
 end
 if kk==ll, fprintf('\n'), end
end
fprintf('\n')
if nargs1==0
 return
end
out=y;
% --- last line of invtrd ---
