function [out1,out2]=invtrcg(arg1,arg2,arg3,arg4,arg5,arg6)
%INVTRCG  Inverse Laplace transform in finite terms.
%   tt=INVTRCG(num,den,typ,gi)
%   tt=INVTRCG(z,p,k,typ,gi)
%   provides as tt the inverse Laplace transform of a continuous-time
%   linear SISO system by using the real Jordan form; gi is a string
%   with the name of transfer function only for display use.
%   The integer typ has the following meanings:
%      1. Complex modes in Cartesian form
%      2. Complex modes in polar form (function sine)
%      3. Complex modes in polar form (function cosine)
%   [tt,y]=INVTRCG(num,den,typ,gi,t) and [tt,y]=INVTRCG(z,p,k,typ,gi,t)
%   provide the impulse response y versus time t (row vectors) from the
%   internal finite-terms expansion.
%   The following option is available at the beginning of the file:
%   opt=1 (default): modes with small coefficients are not displayed
%   opt=0: all computed modes are displayed.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

j=sqrt(-1); tt=[];
nargs=nargin; nargs1=nargout;
%
opt=1;	% if opt=1 "small" modes are filtered
%opt=0;  % if opt=0, all computed modes are displayed
%
if nargs1==1, error(nargchk(4,5,nargs)); else, error(nargchk(5,6,nargs)); end
if nargs1>2, error(' illegal number of output arguments'), end
if nargs==4 | (nargs==5 & nargs1==2)
 num=arg1; den=arg2; typ=arg3; gi=arg4;
 if nargs1==2, t=arg5; else, t=0; end
 [z,p,k]=tozpk(num,den);
elseif nargs==5 | (nargs==6 & nargs1==2)
 z=arg1; p=arg2; k=arg3; typ=arg4; gi=arg5;
 if nargs1==2, t=arg6; else, t=0; end
end
if (typ<1)|(typ>3), error(' illegal flag'), end
if typ==1; flg=1; flg1=0;
elseif typ==2; flg=2; flg1=1;
else; flg=2; flg1=2; end
%
[a1,b1,c1,d1,egv,mul]=jorcf(z,p,k);
%
tol=0; tol1=10^(-8);
if opt~=0
 tol=10^(-8)*norm(c1,'fro');
end
tt=[tt,'|'];
lengi=length(gi);
tt=[tt,sprintf(['   Antitrasformata di Laplace di ',gi,'(s) :'])]; tt=[tt,'|'];
tt=[tt,sprintf(['   ',setstr(45*ones(1,(35+lengi)))])]; tt=[tt,'|'];
tt=[tt,sprintf('   ')];
tt=[tt,sprintf(gi)]; tt=[tt,sprintf('(t) = ')];
strbl1=setstr(' '*ones(1,lengi+8));
strbl2=setstr(' '*ones(1,lengi+11));
cont=0; % index for vector c1
nil=0;
y=zeros(1,length(t));
for i1=1:length(mul) % the main loop on the Jordan blocks
 y1=zeros(1,length(t));
 if abs(imag(egv(i1))) <= tol1*abs(real(egv(i1))) % (the block is real)
  xx1=zeros(1,mul(i1)); xx2=zeros(1,mul(i1));
  xx3=egv(i1); l3=length(sprintf('%.4g',xx3));
  for i2=1:mul(i1)
   ix=cont+mul(i1)-i2+1;
   xx1(i2)=(c1(ix)/fact(i2-1));
   xx2(i2)=(i2-1);
   y1=y1+xx1(i2)*t.^xx2(i2);
   %
   if abs(c1(ix))<=tol, xx1(i2)=0; end
   %
  end
  if opt==1, ii=find(xx1); else, ii=1:mul(i1); end
  lli=length(ii);
  xv1=xx1(ii); xv2=xx2(ii);
  for i2=1:lli
   xx1=xv1(i2); xx2=xv2(i2);
   if (lli>1)&(i2==1)
    if i1>1
     tt=[tt,sprintf('+ (')];
    else
     tt=[tt,sprintf('  (')];
    end
    nil=nil+3;
   end
   if (lli==1)&(xx1>=0)
    if i1>1
     tt=[tt,sprintf('+ ')];
    else
     tt=[tt,sprintf('  ')];
    end
    nil=nil+2;
   end
   l1=length(sprintf('%.4g',abs(xx1)));
   l2=length(sprintf('%.4g',xx2));
   if xx2>0, l=2; else, l=0; end
   if xx2>1, l=l+l2+1; end
   if (i2>1)|((i2==1)&(xx1<0)), l=l+2; end
   if nil+l1+l+1>66-lengi
    tt=[tt,'|']; tt=[tt,sprintf(strbl2)]; nil=0;
   end
   if xx1>=0, sgn=('+ '); else, sgn=('- '); end
   if (i2>1)|((i2==1)&(xx1<0)), tt=[tt,sprintf(setstr(sgn))]; nil=nil+2; end
   tt=[tt,sprintf('%.4g',abs(xx1))]; nil=nil+l1;
   if xx2>0, tt=[tt,sprintf(' t')]; nil=nil+2; end
   if xx2>1, tt=[tt,sprintf('^%.4g',xx2)]; nil=nil+1+l2; end
   if i2~=lli, tt=[tt,sprintf(' ')]; nil=nil+1; end
   if (lli>1)&(i2==lli)
    tt=[tt,sprintf(')')]; nil=nil+1;
   end
  end
  y=y+y1.*exp(xx3*t);
  if lli~=0
   if abs(xx3)>tol1
    if nil+9+l3>66-lengi
     tt=[tt,'|']; tt=[tt,sprintf(strbl2)]; nil=0;
    end
    tt=[tt,sprintf('*exp(%.4g t)',xx3)]; tt=[tt,'|'];
    tt=[tt,sprintf(strbl1)];
    nil=0;
   else
    tt=[tt,'|']; tt=[tt,sprintf(strbl1)]; nil=0;
   end
   tt=[tt,sprintf(' ')]; nil=nil+1;
  end
  cont=cont+mul(i1);
 else % (the block is complex)
  xx3=real(egv(i1)); l3=length(sprintf('%.4g',xx3));
  if flg==2   % (polar form)
   xx1=zeros(1,mul(i1)); xx2=zeros(1,mul(i1)); xx5=zeros(1,mul(i1));
   xx4=imag(egv(i1)); l4=length(sprintf('%.4g',xx4));
   for i2=1:mul(i1)
    ix=cont+2*(mul(i1)-i2+1)-1;
    if flg1==1
     AB=(c1(ix)+j*c1(ix+1))/fact(i2-1); s=(' sin');
    else
     AB=(c1(ix+1)-j*c1(ix))/fact(i2-1); s=(' cos');
    end
    M=abs(AB);
    fi=angle(AB);
    if fi>=pi/2
     fi=fi-pi; M=-M;
    elseif fi<-pi/2
     fi=fi+pi; M=-M;
    end
    xx1(i2)=M; xx2(i2)=(i2-1); xx5(i2)=fi;
    if flg1==1
     y1=y1+(xx1(i2)*t.^xx2(i2)).*sin(xx4*t+xx5(i2));
    else
     y1=y1+(xx1(i2)*t.^xx2(i2)).*cos(xx4*t+xx5(i2));
    end
    %
    if abs(c1(ix)+j*c1(ix+1))<=tol, xx1(i2)=0; end
    %
   end
   if opt==1, ii=find(xx1); else, ii=1:mul(i1); end
   lli=length(ii);
   xv1=xx1(ii); xv2=xx2(ii); xv5=xx5(ii);
   for i2=1:lli
    xx1=xv1(i2); xx2=xv2(i2); xx5=xv5(i2);
    if (i1>1)&(i2==1)
     tt=[tt,sprintf('+ [')]; nil=nil+3;
    elseif (i1==1)&(i2==1)
     tt=[tt,sprintf('  [')]; nil=nil+3;
    end
    l1=length(sprintf('%.4g',abs(xx1)));
    l2=length(sprintf('%.4g',xx2));
    l5=length(sprintf('%.4g',abs(xx5)));
    if xx2>0, l=2; else, l=0; end
    if xx2>1, l=l+l2+1; end
    if xx5~=0, l=l+3+l5; end
    if ((i2==1)&(xx1<0))|(i2>1), l=l+2; end
    if nil+l1+9+l+l4>66-lengi
     tt=[tt,'|']; tt=[tt,sprintf(strbl2)]; nil=0;
    end
    if xx1>=0, sgn=('+ '); else, sgn=('- '); end
    if xx5>0, sgn1=(' + '); elseif xx5<0, sgn1=(' - '); end
    if ((i2==1)&(xx1<0))|(i2>1), tt=[tt,sprintf(setstr(sgn))]; nil=nil+2; end
    tt=[tt,sprintf('%.4g',abs(xx1))]; nil=nil+l1;
    if xx2>0, tt=[tt,sprintf(' t')]; nil=nil+2; end
    if xx2>1, tt=[tt,sprintf('^%.4g',xx2)]; nil=nil+1+l2; end
    tt=[tt,sprintf(setstr(s))];
    tt=[tt,sprintf('(%.4g t',xx4)];
    nil=nil+8+l4;
    if xx5~=0
     tt=[tt,sprintf(setstr(sgn1))];
     tt=[tt,sprintf('%.4g',abs(xx5))];
     nil=nil+3+l5;
    end
    tt=[tt,sprintf(')')];
    if i2~=lli, tt=[tt,sprintf(' ')]; else, tt=[tt,sprintf(']')]; end
    nil=nil+1;
   end
  else	 % (Cartesian form)
   xx1=zeros(1,mul(i1)); xx11=zeros(1,mul(i1)); xx2=zeros(1,mul(i1));
   xx4=imag(egv(i1)); l4=length(sprintf('%.4g',xx4));
   for i2=1:mul(i1)
    ix=cont+2*(mul(i1)-i2+1)-1; xx2(i2)=i2-1;
    xx1(i2)=c1(ix)/fact(i2-1); xx11(i2)=c1(ix+1)/fact(i2-1);
    yy1=xx1(i2)*sin(xx4*t);
    yy1=(yy1+xx11(i2)*cos(xx4*t)).*t.^xx2(i2);
    y1=y1+yy1;
    %
    if abs(c1(ix))<=tol, xx1(i2)=0; end
    if abs(c1(ix+1))<=tol, xx11(i2)=0; end
    %
   end
   xx=[xx1',xx11'];
   if opt==1, ii=find(xx(:,1)|xx(:,2)); else, ii=1:mul(i1); end
   lli=length(ii);
   xv1=xx(ii,:); xv2=xx2(ii);
   for i2=1:lli
    xx1=xv1(i2,1); xx11=xv1(i2,2); xx2=xv2(i2);
    if (i1>1)&(i2==1)
     tt=[tt,sprintf('+ [')]; nil=nil+3;
    elseif (i1==1)&(i2==1)
     tt=[tt,sprintf('  [')]; nil=nil+3;
    end
    l2=length(sprintf('%.4g',xx2));
    l6=length(sprintf('%.4g',abs(xx1)));
    l7=length(sprintf('%.4g',abs(xx11)));
    if xx1<0, l=2; else, l=0; end
    if xx2>0, l=l+6; end
    if xx2>1, l=l+l2+1; end
    if (xx1~=0)|(opt==0), l=l+8+l4+l6; end
    if (xx11~=0)|(opt==0), l=l+8+l4+l7; end
    if (xx11>0 & (xx1~=0 | opt==0)) | ((xx11==0) & (opt==0))
     l=l+3;
    elseif xx11<0 & (xx1~=0 | opt==0)
     l=l+3;
    elseif xx11<0 & (xx1==0 & opt==1)
     l=l+2;
    end
    if nil+l+1>66-lengi
     tt=[tt,'|']; tt=[tt,sprintf(strbl2)]; nil=0;
    end
    if (xx11>0 & (xx1~=0 | opt==0)) | ((xx11==0) & (opt==0))
     sgn1=(' + ');
    elseif xx11<0 & (xx1~=0 | opt==0)
     sgn1=(' - ');
    elseif xx11<0 & (xx1==0 & opt==1)
     sgn1=('- ');
    end
    if xx2>0, tt=[tt,sprintf('+ (')]; nil=nil+3; end
    if xx1<0, tt=[tt,sprintf('- ')]; nil=nil+2; end
    if (xx1~=0)|(opt==0)
     tt=[tt,sprintf('%.4g sin(%.4g t)',abs(xx1),xx4)];
     nil=nil+8+l4+l6;
    end
    if (xx11~=0)|(opt==0)
     tt=[tt,sprintf(setstr(sgn1))]; nil=nil+3;
     tt=[tt,sprintf('%.4g cos(%.4g t)',abs(xx11),xx4)];
     nil=nil+8+l4+l7;
    end
    if xx2>0, tt=[tt,sprintf(') t')]; nil=nil+3; end
    if xx2>1, tt=[tt,sprintf('^%.4g',xx2)]; nil=nil+1+l2; end
    if i2~=lli, tt=[tt,sprintf(' ')]; else, tt=[tt,sprintf(']')]; end
    nil=nil+1;
   end
  end
  y=y+y1.*exp(xx3*t);
  if lli~=0
   if abs(xx3)>tol1
    if nil+9+l3>66-lengi
     tt=[tt,'|']; tt=[tt,sprintf(strbl2)]; nil=0;
    end
    tt=[tt,sprintf('*exp(%.4g t)',xx3)]; tt=[tt,'|'];
    tt=[tt,sprintf(strbl1)]; nil=0;
   else
    tt=[tt,'|']; tt=[tt,sprintf(strbl1)]; nil=0;
   end
   tt=[tt,sprintf(' ')]; nil=nil+1;
  end
  cont=cont+2*mul(i1);
 end % if the block referred to is real or complex
end % of the main loop on the Jordan blocks
if d1~=0
 if nil+length(sprintf('%.4g',d1))+12>66-lengi
  tt=[tt,'|']; tt=[tt,sprintf(strbl1)];
 end
 if d1>0, sgn='+'; else, sgn='-'; end
 tt=[tt,sprintf(sgn)];
 tt=[tt,sprintf(' %.4g*delta(t)',abs(d1))]; tt=[tt,'|'];
end
tt=[tt,'|'];
if nargs1==1
 out1=tt; return
end
out1=tt, out2=y;
% --- last line of invtrcg ---
