function invtr(arg1,arg2,arg3,arg4)
%INVTR	  Antitrasformazione di Laplace o Z (TFI).
%   INVTR,gi - da TFI [INVTR('gi') - da Matlab] fornisce l'antitrasformata
%   di Laplace o Z della funzione di trasferimento gi.
%   Per i modi complessi sono disponibili le seguenti opzioni:
%      1 - modi complessi in forma cartesiana
%      2 - modi complessi in forma polare (funzione seno)
%      3 - modi complessi in forma polare (funzione coseno)
%   Se INVTR viene chiamato senza alcun argomento, la f.d.t. gi puo'
%   essere specificata in interattivo.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

if nargin>0
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1;
 end
else
 flg=0;
 while flg==0
  gi=input('\n   specificare la funzione di trasferimento : ','s');
  if ~isempty(gi)
   if ~exist([gi,'.mat'])
    disp([' **** errore: ',gi,'.mat non esiste'])
   else
    flg=1;
   end
  end
 end
end
[z,p,k,str]=exportf(gi,1); if isempty(k), return, end
if length(z)>length(p)
 disp([' **** errore: m > n in ',gi]), return
end
flg=1;
rop=(length(p)~=0)&(norm(imag(p))>0);
if rop
 flg=0;
 while (flg~=1)&(flg~=2)&(flg~=3)
  fprintf('\n')
  disp('   1 - modi complessi in forma cartesiana')
  disp('   2 - modi complessi in forma polare - funzione seno')
  disp('   3 - modi complessi in forma polare - funzione coseno')
  flg=input('\n   operare una scelta : ');
  if length(flg)==0, flg=0; end
 end
end
typ=flg;
if str=='s'
 invtrc(z,p,k,typ,gi)
else
 invtrd(z,p,k,typ,gi)
end
% --- last line of invtr ---
