function out=importf1(arg1,arg2,arg3)
%IMPORTF1 Converts a Matlab's LTI system to a TFI transfer function.
%   IMPORTF1(sys,'gi')           --> gives the transfer function gi
%				     (factorized) of the LTI system sys
%   IMPORTF1(sys,'gi',1)         --> gives the transfer function gi
%				     (polynomial) of the LTI system sys

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

if ~exist('ctrb.m')
 disp(' '), disp('   **** importf1 requires the Control System toolbox')
 disp(' '), out=[]; return
end
gi=arg2;
if nargin==2
 bb=zpk(arg1);
 [z,p,k,Ts,Td]=zpkdata(bb);
 z=z{1,1};
 p=p{1,1};
 if Ts==0, str='s'; else, str='z'; end
 Num=[]; Den=[];
 i=1;
 while i<=length(z)
  sn=size(Num);
  if abs(imag(z(i)))>10^(-4)
   nn=real(poly([z(i),real(z(i))-j*imag(z(i))]));
   qq=find(z==(real(z(i))-j*imag(z(i))));
   if length(qq)~=0, z(qq(1))=[]; end
   Num=[zeros(sn(1),length(nn)-sn(2)),Num;nn];
  else
   Num=[Num;zeros(1,sn(2)-2),poly(z(i))];
  end
  i=i+1;
 end
 i=1;
 while i<=length(p)
  sd=size(Den);
  if abs(imag(p(i)))>10^(-4)
   dd=real(poly([p(i),real(p(i))-j*imag(p(i))]));
   qq=find(p==(real(p(i))-j*imag(p(i))));
   if length(qq)~=0, p(qq(1))=[]; end
   Den=[zeros(sd(1),length(dd)-sd(2)),Den;dd];
  else
   Den=[Den;zeros(1,sd(2)-2),poly(p(i))];
  end
  i=i+1;
 end
 aa=stf(Num,Den,k,str,gi,Ts);
else
 bb=tf(arg1);
 [num,den,Ts,Td]=tfdata(bb);
 num=num{1,1};
 den=den{1,1};
 if Ts==0, str='s'; else, str='z'; end
 if ~any(num), num=1; k=0; end
 aa=stf(num,den,1,str,gi,Ts);
end
if nargout==1, out=aa; end
% ----- last line of importf1 -----
