function out=importf(arg1,arg2,arg3,arg4,arg5)
%IMPORTF  Converts a transfer function from Matlab to TFI.
%   IMPORTF(num,den,'gi')
%   IMPORTF(num,den,'gi',1)  --> saves num,den in gi.mat
%   IMPORTF(z,p,k,'gi')
%   IMPORTF(z,p,k,'gi',1)    --> saves z,p,k in gi.mat
%   NOTE: option "1", means discrete-time.
%   Optional logic output aa=IMPORTF(....) means "importing without error".

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
if (nargs==3)|((nargs==4)&(isstr(arg3)))
 num=arg1; den=arg2; gi=arg3; k=1;
 if nargs==3, str='s'; else, str='z'; end
 if ~any(num), num=1; k=0; end
 aa=stf(num,den,k,str,gi);
else
 z=arg1; p=arg2; k=arg3; gi=arg4; Num=[]; Den=[];
 if nargs==4, str='s'; else, str='z'; end
 i=1;
 while i<=length(z)
  sn=size(Num);
  if abs(imag(z(i)))>10^(-4)
   nn=real(poly([z(i),real(z(i))-j*imag(z(i))]));
   qq=find(z==(real(z(i))-j*imag(z(i))));
   if length(qq)~=0, z(qq(1))=[]; end
   Num=[zeros(sn(1),length(nn)-sn(2)),Num;nn];
  else
   Num=[Num;zeros(1,sn(2)-2),poly(z(i))];
  end
  i=i+1;
 end
 i=1;
 while i<=length(p)
  sd=size(Den);
  if abs(imag(p(i)))>10^(-4)
   dd=real(poly([p(i),real(p(i))-j*imag(p(i))]));
   qq=find(p==(real(p(i))-j*imag(p(i))));
   if length(qq)~=0, p(qq(1))=[]; end
   Den=[zeros(sd(1),length(dd)-sd(2)),Den;dd];
  else
   Den=[Den;zeros(1,sd(2)-2),poly(p(i))];
  end
  i=i+1;
 end
 aa=stf(Num,Den,k,str,gi);
end
if nargout==1, out=aa; end
% --- last line of importf ---
