function gpmarg(arg1,arg2,arg3,arg4)
%GPMARG   Margini di ampiezza e fase (TFI).
%   GPMARG,gi - da TFI [GPMARG('gi') - da Matlab] visualizza i margini di
%   ampiezza e fase di gi.
%   GPMARG,gi,1 - da TFI [GPMARG('gi','1') - da Matlab] consente
%   il calcolo in interattivo del margine di ampiezza per una fase
%   diversa da -180 e del margine di fase per un'ampiezza diversa da 1.
%   Se GPMARG viene chiamato senza alcun argomento, la f.d.t. gi puo'
%   essere specificata in interattivo.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
if nargs==0
 flg=0;
 while flg==0
  gi=input('\n   specificare la funzione di trasferimento : ','s');
  if ~isempty(gi)
   if gi=='0', return, end
   if ~exist([gi,'.mat'])
    disp([' **** errore: ',gi,'.mat non esiste'])
   else
    flg=1;
   end
  end
 end
else
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1;
 end
end
[z,p,k,str]=exportf(gi,1); if isempty(k), return, end
if strcmp(str,'z')
 T=lsamp; [z,p,k]=diwplane(z,p,k,T);
end
[num,den]=dezpk(z,p,k);
%
xyx=0; if (nargs==0)|(nargs==2), xyx=1; end
if xyx==1
 mess='\n   riferimento per il margine di ampiezza (default -180) : ';
 phi0=input(mess);
 if isempty(phi0), phi0=-180; end
 mag0=-1;
 while mag0<=0
 mess='\n   riferimento per il margine di fase (default 1)        : ';
 mag0=input(mess);
 if isempty(mag0), mag0=1; end
 end
else
 phi0=-180; mag0=1;
end
[gm,pm,omg,omp]=gpcross1(z,p,k,mag0,phi0);
%
%   gain margin
%
if isnan(omg)
 fprintf('\n   margine di ampiezza non determinabile\n')
else
 gm=1/gm;
 if strcmp(str,'z')
  omg=(1/T)*(angle(1+j*omg*T/2)-angle(1-j*omg*T/2));
 end
 fprintf(['\n   margine di ampiezza di ',gi,'(',str,')'])
 fprintf(': %.4g',gm)
 fprintf(' (%.4g db)\n',20*log10(gm))
 fprintf('   (fase = %.4g gradi)',phi0)
 fprintf(' alla pulsazione: %.4g rad/sec\n',omg)
end
%
%   phase margin
%
if isnan(omp)
 fprintf('\n   margine di fase non determinabile\n')
else
pm=180+pm;
if strcmp(str,'z')
 omp=(1/T)*(angle(1+j*omp*T/2)-angle(1-j*omp*T/2));
end
 fprintf(['\n   margine di fase di ',gi,'(',str,')'])
 fprintf(': %.4g gradi\n',pm)
 fprintf('   (ampiezza = %.4g)',mag0)
 fprintf(' alla pulsazione: %.4g rad/sec\n',omp)
end
disp(' ')
% ----- last line of gpmarg -----
