function [gain,phi,omg,omp]=gpcross1(arg1,arg2,arg3,arg4,arg5)
%GPCROSS1 Gain and phase at crossover frequencies.
%   [gain,phi,omg,omp] = GPCROSS1(num,den,mag0,phi0) returns as
%   (gain,omg) the gain and the least frequency corresponding to
%      arg[num(j*om)/den(j*om)]=phi0
%   and as (phi,omp) the phase and the least frequency corresponding to
%      |num(j*om)/den(j*om)|=mag0;
%   gm is the inverse of the gain margin if phi0=-180 and pm-180 is
%   the phase margin if mag0=1; gm and omg and/or pm and omp are
%   returned as NaN when problem has no solution.
%   Other possible call: [gain,phi,omg,omp]=gpcross1(z,p,k,mag0,phi0).

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin; omg=[];
error(nargchk(4,5,nargs));
if nargs==4
 num=arg1; den=arg2; mag0=arg3; phi0=arg4; [z,p,k]=tozpk(num,den);
else
 z=arg1; p=arg2; k=arg3; mag0=arg4; phi0=arg5; [num,den]=dezpk(z,p,k);
end
%
% the real and imaginary parts of num, den
%
Rn=[]; In=0; mm=1; nn=length(num);
for kk=nn:-1:1
 if rem(nn-kk+1,2)
  if (nn-kk)>1, Rn=[0,Rn]; end
  Rn=[mm*num(kk),Rn];
 else
  if (nn-kk)>1, In=[0,In]; end
  In=[mm*num(kk),In]; mm=-mm;
 end
end
%if length(Rn)==0, Rn=0; end
%
Rd=[]; Id=0; mm=1; nn=length(den);
for kk=nn:-1:1
 if rem(nn-kk+1,2)
  if (nn-kk)>1, Rd=[0,Rd]; end
  Rd=[mm*den(kk),Rd];
 else
  if (nn-kk)>1, Id=[0,Id]; end
  Id=[mm*den(kk),Id]; mm=-mm;
 end
end
%
% computation of gain-crossover phase and corresponding frequency
%
pp1=sumpol(conv(Rn,Rn),conv(In,In)); pp2=sumpol(conv(Rd,Rd),conv(Id,Id));
pp=sumpol(pp1,-mag0^2*pp2);
if any(pp)
 vv=roots(pp);
else
 vv=[];
end
if length(vv)~=0
 ii=find((imag(vv)==0)&(real(vv)>0));
else
 ii=[];
end
if isempty(ii)
 omp=NaN; phi=NaN;
else
 vv=vv(ii); vv=sort(vv); omp=vv(1);
 phi=(180/pi)*(angle(polyval(num,j*omp))-angle(polyval(den,j*omp)));
%
% correction for phase
%
 [gg,pp]=asymph(z,p,k,omp,omp); pho=sum(pp)/length(pp); kk=0;
 while (abs(phi-pho) > 120) & (kk <= 12)
  kk=kk+1; phi=phi-360*sign(phi-pho);
 end
end
%
% computation of phase-crossover gain and corresponding frequency
%
pp1=sumpol(conv(Rd,In),-conv(Rn,Id)); pp2=sumpol(conv(Rn,Rd),conv(In,Id));
pp=sumpol(cos(phi0*pi/180)*pp1,-sin(phi0*pi/180)*pp2);
% put true zeros in polynomial
m=length(pp); tol1=norm(pp,'fro')*10^(-8);
for hh=1:m
 if abs(pp(hh)) < tol1
  pp(hh)=0;
 end
end
% try to strip leading zeros
hh=1; rop=(pp(hh)==0)&(hh<m);
while rop
 hh=hh+1; rop=(pp(hh)==0)&(hh<m);
end
pp=pp(hh:m);
if any(pp)
 vv=roots(pp);
else
 vv=[];
end
if length(vv)~=0
 ii=find((imag(vv)==0)&(real(vv)>0));
else
 ii=[];
end
if isempty(ii)
 omg=NaN; gain=NaN;
else
 vv=vv(ii); vv=sort(vv);
 for hh=1:length(ii)
  phi1=(180/pi)*(angle(polyval(num,j*vv(hh)))-angle(polyval(den,j*vv(hh))));
%
% correction for phase
%
  [gg,pp]=asymph(z,p,k,vv(hh)/3,vv(hh)*3); pho=sum(pp)/length(pp); kk=0;
  while (abs(phi1-pho) > 120) & (kk <= 12)
   kk=kk+1; phi1=phi1-360*sign(phi1-pho);
  end
  if abs(phi1-phi0)<90
   omg=vv(hh); break
  end
 end
 if length(omg)~=0
  gain=abs(polyval(num,j*omg))/abs(polyval(den,j*omg));
 else
  omg=NaN; gain=NaN;
 end
end
% --- last line of gpcross1 ---
