function [gm,pm,ogm,opm]=gpcross(mag,phi,om,mag0,phi0)
%GPCROSS  Gain and phase at crossover frequencies.
%   [gm,pm,ogm,opm] = GPCROSS(mag,phi,om,mag0,phi0) returns as (gm,ogm)
%   the gain and the least frequency corresponding to phi=phi0 and as
%   (pm,opm) the phase and the least frequency corresponding to mag=mag0;
%   mag,phi,om are frequency response vectors; gm is the inverse of the
%   gain margin if phi0=-180 and pm-180 is the phase margin if mag0=1;
%   pm and opm are returned as NaN if mag(1)<mag0 or mag(lw)>mag0, while
%   gm and ogm are returned as NaM if phi(1)<phi0 or phi(lw)>phi0.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(5,5,nargs));
%
lw=length(om);
%
% computation of gain-crossover phase and corresponding frequency
%
ii=find(mag<=mag0);
if (mag(1)<mag0) | (isempty(ii))
 pm=NaN; opm=NaN;
else
 iz=ii(1); pm=phi(iz); opm=om(iz);
 if iz==1, iz=2; end
 dom=(om(iz)-om(iz-1)); dphi=(phi(iz)-phi(iz-1));
 if mag(iz-1)==mag(iz)
  rel=NaN;
 else
  rel=(mag0-mag(ii(1)))/(mag(iz-1)-mag(iz));
 end
 pm=pm-dphi*rel; opm=opm-dom*rel;
end
%
% computation of phase-crossover gain and corresponding frequency
%
ii=find(phi<=phi0);
if (phi(1)<phi0) | (isempty(ii))
 gm=NaN; ogm=NaN;
else
 iz=ii(1); gm=mag(iz); ogm=om(iz);
 if iz==1, iz=2; end
 dom=(om(iz)-om(iz-1)); dmag=(mag(iz)-mag(iz-1));
 if phi(iz-1)==phi(iz)
  rel=NaN;
 else
  rel=(phi0-phi(ii(1)))/(phi(iz-1)-phi(iz));
 end
 gm=gm-dmag*rel; ogm=ogm-dom*rel;
end
% --- last line of gpcross ---
