function [out1,fl]=functab(arg1,arg2)
%   A function table for shorthand notation (aux for TFI).
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

fl=0; aA=setstr(224); if length(arg1)<3, out1=arg1; return, end
st=arg1(1:3);
if st=='con', out1='convert'; fl=1;
mess='conversione da tempo continuo a tempo discreto'; end
if st=='des', out1='descrf'; fl=1;
mess='analisi di sistemi non lineari con la funzione descrittiva'; end
if st=='fac', out1='factf'; fl=1;
mess=['fattorizzazione con scelta interattiva della molteplicit',aA]; end
if st=='fre', out1='fresp'; fl=1;
mess='risposta in frequenza'; end
if st=='gpm', out1='gpmarg'; fl=1;
mess='margini di ampiezza e di fase'; end
if st=='inv', out1='invtr'; fl=1;
mess='antitrasformata di Laplace o Z'; end
if st=='lag', out1='lagc'; fl=1;
mess='progetto interattivo di rete ritardatrice'; end
if st=='lea', out1='leadc'; fl=1;
mess='progetto interattivo di rete anticipatrice'; end
if st=='ord', out1='ordf'; fl=1;
mess='ordinamento delle figure'; end
if st=='mak', out1='makeleg'; fl=1;
mess='crea una legenda nell''ultima figura'; end
if st=='nls', out1='nlsim'; fl=1;
mess='risposta di sistema in retroazione con un elemento non lineare'; end
if st=='per', out1='perftra'; fl=1;
mess='progetto di un sistema digitale per l''inseguimento perfetto'; end
if st=='res', out1='resfiglo'; fl=1;
mess='definizione delle posizioni delle figure ai valori di default'; end
if st=='rob', out1='robpar'; fl=1;
mess='analisi di robustezza parametrica'; end
if st=='roo', out1='rootl'; fl=1;
mess='luogo delle radici'; end
if st=='rou', out1='routh'; fl=1;
mess=['intervalli di stabilit',aA,' con il criterio di Routh']; end
if st=='sam', out1='samptime'; fl=1;
mess='definizione del tempo di campionamento'; end
if st=='sel', out1='select'; fl=1;
mess='selezione interattiva di fattori di una funzione di trasferimento'; end
if st=='sta', out1='startint'; fl=1;
mess='definizione di alcune impostazioni di TFI'; end
if st=='tfe', out1='tfeval'; fl=1;
mess='valutazione di una funzione di trasferimento nel campo complesso'; end
if st=='tre', out1='tresp'; fl=1;
mess='risposta nel tempo'; end
if st=='wpl', out1='wplane'; fl=1;
mess='conversione da s a z o da z a s con l''equivalenza nel piano w'; end
if st=='zpp', out1='zpplots'; fl=1;
mess='mappa zeri-poli'; end
if (fl==0)&(length(arg1)<4), out1=arg1; return, end
if fl~=0, st='xxxx'; else, st=arg1(1:4); end
if st=='defa', out1='defactf'; fl=1;
mess='conversione alla forma polinomiale'; end
if st=='deft', out1='deftf'; fl=1;
mess='definizione di alcuni tipi di funzioni di trasferimento'; end
if st=='delf', out1='delf'; fl=1;
mess='cancella tutte le figure correnti'; end
if st=='pidc', out1='pidc'; fl=1;
mess='progetto interattivo di regolatori PID'; end
if st=='pidd', out1='pidd'; fl=1;
mess='progetto interattivo di regolatori PID digitali'; end
if st=='pidn', out1='pidnich'; fl=1;
mess='progetto di regolatori PD, PI o PID con il diagramma di Nichols'; end
if st=='regd', out1='regdph'; fl=1;
mess='progetto di regolatori per allocazione dei poli ad anello chiuso'; end
if st=='regn', out1='regnich'; fl=1;
mess='progetto di reti correttrici con il diagramma di Nichols'; end
if st=='regr', out1='regrootl'; fl=1;
mess='progetto di regolatori con il luogo delle radici'; end
if fl==0, out1=arg1; return, end
if ~(strcmp(arg1,out1))&(nargin==2)
 fprintf(['   ',out1]), fprintf(' ('), fprintf(mess), fprintf(')\n')
end
% --- last line of functab ---
