function [out1,out2,out3]=frespc(z,p,gain,typ,arg5,arg6,arg7,arg8)
%FRESPC   Frequency response of a continuous-time system.
%   FRESPC(z,p,k,typ,[col]) provides a plot of the frequency response
%   of the continuous-time system (z,p,k) with automatic scaling.
%   It is possible to specify the type of diagram as follows:
%     1. Bode diagram of magnitude
%     2. Bode diagram of phase
%     3. Bode diagrams of magnitude and phase
%     4. Nichols diagram
%     5. Nyquist diagram
%   FRESPC(z,p,k,typ,om1,om2,[col]) provides plots of the frequency
%   response function in the range om1 <= omega <= om2.
%   Parameter col (optional) defines color of plot; col must be a string
%   variable ('g'=green, 'b'=blue, 'r'=red, 'y'=yellow, 'c'=cyan,
%   'm'=magenta); default is col='g'.
%   External definition of axes is possible with "axis([xm,xM,ym,yM])".
%   [magn,phas,om1]=FRESPC( ... ) provides output for external use.
%   A finite delay to can be communicated with the 6- and 8- argument calls:
%   frespc(z,p,k,typ,col,to) and frespc(z,p,k,typ,om1,om2,col,to).
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global HALEG

nargs=nargin; error(nargchk(4,8,nargs));
flg=typ; flg1=0; j=sqrt(-1); to=0;
if nargs==4
 col='g-';
elseif nargs==5
 if length(arg5)==1, col=[arg5,'-']; else, col=arg5; end
elseif nargs==6
 if isstr(arg5)
  to=arg6; if length(arg5)==1, col=[arg5,'-']; else, col=arg5; end
 else
  om1=arg5; om2=arg6; k1=log10(om1); k2=log10(om2);
 end
elseif nargs==7
 om1=arg5; om2=arg6; k1=log10(om1); k2=log10(om2);
 if length(arg7)==1, col=[arg7,'-']; else, col=arg7; end
 if flg==3.5, flg1=1; end
elseif nargs==8
 om1=arg5; om2=arg6; k1=log10(om1); k2=log10(om2);
 to=arg8; if length(arg7)==1, col=[arg7,'-']; else, col=arg7; end
 if flg==3.5, flg1=1; end
end
%
[colp,colm,sty]=coltbl(col);
[tp1,tp2,tp3,tp4]=coltbl; colk=tp1(8,:); colw=tp1(7,:);
%
nz=length(z); np=length(p);
if ~flg1
 if (flg<1)|(flg>5), error(' illegal flag in frespc'), end
%
 irx=0; [num,den]=dezpk(z,p,gain);
%
 ih=ishold; YY=axis; s1=get(gca,'XLimMode');
 rop=(ih|strcmp(s1,'manual')) & flg~=4 & flg~=5;
 if rop
  om1=YY(1); om2=YY(2);
 else
  if (nargs==4)|(nargs==5)|((nargs==6)&isstr(arg5))
   tol=10^(-4); vv=abs([z;p]); vv=vv(find(vv>tol)); vv=log10(vv);
   if isempty(vv)
    om1=.01; om2=100; irx=1;
   else
    om1=10^(floor(min(vv)-1)); om2=10^(ceil(max(vv)+1));
   end
  end
 end
%
%  adjusting the frequency range for nichols and nyquist plots
 if (flg==4|flg==5)&(~irx)
  fff=(ih|strcmp(s1,'manual'));
  if fff
   VV=axis; scale=max(abs(VV));
  else
   g1=abs(polyval(num,j*om1)/polyval(den,j*om1));
   g2=abs(polyval(num,j*om2)/polyval(den,j*om2));
   scale=max([g1,g2]);
  end
  for kk=0:16
   om2r=om2*2^kk; comga=polyval(num,j*om2r)/polyval(den,j*om2r);
   mmx=abs(comga); phx=angle(comga);
   if (flg==4) & fff, mmx=abs(20*log10(comga))+abs(180*phx/pi); end
   if (mmx<.001*scale)|(mmx>50*scale), break, end
   if (abs(phx)<.01*pi)|(abs(phx-pi)<.01*pi), break, end
  end
  om2=om2r;
  for kk=0:16
   om1r=om1/2^kk; comga=polyval(num,j*om1r)/polyval(den,j*om1r);
   mmx=abs(comga); phx=angle(comga);
   if (flg==4) & fff, mmx=abs(20*log10(comga))+abs(180*phx/pi); end
   if (mmx<.001*scale)|(mmx>50*scale), break, end
   if (abs(phx)<.01*pi)|(abs(phx-pi)<.01*pi), break, end
  end
  om1=om1r;
 end
 k1=log10(om1); k2=log10(om2);
%
%  adjusting the frequency range for nyquist plots
 if (ih|strcmp(s1,'manual'))&(flg==5)&(~irx)
  nw=21; w=j*ones(1,nw); w1=logspace(k1,k2,nw)+eps; w=j*w1; y=gain*ones(1,nw);
  for kk=1:np
   y=y./(w-p(kk));
  end
  for kk=1:nz
   y=y.*(w-z(kk));
  end
  mag=abs(y); aa=5*max(abs(YY)); ii=find(mag<aa);
  if ~isempty(ii)
   rop=ii(length(ii))-ii(1)+1==length(ii);
   rop=rop & mag(length(ii))>abs(YY);
   rop=rop & length(ii)~=nw;
   if rop & ii(1)>1
    om1=w1(ii(1)-1); om2=10^3*om1;
   end
  else
   if mag(nw)>.05*max(abs(YY))
    om1=om2; om2=10^3*om1;
   end
  end
  k1=log10(om1); k2=log10(om2);
 end
end
%
nw=401; w=j*ones(1,nw); w1=logspace(k1,k2,nw)+eps; w=j*w1; y=gain*ones(1,nw);
for kk=1:np
 y=y./(w-p(kk));
end
for kk=1:nz
 y=y.*(w-z(kk));
end
mag=abs(y)'; phi=(unwrap(angle(y))*180/pi)';
%
%  correction for phase
%
[gg,pp]=asymph(z,p,gain,w1(1),w1(nw));
kk=0;
while (abs(phi(1)-pp(1)) > 180) & (kk <= 12)
 kk=kk+1; phi=phi-360*sign(phi(1)-pp(1));
end
% correction for unwrap
if flg < 4.8
 for kk=1:np
  if (p(kk)~=0)&(abs(real(p(kk)))<eps)
   ii=find(w1>abs(imag(p(kk))));
   [gg,pp]=asymph(z,p,gain,w1(ii(1)),w1(ii(1)));
   if abs(phi(ii(1))-pp(1)) > 90
    phi(ii)=phi(ii)-180*sign(phi(ii(1))-pp(1));
   end
  end
 end
 for kk=1:nz
  if (z(kk)~=0)&(abs(real(z(kk)))<eps)
   ii=find(w1>abs(imag(z(kk))));
   [gg,pp]=asymph(z,p,gain,w1(ii(1)),w1(ii(1)));
   if abs(phi(ii(1))-pp(1)) > 90
    phi(ii)=phi(ii)-180*sign(phi(ii(1))-pp(1));
   end
  end
 end
end
if to~=0, phi=phi-(180/pi)*w1'*to; end
%
ssn=[0 0]; ss2=[-180 -180];
aat=setstr(32*ones(1,120)); aam=sprintf('rad/sec');
mess=[aat(1:120-length(aam)),aam];
%
if flg==1
 mag1=20*log10(mag);
 ha=semilogx(w1,mag1,w1(1),-20,w1(1),20);
 set(ha(1),'Color',colp,'LineStyle',sty)
 set(ha(2),'Color',colk,'LineStyle','none','Marker','.')
 set(ha(3),'Color',colk,'LineStyle','none','Marker','.')
 HALEG=[HALEG,ha(1)];
 VVV=axis; VVV(2)=10^ceil(log10(w1(length(w1))-10^(-8))); axis(VVV)
 if ih | strcmp(s1,'manual')
  axis(YY)
 end
 if ~ih
  hold on, YY=axis; rr=[YY(1),YY(2)];
  semilogx(rr,ssn,'Color',colw,'LineStyle','--'), axis(YY), title('ampiezza')
  xlabel(mess)
  aat=setstr(32*ones(1,70)); aam=sprintf('db');
  mess1=[aat(1:70-length(aam)),aam]; ylabel(mess1)
 end
elseif flg==2
 mm=30*floor(min(phi)/30-10^(-6)); MM=30*ceil(max(phi)/30+10^(-6));
 ha=semilogx(w1,phi,w1(1),mm,w1(1),MM);
 set(ha(1),'Color',colp,'LineStyle',sty)
 set(ha(2),'Color',colk,'LineStyle','none','Marker','.')
 set(ha(3),'Color',colk,'LineStyle','none','Marker','.')
 HALEG=[HALEG,ha(1)];
 VVV=axis; VVV(2)=10^ceil(log10(w1(length(w1))-10^(-8))); axis(VVV)
 if ih | strcmp(s1,'manual')
  axis(YY)
 end
 if ~ih
  hold on, YY=axis; rr=[YY(1),YY(2)];
  semilogx(rr,ss2,'Color',colw,'LineStyle','--'), axis(YY), title('fase')
  xlabel(mess)
  aat=setstr(32*ones(1,70)); aam=sprintf('gradi');
  mess1=[aat(1:70-length(aam)),aam]; ylabel(mess1)
 end
elseif flg==3
 mag1=20*log10(mag);
 subplot(2,1,1)
 YY=axis; s1=get(gca,'XLimMode');
 ha=semilogx(w1,mag1,w1(1),-20,w1(1),20);
 set(ha(1),'Color',colp,'LineStyle',sty)
 set(ha(2),'Color',colk,'LineStyle','none','Marker','.')
 set(ha(3),'Color',colk,'LineStyle','none','Marker','.')
 HALEG=[HALEG,ha(1)];
 VVV=axis; VVV(2)=10^ceil(log10(w1(length(w1))-10^(-8))); axis(VVV)
 if ih | strcmp(s1,'manual')
  axis(YY)
 end
 if ~ih
  hold on, YY=axis; rr=[YY(1),YY(2)];
  semilogx(rr,ssn,'Color',colw,'LineStyle','--'), axis(YY), title('ampiezza')
  xlabel(mess)
  aat=setstr(32*ones(1,35)); aam=sprintf('db');
  mess1=[aat(1:35-length(aam)),aam]; ylabel(mess1), hold off
 end
 subplot(2,1,2)
 YY=axis; mm=30*floor(min(phi)/30-10^(-6)); MM=30*ceil(max(phi)/30+10^(-6));
 ha=semilogx(w1,phi,w1(1),mm,w1(1),MM);
 set(ha(1),'Color',colp,'LineStyle',sty)
 set(ha(2),'Color',colk,'LineStyle','none','Marker','.')
 set(ha(3),'Color',colk,'LineStyle','none','Marker','.')
 VVV=axis; VVV(2)=10^ceil(log10(w1(length(w1))-10^(-8))); axis(VVV)
 if ih | strcmp(s1,'manual')
  axis(YY)
 end
 if ~ih
  hold on, YY=axis; rr=[YY(1),YY(2)];
  semilogx(rr,ss2,'Color',colw,'LineStyle','--'), axis(YY), title('fase')
  xlabel(mess)
  aat=setstr(32*ones(1,35)); aam=sprintf('gradi');
  mess1=[aat(1:35-length(aam)),aam]; ylabel(mess1)
 end
elseif flg==4
 magv=mag; phiv=phi;
% corrections for resonance peaks
 if ~isempty(p)
  pv=p(find(p~=0)); delta=abs(real(pv))./abs(pv);
  iip=find((delta<.5)&(imag(pv)>0)); delta=delta(iip);
  [oomp,iip]=sort(imag(pv(iip))); delta=delta(iip);
  if length(oomp)~=0
   for kk=1:length(oomp)
    if delta(kk) > eps
     k1=log10(oomp(kk)/(1+40*delta(kk))); k2=log10(oomp(kk)*(1+40*delta(kk)));
     wn=logspace(k1,k2,nw); w1=[w1,wn];
     w1=sort(w1); nw1=length(w1); w=j*ones(1,nw1); w=j*w1;
     y=gain*ones(1,nw1);
     for kk=1:np
      y=y./(w-p(kk));
     end
     for kk=1:nz
      y=y.*(w-z(kk));
     end
     mag=abs(y)'; phi=(unwrap(angle(y))*180/pi)';
     if to~=0, phi=phi-(180/pi)*w1'*to; end
    else
     ii=find(w1>oomp(kk)); ii1=ii(1);
     if ii1==1, ii1=2; end
     mag=[mag(1:ii1-1);10^(8);10^(8);mag(ii1:nw)];
     phi=[phi(1:ii1-1);phi(ii1-1);phi(ii1);phi(ii1:nw)];
     w1=[w1(1:ii1-1),w1(ii1-1),w1(ii1),w1(ii1:nw)];
    end
   end
  end
 end
 np0=length(find(abs(p)<10^(-8)));
 if np0==0
  gain0=polyval(num,0)/polyval(den,0);
  mag=[abs(gain0);mag];
  if gain0<0, phi=[180*sign(phi(1));phi]; else, phi=[0;phi]; end
  w1=[0,w1];
 end
 if (length(num)==length(den))&(to==0)
  gainf=num(1)/den(1);
  mag=[mag;abs(gainf)];
  if gainf<0, phi=[phi;180*sign(phi(length(phi)))]; else, phi=[phi;0]; end
  w1=[w1,10^10];
 end
 magl=20*log10(mag);
 ha=plot(phi,magl,'Color',colp,'LineStyle',sty);
 HALEG=[HALEG,ha];
 if ih | strcmp(s1,'manual')
  axis(YY)
 end
 if ~ih
  hold on, YY=axis; mm=[YY(3),YY(4)]; pp=[YY(1),YY(2)];
  if YY==[-360 0 -40 40], set(gca,'xtick',(-360:30:0)), end
  ha=plot(pp,ssn,ss2,mm);
  set(ha(1),'Color',colw,'LineStyle','--')
  set(ha(2),'Color',colw,'LineStyle','--')
  axis(YY), title('diagramma di Nichols')
  aat=setstr(32*ones(1,120)); aam=sprintf('gradi');
  mess2=[aat(1:120-length(aam)),aam]; xlabel(mess2)
  aat=setstr(32*ones(1,70)); aam=sprintf('db');
  mess1=[aat(1:70-length(aam)),aam]; ylabel(mess1)
  if YY(2)>eps
   rr1=[0,0]; rr2=[YY(3),YY(4)];
   plot(rr1,rr2,'Color',colw,'LineStyle',':')
  end
  if YY==[-360.01,0,-40,40], YY(1)=-360; axis(YY), eval('nigrid'), end
 end
elseif flg==5
 gainf=polyval(num,j*10^4*w1(nw))/polyval(den,j*10^4*w1(nw));
 % correction for delay
 if to~=0
  om1=log10(1/w1(nw)); om2=log10(20*to);
  wn=1./logspace(om1,om2,2000); w1=[w1,wn];
  w1=sort(w1); nw1=length(w1); w=j*ones(1,nw1); w=j*w1;
  y=gain*ones(1,nw1);
  for kk=1:np
   y=y./(w-p(kk));
  end
  for kk=1:nz
   y=y.*(w-z(kk));
  end
  mag=abs(y)'; phi=(unwrap(angle(y))*180/pi)';
  phi=phi-(180/pi)*w1'*to; y=mag'.*exp(j*phi'*(pi/180));
 end
% corrections for resonance peaks
 if ~isempty(p)
  pv=p(find(p~=0)); delta=abs(real(pv))./abs(pv);
  iip=find((delta<.5)&(imag(pv)>0)); delta=delta(iip);
  [oomp,iip]=sort(imag(pv(iip))); delta=delta(iip);
  if length(oomp)~=0
   for kk=1:length(oomp)
    if delta(kk) > eps
     k1=log10(oomp(kk)/(1+40*delta(kk))); k2=log10(oomp(kk)*(1+40*delta(kk)));
     wn=logspace(k1,k2,nw); w1=[w1,wn];
     w1=sort(w1); nw1=length(w1); w=j*ones(1,nw1); w=j*w1;
     y=gain*ones(1,nw1);
     for kk=1:np
      y=y./(w-p(kk));
     end
     for kk=1:nz
      y=y.*(w-z(kk));
     end
     mag=abs(y)'; phi=(unwrap(angle(y))*180/pi)';
     if to~=0, phi=phi-(180/pi)*w1'*to; y=mag'.*exp(j*phi'*(pi/180)); end
    else
     ii=find(w1>oomp(kk)); ii1=ii(1);
     mag=[mag(1:ii1-1);10^(8);10^(8);mag(ii1:nw)];
     phi=[phi(1:ii1-1);phi(ii1-1);phi(ii1);phi(ii1:nw)];
     w1=[w1(1:ii1-1),w1(ii1-1),w1(ii1),w1(ii1:nw)];
     y=mag'.*exp(j*phi'*(pi/180));
    end
   end
  end
 end
 np0=length(find(abs(p)<10^(-8)));
 if np0~=0
  if strcmp(s1,'auto')
   mm=max(mag); mm=10^(floor(log10(mm))); axis([-2,2,-1.5,1.5]*mm/2);
  end
 else
% starting point from the real axis
  gain0=polyval(num,0)/polyval(den,0);
  mag=[abs(gain0);mag];
  if gain0<0, phi=[180*sign(phi(1));phi]; else, phi=[0;phi]; end
  w1=[0,w1];
  y=[gain0,y];
 end
 if to==0, y=[y,gainf]; end
 ha=plot(real(y),imag(y),'Color',colp,'LineStyle',sty);
 HALEG=[HALEG,ha];
 if ih | strcmp(s1,'manual')
  axis(YY)
 end
 if ~ih
  hold on, YY=axis; mm=[YY(3),YY(4)]; pp=[YY(1),YY(2)];
  ha=plot(pp,ssn,ssn,mm);
  set(ha(1),'Color',colw,'LineStyle',':')
  set(ha(2),'Color',colw,'LineStyle',':')
  axis(YY)
  ang=pi*linspace(0,1,200); circ1=cos(ang)+j*sin(ang);
  plot(circ1,'Color',colw,'LineStyle','--'), axis(YY)
  ang=ang+pi; circ1=cos(ang)+j*sin(ang);
  plot(circ1,'Color',colw,'LineStyle','--'), axis(YY)
  title('diagramma di Nyquist')
  if YY==[-2.0001,2,-1.5,1.5], YY(1)=-2; axis(YY), eval('nygrid'), end
 end
end
if nargout==0
 if ~ih
  hold off
  if flg==3, clf, end
  disp(' ')
 end
 figure(gcf), return
end
out1=mag; out2=phi; out3=w1;
% --- last line of frespc ---
