function frespaux(typ)
%FRESPAUX Auxiliary file for graphic management related to fresp.
%    **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global pbs VV GG PP flg1 vectc HA1 HA2 vmag1 vphi1 vw11...
 vmag2 vphi2 vw12 vmag3 vphi3 vw13 vmag4 vphi4 vw14 vmag5 vphi5 vw15...
 vmag6 vphi6 vw16 vmag7 vphi7 vw17 HHAt indexit

[colop,colom,tp2]=coltbl('o'); err=0; xy=1;
if typ==1
 mess='Scegliere punti con il mouse (pulsante 1, pulsante 2 per uscire)';
 set(pbs(1),'ForegroundColor',colom,'Visible','on','String',mess)
 if flg1~=4
  title('')
 else
  subplot(2,1,1), title(''), subplot(2,1,2), title('')
 end
 bb=1; hh=0; kk1=0;
 while bb==1
  [x1s,y1s,bb]=ginput(1);
  if isempty(bb), bb=2; end
  if bb==1
   x=x1s; y=y1s;
   if flg1~=4
    if x<VV(1), x=VV(1)*(1+10^(-8)); end
    if x>VV(2), x=VV(2); end
    if hh~=0, eval('delete(ha)','err=1;'), end
    hold on
    ha=semilogx([x x],[VV(3) VV(4)],'Color',colop,'LineStyle','-',...
    'LineWidth',2);
   else
    subplot(2,1,1), VV1=axis; hold on
    if x<VV1(1), x=VV1(1)+10^(-8); end
    if x>VV1(2), x=VV1(2); end
    if hh~=0, eval('delete(ha1)','err=1;'), end
    ha1=semilogx([x x],[VV1(3) VV1(4)],'Color',colop,'LineStyle','-',...
    'LineWidth',2);
    subplot(2,1,2), VV2=axis; hold on
    if hh~=0, eval('delete(ha2)','err=1;'), end
    ha2=semilogx([x x],[PP(3) PP(4)],'Color',colop,'LineStyle','-',...
    'LineWidth',2);
   end
   for kk=1:length(vectc)
    kks=int2str(kk);
    eval(['mg=vmag',kks,';']), lw=length(mg);
    eval(['ph=vphi',kks,';'])
    eval(['omg=vw1',kks,';'])
    if (x>=omg(1))&(x<=omg(lw)*(1+10^(-8)))
     [zz,ii]=min(abs(x-omg)); magnit=mg(ii); phase=ph(ii); omega=omg(ii);
     if ii==lw, ii=lw-1; end
     dmag=mg(ii+1)-mg(ii);dphi=ph(ii+1)-ph(ii); domg=omg(ii+1)-omg(ii);
     magnit=magnit+(x-omega)*dmag/domg;
     magdb=20*log10(magnit);
     phase=phase+(x-omega)*dphi/domg;
    else
     magdb=NaN; phase=NaN;
    end
    cc=vectc(kk);
    % color correction table
    [tp1,tbl,tp2]=coltbl(cc);
    mess=sprintf('%.3g db',magdb);
    mess=[mess,sprintf([', %.3g ',setstr(176)],phase)];
    set(pbs(kk+1),'ForegroundColor',tbl,'Visible','on','String',mess)
   end % for kk
   kk=kk+1;
   mess=sprintf('%.3g rad/sec',x);
   set(pbs(kk+1),'ForegroundColor',colom,'Visible','on','String',mess)
   kk1=kk+1;
  else
   for rr=1:kk1
    set(pbs(rr),'Visible','off')
   end
   set(pbs(20),'Visible','on')
   if flg1~=4
    if hh~=0, eval('delete(ha)','err=1;'), end
    hold off
   else
    if hh~=0, eval('delete(ha1)','err=1;'), eval('delete(ha2)','err=1;'), end
    subplot(2,1,1), hold off, subplot(2,1,2), hold off
   end
   return
  end % if bb
  hh=1;
 end % while
 if flg1~=4
  hold off
 else
  subplot(2,1,1), hold off, subplot(2,1,2), hold off
 end
elseif typ==2
 title('')
 for kk=1:length(vectc)
  [tp1,tp2,tp3,mmm]=coltbl(vectc(kk)); mmm=deblank(mmm);
  set(pbs(10+kk),'Visible','on','String',mmm)
 end
 indexit=10+length(vectc)+1;
 set(pbs(indexit),'Visible','on','String','MENU')
 if length(vectc)>1
  mess='Scegliere un colore o MENU per uscire';
 else
  mess='Scegliere il colore o MENU per uscire';
 end
 set(pbs(1),'ForegroundColor',colom,'Visible','on','String',mess)
 figure(gcf)
end
if typ>=11
 SEL=typ-10; xy=0;
 if SEL==indexit-10
  for rr=1:18, set(pbs(rr),'Visible','off'), end
  set(pbs(20),'Visible','on'), hold off, return
 end
 if length(vectc)>1
  ii1=SEL;
 else
  ii1=1;
 end
 eval('delete(HA1(ii1))','err=1;'), eval('delete(HA2(ii1))','err=1;')
 cc=vectc(ii1);
 for kk=11:indexit
  set(pbs(kk),'Visible','off')
 end
 % color correction table
 [tp1,tbl,tp2,mmm]=coltbl(cc); mmm=deblank(mmm);
 messp1=['Scegliere un punto con il mouse (pulsante 1) sul grafico ',mmm,...
 ' (pulsante 2 per uscire)'];
 messp2='Premere il pulsante 1 per cancellare i dati';
 set(pbs(1),'ForegroundColor',tbl,'Visible','on','String',messp1)
 mess='Anello aperto:';
 set(pbs(2),'ForegroundColor',tbl,'Visible','off','String',mess)
 set(pbs(3),'Visible','off')
 set(pbs(4),'Visible','off')
 set(pbs(5),'Visible','off')
 mess='Anello chiuso:';
 set(pbs(6),'ForegroundColor',tbl,'Visible','off','String',mess)
 set(pbs(7),'Visible','off')
 set(pbs(8),'Visible','off')
 eval(['mg=vmag',int2str(ii1),';']), lw=length(mg);
 eval(['ph=vphi',int2str(ii1),';'])
 eval(['omg=vw1',int2str(ii1),';'])
 if flg1==5
  x1=ph; y1=20*log10(mg);
 else
  x1=mg.*cos(ph*pi/180); y1=mg.*sin(ph*pi/180);
 end
 bb1=1; hh1=0;
 while bb1==1
  if xy==4
   [x1s,y1s,bb1]=ginput(1);
   if isempty(bb1), bb1=2; end
  end
  xy=4;
  if bb1==1
   set(pbs(1),'ForegroundColor',tbl,'String',messp1)
   for kk=2:8
    set(pbs(kk),'Visible','off')
   end
   [x1s,y1s,bb1]=ginput(1);
   if isempty(bb1), bb1=2; end
  end
  if bb1==1
   set(pbs(1),'ForegroundColor',tbl,'String',messp2)
   set(pbs(2),'Visible','on')
   set(pbs(6),'Visible','on')
   xc=x1s; yc=y1s;
   if hh1~=0
    eval('delete(HA1(ii1))','err=1;'), eval('delete(HA2(ii1))','err=1;')
   end
   hold on
   mx=1; my=1; [zz,rr]=min(my*abs(x1-xc)+mx*abs(y1-yc));
   rr1=rr-1; rr2=rr+1;
   if rr==1, rr1=1; end
   if rr==lw, rr2=lw; end
   ww1=omg(rr1); ww2=omg(rr2);
   xx1=linspace(x1(rr1),x1(rr2),100); yy1=linspace(y1(rr1),y1(rr2),100);
   [zz,kh]=min(my*abs(xx1-xc)+mx*abs(yy1-yc));
   xeval=xx1(kh); yeval=yy1(kh); weval=ww1+(ww2-ww1)*kh/100;
   if kh==1, kh=2; end
   x=xx1(kh); y=yy1(kh); x0=xx1(kh-1); y0=yy1(kh-1);
   rx=(VV(2)-VV(1))/(2*25); ry=(VV(4)-VV(3))/(1.5*25);
   [HA1(ii1),HA2(ii1)]=arrowl(x0,y0,x,y,rx,ry,cc);
   HHAt=[HHAt,HA1(ii1),HA2(ii1)];
   if flg1==5
    mess=sprintf('ampiezza: %.3g db',yeval);
    mess1=sprintf('fase: %.3g gradi',xeval);
    yv=10^(yeval/20);
    z=yv*exp(j*xeval*pi/180);
   else
    mess=sprintf('x: %.3g',xeval);
    mess1=sprintf('y: %.3g',yeval);
    z=xeval+j*yeval;
   end
   set(pbs(3),'ForegroundColor',tbl,'Visible','on','String',mess)
   set(pbs(4),'ForegroundColor',tbl,'Visible','on','String',mess1)
   mess=sprintf('omega: %.3g rad/sec',weval);
   set(pbs(5),'ForegroundColor',tbl,'Visible','on','String',mess)
   z=z/(1+z); mcl=20*log10(abs(z)); ncl=angle(z)*180/pi;
   mess=sprintf('ampiezza: %.3g db',mcl);
   set(pbs(7),'ForegroundColor',tbl,'Visible','on','String',mess)
   mess=sprintf('fase: %.3g gradi',ncl);
   set(pbs(8),'ForegroundColor',tbl,'Visible','on','String',mess)
  end % if bb1==1
  hh1=1;
 end % while bb1
 for kk=2:8, set(pbs(kk),'Visible','off'), end
 if length(vectc)>1
  mess='Scegliere un colore o MENU per uscire';
 else
  mess='Scegliere il colore o MENU per uscire';
 end
 set(pbs(1),'ForegroundColor',colom,'Visible','on','String',mess)
 for kk=11:indexit, set(pbs(kk),'Visible','on'), end
end % if typ
% --- last line of frespaux ---
