function fresp(arg1,arg2,arg3,arg4)
%FRESP	  Risposta in frequenza - diagr. di Bode, Nichols, Nyquist (TFI).
%   FRESP,gi - da TFI [FRESP('gi') - da Matlab] fornisce grafici della
%   funzione di risposta in frequenza corrispondente alla f.d.t. gi.
%   Possibili opzioni:
%      1. Diagramma di Bode dell'ampiezza
%      2. Diagramma di Bode della fase
%      3. Diagrammi di Bode di ampiezza e fase in una sola figura
%      4. Diagrammi di Bode di ampiezza e fase in due figure distinte
%      5. Diagramma di Nichols
%      6. Diagramma di Nyquist
%   Se FRESP viene chiamato senza alcun argomento, la f.d.t. gi puo'
%   essere specificata in interattivo.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global ABIL TRF1 TRF2 TRF3 TRF4 TRF5 TRF5 TRF6 TRF7 gr flg1 fleg GG PP...
 pbs VV vectc HA1 HA2 vmag1 vphi1 vw11 vmag2 vphi2 vw12 vmag3 vphi3 vw13...
 vmag4 vphi4 vw14 vmag5 vphi5 vw15 vmag6 vphi6 vw16 vmag7 vphi7 vw17 HHAt...
 indexit HALEG FIGLEG LABLEG SUBPLEG

aA=setstr(224); eA=setstr(232); oA=setstr(242); EA=setstr(200);
nfig=gcf; nfigs=int2str(nfig); fluic=0; ddd=1; ddd1='0'; ddd2='1';
FIGLEG=nfig; HALEG=[]; LABLEG=[]; SUBPLEG=0;
HA1=zeros(1,7); HA2=zeros(1,7); HHAt=[]; FIGLO=resfiglo;
ms1=['\n **** errore: non si pu',oA,' cambiare figura durante l''esecuzione\n'];
if exist('legen#.mat'), load legen#, else, legen=0; islegen=0; end
if nargin>0
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1;
 end
end
framesc=get(0,'DefaultFigureColor');
clf, ordf(3), clc, set(gcf,'Color',framesc)
VFULL=get(gcf,'Position');
SC=diag([1/VFULL(3);1/VFULL(4);1/VFULL(3);1/VFULL(4)]);
if any(FIGLO(1,:))
 erx=0; eval('set(nfig,''Position'',FIGLO(1,1:4))','erx=1;')
end
set(0,'DefaultUIControlUnits','normalized')
[tp1,tp2,ccol,ccols]=coltbl;
colk=tp1(8,:);
colw=tp1(7,:);
colom=tp2(9,:);
colbg=colk;
men_opt=uimenu(nfig,'Label','Memo');
men_gr=uimenu(nfig,'Label','Reticolo on/off','Callback','gridmng(2)');
%
pbs=zeros(1,20);
BB=VFULL(4)-20;
Pos=[10 BB 450 15]*SC;
pbs(1)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'Visible','off');
%
llth=150;
AA=VFULL(3)-llth-4; BB=VFULL(4)-16;
%
for kk=2:10
 Pos=[AA BB-15*(kk-2) llth 15]*SC;
 pbs(kk)=uicontrol(gcf,...
 'Style','text',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'BackgroundColor',colbg,...
 'Visible','off');
end
%
BB=VFULL(4)-26; llth=60;
%
for kk=11:18
 Pos=[4 BB-20*(kk-10) llth 20]*SC;
 pbs(kk)=uicontrol(gcf,...
 'Style','push',...
 'Position',Pos,...
 'HorizontalAlignment','left',...
 'Visible','off',...
 'Callback',['frespaux(',int2str(kk),')']);
end
%
Pos=[10 5 400 15]*SC;
pbs(20)=uicontrol(gcf,...
'Style','text',...
'Position',Pos,...
'HorizontalAlignment','left',...
'BackgroundColor',colbg,...
'ForegroundColor',colom,...
'Visible','off',...
'String','PREMERE INVIO PER IL MENU');
%
j=sqrt(-1);
flg=0; flg1=0; izz=-1; gr=0; flzo=0; fleg=0; ab=0; flmn=0; ind=1; fladj=0;
if legen==1, fleg=1; end
vectc=[]; vstr=[]; vecttc=[];
iiq=0; iitf=0;
vectg=[]; gnum=[]; gn=0; vto=[];
fldiv1=0; fldiv2=0; flgd=0; flgdd=0; flgd1=0; PH=[];
while flg==0
 rp=(nargin==0)|((izz==2)&(flg1~=3)&(flg1~=4));
 rp1=(izz==1)&((flg1==3)|(flg1==4));
 if rp|rp1
  fl1=0; ind=1;
  while fl1==0
   gi=input('\n   specificare la funzione di trasferimento : ','s');
   if isempty(get(0,'children')), return, end
   if gcf~=nfig, fprintf(ms1), return, end
   if ~isempty(gi)
    if gi=='0', ordf(1), return, end
    if ~exist([gi,'.mat'])
     disp([' **** errore: ',gi,'.mat non esiste'])
    else
     fl1=1;
    end
   end
  end
 end
 [z,p,k,str,tc]=exportf(gi,2); if isempty(k), ordf(1), return, end
 if (str=='z')&(tc==0), tc=lsamp; end
 if (str=='z')&(length(z)>length(p))
  disp(' '), disp('   **** attenzione: sistema discreto anticipativo !!!')
  xyx=input('\n   uscire da fresp ? (1) : ');
  if xyx==1, ordf(1), return, end
 end
% clc
 to=0; iitf=iitf+1;
 eval(['vectz',int2str(iitf),'=z;'])
 eval(['vectp',int2str(iitf),'=p;'])
 eval(['vectk',int2str(iitf),'=k;'])
 vectg=[vectg,gi]; gnum=[gnum;length(gi)];
 vstr=[vstr;str]; vto=[vto;to]; vecttc=[vecttc;tc];
 while (flg1~=1)&(flg1~=2)&(flg1~=3)&(flg1~=4)&(flg1~=5)&(flg1~=6)
  disp(' ')
  disp('   1 - Diagramma di Bode dell''ampiezza')
  disp('   2 - Diagramma di Bode della fase')
  disp('   3 - Diagrammi di Bode di ampiezza e fase - una sola figura')
  disp('   4 - Diagrammi di Bode di ampiezza e fase - due figure')
  disp('   5 - Diagramma di Nichols')
  disp('   6 - Diagramma di Nyquist')
  flg1=input('\n   operare una scelta (0 per uscire) : ');
  if isempty(flg1), flg1=7; end
  if flg1==0, ordf(1), return, end
  if isempty(get(0,'children')), return, end
  if gcf~=nfig, fprintf(ms1), return, end
  if length(flg1)==0
   clc, flg1=0;
  end
 end
 if fluic==0
  if flg1==1
   mess='diagramma di Bode dell''ampiezza';
  elseif flg1==2
   mess='diagramma di Bode della fase';
  elseif flg1==3
   mess='diagrammi di Bode (una figura)';
  elseif flg1==4
   mess='diagrammi di Bode (due figure)';
   ddd=2.2;
  elseif flg1==5
   mess='diagramma di Nichols'; ddd1='1'; ddd2='0';
  elseif flg1==6
   mess='diagramma di Nyquist'; ddd1='1'; ddd2='0';
  end
  uimenu(men_opt,'Label',mess);
  if (flg1==1)|(flg1==2)
   men_zoom=uimenu(nfig,'Label','Zoom on/off','Callback','gridmng(9)');
  elseif flg1==4
   men_zoom=uimenu(nfig,'Label','Zoom on/off','Callback','gridmng(10)');
  elseif (flg1==5)|(flg1==6)
   men_zoom=uimenu(nfig,'Label','Zoom on/off','Callback','gridmng(11)');
  end
 end
 nflg=flg1; rpp=(flg1~=3)&(flg1~=4); rpp1=(flg1~=1)&(flg1~=2);
 if (flg1==5)|(flg1==6)
  nflg=flg1-1;
 end
 flg2=0;
 while flg2==0
  ins=[ccol(7),'=',deblank(ccols(7,:)),','];
 fprintf(['\n   scegliere il colore del grafico: ',ins,' g=verde,'])
 mest='\n   b=blu, r=rosso, y=giallo, m=magenta, c=celeste, default verde : ';
  c=input(mest,'s');
  if isempty(c), c='g'; end
  c=c(1);
  if strcmp(c,'0'), ordf(1), return, end
  if isempty(get(0,'children')), return, end
  if gcf~=nfig, fprintf(ms1), return, end
  if isempty(vectc)
   rop=0; for kk=1:7, rop=rop|(c==ccol(kk)); end
   if rop, flg2=1; end
  else
   rop=0;
   for kk=1:7
    rop=rop|((c==ccol(kk))&isempty(find(vectc==ccol(kk))));
   end
   if rop, flg2=1; end
  end
 end
 vectc=[vectc;c]; ind1=0;
 if islegen
  if gn==0
   if length(gnum)==1
    LABLEG=['''',vectg,''''];
   else
    LABLEG=[LABLEG,',''',...
    vectg(sum(gnum(1:length(gnum)-1))+1:sum(gnum)),''''];
   end
  end
 end
 mess=[gi,', colore ',c];
 eval(['TRF',int2str(iitf),'=[gi,c];'])
 if flg1==4, mmm='subplot(2,1,2),'; else, mmm=[]; end
 mmm=[mmm,'tfmaux(',int2str(iitf),',',ddd1,',',ddd2,')'];
 if fluic==0
  fluic=1;
  uimenu(men_opt,'Label',mess,'Separator','on','Callback',mmm);
 else
  uimenu(men_opt,'Label',mess,'Callback',mmm);
 end
 ABIL=ddd;
 if (fladj==1)&((flg1==1)|(flg1==2)|(flg1==3)|(flg1==4))
  if strcmp(str,'s')
   [mag,phi,w1]=eval('frespc(z,p,k,3.5,c,to)');
  else
   [mag,phi,w1]=eval('frespd(z,p,k,tc,3.5,c,to)');
  end
  MMin=20*log10(min(mag)); MMax=20*log10(max(mag));
  PMin=min(phi); PMax=max(phi);
  if (flg1==1)|(flg1==2)|(flg1==3)
   if (flg1==1)|(flg1==3), ymin=MMin; ymax=MMax; end
   if flg1==2, ymin=PMin; ymax=PMax; end
   VV=axis; xt=get(gca,'Xtick');  yt=get(gca,'Ytick'); dyt=yt(2)-yt(1);
   YYmin=min([yt(1),ymin]); YYmax=max([yt(length(yt)),ymax]);
   ntn=(YYmax-YYmin)/dyt; tol=(YYmax-YYmin)/400;
   while ntn>16, dyt=dyt*2; ntn=ntn/2; yt=yt(1); end
   while YYmin<yt(1)-tol, yt=[yt(1)-dyt,yt]; end
   while YYmax>yt(length(yt))+tol, yt=[yt,yt(length(yt))+dyt]; end
   VV(3)=yt(1); VV(4)=yt(length(yt));
   axis(VV); set(gca,'Ytick',yt)
   if flg1==3
    pho1=min([pho1,PMin]); pho2=max([pho2,PMax]);
    izz=4; flgd=0; flgd1=1;
    eval(['z=vectz',int2str(1),';'])
    eval(['p=vectp',int2str(1),';'])
    eval(['k=vectk',int2str(1),';'])
    str=vstr(1); c=vectc(1); to=vto(1); tc=vecttc(1); gn=1;
    eval(['w1=vw1',int2str(1),';']);
    iiq=0; HALEG=[]; ind2=1; ind1=0; hold off
   end
  elseif flg1==4
   subplot (2,1,1)
   GG=axis; yt=get(gca,'Ytick'); dyt=yt(2)-yt(1);
   ymin=MMin; ymax=MMax;
   YYmin=min([yt(1),ymin]); YYmax=max([yt(length(yt)),ymax]);
   ntn=(YYmax-YYmin)/dyt; tol=(YYmax-YYmin)/400;
   while ntn>8, dyt=dyt*2; ntn=ntn/2; yt=yt(1); end
   while YYmin<yt(1)-tol, yt=[yt(1)-dyt,yt]; end
   while YYmax>yt(length(yt))+tol, yt=[yt,yt(length(yt))+dyt]; end
   GG(3)=yt(1); GG(4)=yt(length(yt));
   axis(GG); set(gca,'Ytick',yt)
   subplot (2,1,2)
   PP=axis; yt=get(gca,'Ytick'); dyt=yt(2)-yt(1);
   ymin=PMin; ymax=PMax;
   YYmin=min([yt(1),ymin]); YYmax=max([yt(length(yt)),ymax]);
   ntn=(YYmax-YYmin)/dyt; tol=(YYmax-YYmin)/400;
   while ntn>8, dyt=dyt*2; ntn=ntn/2; yt=yt(1); end
   while YYmin<yt(1)-tol, yt=[yt(1)-dyt,yt]; end
   while YYmax>yt(length(yt))+tol, yt=[yt,yt(length(yt))+dyt]; end
   PP(3)=yt(1); PP(4)=yt(length(yt));
   axis(PP); set(gca,'Ytick',yt)
  end
  fladj=0;
 end
 while ind1==0
  if rpp
   if strcmp(str,'s')
    [mag,phi,w1]=eval('frespc(z,p,k,nflg,c,to)');
   else
    [mag,phi,w1]=eval('frespd(z,p,k,tc,nflg,c,to)');
   end
   VV=axis;
   if flgd==1
    stepy=(VV(4)-VV(3))/ndiv(2);
    ytick=VV(3):stepy:VV(4); set(gca,'ytick',ytick)
   end
   if flgdd==1
    stepx=(VV(2)-VV(1))/ndiv(1);
    xtick=VV(1):stepx:VV(2); set(gca,'xtick',xtick)
   end
  else
   rop=(izz==1)&strcmp(str,'s');
   rop1=((izz==4)|(izz==9))&strcmp(str,'s');
   rop2=(izz==1)&strcmp(str,'z');
   rop3=((izz==4)|(izz==9))&strcmp(str,'z');
   if flg1==3
    if rop|rop1|rop2|rop3
     VV=axis;
     if flgd==1
      semilogx(w1(1),-20,'Color',colk,'LineStyle','none','Marker','.')
      axis(VV)
      stepy=(VV(4)-VV(3))/ndiv(2);
      ytick=VV(3):stepy:VV(4); set(gca,'ytick',ytick)
      hold on
     end
     if rop
      [pho1,pho2,mag,phi,w1]=eval('bodec(z,p,k,VV(1),VV(2),c,pho1,pho2,to)');
     elseif (rop1 & flgd1==1)
      [pho1,pho2,mag,phi,w1]=eval('bodec(z,p,k,VV(1),VV(2),c,pho2,pho1,to)');
     elseif (rop1 & flgd1==0)
      [pho1,pho2,mag,phi,w1]=eval('bodec(z,p,k,VV(1),VV(2),c,to)');
     elseif rop2
      [pho1,pho2,mag,phi,w1]=eval('boded(z,p,k,tc,VV(1),c,pho1,pho2,to)');
     elseif (rop3 & flgd1==1)
      [pho1,pho2,mag,phi,w1]=eval('boded(z,p,k,tc,VV(1),c,pho2,pho1,to)');
     elseif (rop3 & flgd1==0)
      [pho1,pho2,mag,phi,w1]=eval('boded(z,p,k,tc,VV(1),c,to)');
     end
    else
     if strcmp(str,'s')
      [pho1,pho2,mag,phi,w1]=eval('bodec(z,p,k,c,to)');
     else
      [pho1,pho2,mag,phi,w1]=eval('boded(z,p,k,tc,c,to)');
     end
    end
   else    %flg1==4
    if fleg==1, eval('legend off'), end
    [colp,tp1,tp2]=coltbl(c);
    subplot(2,1,1)
    if izz==1, hold on, end
    if rop|rop1|rop2|rop3
     if rop|rop1
      [mag,phi,w1]=eval('frespc(z,p,k,3.5,GG(1),GG(2),c,to)');
     elseif rop2|rop3
      [mag,phi,w1]=eval('frespd(z,p,k,tc,3.5,GG(1),c,to)');
     end
     mag1=20*log10(mag);
     ha=semilogx(w1,mag1,'Color',colp,'LineStyle','-');
     HALEG=[HALEG,ha]; axis(GG), hold off
    else
     if strcmp(str,'s')
      [mag,phi,w1]=eval('frespc(z,p,k,3.5,c,to)');
     else
      [mag,phi,w1]=eval('frespd(z,p,k,tc,3.5,c,to)');
     end
     mag1=20*log10(mag);
     ha=semilogx(w1,mag1,w1(1),-20,w1(1),20);
     set(ha(1),'Color',colp,'LineStyle','-')
     set(ha(2),'Color',colk,'LineStyle','none','Marker','.')
     set(ha(3),'Color',colk,'LineStyle','none','Marker','.')
     HALEG=[HALEG,ha(1)];
     VVV=axis; VVV(2)=10^ceil(log10(w1(length(w1))-10^(-8))); axis(VVV)
    end
    if ~(rop|rop1|rop2|rop3)|(izz==4)|(izz==9)
     hold on, GG=axis; rr=[GG(1),GG(2)]; ssn=[0 0];
     semilogx(rr,ssn,'Color',colw,'LineStyle','--'), axis(GG)
     title('ampiezza')
     aat=setstr(32*ones(1,120)); aam=sprintf('rad/sec');
     mess=[aat(1:120-length(aam)),aam]; xlabel(mess)
     aat=setstr(32*ones(1,35)); aam=sprintf('db');
     mess1=[aat(1:35-length(aam)),aam]; ylabel(mess1)
     hold off
    end
    if flgd==1
     stepy=(GG(4)-GG(3))/ndiv;
     ytick=GG(3):stepy:GG(4); set(gca,'ytick',ytick)
    end
    if fleg==1, eval(['legend(HALEG,',LABLEG,')']), end
    subplot(2,1,2)
    if izz==1, hold on, end
    if rop|rop1|rop2|rop3
     semilogx(w1,phi,'Color',colp,'LineStyle','-'), axis(PP), hold off
    else
     mm=30*floor(min(phi)/30-10^(-6)); MM=30*ceil(max(phi)/30+10^(-6));
     ha=semilogx(w1,phi,w1(1),mm,w1(1),MM);
     set(ha(1),'Color',colp,'LineStyle','-')
     set(ha(2),'Color',colk,'LineStyle','none','Marker','.')
     set(ha(3),'Color',colk,'LineStyle','none','Marker','.')
     VVV=axis; VVV(2)=10^ceil(log10(w1(length(w1))-10^(-8))); axis(VVV)
    end
    if ~(rop|rop1|rop2|rop3)|(izz==4)|(izz==9)
     hold on, PP=axis;
     rr=[PP(1),PP(2)]; ss2=[-180 -180];
     semilogx(rr,ss2,'Color',colw,'LineStyle','--'), axis(PP), title('fase')
     xlabel(mess)
     aat=setstr(32*ones(1,35)); aam=sprintf('gradi');
     mess1=[aat(1:35-length(aam)),aam]; ylabel(mess1)
     hold off
    end
    if flgd1==1
     stepy=(PP(4)-PP(3))/ndiv1;
     ytick=PP(3):stepy:PP(4); set(gca,'ytick',ytick)
    end
   end
  end
  iiq=iiq+1;
  eval(['vmag',int2str(iiq),'=mag;'])
  eval(['vphi',int2str(iiq),'=phi;'])
  eval(['vw1',int2str(iiq),'=w1;'])
  if izz<0
   hold off
  end
  rop=((izz==5)|(izz==10)|(izz==6))&(ind<length(vectc))&rpp;
  rop1=(izz==2)&(ind>1)&(ind<length(vectc))&rpp;
  rop2=((izz==4)|(izz==9))&(ind<length(vectc))&((flg1==3)|(flg1==4));
  rop3=(izz==1)&(ind>1)&(ind<length(vectc))&((flg1==3)|(flg1==4));
  if rop|rop1|rop2|rop3
   ind=ind+1; ind2=1;
   if rpp
    izz=2;
   else
    izz=1;
   end
   eval(['z=vectz',int2str(ind),';'])
   eval(['p=vectp',int2str(ind),';'])
   eval(['k=vectk',int2str(ind),';'])
   str=vstr(ind); c=vectc(ind); to=vto(ind); tc=vecttc(ind);
   hold on
  else
   if islegen
    if fleg==1
     if (flg1~=4)
      eval(['legend(HALEG,',LABLEG,')'])
     else
      subplot(2,1,1), eval(['legend(HALEG,',LABLEG,')']), SUBPLEG=1;
     end
    end
   end
   if gr==1
    if flg1==4
     if fleg==1, eval('legend off'), end
     subplot(2,1,1), axis(GG), grid on, hold off
     if fleg==1, eval(['legend(HALEG,',LABLEG,')']), end
     subplot(2,1,2), axis(PP), grid on, hold off
    else
     grid on
    end
   end
   if izz>0
    hold off
   end
   gn=0; ind2=0; ind=1;
   figure(nfig)
   xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
  end
  while ind2==0
   clc, disp(' ')
   disp('   MENU :')
   disp(' ')
   disp('   1 - cambiare gli assi di riferimento')
   if gr==0
    disp('   2 - inserire reticolo')
   else
    disp('   2 - eliminare il reticolo')
   end
   disp('   3 - informazioni sulla risposta in frequenza')
   disp('   4 - aggiungere un grafico in colore diverso')
   disp('   5 - rivedere la figura')
   if rpp  %  menu flg1~=3 & flg1~=4
    disp('   6 - informazioni sui grafici con il mouse')
    if (flg1==1)|(flg1==2)
     disp('   7 - approssimazione asintotica (solo tempo continuo)')
     disp('   8 - introdurre un ritardo finito')
     menupointer=[5,3,7,2,4,1,6,10];
    elseif flg1==6
     if flzo~=3
      disp('   7 - ingrandire per passi')
     else
      if flmn==0
       disp('   7 - eliminare luoghi a M e N costanti')
      else
       disp('   7 - inserire luoghi a M e N costanti')
      end
     end
     disp('   8 - inserire graduazione in omega')
     disp('   9 - introdurre un ritardo finito')
     menupointer=[5,3,7,2,4,1,6,8,10];
    elseif flg1==5
     if flmn==0
      disp('   7 - inserire luoghi a M e N costanti')
     else
      disp('   7 - eliminare luoghi a M e N costanti')
     end
     disp('   8 - inserire graduazione in omega')
     disp('   9 - introdurre un ritardo finito')
     menupointer=[5,3,7,2,4,1,6,8,10];
    end
   else  % menu flg1==3 | flg1==4
    disp('   6 - informazioni sui grafici con il mouse')
    disp('   7 - approssimazione asintotica (solo tempo continuo)')
    disp('   8 - introdurre un ritardo finito')
    menupointer=[4,2,6,1,3,11,5,9];
   end
   if (flg1==1)|(flg1==2)
    zoom off, zoom out, axis(VV)
   elseif flg1==4
    zoom off
    subplot(2,1,1), zoom out, axis(GG), subplot(2,1,2), zoom out, axis(PP)
   elseif (flg1==5)|(flg1==6)
    zoom off, zoom out
   end
   izz=input('\n   operare una scelta (premere invio per uscire) : ');
   if isempty(get(0,'children')), return, end
   if gcf~=nfig, fprintf(ms1), return, end
   if isempty(izz)
    cc=get(0,'Children');
    if any(cc==nfig)
     FIGLO(1,1:4)=get(nfig,'Position');
     save figlo# FIGLO -v4
    else
     disp(' '), disp(['   LA FIGURA ',EA,' STATA CANCELLATA!'])
    end
    set(0,'DefaultUIControlUnits','pixel')
    eval('delete(men_gr)','err=1;'), eval('delete(men_zoom)','err=1;')
    ordf(1), return
   end
   izz=floor(izz); if izz==1, clc, end
   lpointer=length(menupointer);
   if (izz>=1) & (izz<=lpointer)
    izz=menupointer(izz);
   else
    izz=20;
   end
   if ((izz==1)&rpp)|(izz==11)
    VV=axis; ab=1;
    xyx=input('\n   **** premere invio per abilitare la selezione ','s');
    if (flg1==5)|(flg1==6)
     BB=VFULL(4)-20; Pos=[10 BB 500 15]*SC; set(pbs(1),'Position',Pos)
    end
    set(gcf,'Color',colbg)
    set(men_opt,'Enable','off')
    set(men_gr,'Enable','off')
    if flg1~=3, set(men_zoom,'Enable','off'), end
    if (flg1>=1)&(flg1<=4)
     namef='frespaux(1)';
    else
     namef='frespaux(2)';
    end
    eval(namef)
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
    for rr=1:18, set(pbs(rr),'Visible','off'), end
    if ~isempty(HHAt)
     flgin=0;
     flgin=input('\n   conservare le frecce ? (1) : ');
     if isempty(flgin), flgin=0; end
     if flgin~=1
      for kk=1:length(HHAt)
       eval('delete(HHAt(kk))','err=1;')
      end
      HHAt=[];
     end
    end
    eval('set(men_opt,''Enable'',''on'')','err=1;')
    eval('set(men_gr,''Enable'',''on'')','err=1;')
    if flg1~=3, eval('set(men_zoom,''Enable'',''on'')','err=1;'), end
    if flg1==1
     title('diagramma di Bode dell''ampiezza')
    elseif flg1==2
     title('diagramma di Bode della fase')
    elseif flg1==3
     title('diagrammi di Bode di ampiezza (-) e fase (-.)')
    elseif flg1==4
     subplot(2,1,1), title('ampiezza'), subplot(2,1,2), title('fase')
    elseif flg1==5
     title('diagramma di Nichols')
    elseif flg1==6
     title('diagramma di Nyquist')
    end
    eval('set(pbs(20),''Visible'',''off'')','err=1;')
    eval('set(gcf,''Color'',framesc)','err=1;')
%   if fleg==1, eval(['legend(HALEG,',LABLEG,')']), end
   elseif ((izz==2)&rpp)|((izz==1)&((flg1==3)|(flg1==4)))
    fladj=1;
    if length(vectc)<7
     if flg1~=4
      hold on
     end
     ind1=1; ind2=1; flgd=0; flgdd=0; flgd1=0;
    else
     fprintf(['\n   il numero massimo di grafici ',eA,' sette']), pause
    end
   elseif ((izz==3)&rpp)|((izz==2)&(flg1==3))
    if gr==0
     gr=1; grid on
    else
     gr=0; grid off
    end
    figure(nfig)
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   elseif (izz==2)&(flg1==4)
    if fleg==1, eval('legend off'), end
    subplot(2,1,1)
    if fleg==1, eval(['legend(HALEG,',LABLEG,')']), end
    if gr==0, grid on, else, grid off, end
    hold off
    subplot(2,1,2)
    if gr==0
     gr=1; grid on
    else
     gr=0; grid off
    end
    hold off, figure(nfig)
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   elseif ((izz==4)&rpp)|((izz==3)&((flg1==3)|(flg1==4)))
    if (fleg==1)&(ab==1), eval(['legend(HALEG,',LABLEG,')']), ab=0; end
    figure(nfig)
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   elseif ((izz==5)&rpp)|((izz==4)&((flg1==3)|(flg1==4)))
    if fleg==1, eval('legend off'), end
    rop=0; VV=axis;
    if flg1==4
     subplot(2,1,1)
     ytick=get(gca,'ytick'); VV1=axis;
     ndiv=round((VV1(4)-VV1(3))/(ytick(2)-ytick(1)));
     subplot(2,1,2)
     ytick=get(gca,'ytick'); VV1=axis;
     ndiv1=round((VV1(4)-VV1(3))/(ytick(2)-ytick(1)));
     VV(1)=GG(1); VV(2)=GG(2);
    else
     VV1=axis; xtick=get(gca,'xtick'); ytick=get(gca,'ytick');
     divx=xtick(2)-xtick(1); divy=ytick(2)-ytick(1);
     ndiv=round([(VV1(2)-VV1(1))/divx,(VV1(4)-VV1(3))/divy]);
    end
    if (flg1==1)|(flg1==2)|(flg1==3)|(flg1==4)
     fprintf(['\n   il campo di frequenza ',eA,' [%.4g %.4g];'],VV(1),VV(2))
     while ~rop
      indin=0; while indin==0
   TA1=input('\n   premere invio o specificare nuovi valori: [om1 om2] = ');
      ll1=length(TA1); if (ll1==0)|(ll1==2), indin=1; end, end, TA1=sort(TA1);
      if ll1~=0
       rop=(TA1(1)>0)&(TA1(2)>0);
       if ~rop
	fprintf('\n **** errore: scala logaritmica con valori negativi')
       end
      else
       rop=1;
      end
     end
     if flg1~=2 & flg1~=4
      fprintf(['\n   il campo di ampiezza ',eA,' [%.4g %.4g];'],VV(3),VV(4))
     elseif flg1==2
      fprintf(['\n   il campo di fase ',eA,' [%.4g %.4g];'],VV(3),VV(4))
     elseif flg1==4
      fprintf(['\n   il campo di ampiezza ',eA,' [%.4g %.4g];'],GG(3),GG(4))
     end
     indin=0; while indin==0
     TA2=input('\n   premere invio o introdurre nuovi valori: [ym yM] = ');
     ll2=length(TA2); if (ll2==0)|(ll2==2), indin=1; end, end, TA2=sort(TA2);
     if flg1==4
      fprintf('   numero di divisioni dell''asse dell''ampiezze: %.4g;',ndiv)
     else
      fprintf('   numero di divisioni dell''asse y: %.4g;',ndiv(2))
     end
     if ll2~=0
      fprintf('\n   premere invio per la messa in scala automatica')
     else
      fprintf('\n   premere invio per conservare la scala precedente')
     end
     indin=0; while indin==0
     ndivt=input('\n   o specificare un nuovo valore: ndy = ');
     if (length(ndivt)==0)|(length(ndivt)==1), indin=1; end, end
     if length(ndivt)~=0
      if flg1==4
       ndiv=round(abs(ndivt));
      else
       ndiv=round([ndiv(1) abs(ndivt)]);
      end
      flgd=1;
     else
      if ll2==0
       flgd=1;
      else
       flgd=0;
      end
     end
    else
     fprintf(['\n   l''intervallo dell''asse x ',eA,...
     ' [%.4g %.4g];'],VV(1),VV(2))
     indin=0; while indin==0
     TA1=input('\n   premere invio o specificare nuovi valori: [xm xM] = ');
     ll1=length(TA1); if (ll1==0)|(ll1==2), indin=1; end, end, TA1=sort(TA1);
     fprintf('   numero di divisioni dell''asse x: %.4g;',ndiv(1))
     if ll1~=0
      fprintf('\n   premere invio per la messa in scala automatica')
     else
      fprintf('\n   premere invio per conservare la scala precedente')
     end
     indin=0; while indin==0
     ndivt1=input('\n   o introdurre un nuovo valore: ndx = ');
     if (length(ndivt1)==0)|(length(ndivt1)==1), indin=1; end, end
     fprintf(['\n   l''intervallo dell''asse y ',eA,...
     ' [%.4g %.4g];'],VV(3),VV(4))
     indin=0; while indin==0
     TA2=input('\n   premere invio o specificare nuovi valori: [ym yM] = ');
     ll2=length(TA2); if (ll2==0)|(ll2==2), indin=1; end, end, TA2=sort(TA2);
     fprintf('   numero di divisioni dell''asse y: %.4g;',ndiv(2))
     if ll2~=0
      fprintf('\n   premere invio per la messa in scala automatica')
     else
      fprintf('\n   premere invio per conservare la scala precedente')
     end
     indin=0; while indin==0
     ndivt2=input('\n   o specificare un nuovo valore: ndy = ');
     if (length(ndivt2)==0)|(length(ndivt2)==1), indin=1; end, end
     %
     if (length(TA1)~=0), fldiv1=0; end
     rp1=(length(ndivt1)~=0)|((fldiv1==1)&(length(TA1)==0));
     if rp1, flgdd=1; fldiv1=1; else, flgdd=0; end
     if (length(TA2)~=0), fldiv2=0; end
     rp2=(length(ndivt2)~=0)|((fldiv2==1)&(length(TA2)==0));
     if rp2, flgd=1; fldiv2=1; else, flgd=0; end
     if length(ndivt1)~=0, ndiv(1)=round(abs(ndivt1)); end
     if length(ndivt2)~=0, ndiv(2)=round(abs(ndivt2)); end
     flmn=0;
    end
    if (ll1==0)&(flg1==4), TA1=[GG(1),GG(2)]; end
    if (ll1==0)&(flg1~=4), TA1=[VV(1),VV(2)]; end
    if (ll2==0)&(flg1==4), TA2=[GG(3),GG(4)]; end
    if (ll2==0)&(flg1~=4), TA2=[VV(3),VV(4)]; end
    if flg1==4, GG=[TA1,TA2]; else, VV=[TA1,TA2]; end
    if flg1==3
     minph=pho1; maxph=pho2;
     fprintf(['\n   il campo di fase scelto ',eA,' [%.4g %.4g];'],minph,maxph)
     if length(PH)~=0
      fprintf(' (richiesto [%.4g %.4g]);',PH(1),PH(2))
      fprintf('\n   premere invio per confermare il campo richiesto')
     else
      fprintf('\n   premere invio per confermare la scala precedente')
     end
     indin=0; while indin==0
     TP=input('\n   o specificare nuovi valori: [phm phM] = ');
     llp=length(TP); if (llp==0)|(llp==2), indin=1; end, end, TP=sort(TP);
     if llp~=0
      PH=TP;
     end
     if length(PH)~=0
      pho1=PH(1); pho2=PH(2); flgd1=1;
     else
      if flgd==1, flgd1=1; end
     end
    elseif flg1==4
     fprintf(['\n   il campo di fase ',eA,' [%.4g %.4g];'],PP(3),PP(4))
     indin=0; while indin==0
     TA=input('\n   premere invio o specificare nuovi valori: [ym yM] = ');
     lla=length(TA); if (lla==0)|(lla==2), indin=1; end, end, TA=sort(TA);
     if lla~=0, PP(3)=TA(1); PP(4)=TA(2); end
     PP(1)=GG(1);PP(2)=GG(2);
     fprintf('   numero di divisioni dell''asse della fase: %.4g;',ndiv1)
     if lla~=0
      fprintf('\n   premere invio per la messa in scala automatica')
     else
      fprintf('\n   premere invio per confermare la scala precedente')
     end
     indin=0; while indin==0
     ndivt=input('\n   o specificare un nuovo valore: ndy = ');
     if (length(ndivt)==0)|(length(ndivt)==1), indin=1; end, end
     if length(ndivt)~=0
      ndiv1=round(abs(ndivt)); flgd1=1;
     else
      if lla==0
       flgd1=1;
      else
       flgd1=0;
      end
     end
    end
    eval(['z=vectz',int2str(1),';'])
    eval(['p=vectp',int2str(1),';'])
    eval(['k=vectk',int2str(1),';'])
    str=vstr(1); c=vectc(1); to=vto(1); tc=vecttc(1); gn=1;
    if flg1~=4
     eval(['w1=vw1',int2str(1),';'])
     axis(VV);
    end
    iiq=0; HALEG=[];
    ind2=1;
    if isempty(get(0,'children')), return, end
    if gcf~=nfig, fprintf(ms1), return, end
   elseif ((izz==6)&((flg1==1)|(flg1==2)))|((izz==5)&((flg1==3)|(flg1==4)))
    if length(vectc)>1
     xx=0;
     while xx==0
      col=input('\n   scegliere la funzione specificandone il colore : ','s');
      if isempty(col), col='z'; end
      if col=='0', ordf(1), return, end
      if isempty(get(0,'children')), return, end
      if gcf~=nfig, fprintf(ms1), return, end
      ropc=0; for kk=1:7, ropc=ropc|strcmp(col,ccol(kk)); end
      if ropc
       if length(find(vectc==col))>0
	xx=1;
       end
      end
     end
    else
     col=c;
    end
    q=find(vectc==col);
    if vstr(q)=='z'
     fprintf('\n **** errore: sistema a tempo discreto !\n')
     pause
    elseif vto(q)~=0
     fprintf('\n **** errore: la f.d.t. include un ritardo finito !')
     fprintf('\n'), pause
    else
     eval(['zc=vectz',int2str(q),';'])
     eval(['pc=vectp',int2str(q),';'])
     eval(['kc=vectk',int2str(q),';'])
     tc=vecttc(q);
     [colp,tp1,tp2]=coltbl(col);
     if flg1==1
      hold on, VV=axis;
      [om,yg]=asymga(zc,pc,kc,VV(1),VV(2));
      yg=20*log10(yg);
      semilogx(om,yg,'Color',colp,'LineStyle','--')
      for kk=2:(length(om)-1)
       semilogx([om(kk),om(kk)],[VV(3),yg(kk)],'Color',colp,'LineStyle','--')
      end
      hold off
     elseif flg1==2
      hold on, VV=axis;
      [om,yy]=asymph(zc,pc,kc,VV(1),VV(2));
      semilogx(om,yy,'Color',colp,'LineStyle','--')
      for kk=2:(length(om)-1)
       semilogx([om(kk),om(kk)],[VV(3),yy(kk)],'Color',colp,'LineStyle','--')
      end
      hold off
     elseif flg1==3
      hold on, VV=axis;
      [om,yg]=asymga(zc,pc,kc,VV(1),VV(2));
      yg=20*log10(yg);
      semilogx(om,yg,'Color',colp,'LineStyle','--')
      for kk=2:(length(om)-1)
       semilogx([om(kk),om(kk)],[VV(3),yg(kk)],'Color',colp,'LineStyle','--')
      end
      [om,yp]=asymph(zc,pc,kc,VV(1),VV(2)); lwa=length(om);
      scale=VV(4)-VV(3); scaleph=pho2-pho1;
      fr=(yp-pho1)*(scale/scaleph)+VV(3);
      semilogx(om,fr,'Color',colp,'LineStyle','--')
      for kk=2:(lwa-1)
       semilogx([om(kk),om(kk)],[VV(3),fr(kk)],'Color',colp,'LineStyle','--')
      end
      hold off
     elseif flg1==4
      if fleg==1, eval('legend off'), end
      subplot(2,1,1), axis(GG), hold on
      [om,yy]=asymga(zc,pc,kc,GG(1),GG(2)); yy=20*log10(yy);
      semilogx(om,yy,'Color',colp,'LineStyle','--')
      for kk=2:(length(om)-1)
       semilogx([om(kk),om(kk)],[GG(3),yy(kk)],'Color',colp,'LineStyle','--')
      end
      hold off
      if fleg==1, eval(['legend(HALEG,',LABLEG,')']), end
      subplot(2,1,2), axis(PP), hold on
      [om,yy]=asymph(zc,pc,kc,PP(1),PP(2));
      semilogx(om,yy,'Color',colp,'LineStyle','--')
      for kk=2:(length(om)-1)
       semilogx([om(kk),om(kk)],[PP(3),yy(kk)],'Color',colp,'LineStyle','--')
      end
      hold off
     end
    end
    figure(nfig)
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   elseif (izz==6)&((flg1==5)|(flg1==6))
    hold off
    if flg1==5
     if flmn==0
      axis([-360.01,0,-40,40]), flmn=1;
     else
      axis([-360,0,-40,40]), flmn=0;
     end
     flgdd=0; flgd=0;
    elseif flg1==6
     if flzo==0
      QQ=[-40,40,-30,30]; flzo=1; QQ1=axis;
      if abs(max(QQ1))<20, QQ=QQ/5; flzo=2; end
     elseif (flzo==1)|(flzo==2)
      QQ=QQ/(6-flzo); flzo=flzo+1;
     end
     if flzo==3
      if flmn==0
       QQ=[-2,2,-1.5,1.5]; flmn=1;
      else
       QQ=[-2.0001,2,-1.5,1.5]; flmn=0;
      end
     end
     axis(QQ), flgdd=0; flgd=0; VV=QQ;
    end
    eval(['z=vectz',int2str(1),';'])
    eval(['p=vectp',int2str(1),';'])
    eval(['k=vectk',int2str(1),';'])
    str=vstr(1); c=vectc(1); to=vto(1); tc=vecttc(1); gn=1;
    iiq=0; HALEG=[];
    ind2=1;
   elseif ((izz==7)&rpp)|((izz==6)&((flg1==3)|(flg1==4)|(flg1==5)))
    clc
    if length(vectc)>1
     xx=0;
     while xx==0
      col=input('\n   scegliere la funzione specificandone il colore : ','s');
      if isempty(col), col='z'; end
      if col=='0', ordf(1), return, end
      if isempty(get(0,'children')), return, end
      if gcf~=nfig, fprintf(ms1), return, end
      ropc=0; for kk=1:7, ropc=ropc|strcmp(col,ccol(kk)); end
      if ropc
       if length(find(vectc==col))>0
	xx=1;
       end
      end
     end
    else
     col=c;
    end
    q=find(vectc==col);
    eval(['mg=vmag',int2str(q),';'])
    eval(['ph=vphi',int2str(q),';'])
    eval(['omg=vw1',int2str(q),';'])
    lw=length(omg);
    eval(['zc=vectz',int2str(q),';'])
    eval(['pc=vectp',int2str(q),';'])
    eval(['kc=vectk',int2str(q),';'])
    str=vstr(q); to=vto(q); tc=vecttc(q);
    if (str=='z')&(to~=0), pc=[pc;zeros(to,1)]; end
    [numc,denc]=dezpk(zc,pc,kc);
    disp(' ')
    disp('   RISPOSTA IN FREQUENZA AD ANELLO APERTO :')
    [gm,pm,wg,wp]=gpcross(mg,ph,omg,1,-180);
    if ~isnan(gm), gm=1/gm; end
    pm=pm+180;
    if isnan(gm)
     disp('   margine di ampiezza non determinabile')
    elseif abs(gm) < 10^(30)
     fprintf('   margine di ampiezza:  %.4g',gm)
     fprintf(' (%.4g db)',20*log10(gm))
     fprintf(' per omega= %.4g rad/sec\n',wg)
    else
     fprintf('   margine di ampiezza: non determinabile\n')
    end
    if isnan(pm)
     disp('   margine di fase non determinabile')
    elseif abs(pm) < 10^(30)
     fprintf('   margine di fase: %.4g gradi',pm)
     fprintf(' per omega= %.4g rad/sec\n',wp)
    else
     fprintf('   margine di fase: non determinabile\n')
    end
    if str=='s'
     ii=find(abs(pc)==0);
    else
     ii=find(abs(pc-1)==0);
    end
    if length(ii)==1
     if str=='s'
      num1=numc; den1=denc;
     else
      [z1,p1,k1]=diwplane(zc,pc,kc,tc); [num1,den1]=dezpk(z1,p1,k1);
     end
     num1=[0,num1]; den1=[0,den1]; ln=length(num1); ld=length(den1);
     axx=(num1(ln-1)*den1(ld-1)-num1(ln)*den1(ld-2))/den1(ld-1)^2;
     if (str=='s')&(to~=0)
      pr=pc(find(abs(pc)~=0)); [numr,denr]=dezpk(zc,pr,kc);
      gaino=polyval(numr,0)/polyval(denr,0); axx=axx-gaino*to;
     end
     fprintf('   ascissa dell''asintoto verticale del ')
     fprintf('diagramma polare: %.4g\n',axx)
    end
    disp(' ')
    disp('   RISPOSTA IN FREQUENZA AD ANELLO CHIUSO :')
    num0=numc; den0=sumpol(numc,denc);
    if str=='s'
     gain0=polyval(num0,0)/polyval(den0,0);
    else
     gain0=polyval(num0,1)/polyval(den0,1);
    end
    zz=mg.*exp(j*ph/180*pi); zz=abs(zz./(1+zz)); [mzz,ii]=max(zz);
    omgp=omg(ii); lw=length(omg);
    if ii>=6 & ii<=lw-5
     omg1=linspace(omg(ii-5),omg(ii+5),lw);
     zz1=spline(omg(ii-5:ii+5),zz(ii-5:ii+5),omg1);
     [mzz,ii]=max(zz1); omgp=omg1(ii);
    else
     zz1=zz; omg1=omg;
    end
    if (ii~=lw)&(ii~=1)
     domg=omg1(ii+1)-omg1(ii-1); dzz=zz1(ii+1)-zz1(ii-1); mzz=mzz+abs(dzz/4);
     if zz1(ii+1)>zz1(ii-1)
      omgp=omgp+(1-(zz1(ii)-zz1(ii+1))/(zz1(ii)-zz1(ii-1)))*domg/4;
     else
      omgp=omgp-(1-(zz1(ii)-zz1(ii-1))/(zz1(ii)-zz1(ii+1)))*domg/4;
     end
     mzz1=mzz/gain0; mzzdb=20*log10(mzz); mzz1db=20*log10(mzz1);
     fprintf('   risonanza assoluta: %.4g',mzz)
     fprintf(' (%.4g db)',mzzdb)
     fprintf(' per omega= %.4g rad/sec\n',omgp)
     fprintf('   guadagno statico: %.4g',gain0)
     fprintf(' (%.4g db);',20*log10(gain0))
     fprintf(' risonanza relativa: %.4g',mzz1)
     fprintf(' (%.4g db)\n',mzz1db)
    else
     fprintf('   risonanza ad anello chiuso non determinabile\n')
     fprintf('   guadagno statico ad anello chiuso: %.4g',gain0)
     fprintf(' (%.4g db)\n',20*log10(gain0))
    end
    ggf=gain0/sqrt(2); ii=find(zz/gain0>ggf);
    if length(ii)~=0, iind=ii(length(ii)); else, iind=1; end
    if iind==1 | iind==lw
     fprintf('   banda passante (-3db) non determinabile\n')
    else
     mzz=zz(iind); bandw=omg(iind);
     dzz=zz(iind+1)-zz(iind); domg=omg(iind+1)-omg(iind);
     bandw=bandw+(ggf-mzz)*(domg/dzz);
     fprintf('   banda passante (-3db): %.4g rad/sec\n',bandw)
    end
    disp(' '), disp('   **** premere un tasto per proseguire'), pause
   elseif (izz==8)&rpp&rpp1
    if length(vectc)>1
     xx=0;
     while xx==0
      col=input('\n   scegliere la funzione specificandone il colore : ','s');
      if isempty(col), col='z'; end
      if col=='0', ordf(1), return, end
      if isempty(get(0,'children')), return, end
      if gcf~=nfig, fprintf(ms1), return, end
      ropc=0; for kk=1:7, ropc=ropc|strcmp(col,ccol(kk)); end
      if ropc
       if length(find(vectc==col))>0
	xx=1;
       end
      end
     end
    else
     col=c;
    end
    eval(['aa=length(''hha1',col,''');'])
    if aa~=0
     eval(['for krx=1:length(hha1',col,'),delete(hha1',col,'(krx)),end'],...
     'err=1;'), eval(['hha1',col,'=[];'])
     eval(['for krx=1:length(hha2',col,'),delete(hha2',col,'(krx)),end'],...
     'err=1;'), eval(['hha2',col,'=[];'])
     eval(['for krx=1:length(hha3',col,'),delete(hha3',col,'(krx)),end'],...
     'err=1;'), eval(['hha3',col,'=[];'])
    end
    cfsize=get(gca,'FontSize'); flgin=0;
    while flgin==0
     fsize=input('\n   corpo del carattere (da 6 a 14, default 8) : ');
     if length(fsize)==0; fsize=8; end
     fsize=round(fsize); flgin=1;
     if (fsize<6)|(fsize>14), flgin=0; end
    end
    flgin=0;
    while flgin==0
     fdens=input(['\n   cifra di densit',aA,' (da 1 a 10, default 1) : ']);
     if length(fdens)==0, fdens=1; end
     fdens=round(fdens); flgin=1;
     if (fdens<1)|(fdens>10), flgin=0; end
    end
    q=find(vectc==col);
    eval(['mg=vmag',int2str(q),';'])
    eval(['ph=vphi',int2str(q),';'])
    eval(['omg=vw1',int2str(q),';'])
    lw=length(omg);
    if flg1==5
     x1=ph; y1=20*log10(mg);
    else
     x1=mg.*cos(ph*pi/180); y1=mg.*sin(ph*pi/180);
    end
    VV=axis;
    rx=(VV(2)-VV(1))/(2*25); ry=(VV(4)-VV(3))/(1.5*25);
    ii=find((VV(1)<x1)&(x1<VV(2))&(VV(3)<y1)&(y1<VV(4))&(omg'>0));
    if length(ii)~=0
     hold on
     om1=omg(ii(1)); om2=omg(ii(length(ii)));
     om=10^floor(log10(om1)); omi=om;
     if fdens==1
      ve=[1.2,1.5,1.8,2.2,2.7,3.3,3.9,4.7,5.6,6.8,8.2,10];
     else
      ve=round(100*logspace(0,1,12*fdens+1))/100; ve=ve(2:length(ve));
     end
     hh=1; xv=x1(1); yv=y1(1); x=xv; y=yv;
     rrp=(mg(2)>=mg(1));
     while (om < om2)
      mx=1; my=1; [zz,kk]=min(abs(omg-om));
      kk1=kk-1; kk2=kk+1;
      if kk==1, kk1=1; end
      if kk==lw, kk2=lw; end
      ww1=omg(kk1); ww2=omg(kk2); ww=linspace(ww1,ww2,100);
      xx1=x1(kk1); xx2=x1(kk2); yy1=y1(kk1); yy2=y1(kk2);
      [zz,kh]=min(abs(ww-om));
      if kh==1, kh=2; end
      x=xx1+(xx2-xx1)*kh/100; y=yy1+(yy2-yy1)*kh/100;
      x0=xx1+(xx2-xx1)*(kh-1)/100; y0=yy1+(yy2-yy1)*(kh-1)/100;
      str=sprintf(' %.3g',om);
      rop=(abs(x-xv)>length(str)*(fsize/cfsize)*.5*rx);
      rop=rop|(abs(y-yv)>(fsize/cfsize)*ry);
      rop=rop & (om > om1) & ((abs(x)>rx/2)|(abs(y)>ry/2)|(flg1==5)|rrp);
      rop=rop & (x>VV(1)) & (x<VV(2)) & (y>VV(3)) & (y<VV(4));
      if rop
       [han1,han2]=arrowl(x0,y0,x,y,rx/4,ry/4,col,1);
       eval(['hha1',col,'=[hha1',col,',han1];']);
       eval(['hha2',col,'=[hha2',col,',han2];']);
       xo=x+.5*(fsize/cfsize)*rx; yo=y-.5*(fsize/cfsize)*ry;
       if (x+length(str)*(fsize/cfsize)*.75*rx)>VV(2)
	xo=x-length(str)*(fsize/cfsize)*.75*rx; % yo=y+ry;
       end
       nnn=text(xo,yo,str,'FontSize',fsize,'Interpreter','none');
       eval(['hha3',col,'=[hha3',col,',nnn];']);
       xv=x; yv=y;
      end
      if hh==length(ve)
       omi=10*omi; om=omi; hh=1;
      else
       om=ve(hh)*omi; hh=hh+1;
      end
     end
    end  % length(ii)
    figure(nfig)
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
    hold off
   elseif ((izz==9)&rpp)|((izz==3)&((flg1==3)|(flg1==4)))
    if (fleg==1)&(ab==1), eval(['legend(HALEG,',LABLEG,')']), ab=0; end
    figure(nfig)
    xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   elseif ((izz==10)&rpp)|((izz==9)&((flg1==3)|(flg1==4)))
    if flzo==3, flmn=1; end
    if fleg==1, eval('legend off'), end
    if length(vectc)>1
     xx=0;
     while xx==0
      col=input('\n   scegliere la funzione specificandone il colore : ','s');
      if isempty(col), col='z'; end
      if col=='0', ordf(1), return, end
      if isempty(get(0,'children')), return, end
      if gcf~=nfig, fprintf(ms1), return, end
      ropc=0; for kk=1:7, ropc=ropc|strcmp(col,ccol(kk)); end
      if ropc
       if length(find(vectc==col))>0
	xx=1;
       end
      end
     end
    else
     col=c;
    end
    q=find(vectc==col); str=vstr(q); to=vto(q); tc=vecttc(q);
    if to~=0, eval('delete(mendel)','err=1;'), end
    flgde=1;
    while flgde==1
     if str=='s'
      mess='\n   ritardo finito (in secondi) - default zero : ';
      astr='sec';
     else
      fprintf(['\n   il tempo di campionamento ',eA,' ',num2str(tc),' sec'])
      mess='\n   ritardo finito (numero di campioni) - default zero : ';
      astr='camp';
     end
     to=input(mess); flgde=0;
     if isempty(to)
      to=0;
     elseif to<0
      disp([' **** errore: un ritardo negativo non ',eA,' consentito']);
      flgde=1;
     end
     if str=='z', to=round(to); end
     mess=['ritardo = ',num2str(to),' ',astr,', colore ',col];
     mendel=uimenu(men_opt,'Label',mess);
     vto(q)=to;
     eval(['z=vectz',int2str(1),';'])
     eval(['p=vectp',int2str(1),';'])
     eval(['k=vectk',int2str(1),';'])
     str=vstr(1); c=vectc(1); to=vto(1); tc=vecttc(1); gn=1;
     if flg1==4
      subplot(2,1,1)
      ytick=get(gca,'ytick'); VV=axis;
      ndiv=round((VV(4)-VV(3))/(ytick(2)-ytick(1)));
      subplot(2,1,2)
      ytick=get(gca,'ytick'); VV=axis;
      ndiv1=round((VV(4)-VV(3))/(ytick(2)-ytick(1)));
      flgd=1; flgdd=1; flgd1=1;
     elseif (flg1==5)|(flg1==6)
      VV=axis; xtick=get(gca,'xtick'); ytick=get(gca,'ytick');
      divx=xtick(2)-xtick(1); divy=ytick(2)-ytick(1);
      ndiv=round([(VV(2)-VV(1))/divx,(VV(4)-VV(3))/divy]);
      eval(['w1=vw1',int2str(1),';'])
      flgd=1; flgdd=1; flgd1=1;
     end
     iiq=0; ind2=1; HALEG=[];
    end
   end	% izz
  end  %ind2
 end  %ind1
end  % flg
disp(' ')
% --- last line of fresp ---
