function [out1,out2]=fpade(to,p,q)
%FPADE	  Pade' expansion of finite delay transfer function.
%   [N,D] = FPADE(to,p,q) provides in the row vectors N,D the
%   coefficients, in decreasing powers, of the numerator and
%   denominator of the Pade' expansion of exp(-to*s) ; p and q
%   are the orders of numerator and denominator polynomials.
%   If called with  negative to it also displays N and D in
%   rational form in the case to=1 (as nNrat, dNrat, nDrat,dDrat).

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

error(nargchk(3,3,nargin));
p=fix(p); q=fix(q);
if p<0|q<0
 error(' negative argument in function pade');
end
p1=p+1; q1=q+1;
NN=zeros(1,p1); DD=zeros(1,q1);
for k=0:p
 NN(1,p1-k)=(fact(p+q-k)*fact(p))/(fact(p+q)*fact(k)*fact(p-k))*(-1)^k;
end
for k=0:q
 DD(1,q1-k)=(fact(p+q-k)*fact(q))/(fact(p+q)*fact(k)*fact(q-k));
end
N=NN; D=DD;
for k=1:p
 N(k)=N(k)*to^(p1-k);
end
for k=1:q
 D(k)=D(k)*to^(q1-k);
end
if to < 0
 [nNrat,dNrat]=rat(NN); [nDrat,dDrat]=rat(DD);
 nNrat
 dNrat
 nDrat
 dDrat
 disp('   **** press any key to continue')
 pause
end
if nargout==0, return, end
out1=N; out2=D;
% --- last line of fpade ---
