function p=fbutter(on,n)
%FBUTTER  Denominator of Butterworth filter transfer function.
%   p = FBUTTER(on,n) gives the denominator polynomial of the
%   Butterworth filter of order n and corner frequency on.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

error(nargchk(2,2,nargin));
j=sqrt(-1);
p=zeros(1,n+1);
pp=j*zeros(1,n);
for k=1:n
 pp(k)=exp(j*(2*k+n-1)*pi/(2*n));
end
pq=poly(pp);
r=length(pq);
p((n-r+2):n+1)=pq;
p=real(p);
for k=1:n
 p(k)=p(k)/(on^(n-k+1));
end
% --- last line of fbutter ---
