function p=fbessel(on,np)
%FBESSEL  Denominator of Bessel filter transfer function.
%   p = FBESSEL(on,n) gives the denominator polynomial of the Bessel filter
%   of order n and corner frequency on.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

error(nargchk(2,2,nargin));
if np==1
 p=[1 1];
else
 C=zeros(np,np+1);
 C1=zeros(np,np+1);
 C(1,np+1)=1;
 C(1,np)=1;
 C(2,np+1)=3;
 C(2,np)=3;
 C(2,np-1)=1;
 for k=3:np
  R=conv([1 0 0],C(k-2,:));
  S=C(k-1,:);
  C(k,:)=(2*k-1)*S+R(3:np+3);
  C(k,np+1)=C(k,np);
 end
 p=zeros(1,np+1);
 ok=C(np,np+1)^(1/np);
 for h=1:np+1
  p(np-h+2)=C(np,np-h+2)/ok^(np-h+1);
 end
end
for k=1:np
 p(k)=p(k)/(on^(np-k+1));
end
% --- last line of fbessel ---
