function factf(arg1,arg2,arg3,arg4)
%FACTF	  Fattorizzazione di funzione di trasferimento (TFI).
%    FACTF,gi,gj - da TFI [FACTF('gi','gj') - da Matlab] memorizza in
%    gj la forma fattorizzata di gi. Per ottenere una buona robustezza
%    numerica, viene specificata in interattivo una tolleranza per il
%    riconoscimento delle eventuali radici multiple.
%    Se FACTF viene chiamato senza alcun argomento, le f.d.t. gi e gj
%    possono essere specificate in modo interattivo.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

aA=setstr(224); o=setstr(166); vv=[];
if nargin==0
 flg=0;
 while flg==0
  gi=input('\n   funzione di trasferimento gi (ingresso) : ','s');
  if ~isempty(gi)
   if ~exist([gi,'.mat'])
    disp([' **** errore: ',gi,'.mat non esiste'])
   else
    flg=1;
   end
  end
 end
 while flg==1
  gj=input('\n   funzione di trasferimento gj (uscita) : ','s');
  if ~isempty(gj)
   flg=2;
  end
 end
elseif nargin>=2
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1; gj=arg2;
 end
else
 disp(' **** errore: numero di argomenti non sufficiente'), return
end
eval(['load ',gi])
sn=size(Numc); sd=size(Denc);
Num=Numc; Den=Denc;
zz=[]; pp=[];
clc
tfg(gi)
fprintf('\n   Si possono fattorizzare:\n\n   1) numeratore')
fprintf('\n   2) denominatore\n   3) numeratore e denominatore\n')
xx=0;
while ((xx~=1)&(xx~=2)&(xx~=3))
 xx=input('\n   operare una scelta (premere invio per uscire) : ');
 if length(xx)==0
  return
 end
end
if xx~=2
 for i=1:sn(1)
  a=(find(Numc(i,:)~=0));
  r=roots(Numc(i,a(1):sn(2)));
  zz=[zz;r];
 end
 ss=1;
 if length(zz)==0, ss=0; end
 while ss==1
  clc, disp(' ')
  disp('   >>> Zeri <<<')
  disp(' ')
  zzz=1;
  for k=1:length(zz)
   if abs(imag(zz(k)))>10^(-4)
    fprintf(['  %4.f  ',o,'  %+4.4e    %+4.4e * j'],...
     k,real(zz(k)),imag(zz(k)))
    fprintf(['  ',o,'%4.f\n'],zzz)
   else
    fprintf(['  %4.f  ',o,'  %+4.4e                    '],k,real(zz(k)))
    fprintf(['  ',o,'%4.f\n'],zzz)
   end
  end
  tol=input('\n   specificare la tolleranza (default 10^(-4)) : ');
  if isempty(tol)
   tol=10^(-4);
  end
  tol=abs(tol*1.01); [egv,mul]=makest(zz,tol,0);
% Rounds the eigenvalues
  for k=1:length(mul)
   if mul(k)>1
    pre=real(egv(k)); pim=imag(egv(k));
    if pre~=0
     tt=10^(8-round(log10(abs(pre))));
     pre=(round(abs(pre)*tt)/tt)*sign(pre);
    end
    if pim~=0
     tt=10^(8-round(log10(abs(pim))));
     pim=(round(abs(pim)*tt)/tt)*sign(pim);
    end
    egv(k)=pre+j*pim;
   end
  end
% Builds the conjugate eigenvalues
  ii=find(abs(imag(egv))>0);
  egv=[egv conj(egv(ii))];
  mul=[mul mul(ii)];
  disp(' ')
  disp(['   >>> Zeri con gli ordini di molteplicit',aA,' rilevati <<<'])
  disp(' ')
  for k=1:length(egv)
   if abs(imag(egv(k)))>10^(-4)
    fprintf(['  %4.f  ',o,'  %+4.4e    %+4.4e * j'],k,...
     real(egv(k)),imag(egv(k)))
    fprintf(['  ',o,'%4.f\n'],mul(k))
   else
    fprintf(['  %4.f  ',o,'  %+4.4e                    '],k,real(egv(k)))
    fprintf(['  ',o,'%4.f\n'],mul(k))
   end
  end
  kzz=0;
  while kzz==0;
   kzz=1;
   ss=input('\n   cambiare la tolleranza (1/0) ? : ');
   if isempty(ss), ss=0; kzz=0; end;
   rop=((ss~=1)&(ss~=0)); if rop, kzz=0; end
  end
 end % while ss==1
 egvz=egv;
 mulz=mul;
 for i1=1:length(mulz)
  for i2=1:mulz(i1)
   if imag(egvz(i1))==0
    vv=[vv;egvz(i1)];
   elseif imag(egvz(i1))<0
    vv=[vv;egvz(i1);conj(egvz(i1))];
   end
  end
 end
 z=vv;
 Num=[]; ii=1;
 while ii<=length(z)
  sn=size(Num);
  if abs(imag(z(ii)))>10^(-4)
   nn=poly([z(ii),real(z(ii))-j*imag(z(ii))]);
   qq=find(z==(real(z(ii))-j*imag(z(ii))));
   if length(qq)~=0, z(qq(1))=[]; end
   Num=[zeros(sn(1),length(nn)-sn(2)),Num;nn];
  else
   Num=[Num;zeros(1,sn(2)-2),poly(z(ii))];
  end
  ii=ii+1;
 end
end
if xx~=1
 for i=1:sd(1)
  a=(find(Denc(i,:)~=0));
  r=roots(Denc(i,a(1):sd(2)));
  pp=[pp;r];
 end
 ss=1;
 if length(pp)==0, ss=0; end
 while ss==1
  clc, disp(' ')
  disp('   >>> Poli <<<')
  disp(' ')
  ppp=1;
  for k=1:length(pp)
   if abs(imag(pp(k)))>10^(-4)
    fprintf(['  %4.f  ',o,'  %+4.4e    %+4.4e * j'],...
     k,real(pp(k)),imag(pp(k)))
    fprintf(['  ',o,'%4.f\n'],ppp)
   else
    fprintf(['  %4.f  ',o,'  %+4.4e                    '],k,real(pp(k)))
    fprintf(['  ',o,'%4.f\n'],ppp)
   end
  end % for
  tol=input('\n   specificare la tolleranza (default 10^(-4)) : ');
  if isempty(tol)
   tol=10^(-4);
  end
  tol=abs(tol*1.01); [egv,mul]=makest(pp,tol,0);
% Rounds the eigenvalues
  for k=1:length(mul)
   if mul(k)>1
    pre=real(egv(k)); pim=imag(egv(k));
    if pre~=0
     tt=10^(8-round(log10(abs(pre))));
     pre=(round(abs(pre)*tt)/tt)*sign(pre);
    end
    if pim~=0
     tt=10^(8-round(log10(abs(pim))));
     pim=(round(abs(pim)*tt)/tt)*sign(pim);
    end
    egv(k)=pre+j*pim;
   end
  end
% Builds the conjugate eigenvalues
  ii=find(abs(imag(egv))>0);
  egv=[egv conj(egv(ii))];
  mul=[mul mul(ii)];
  disp(' ')
  disp(['   >>> Poli con gli ordini di molteplicit',aA,' rilevati <<<'])
  disp(' ')
  for k=1:length(egv)
   if abs(imag(egv(k)))>10^(-4)
    fprintf(['  %4.f  ',o,'  %+4.4e    %+4.4e * j'],...
      k,real(egv(k)),imag(egv(k)))
    fprintf(['  ',o,'%4.f\n'],mul(k))
   else
    fprintf(['  %4.f  ',o,'  %+4.4e                    '],k,real(egv(k)))
    fprintf(['  ',o,'%4.f\n'],mul(k))
   end
  end % for
  kzz=0;
  while kzz==0;
   kzz=1;
   ss=input('\n   cambiare la tolleranza (1/0) ? : ');
   if length(ss)==0; ss=0; kzz=0; end;
   rop=((ss~=1)&(ss~=0)); if rop; kzz=0; end;
  end
 end % while ss==1
 egvp=egv;
 mulp=mul;
 vv=[];
 for i1=1:length(mulp)
  for i2=1:mulp(i1)
   if imag(egvp(i1))==0
    vv=[vv;egvp(i1)];
   elseif imag(egvp(i1))<0
    vv=[vv;egvp(i1);conj(egvp(i1))];
   end
  end
 end
 p=vv;
 Den=[]; ii=1;
 while ii<=length(p)
  sd=size(Den);
  if abs(imag(p(ii)))>10^(-4)
   dd=poly([p(ii),real(p(ii))-j*imag(p(ii))]);
   qq=find(p==(real(p(ii))-j*imag(p(ii))));
   if length(qq)~=0, p(qq(1))=[]; end
   Den=[zeros(sd(1),length(dd)-sd(2)),Den;dd];
  else
   Den=[Den;zeros(1,sd(2)-2),poly(p(ii))];
  end
  ii=ii+1;
 end
end
clc
tfg(gi)
aa=stf(Num,Den,kc,strc,gj);
if aa==1, tfg(gj), end
% --- last line of factf ---
