function out=exportf1(arg1,arg2)
%EXPORTF1 Converts a transfer function from TFI to a Matlab's LTI system.
%   sys=EXPORTF1('gi')               --> gives the zpk LTI form of the
%					 transfer function gi
%   sys=EXPORTF1('gi',1)             --> gives the tf LTI form of the
%					 transfer function gi

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

out=[];
if ~exist('ctrb.m')
 disp(' '), disp('   **** exportf1 requires the Control System toolbox')
 disp(' '), out=[]; return
end
if nargin==1
 if ~exist([arg1,'.mat'])
  disp([' **** error: ',arg1,'.mat does not exist']), return
 end
 [z,p,k,str,Tc]=exportf(arg1,3);
 if (str=='z')&(Tc==0), Tc=lsamp; end
 out=zpk(z,p,k);
 set(out,'Variable',str,'Ts',Tc,'Td',0)
else
 [num,den,str,Tc]=exportf(arg1,3);
 if (str=='z')&(Tc==0), Tc=lsamp; end
 out=tf(num,den);
set(out,'Variable',str,'Ts',Tc,'Td',0)
end
% ----- last line of exportf1 -----
