function [out1,out2,out3,out4,out5]=exportf(arg1,arg2)
%EXPORTF  Converts a transfer function from TFI to Matlab.
%   [num,den]=EXPORTF('gi')          --> gives the polynomial form of the
%   [num,den,str]=EXPORTF('gi',1)        transfer function gi
%   [z,p,k]=EXPORTF('gi')            --> gives the factorized form of the
%   [z,p,k,str]=EXPORTF('gi',1)          transfer function gi
%   NOTE: option "1" also provides the value of string variable "str":
%   str='s' means continuous-time; str='z' means discrete-time.
%   [num,den,str,Tc]=EXPORTF('gi',2) --> also gives the sampling time Tc
%   [z,p,k,str,Tc]=EXPORTF('gi',2)
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

eA=setstr(232);
nargs1=nargin; nargs2=nargout;
flg=0;
if nargs1==1, arg2=0; end
if (nargs1==2)&(arg2>=2), flg=1; end
flg1=(nargs2==2)|((nargs2==3)&(nargs1==2))|((nargs2==4)&(flg==1));
gi=arg1; Tc=0; T=lsamp;
aa=1; eval(['load ',gi],'aa=2;')
if aa==2, fprintf(['\n **** il nome ',gi,' non ',eA,' ammesso\n']), return, end
if (Tc~=0)&(Tc~=T)&(arg2<=2)
 fprintf(['\n **** attenzione: il tempo di campionamento di ',gi,...
 ' ',eA,' %.4g sec\n'],Tc)
 disp(' '), disp('   **** premere un tasto per proseguire'), pause
end
sn=size(Numc); sd=size(Denc);
num=kc; den=1; z=[]; p=[];
for i=1:sn(1)
 a=(find(Numc(i,:)~=0));
 if flg1
  num=conv(num, Numc(i,a(1):sn(2)));
 else
  r=roots(Numc(i,a(1):sn(2)));
  z=[z;r];
 end
end
for i=1:sd(1)
 a=(find(Denc(i,:)~=0));
 if flg1
  den=conv(den, Denc(i,a(1):sd(2)));
 else
  r=roots(Denc(i,a(1):sd(2)));
  p=[p;r];
 end
end
if flg1
 out1=num; out2=den;
 if nargs1==2, out3=strc; end
 if (nargs1==1)&(flg==1), out3=Tc; end
 if (nargs1==2)&(flg==1), out4=Tc; end
else
 tol=10^(-8);
 [egvz,mulz]=makest(z,tol,0);
 [egvp,mulp]=makest(p,tol,0);
 vv=[];
 for i1=1:length(mulz)
  for i2=1:mulz(i1)
   if imag(egvz(i1))==0
    vv=[vv;egvz(i1)];
   elseif imag(egvz(i1))>0
    vv=[vv;egvz(i1);conj(egvz(i1))];
   end
  end
 end
 z=vv;
 vv=[];
 for i1=1:length(mulp)
  for i2=1:mulp(i1)
   if imag(egvp(i1))==0
    vv=[vv;egvp(i1)];
   elseif imag(egvp(i1))>0
    vv=[vv;egvp(i1);conj(egvp(i1))];
   end
  end
 end
 p=vv;
 out1=z; out2=p; out3=kc;
 if nargs1==2, out4=strc; end
 if (nargs1==1)&(flg==1), out4=Tc; end
 if (nargs1==2)&(flg==1), out5=Tc; end
end
% --- last line of exportf ---
