function expgm(gi,gj,h)
%EXPGM	  Computes the h-power of a transfer function.
%   EXPGM('gi','gj',h) provides the h-power gi^(h) and saves the result
%   in gj.mat; h must be integer.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(3,3,nargs));
if ~exist([gi,'.mat'])
 error([' **** error: ',gi,'.mat does not exist'])
end
[Numi,Deni,ki,stri]=ltf(gi);
[Numj,Denj,kj]=expg(Numi,Deni,ki,h);
aa=stf(Numj,Denj,kj,stri,gj);
% --- last line of expgm ---
