function [Num,Den,k]=expg(Numc,Denc,kc,h)
%EXPG	  Computes the h-power of a transfer function (aux for TFI).
%   [Num,Den,k]=EXPG(Numc,Denc,kc,h) provides the h-power of
%   Gc=kc*Numc/Denc; h must be integer.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(4,4,nargs));
[Numc,Denc,kc]=ridg(Numc,Denc,kc);
Nc=Numc; Dc=Denc;
Num=[]; Den=[];
if round(h)~=h
 error(' h must be integer')
end
if h~=0
 if h<0, Numc=Dc; Denc=Nc; kc=1/kc; end
 for i=1:abs(h)
  if size(Numc)==[1,1], Num=1; else, Num=[Num;Numc]; end
  if size(Denc)==[1,1], Den=1; else, Den=[Den;Denc]; end
 end
 k=(kc)^abs(h);
else
 Num=1; Den=1; k=1;
end
% --- last line of expg ---
