function out1=drgrid(s)
%DRGRID   Constant damping factor loci for a digital root locus plot.
%   DRGRID(1) clears the graphics screen and sets HOLD ON so that the
%   the root locus can be plot over the grid.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

[tp1,tp2,tp3,tp4]=coltbl;
if tp1(7,1)==1, BW='w'; else, BW='k'; end
status=ishold;
if nargin==1
 VV=[-2 2 -1.5 1.5]; hold off
else
 VV=axis; hold on
end
fsize=8;
%
i=sqrt(-1); ha=[];
%
% Plot constant delta lines
%
delta=[.1 .2 .3 .4 .5 .6 .7 .8 .9];
%
T=lsamp;
Om=2*pi/T;
omv=linspace(0,Om/2,24);
for kk=1:2
 [d,om]=meshgrid(delta,omv);
 s=-om.*d ./(sqrt(1-d.^2))-(-1)^kk*i*om;
 z=exp(s*T);
 xx=real(z); yy=imag(z);
 ha1=plot(xx,yy,[BW,':']); ha=[ha;ha1]; hold on
end
%
% Label the plotted lines
%
vx=14;
for k=1:length(delta)
 xp=xx(vx,k); yp=-yy(vx,k);
 if (xp>=VV(1))&(xp<=VV(2))&(yp>=VV(3))&(yp<=VV(4))
  ha1=text(xp,yp,sprintf('%.1g',delta(k)));
  set(ha1,'FontSize',fsize)
  ha=[ha;ha1];
 end
end
%
% Plot constant omega_n lines
%
omv=linspace(0,Om/2,11); omv=omv(2:10);
delta=linspace(0,.9,24);
for kk=1:2
 [d,om]=meshgrid(delta,omv);
 s=-om.*d ./(sqrt(1-d.^2))-(-1)^kk*i*om;
 z=exp(s*T);
 xx=real(z); yy=imag(z);
 ha1=plot(xx',yy',[BW,':']); ha=[ha;ha1]; hold on
end
%
if nargin==1
 axis([-2 2 -1.5 1.5])
else
 axis(axis)
end
%
if (nargin==0)&(~status), hold off, end  % Return hold to previous status
if nargout==0
 return
else
 out1=ha;
end
% --- last line of drgrid ---
