function [out1,out2,out3]=diwplane(arg1,arg2,arg3,arg4)
%DIWPLANE Direct wplane transform (discrete to continuous time).
%   Possible uses:
%   [num,den]=DIWPLANE(numd,dend,T)
%   [z,p,k]=DIWPLANE(zd,pd,kd,T)
%   DIWPLANE tranforms a discrete-time system to continuous-time
%   according to the wplane equivalences:
%
%	   1 + wT/2	     2 (z - 1)
%     z =  --------  ;	w =  --------- .
%	   1 - wT/2	     T (z + 1)

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

tol=10^(-8);
nargs=nargin;
error(nargchk(3,4,nargs));
if nargs==3
 numd=arg1;dend=arg2;T=arg3; [zd,pd,Kd]=tozpk(numd,dend);
else
 zd=arg1;pd=arg2;Kd=arg3;T=arg4;
end
if T<=0
 error(' T illegal in diwplane');
end
%
flg=0;
m=length(zd); n=length(pd);
if m>n
 zz=zd; zd=pd; pd=zz; Kd=1/Kd; m=length(zd); n=length(pd); flg=1;
end
Kw=Kd;
zw=[];
for kk=1:m
 if zd(kk)~=-1
  zw=[zw;(zd(kk)-1)*(2/T)/(zd(kk)+1)];
  Kw=-Kw*(zd(kk)+1);
 else
  Kw=-Kw*4/T;
 end
end
for kk=1:n-m
 zw=[zw;2/T];
end
pw=[];
for kk=1:n
 pw=[pw;(pd(kk)-1)*(2/T)/(pd(kk)+1)];
 Kw=-Kw/(pd(kk)+1);
end
Kw=real(Kw);
%
%   reduction to the minimal form
%
mw=length(zw); nw=length(pw);
iz=ones(mw,1); ip=ones(nw,1);
tol1=tol*max(abs(zw));
for kk=1:mw
 for kh=1:nw
  if (abs(zw(kk)-pw(kh))<=tol1)&(ip(kh)~=0)
   iz(kk)=0; ip(kh)=0; break
  end
 end
end
zw=zw(find(iz)); pw=pw(find(ip));
if flg==1
 zz=zw; zw=pw; pw=zz; Kw=1/Kw;
end
%
if nargs==3
 denw=real(poly(pw)); numw=Kw*(real(poly(zw)));
 out1=numw;out2=denw;out3=0;
elseif nargs==4
 out1=zw;out2=pw;out3=Kw;
end
% --- last line of diwplane ---
