function [X,Y] = diopha(A,B,C)
%DIOPHA   Diophantine equation solution
%   [X,Y] = DIOPHA(A,B,C) provides the minimum-degree solution
%   of the polynomial equation
%
%	  A*X + B*Y = C
%
%   Denote by n,m,p the degrees of  A,B,C, respectively.
%   The degrees k,h of the provided solution X,Y satisfy
%   k=p-n if p>=m+n,
%   k<=m-1 if p<m+n; h<=n-1 always.

%   L.Marconi, 15/6/1996.

n=length(A)-1; m=length(B)-1; l=length(C)-1;
if (l>=m+n)
  k=l-n;
else
  k=m-1;
end
h=n-1; o=k+h+2;
M=zeros(o,o);
for (ii=1:k+1)
  M(ii:ii+n,ii)=A';
end
for (ii=1:h+1)
  M(o-ii-m+1:o-ii+1,o-ii+1)=B';
end
Q=zeros(o,1); Q(o-l:o,1)=C'; XX=inv(M)*Q;
X=XX(1:k+1)'; if (isempty(X)) X=0; end
Y=XX(k+2:o)'; if (isempty(Y)) Y=0; end
% --- last line of diopha ---
