function [num,den]=dezpk(z,p,k)
%DEZPK	  Zero-pole-gain to transfer function conversion.
%   [num,den] = DEZPK(z,p,k) finds the numerator and denominator
%   coefficients in descending powers of s from zeros, poles and gain:
%
%      num(s)	  (s-z1)(s-z2)...(s-zn)
%      ------ = k --------------------- .
%      den(s)	  (s-p1)(s-p2)...(s-pn)
%
%   NOTE: num & den are row vectors, while of z & p are column vectors
%   whose components must be conjugate by pairs.
%   See TOZPK to convert the other way.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

den=real(poly(p));
if isempty(z)
 num=k;
else
 num=k*(real(poly(z)));
end
% --- last line of dezpk ---
