function descrf(arg1,arg2,arg3,arg4)
%DESCRF   Calcolo e graficazione di funzioni descrittive (TFI).
%   DESCRF calcola e grafica le funzioni descrittive dei piu' comuni
%   elementi non lineari. Tipo e parametri sono specificati in interattivo.
%   I tipi sono: saturazione, soglia, saturazione con soglia, qualunque
%   funzione ottenuta per interpolazione lineare fra punti dati (con
%   possibilita' di discontinuita'), rele' ideale, rele' con soglia,
%   rele' con isteresi, gioco. Altre possibilita' in interattivo sono:
%      1. calcolo del valore massimo
%      2. calcolo della funzione inversa in un dato punto.
%   DESCRF,gi - da TFI [DESCRF('gi') - da Matlab] fornisce nella stessa
%   figura i diagrammi di Nyquist di gi(j*omega) e di -1/F(X), in cui
%   F(X) e' una delle precedenti funzioni descrittive, per determinare
%   possibili oscillazioni autosostenute (cicli limite).

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global ABIL TRF1 gr nfig nfig1 HALEG FIGLEG LABLEG SUBPLEG

if nargin>0
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1;
  [z,p,k,str]=exportf(gi,1); if isempty(k), return, end
  if str=='z'
   disp(['   **** il programma descrf si applica solo a sistemi a ',...
   'tempo continuo']), return
  end
 end
end
%
aA=setstr(224); eA=setstr(232); oA=setstr(242); EA=setstr(200);
clf, nfig=gcf; nfigs=int2str(nfig); nargs=nargin; j=sqrt(-1); ABIL=0;
figure(nfig+1), ordf(1), clf, nfig1=gcf; nfigs1=int2str(nfig1); hha1=[];
[vcol1,vcol2,repco]=coltbl; FIGLO=resfiglo;
FIGLEG=0; HALEG=[]; LABLEG=[]; SUBPLEG=0;
flx=0; fly=0; gr=0; ffp=1; ffq=1; to=0; flguic=0;
ms1=['\n **** errore: non si pu',oA,' cambiare figura durante l''esecuzione\n'];
ms2='   **** premere un tasto per proseguire';
if exist('legen#.mat'), load legen#, else, legen=0; islegen=0; end
%
flg=0; VV=zeros(1,4);
while flg==0
clc, disp(' '),
 disp('   Scegliere l''elemento non lineare :')
 disp(' ')
 disp('    1 - saturazione')
 disp('    2 - soglia')
 disp('    3 - saturazione con soglia')
 disp(['    4 - qualunque nonlinearit',aA,' interpolata linearmente'])
 disp(['    5 - rel',eA,' ideale'])
 disp(['    6 - rel',eA,' con soglia'])
 disp(['    7 - rel',eA,' con isteresi'])
 disp('    8 - gioco')
 izz=input('\n   operare una scelta (0 per uscire) : ');
 if isempty(izz), izz=-1; end
 izz=round(izz);
 if izz==0, eval('delete(nfig1)','err=1;'), ordf(1), clf, return, end
 if (izz>=1)&(izz<=8), flg=1; end
end
%
if izz==1
 mess1='saturazione';
 flg=0;
 while flg==0
  xd=input(['\n   limite destro dell''intervallo di linearit',aA,' X1 : ']);
  if length(xd)==1, if xd>0, flg=1; end, end
 end
 flg=0;
 while flg==0
  yd=input('\n   livello di saturazione Y1 : ');
  if length(yd)==1, flg=1; end
 end
 xd=[-xd,xd]; yd=[-yd,yd]; yx=sort(yd);
 dx=(xd(2)-xd(1))*1.1; VV(1)=xd(1)-1.2*dx; VV(2)=xd(2)+1.2*dx;
 dy=(yx(2)-yx(1))*1.1; VV(3)=yx(1)-.1*dy; VV(4)=yx(2)+.1*dy;
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 xd=[-10^8,xd,10^8];
 yd=[yd(1),yd,yd(2)];
 x=[VV(1),xd(2:3),VV(2)]; y=yd;
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
%
elseif izz==2
 mess1='soglia';
 flg=0;
 while flg==0
  xd=input('\n   limite destro dell''intervallo di soglia X1 : ');
  if length(xd)==1, if xd>0, flg=1; end, end
 end
 flg=0;
 while flg==0
  md=input('\n   guadagno nella zona lineare m : ');
  if length(md)==1, flg=1; end
 end
 xd=[-xd,xd];
 dx=(xd(2)-xd(1))*1.1; VV(1)=xd(1)-2*dx; VV(2)=xd(2)+2*dx;
 VV(3)=-1.2*2*dx*abs(md); VV(4)=-VV(3);
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 xd=[-10^8,xd,10^8];
 yd=[(xd(1)-xd(2))*md,0,0,(xd(4)-xd(3))*md];
 x=[VV(1),xd(2:3),VV(2)];  y=[(x(1)-x(2))*md,0,0,(x(4)-x(3))*md];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
%
elseif izz==3
 mess1='saturazione con soglia';
 flg=0;
 while flg==0
  xd=input(['\n   punti di discontinuit',aA,' sull''asse x [X1 X2] : ']);
  if length(xd)==2
   if (all(xd>0)) & (xd(2)>xd(1)), flg=1; end
  end
 end
 xd=[-xd(2),-xd(1),xd];
 flg=0;
 while flg==0
  yd=input('\n   livello di saturazione Y1 : ');
  if length(yd)==1, flg=1; end
 end
 yd=[-yd,yd]; yx=sort(yd);
 dx=(xd(4)-xd(1))*1.1; VV(1)=xd(1)-dx; VV(2)=xd(4)+dx;
 dy=(yx(2)-yx(1))*1.1; VV(3)=yx(1)-.1*dy; VV(4)=yx(2)+.1*dy;
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 xd=[-10^8,xd,10^8];
 yd=[yd(1),yd(1),0,0,yd(2),yd(2)];
 x=[VV(1),xd(2:5),VV(2)]; y=yd;
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
%
elseif izz==4
 mess1=['nonlinearit',aA,' interpolata linearmente'];
 flg=0; flg1=0;
 while flg==0
  while flg1==0
   xd=input(['\n   punti di discontinuit',aA,' in x [x1 x2 x3 ...] : ']);
   lx=length(xd);
   if lx==1
    if xd==0, eval('delete(nfig1)','err=1;'), ordf(1), return, end
   end
   if lx>=2
    if all(xd>=0), flg1=1; end
   else
    xd=[1,2]; lx=2;
   end
   if abs(xd(lx)-xd(lx-1)<eps)
    disp(' '), disp('   **** pendenza finale non ammessa'), flg1=0;
   end
  end
  yd=input(['\n   punti di discontinuit',aA,' in y [y1 y2 y3 ...] : ']);
  if ~isempty(yd)
   if xd(1)==0 & yd(1)==0
    disp(['   **** l''origine verr',setstr(224),' automaticamente inclusa'])
   end
  end
  ly=length(yd);
  if lx==ly & (xd(1)~=0|yd(1)~=0) flg=1; else, flg1=0; end
 end
 [xd,ii]=sort(xd); yd=yd(ii);
 ii=lx:-1:1; xd=[-xd(ii),xd]; yd=[-yd(ii),yd]; lx=2*lx; ly=2*ly;
 m1=(yd(1)-yd(2))/(xd(1)-xd(2)); m2=(yd(lx)-yd(lx-1))/(xd(lx)-xd(lx-1));
 dx=(xd(lx)-xd(1))*1.1; VV(1)=xd(1)-.2*dx; VV(2)=xd(lx)+.2*dx;
 dy=(max(yd)-min(yd))*1.1; VV(3)=min(yd)-.1*dy; VV(4)=max(yd)+.1*dy;
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 xd=[-10^8,xd,10^8]; lx=length(xd);
 yd=[yd(1)+(xd(1)-xd(2))*m1,yd,yd(ly)+(xd(lx)-xd(lx-1))*m2];
 x=[VV(1),xd(2:lx-1),VV(2)];
 y=[yd(2)+(x(1)-x(2))*m1,yd(2:lx-1),yd(lx-1)+(x(lx)-x(lx-1))*m2];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
%
elseif izz==5
 mess1=['rel',eA,' ideale'];
 flg=0;
 xd=0;
 while flg==0
  yd=input('\n   livello di saturazione Y1 : ');
  if length(yd)==1, flg=1; end
 end
 yd=[-yd,yd];
 yx=sort(yd);
 VV(1)=xd-5; VV(2)=xd+5;
 dy=(yx(2)-yx(1))*1.1; VV(3)=yx(1)-.1*dy; VV(4)=yx(2)+.1*dy;
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 x=[VV(1),xd,xd,VV(2)]; y=[yd(1),yd(1),yd(2),yd(2)];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
%
elseif izz==6
 mess1=['rel',eA,' con soglia'];
 flg=0;
 while flg==0
  xd=input(['\n   punto di discontinuit',aA,' X1 : ']);
  if length(xd)==1, if xd>0, flg=1; end, end
 end
 xd=abs(xd); xd=[-xd,xd];
 flg=0;
 while flg==0
  yd=input('\n   livello di saturazione Y1 : ');
  if length(yd)==1, flg=1; end
  yd=[-yd,0,yd]; yx=sort(yd);
 end
 dx=(xd(2)-xd(1))*1.1; VV(1)=xd(1)-2*dx; VV(2)=xd(2)+2*dx;
 dy=(yx(3)-yx(1))*1.1; VV(3)=yx(1)-.1*dy; VV(4)=yx(3)+.1*dy;
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 x=[VV(1),xd(1),xd,xd(2),VV(2)]; y=[yd(1),yd(1),yd(2),yd(2),yd(3),yd(3)];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
%
elseif izz==7
 mess1=['rel',eA,' con isteresi'];
 flg=0;
 while flg==0
  xd=input(['\n   punto di discontinuit',aA,' X1 : ']);
  if isempty(xd), xd=0; end
  if (xd~=0)&(length(xd)==1), flg=1; end
 end
 xd=abs(xd); xd=[-xd,xd];
 flg=0;
 while flg==0
  yd=input('\n   corrispondente livello di saturazione Y1 : ');
  if length(yd)==1, flg=1; end
 end
 yd=[-yd,yd];
 yx=sort(yd);
 dx=(xd(2)-xd(1))*1.1; VV(1)=xd(1)-2*dx; VV(2)=xd(2)+2*dx;
 dy=(yx(2)-yx(1))*1.1; VV(3)=yx(1)-.1*dy; VV(4)=yx(2)+.1*dy;
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 x=[VV(1),xd(2),xd(2),VV(2)]; y=[yd(1),yd(1),yd(2),yd(2)];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
 x=[VV(2),xd(1),xd(1),VV(1)]; y=[yd(2),yd(2),yd(1),yd(1)];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-')
%
elseif izz==8
 mess1='gioco';
 flg=0;
 while flg==0
  xd=input('\n   limite destro dell''intervallo di gioco X1 : ');
  if isempty(xd), xd=0; end
  if (xd>0)&(length(xd)==1), flg=1; end
 end
 xd=[-xd,xd];
 flg=0;
 while flg==0
  md=input('\n   guadagno nella zona lineare m : ');
  if length(md)==1, flg=1; end
 end
 dx=xd(2)-xd(1); VV(1)=xd(1)-2*dx; VV(2)=xd(2)+2*dx;
 VV(3)=1.1*(VV(1)-xd(1))*abs(md); VV(4)=-VV(3);
 plot([VV(1),VV(2),VV(2),VV(1)],[VV(3),VV(3),VV(4),VV(4)],...
 'Color',vcol1(8,:),'LineStyle','none','Marker','.'), VV=axis;
 x=[.8*VV(1),.8*VV(1)+(xd(2)-xd(1)),.8*VV(2)];
 y=[(x(1)-xd(1))*md,(x(1)-xd(1))*md,(x(3)-xd(2))*md];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-'), axis(VV), hold on
 x=[.8*VV(2),.8*VV(2)-(xd(2)-xd(1)),.8*VV(1)];
 y=[(x(1)-xd(2))*md,(x(1)-xd(2))*md,(x(3)-xd(1))*md];
 plot(x,y,'Color',vcol1(1,:),'LineStyle','-')
end
%
xa=[VV(1),VV(2)]; ya=[0,0]; xb=[0,0]; yb=[VV(3),VV(4)];
ha=plot(xa,ya,xb,yb);
set(ha(1),'Color',vcol1(7,:),'LineStyle',':')
set(ha(2),'Color',vcol1(7,:),'LineStyle',':')
title('relazione ingresso-uscita di NL')
men_opt1=uimenu(nfig1,'Label','Memo');
mess=['NL : ',mess1];
uimenu(men_opt1,'Label',mess);
mess=['(vedere la funzione descrittiva in Fig. ',nfigs,')'];
uimenu(men_opt1,'Label',mess);
ordf(2), figure(nfig1), hold off
%
xyx=input('\n   **** premere invio per proseguire ','s');
%
ordf(1), figure(nfig), ordf(3)
if any(FIGLO(6,:))
 erx=0; eval('set(nfig,''Position'',FIGLO(6,1:4))','erx=1;')
end
men_opt=uimenu(nfig,'Label','Memo');
men_gr=uimenu(nfig,'Label','Reticolo on/off','Callback','gridmng(1)');
men_zoom=uimenu(nfig,'Label','Zoom on/off','Callback','gridmng(7)');
mess=['NL : ',mess1,'  (vedere il grafico)'];
uimenu(men_opt,'Label',mess,'Callback','gridmng(3)');
if nargs==1
 mess=['funzione di trasferimento : ',gi];
 TRF1=[gi,repco(1)];
 uimenu(men_opt,'Label',mess,'Callback','tfmaux(1,.76)');
 mess='funzione descrittiva:';
 uimenu(men_opt,'Label',mess,'Separator','on');
 mess='blu: verso l''origine al crescere di X';
 uimenu(men_opt,'Label',mess);
 mess='rosso: dall''origine al crescere di X';
 uimenu(men_opt,'Label',mess);
end
%   selecting positive breaks points for some nonlinear elements
if izz<=4, ld=length(xd); xd=[0,xd(ld/2+1:ld)]; yd=[0,yd(ld/2+1:ld)]; end
%
%   Computation of the describing functions
%
flg=0;
while flg==0
 if ffp==1
  s1=get(gca,'XLimMode'); isauto=strcmp(s1,'auto'); VV=axis;
%
  if izz==1 %  saturation
   X1=xd(2); Y1=yd(2);
   m=Y1/X1;
   if nargs==0
    if isauto, VV(1)=0; VV(2)=10*X1; end
    np=400; X=linspace(VV(1),VV(2),np); DF=zeros(1,np);
    for kk=1:np
     if X(kk)<=X1
      DF(kk)=m;
     else
      DF(kk)=m*satdfn(X(kk)/X1);
     end
    end
%   sharpening discontinuity
    ii=find(X<X1);
    if length(ii)~=0 & length(ii)<np
     X=[X(ii),X1,X(length(ii)+1:np)];
     DF=[DF(ii),DF(length(ii)),DF(length(ii)+1:np)];
    end
    ha=plot([0,0],[0,1.1*m],X,DF);
    set(ha(1),'Color',vcol1(8,:),'LineStyle','none','Marker','.')
    set(ha(2),'Color',vcol1(1,:),'LineStyle','-')
   else
    if isauto, VV=[-2,2,-1.5,1.5]; axis(VV), end
    [mag,phi,w1]=eval('frespc(z,p,k,5,repco(1),to)'); hold on
%   scaling the inverse DF
    XM=X1; rinvdf=-1/m; iinvdf=0;
    if ((-1/m)>VV(1))&(0>VV(3))&(0<VV(4))
     while (rinvdf>VV(1))&(rinvdf<VV(2))&(iinvdf>VV(3))&(iinvdf<VV(4))
      XM=XM*1.2; rinvdf=-1/(m*satdfn(XM/X1));
     end
    end
    np=400; X=linspace(X1,XM,np); RIDF=zeros(1,np); IIDF=zeros(1,np);
    for kk=1:np
     RIDF(kk)=-1/(m*satdfn(X(kk)/X1));
    end
    plot(RIDF,IIDF,'Color',vcol1(2,:),'LineStyle','-'), hold off
   end
  elseif izz==2 %  dead zone
   X1=xd(2); m=md;
   if nargs==0
    if isauto, VV(1)=0; VV(2)=10*X1; end
    np=400; X=linspace(VV(1),VV(2),np); DF=zeros(1,np);
    for kk=1:np
     if X(kk)<=X1
      DF(kk)=0;
     else
      DF(kk)=m*(1-satdfn(X(kk)/X1));
     end
    end
%   sharpening discontinuity
    ii=find(X<X1);
    if length(ii)~=0 & length(ii)<np
     X=[X(ii),X1,X(length(ii)+1:np)];
     DF=[DF(ii),DF(length(ii)),DF(length(ii)+1:np)];
    end
    plot(X,DF,'Color',vcol1(1,:),'LineStyle','-')
   else
    if isauto, VV=[-2,2,-1.5,1.5]; axis(VV), end
    [mag,phi,w1]=eval('frespc(z,p,k,5,repco(1),to)'); hold on
%   scaling the inverse DF
    XM=X1; rinvdf=-10^8;
    if ((-1/m)>VV(1))&(0>VV(3))&(0<VV(4))
     while rinvdf<VV(1)
      XM=XM*1.2; rinvdf=-1/(m*(1-satdfn(XM/X1)));
     end
     XM=XM/1.2; if XM==X1, XM=X1+10^(-8); end
    end
    np=400; X=logspace(log10(XM),log10(XM)+3,np);
    RIDF=zeros(1,np); IIDF=zeros(1,np);
    for kk=1:np
     RIDF(kk)=-1/(m*(1-satdfn(X(kk)/X1)));
    end
    plot(RIDF,IIDF,'Color',vcol1(6,:),'LineStyle','-'), hold off
   end
  elseif izz==3 %  saturation with dead zone
   X1=xd(2); X2=xd(3); m=yd(3)/(xd(3)-xd(2));
   if isauto, VV(1)=0; VV(2)=10*X2; end
   np=400; X=linspace(VV(1),VV(2),np); DF=zeros(1,np);
   for kk=1:np
    if X(kk)<=X1
     DF(kk)=0;
    elseif (X(kk)>X1) & (X(kk)<=X2)
     DF(kk)=m*(1-satdfn(X(kk)/X1));
    else
     DF(kk)=m*(satdfn(X(kk)/X2)-satdfn(X(kk)/X1));
    end
   end
%   sharpening discontinuity
   ii=find(X<X1);
   if length(ii)~=0 & length(ii)<np
    X=[X(ii),X1,X(length(ii)+1:np)];
    DF=[DF(ii),DF(length(ii)),DF(length(ii)+1:np)];
   end
   if nargs==0
    plot(X,DF,'Color',vcol1(1,:),'LineStyle','-')
   else
    if isauto, VV=[-2,2,-1.5,1.5]; axis(VV), end
    [mag,phi,w1]=eval('frespc(z,p,k,5,repco(1),to)'); hold on
%   scaling the inverse DF
    MM=max(abs(DF)); m1=abs(m);
    if ((-1/MM)>VV(1))&(0>VV(3))&(0<VV(4))
     XM=X1; rinvdf=-10^8;
     while (rinvdf<VV(1))&(rinvdf<(-1/MM))
      XM=XM*1.2;
      if XM<=X2
       rinvdf=-1/(m1*(1-satdfn(XM/X1)));
      else
       rinvdf=-1/(m1*(satdfn(XM/X2)-satdfn(XM/X1)));
      end
     end
     XM=XM/1.2; Xm=XM; if Xm==X1, Xm=X1+10^(-8); end
     while rinvdf>VV(1)
      XM=XM*1.2;
      if XM<=X2
       rinvdf=-1/(m1*(1-satdfn(XM/X1)));
      else
       rinvdf=-1/(m1*(satdfn(XM/X2)-satdfn(XM/X1)));
      end
     end
    else
     Xm=VV(1)-10; XM=Xm;
    end
    np=400; X=linspace(Xm,XM,np);
    RIDF=zeros(1,np); IIDF=zeros(1,np);
    for kk=1:np
     if X(kk)<=X2
      RIDF(kk)=-1/(m*(1-satdfn(X(kk)/X1)));
     else
      RIDF(kk)=-1/(m*(satdfn(X(kk)/X2)-satdfn(X(kk)/X1)));
     end
    end
    [mm,ii]=max(-abs(RIDF)); RIDF1=RIDF(1:ii); RIDF2=RIDF(ii:length(RIDF));
    DD=(VV(4)-VV(3))/200;
    IIDF1=DD*ones(1,length(RIDF1)); IIDF2=-DD*ones(1,length(RIDF2));
    ha=plot(RIDF1,IIDF1,[mm,mm],[DD,-DD],RIDF2,IIDF2);
    set(ha(1),'Color',vcol1(6,:),'LineStyle','-')
    set(ha(2),'Color',vcol1(6,:),'LineStyle','-')
    set(ha(3),'Color',vcol1(2,:),'LineStyle','-'), hold off
   end
  elseif izz==4 %  any linearly interpolated nonlinearity
%   computing differences
   dxd=diff(xd); dyd=diff(yd); xdi=[];
%   finite slopes
   ii=find(dxd~=0); xdf=xd(ii); xdf=xdf(2:length(xdf));
   md=dyd(ii)./dxd(ii); mm=-diff(md);
%   infinite slopes
   ii=find(dxd==0); lii=length(ii);
   if lii~=0
    xdi=xd(ii);
    dyi=dyd(ii);
    if xdi(1)==0
     ii=find(xdi==0); syi=sum(dyi(ii));
     if length(xdi)>length(ii)
      xdi=[0,xdi(length(ii)+1:length(xdi))];
      dyi=[syi,dyi(length(ii)+1:length(xdi))];
     else
      xdi=0; dyi=syi;
     end
    end
   end
   lii=lii-length(ii)+1;
   xmax=5*xd(length(xd)-1);
   if isauto
    VV(1)=0; VV(2)=xmax;
   end
%
   if nargs==0
    np=400; X=linspace(VV(1),VV(2),np);
   else
    np=400; X=[linspace(0,xmax,2*np),logspace(log10(xmax),log10(xmax)+2,np)];
    np=3*np;
   end
   DF=zeros(1,np);
   for kk=1:np
    ii=find(xdf<=X(kk)); nsum=length(ii);
    if nsum==0
     DF(kk)=DF(kk)+md(1);
    else
     for hh=1:nsum
      DF(kk)=DF(kk)+(md(hh)-md(hh+1))*satdfn(X(kk)/xdf(hh));
     end
     DF(kk)=DF(kk)+md(nsum+1);
    end
    if lii~=0
     ii=find(xdi<=X(kk)); nsum=length(ii);
     if nsum~=0
      for hh=1:nsum
       if xdi(hh)==0
        DF(kk)=DF(kk)+4*dyi(hh)/(pi*X(kk)+eps);
       else
        DF(kk)=DF(kk)+4*dyi(hh)/(pi*X(kk))*sqrt(1-(xdi(hh)/X(kk))^2);
       end
      end
     end
    end
   end
   if isauto&(xd(2)==0)&(yd(2)~=0)&(nargs==0)
    ii=find(abs(DF)<=10*abs(yd(2))); X=X(ii(1):np); DF=DF(ii(1):np);
   end
%  sharpening discontinuity
   ii=find(xd~=0); X1=xd(ii(1));
   ii=find(X<X1);
   if length(ii)~=0 & length(ii)<length(X)
    X=[X(ii),X1,X(length(ii)+1:length(X))];
    DF=[DF(ii),DF(length(ii)),DF(length(ii)+1:length(DF))];
   end
   if nargs==0
    ha=plot(0,0,X,DF);
    set(ha(1),'Color',vcol1(8,:),'LineStyle','none','Marker','.')
    set(ha(2),'Color',vcol1(1,:),'LineStyle','-')
   else
    if isauto, VV=[-2,2,-1.5,1.5]; axis(VV), end
    [mag,phi,w1]=eval('frespc(z,p,k,5,repco(1),to)'); hold on
    DF=DF+10^(-8); RIDF=-1./DF; IIDF=ones(1,length(RIDF));
    DDF=diff(RIDF); DDF=[DDF(1),DDF]; tol=10^(-8);
    ii1=find(DDF>=tol); ii2=find(DDF<tol);
    RIDF1=RIDF(ii1); RIDF2=RIDF(ii2);
    DD=(VV(4)-VV(3))/200;
    if (length(ii1)==0)|(length(ii2)==0), DD=0; end
    IIDF1=DD*IIDF(ii1); IIDF2=-DD*IIDF(ii2);
    if ~isempty(RIDF1)
     plot(RIDF1,IIDF1,'Color',vcol1(6,:),'LineStyle','-')
    end
    if ~isempty(RIDF2)
     plot(RIDF2,IIDF2,'Color',vcol1(2,:),'LineStyle','-')
    end
   end
  elseif izz==5 %  ideal relay
   Y1=yd(2);
   if nargs==0
    if isauto, xmax=10; VV(1)=0; VV(2)=xmax; end
    np=400; X=linspace(VV(1),VV(2),np); DF=zeros(1,np);
    for kk=1:np
     DF(kk)=4*Y1/(pi*X(kk)+eps);
    end
    if isauto
     ii=find(abs(DF)<=10*abs(Y1)); X=X(ii(1):np); DF=DF(ii(1):np);
    end
    ha=plot(0,0,X,DF);
    set(ha(1),'Color',vcol1(8,:),'LineStyle','none','Marker','.')
    set(ha(2),'Color',vcol1(1,:),'LineStyle','-')
   else
    if isauto, VV=[-2,2,-1.5,1.5]; axis(VV), end
    [mag,phi,w1]=eval('frespc(z,p,k,5,repco(1),to)'); hold on
%   scaling the inverse DF
    XM=.002*(VV(2)-VV(1)); rinvdf=-pi*XM/(4*Y1); iinvdf=0;
    if (0>VV(3))&(0<VV(4))
     while (rinvdf>VV(1))&(rinvdf<VV(2))&(iinvdf>VV(3))&(iinvdf<VV(4))
      XM=XM*1.2; rinvdf=-pi*XM/(4*Y1);
     end
    end
    np=400; X=linspace(0,XM,np); RIDF=zeros(1,np); IIDF=zeros(1,np);
    for kk=1:np
     RIDF(kk)=-(pi*X(kk))/(4*Y1);
    end
    plot(RIDF,IIDF,'Color',vcol1(2,:),'LineStyle','-'), hold off
   end
  elseif izz==6 %  relay with dead zone
   X1=xd(2); Y1=yd(3);
   if isauto, VV(1)=0; VV(2)=10*X1; end
   np=400; X=linspace(VV(1),VV(2),np); DF=zeros(1,np);
   for kk=1:np
    if X(kk)<X1
     DF(kk)=0;
    else
     DF(kk)=(4*Y1/(pi*X(kk)))*sqrt(1-(X1/X(kk))^2);
    end
   end
%   sharpening discontinuity
   ii=find(X<X1);
   if length(ii)~=0 & length(ii)<np
    X=[X(ii),X1,X(length(ii)+1:np)];
    DF=[DF(ii),DF(length(ii)),DF(length(ii)+1:np)];
   end
   if nargs==0
    plot(X,DF,'Color',vcol1(1,:),'LineStyle','-')
   else
    if isauto, VV=[-2,2,-1.5,1.5]; axis(VV), end
    [mag,phi,w1]=eval('frespc(z,p,k,5,repco(1),to)'); hold on
%   scaling the inverse DF
    MM=max(DF);
    XM=X1; rinvdf=-10^8; DD=1;
    if ((-1/MM)>VV(1))&(0>VV(3))&(0<VV(4))
     while (rinvdf>VV(1))|(DD>=0)
      rinvdfp=rinvdf; XM=XM*1.2;
      rinvdf=-1/((4*Y1/(pi*XM))*sqrt(1-(X1/XM)^2));
      DD=rinvdf-rinvdfp;
     end
    end
    np=400; X=logspace(log10(X1*(1+10^(-8))),log10(XM),np);
    RIDF=zeros(1,np); IIDF=zeros(1,np);
    for kk=1:np
     RIDF(kk)=-1/((4*Y1/(pi*X(kk)))*sqrt(1-(X1/X(kk))^2));
    end
    [mm,ii]=max(RIDF); RIDF1=RIDF(1:ii); RIDF2=RIDF(ii:length(RIDF));
    DD=(VV(4)-VV(3))/200;
    IIDF1=DD*ones(1,length(RIDF1)); IIDF2=-DD*ones(1,length(RIDF2));
    ha=plot(RIDF1,IIDF1,[mm,mm],[DD,-DD],RIDF2,IIDF2);
    set(ha(1),'Color',vcol1(6,:),'LineStyle','-')
    set(ha(2),'Color',vcol1(6,:),'LineStyle','-')
    set(ha(3),'Color',vcol1(2,:),'LineStyle','-'), hold off
   end
  elseif izz==7 %  relay with hysteresis
   X1=xd(2); Y1=yd(2);
   if nargs==0
    if isauto, VV(1)=0; VV(2)=10*X1; end
    np=400; X=linspace(max(X1,VV(1)),VV(2),np);
    DF=zeros(1,np); DFp=zeros(1,np);
    for kk=1:np
     DF(kk)=4*abs(Y1)/(pi*X(kk)+eps);
     DFp(kk)=-(180/pi)*asin(X1/X(kk))+90*(sign(Y1)-1);
    end
    ha=plot(0,0,X,DF); Xp=X;
    set(ha(1),'Color',vcol1(8,:),'LineStyle','none','Marker','.')
    set(ha(2),'Color',vcol1(1,:),'LineStyle','-')
   else
    if isauto, VV=[-2,2,-1.5,1.5]; axis(VV), end
    [mag,phi,w1]=eval('frespc(z,p,k,5,repco(1),to)'); hold on
%   scaling the inverse DF
    XM=X1; invdf=-pi*XM/(4*Y1)*(sqrt(1-(X1/XM)^2)+j*(X1/XM));
    if (pi*X1/(4*Y1)>VV(3))&(pi*X1/(4*Y1)<VV(4))
     rinvdf=real(invdf); iinvdf=imag(invdf);
     while (rinvdf>VV(1))&(rinvdf<VV(2))&(iinvdf>VV(3))&(iinvdf<VV(4))
      XM=XM*1.2; invdf=-pi*XM/(4*Y1)*(sqrt(1-(X1/XM)^2)+j*(X1/XM));
      rinvdf=real(invdf); iinvdf=imag(invdf);
     end
    end
    np=400; X=linspace(X1,XM,np); IDF=j*ones(1,np);
    for kk=1:np
     IDF(kk)=-pi*X(kk)/(4*Y1)*(sqrt(1-(X1/X(kk))^2)+j*(X1/X(kk)));
    end
    RIDF=real(IDF); IIDF=imag(IDF);
    plot(RIDF,IIDF,'Color',vcol1(2,:),'LineStyle','-'), hold off
   end
  elseif izz==8 %  backlash
   X1=xd(2); m=md;
   if nargs==0
    if isauto, VV(1)=0; VV(2)=10*X1; end
    np=400; X=linspace(VV(1),VV(2),np); DFr=zeros(1,np); DFi=zeros(1,np);
    for kk=1:np
     if X(kk)<=X1
      DFr(kk)=0; DFi(kk)=0;
     else
      DFr(kk)=(abs(m)/2)*(1+satdfn(X(kk)/(X(kk)-2*X1)));
      DFi(kk)=(abs(m)*4/pi)*X1*(X1-X(kk))/X(kk)^2;
     end
    end
    DF=abs(DFr+j*DFi); DFp=(180/pi)*angle(DFr+j*DFi)+90*(1-sign(m));
    ha=plot(0,0,X,DF); Xp=X;
    set(ha(1),'Color',vcol1(8,:),'LineStyle','none','Marker','.')
    set(ha(2),'Color',vcol1(1,:),'LineStyle','-')
%   sharpening phase discontinuity
    ii=find(Xp<=X1);
    if length(ii)~=0 & length(ii)<np
     Xp=[Xp(ii),X1,X1,Xp(length(ii)+1:np)];
     DFp=[DFp(ii),90*(1-sign(m)),-90+90*(1-sign(m)),DFp(length(ii)+1:np)];
    end
   else
    if isauto, VV=[-2,2,-1.5,1.5]; axis(VV), end
    [mag,phi,w1]=eval('frespc(z,p,k,5,repco(1),to)'); hold on
%   scaling the inverse DF
    XM=X1; rinvdf=-10^8; iinvdf=-10^8;
    if ((-1/m)>VV(1))&(0>VV(3))&(0<VV(4))
     while (rinvdf<VV(1))|(iinvdf<VV(3))
      XM=XM*1.001;
      rdf=(abs(m)/2)*(1+satdfn(XM/(XM-2*X1)));
      idf=(abs(m)*4/pi)*X1*(X1-XM)/XM^2;
      invdf=-1/(rdf+j*idf);
      rinvdf=real(invdf); iinvdf=imag(invdf);
     end
     XM=XM/1.001; if XM==X1, XM=X1+10^(-8); end
    end
    np=400;
    X=logspace(log10(XM),log10(XM)+.01,np);
    X=[X,logspace(log10(XM)+.01,log10(XM)+3,np)];
    IDF=j*ones(1,2*np);
    for kk=1:2*np
     DFr(kk)=(abs(m)/2)*(1+satdfn(X(kk)/(X(kk)-2*X1)));
     DFi(kk)=(abs(m)*4/pi)*X1*(X1-X(kk))/X(kk)^2;
    end
    IDF=-1./(DFr+j*DFi);
    plot(IDF,'Color',vcol1(6,:),'LineStyle','-'), hold off
   end
  end
%
  if flx==1, set(gca,'xtick',xtick), end
  if fly==1, set(gca,'ytick',ytick), end
  flx=0; fly=0;
  if gr==1, grid on, end
  if (izz<=6)|(nargs==1)
   if ~isauto, axis(VV), end
  else
   if isauto, VV=axis; axis(VV), else, axis(VV), end
   hold on
   mess='modulo (g) e argomento (r)';
   text(VV(1)+.15*(VV(2)-VV(1)),VV(3)+.04*(VV(4)-VV(3)),mess)
   VV=axis; minga=VV(3); maxga=VV(4); scale=maxga-minga;
   ytick=get(gca,'ytick'); ndiv=length(ytick)-1;
   minph=min(DFp); maxph=max(DFp);
   minph=30*floor(minph/30+10^(-4)); maxph=30*ceil(maxph/30-10^(-4));
   minstp=3.75; divph=ceil((maxph-minph)/minstp);
   kk=1;
   while divph>ndiv
    kk=kk+1;
    divph=ceil((maxph-minph)/(minstp*kk));
   end
   sstep=minstp*kk; scaleph=ndiv*sstep; minph=maxph-scaleph;
   phi1=minph; phi2=maxph; stepga=scale/ndiv;
   xxt=VV(2)+.02*(VV(2)-VV(1));
   text(xxt,minga,sprintf('%.5g',minph))
   for kk=1:ndiv
    text(xxt,minga+kk*stepga,sprintf('%.5g',minph+kk*sstep))
   end
   scaleph=phi2-phi1; phic=(DFp-phi1)*(scale/scaleph)+minga;
   plot(Xp,phic,'Color',vcol1(2,:),'LineStyle','-'), axis(VV)
  end
  if nargs==0
   title('funzione descrittiva')
  else
   for kk=1:length(hha1), eval('delete(hha1(kk))','err=1;'), end, hha1=[];
   x3n=mag.*cos(phi*pi/180); y3n=mag.*sin(phi*pi/180); omg=w1;
   ncol=1; mg=mag;
   cfsize=get(gca,'FontSize'); fsize=8; lw=length(omg);
   rx=(VV(2)-VV(1))/(2*25); ry=(VV(4)-VV(3))/(1.5*25);
   ii=find((VV(1)<x3n)&(x3n<VV(2))&(VV(3)<y3n)&(y3n<VV(4))&(omg'>0));
   if length(ii)~=0
    hold on
    om1=omg(ii(1)); om2=omg(ii(length(ii)));
    omm=10^floor(log10(om1)); omi=omm;
    ve=[1.2,1.5,1.8,2.2,2.7,3.3,3.9,4.7,5.6,6.8,8.2,10];
    hhr=1; xv=x3n(1); yv=y3n(1); x=xv; y=yv;
    rrp=mg(2)>=mg(1);
    while (omm < om2)
     mx=1; my=1; [zz,kk]=min(abs(omg-omm));
     kk1=kk-1; kk2=kk+1; if kk==1, kk1=1; end, if kk==lw, kk2=lw; end
     ww1=omg(kk1); ww2=omg(kk2); ww=linspace(ww1,ww2,100);
     xx1=x3n(kk1); xx2=x3n(kk2); yy1=y3n(kk1); yy2=y3n(kk2);
     [zz,kh]=min(abs(ww-omm));
     if kh==1, kh=2; end
     x=xx1+(xx2-xx1)*kh/100; y=yy1+(yy2-yy1)*kh/100;
     x0=xx1+(xx2-xx1)*(kh-1)/100; y0=yy1+(yy2-yy1)*(kh-1)/100;
     stri=sprintf(' %.3g',omm);
     rop=(abs(x-xv)>length(stri)*(fsize/cfsize)*.8*rx);
     rop=rop|(abs(y-yv)>(fsize/cfsize)*1.2*ry);
     rop=rop & (omm > om1) & ((abs(x)>rx/2)|(abs(y)>ry/2)|rrp);
     rop=rop & (x>VV(1)) & (x<VV(2)) & (y>VV(3)) & (y<VV(4));
     if rop
      [han1,han2]=arrowl(x0,y0,x,y,rx/2,ry/2,repco(ncol),1);
      hha1=[hha1;han1]; hha1=[hha1;han2];
      xo=x+.5*(fsize/cfsize)*rx; yo=y-.5*(fsize/cfsize)*ry;
      if (x+length(stri)*(fsize/cfsize)*.75*rx)>VV(2)
       xo=x-length(stri)*(fsize/cfsize)*.75*rx; % yo=y+ry;
      end
      nnn=text(xo,yo,stri,'FontSize',fsize); hha1=[hha1;nnn];
      xv=x; yv=y;
     end
     if hhr==length(ve)
      omi=10*omi; omm=omi; hhr=1;
     else
      omm=ve(hhr)*omi; hhr=hhr+1;
     end
    end
   end  % length(ii)
   hold off
   title(['diagrammi polari di ',gi,' e di -1/F(X)'])
  end
  figure(nfig), hold off
 end % if ffp==1
 ABIL=1;
 if ffq==1, xyx=input(['\n   **** figura ',nfigs,' **** '],'s'); end
 clc, disp(' '), ffp=1; ffq=1;
 disp('   MENU :')
 disp(' ')
 disp('   1 - cambiare gli assi di riferimento')
 if gr==0
  disp('   2 - inserire reticolo')
 else
  disp('   2 - eliminare il reticolo')
 end
 if nargs==0
  disp('   3 - calcolare il massimo di F(X)')
  disp('   4 - calcolare valori inversi di F(X)')
  disp('   5 - rivedere la figura')
  disp('   6 - visualizzare l''espressione di F(X)')
 else
  disp('   3 - determinare i possibili cicli limite')
  disp('   4 - introdurre un ritardo finito')
  disp('   5 - rivedere la figura')
  disp('   6 - grafico di F(X) e relative informazioni')
 end
 zoom off, zoom out
 izy=input('\n   operare una scelta (premere invio per uscire) : ');
 if gcf~=nfig, fprintf(ms1), return, end
 if length(izy)==0
  cc=get(0,'Children');
  if any(cc==nfig)
   FIGLO(6,1:4)=get(nfig,'Position');
   save figlo# FIGLO -v4
  else
   disp(' '), disp('   ',EA,' STATA CANCELLATA LA FIGURA!')
  end
  eval('delete(nfig1)','err=1;')
  eval('delete(men_zoom)','err=1;'), eval('delete(men_gr)','err=1;')
  ordf(1), return
 end
 izy=round(izy);
 if nargs==0
  if izy<1 | izy>6, ffp=0; ffq=0; end
 else
  if izy<1 | izy>6, ffp=0; ffq=0; end
  if izy==3, izy=7; end, if izy==6, izy=8; end, if izy==4, izy=9; end
 end
 if izy==1
  clc, VV=axis;
  xtick=get(gca,'xtick'); ytick=get(gca,'ytick');
  divx=xtick(2)-xtick(1); divy=ytick(2)-ytick(1);
  ndiv=round([(VV(2)-VV(1))/divx,(VV(4)-VV(3))/divy]);
  fprintf(['\n   l''intervallo dell''asse x ',eA,' [%.4g %.4g];'],VV(1),VV(2))
  indin=0; while indin==0
  TA1=input('\n   premere invio o specificare nuovi valori: [xm xM] = ');
  ll1=length(TA1); if (ll1==0)|(ll1==2), indin=1; end, end, TA1=sort(TA1);
  fprintf('   numero di divisioni dell''asse x: %.4g;',ndiv(1))
  if ll1==2
   fprintf('\n   premere invio per la messa in scala automatica')
  else
   fprintf('\n   premere invio per conservare la scala precedente')
  end
  indin=0; while indin==0
  ndivt1=input('\n   o specificare un nuovo valore: ndx = ');
  if (length(ndivt1)==0)|(length(ndivt1)==1), indin=1; end, end
  fprintf(['\n   l''intervallo dell''asse y ',eA,' [%.4g %.4g];'],VV(3),VV(4))
  indin=0; while indin==0
  TA2=input('\n   premere invio o specificare nuovi valori: [ym yM] = ');
  ll2=length(TA2); if (ll2==0)|(ll2==2), indin=1; end, end, TA2=sort(TA2);
  fprintf('   numero di divisioni dell''asse y: %.4g;',ndiv(2))
  if ll2==2
   fprintf('\n   premere invio per la messa in scala automatica')
  else
   fprintf('\n   premere invio per conservare la scala precedente')
  end
  indin=0; while indin==0
  ndivt2=input('\n   o specificare un nuovo valore: ndy = ');
  if (length(ndivt2)==0)|(length(ndivt2)==1), indin=1; end, end
  if ll1==2, VV(1)=TA1(1); VV(2)=TA1(2); end
  if ll2==2, VV(3)=TA2(1); VV(4)=TA2(2); end
  if gcf~=nfig, fprintf(ms1), return, end
  rop=(ll1==2)|(ll2==2);
  if rop, axis(VV), end
  if ll1==0, flx=1; end
  if ll2==0, fly=1; end
  if length(ndivt1)~=0
   ndivt1=round(abs(ndivt1)); stepx=(VV(2)-VV(1))/ndivt1;
   xtick=VV(1):stepx:VV(2); flx=1;
  end
  if length(ndivt2)~=0
   ndivt2=round(abs(ndivt2)); stepy=(VV(4)-VV(3))/ndivt2;
   ytick=VV(3):stepy:VV(4); fly=1;
  end
  ffp=1;
 elseif izy==2
  if gr==0
   gr=1; grid on
  else
   gr=0; grid off
  end
  figure(nfig), ffp=0;
 elseif izy==3
  clc
  [DFmm,ii]=max(DF); Xmm=DF(ii);
  kk=find(DF==DFmm);
  if (ii<6 | ii>(length(DF)-5)) & length(kk)==1
   fprintf(['\n   il massimo di F(X) non ',eA' determinabile \n\n'])
  else
   if length(kk)==1
    Xin=linspace(X(ii-5),X(ii+5),201);
    DFin=spline(X(ii-5:ii+5),DF(ii-5:ii+5),Xin);
    [DFmm,ii]=max(DFin); Xmm=Xin(ii);
   end
   VV=axis; axis(VV), hold on
   plot(VV(1:2),[DFmm,DFmm],'Color',vcol1(2,:),'LineStyle',':'),
   if length(kk)==1
    plot([Xmm,Xmm],[VV(3),DFmm],'Color',vcol1(2,:),'LineStyle',':')
   end
   figure(nfig), hold off
   xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   clc, disp(' ')
   fprintf('   [F(x)]_max    : %.4g\n\n',DFmm)
   fprintf('   -1/[F(X)]_max : %.4g\n\n',-1/DFmm)
   if length(kk)==1
    fprintf('   il corrispondente valore di X: %.4g\n\n',Xmm)
   end
  end
  disp('   **** premere un tasto per continuare'), pause
  ffp=0; ffq=0;
 elseif izy==4
  clc, fl1=0;
  while fl1==0
   fli=0;
   while fli==0
    FR=input('\n   specificare il valore di F(X) : ');
    if length(FR)==1, fli=1; end
   end
   Xe=[];
   for kk=1:length(X)-1
    if ((DF(kk)<=FR)&(DF(kk+1)>FR)) | ((DF(kk)>=FR)&(DF(kk+1)<FR))
     Xe=[Xe,X(kk)+(FR-DF(kk))*(X(kk+1)-X(kk))/(DF(kk+1)-DF(kk))];
    end
   end
   VV=axis; axis(VV), hold on
   plot(VV(1:2),[FR,FR],'Color',vcol1(3,:),'LineStyle',':'),
   if length(Xe)~=0
    for kk=1:length(Xe)
     plot([Xe(kk),Xe(kk)],[VV(3),FR],'Color',vcol1(3,:),'LineStyle',':')
    end
   end
   figure(nfig), hold off
   xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   clc, disp(' ')
   fprintf('   valore o valori inversi di F(X) = %.4g :\n\n',FR)
   if length(Xe)==0
    disp('   valori inversi non determinabili')
   else
    for kk=1:length(Xe)
     fprintf('   X%.4g : %.4g\n',kk,Xe(kk))
    end
   end
 mess='\n   introdurre una lettera per un altro punto, invio per il menu : ';
   xyx=input(mess,'s');
   if length(xyx)==0, fl1=1; end
  end
  ffp=0; ffq=0;
 elseif izy==6
  clc, disp(' '), tt=56; aa=setstr(ones(1,tt)*32); tol=10^(-8);
  ab1='   F(X) = ';
  ab2='          ';
  wws=['%.4g            ';
       '%.4g/(pi*X)     ';
       '%.4g*Phi(X/%.4g)';
       '%.4g*Psi(X,%.4g)';
       'per %.4g<=X<%.4g';
       'per %.4g<=X     '];
  lws=[4,11,16,16,16,11];
  ab3='   con    ';
  ab4='Phi(X/X1):=2/pi*[arcsen(X1/X)+X1/X*sqrt(1-(X1/X)^2)]';
  ab5='Psi(X,0):=4/(pi*X); ';
  ab5=[ab5,'Psi(X,X1):=4/(pi*X)*sqrt(1-(X1/X)^2)'];
  disp('   FUNZIONE DESCRITTIVA : ')
  disp(' ')
  if izz==1 %  saturation
   wwm=[1,m,0,0,0,0,5,0,X1;3,m,X1,0,0,0,6,X1,0];
   mesf=1;
  elseif izz==2 %  dead zone
   wwm=[1,0,0,0,0,0,5,0,X1;3,-m,X1,1,m,0,6,X1,0];
   mesf=1;
  elseif izz==3 %  saturation with dead zone
   wwm=[1,0,0,0,0,0,5,0,X1;3,-m,X1,1,m,0,5,X1,X2;3,-m,X1,3,m,X2,6,X2,0];
   mesf=1;
  elseif izz==4 %  any linearly interpolated nonlinearity
   mesff=0; mesfi=0; bound=0;
   ii=find(abs(xd)>tol); xd1=xd(ii(1));
   wwm=[1,md(1),0,0,0,0,5,0,xd1]; rowp=wwm(1:3);
   rop=1;
   if length(xdi)==0, rop=0; end
   if rop==1
    if xdi(1)==0
     if abs(md(1))<tol
      wwm=[4,dyi(1),0,0,0,0,5,0,xd1]; rowp=wwm(1:3);
     else
      wwm=[1,md(1),0,4,dyi(1),0,5,0,xd1]; rowp=wwm(1:6);
     end
    end
   end
   for kk=1:length(xdf)
    row=[];
    for hh=1:kk
     if abs(mm(hh))>tol
     row=[row,3,mm(hh),xdf(hh)]; mesff=1;
     end
    end
    if abs(md(kk+1))>tol
     row=[row,1,md(kk+1),0];
    end
    if lii~=0
     ii=find(xdi<=xdf(kk)); llii=length(ii);
     for hh=1:llii;
      if abs(dyi(hh))>tol
       row=[row,4,dyi(hh),xdi(hh)]; mesfi=1;
      end
     end
    end
    wwr=[];
    rop=1;
    if length(row)==length(rowp)
     if norm(row-rowp)<tol
      rop=0;
     end
    end
    if length(row)~=0 & rop==1
     rowp=row;
     if rem(length(row),6)~=0, row=[row,0,0,0]; end
     for hh=1:length(row)/6
      wwr=[wwr,row(1+(hh-1)*6:6+(hh-1)*6),0,0,0];
      wwm=[wwm;wwr]; wwr=[];
     end
     bound=xdf(kk);
    end
    [mw,nw]=size(wwm);
    wwm(mw,7)=5; wwm(mw,8)=bound;
    if kk<length(xdf), wwm(mw,9)=xdf(kk+1); else, wwm(mw,9)=0; end
   end
   [mw,nw]=size(wwm);
   wwm(mw,7)=6; wwm(mw,9)=0;
   if mesff==1 & mesfi==0
    mesf=1;
   elseif mesff==0 & mesfi==1
    mesf=2;
   elseif mesff==1 & mesfi==1
    mesf=3;
   end
  elseif izz==5 %  ideal relay
   wwm=[2,Y1*4,0,0,0,0,6,0,0];
   mesf=0;
  elseif izz==6 %  relay with dead zone
   wwm=[1,0,0,0,0,0,5,0,X1;4,Y1,X1,0,0,0,6,X1,0];
   mesf=2;
  elseif izz==7 %  relay with hysteresis
   ab=ab1;
   ab=[ab,'non definita'];
   fprintf([ab,aa(1:tt-length(ab))]), fprintf(wws(5,:),0,X1)
   fprintf('\n')
   ab=ab2;
   if Y1>=0, s1='+'; else, s1='-'; end, m1=abs(4*Y1);
   ab=[ab,s1,sprintf('(%.4g/(pi*X))*[sqrt(1-(%.4g/X)^2)',m1,X1)];
   fprintf([ab,'\n'])
   ab=ab2;
   ab=[ab,'-',sprintf('j*%.4g/X]',X1)];
   fprintf([ab,aa(1:tt-length(ab))]), fprintf(wws(6,:),X1)
   fprintf('\n')
  elseif izz==8 %  backlash
   ab=ab1; s1='+';
   str1=wws(1,:); str1=str1(1:lws(1));
   ab=[ab,s1,sprintf(str1,0)];
   fprintf([ab,aa(1:tt-length(ab))]), fprintf(wws(5,:),0,X1)
   fprintf('\n')
   ab=ab2;
   if m>=0, s1='+'; else, s1='-'; end, m1=abs(m);
   ab=[ab,s1,sprintf('%.4g*[1+Phi(X/(X-',m1/2)];
   ab=[ab,sprintf('%.4g))]',2*X1)];
   fprintf([ab,'\n'])
   if m>=0, s1='+'; else, s1='-'; end, m1=abs(4*m*X1);
   ab=ab2;
   ab=[ab,s1,sprintf('j*%.4g',m1)];
   ab=[ab,sprintf('*(%.4g-X)/(pi*X^2)',X1)];
   fprintf([ab,aa(1:tt-length(ab))]), fprintf(wws(6,:),X1)
   fprintf('\n\n')
   ab5=' Phi(x):=(2/pi)*[asin(1/x)+(1/x)*sqrt(1-(1/x)^2)]';
   fprintf([ab3,ab5,'.\n'])
  end
  if izz<=6
   [mw,nw]=size(wwm);
   for hh=1:mw
    if hh==1, ab=ab1; else, ab=ab2; end
    if wwm(hh,2)>=0, s1='+'; else, s1='-'; end, m1=abs(wwm(hh,2));
    str1=wws(wwm(hh,1),:); str1=str1(1:lws(wwm(hh,1)));
    if (wwm(hh,1)==1)|(wwm(hh,1)==2)|(wwm(hh,1)==6)
     ab=[ab,s1,sprintf(str1,m1)];
    else
     ab=[ab,s1,sprintf(str1,m1,wwm(hh,3))];
    end
    if wwm(hh,4)~=0
     if wwm(hh,5)>=0, s1='+'; else, s1='-'; end, m1=abs(wwm(hh,5));
     str1=wws(wwm(hh,4),:); str1=str1(1:lws(wwm(hh,4)));
     if (wwm(hh,4)==1)|(wwm(hh,4)==2)|(wwm(hh,4)==6)
      ab=[ab,s1,sprintf(str1,m1)];
     else
      ab=[ab,s1,sprintf(str1,m1,wwm(hh,6))];
     end
    end
    fprintf([ab,aa(1:tt-length(ab))])
    if wwm(hh,7)~=0
     str1=wws(wwm(hh,7),:); str1=str1(1:lws(wwm(hh,7)));
     x1=wwm(hh,8);
     if (wwm(hh,7)==1)|(wwm(hh,7)==2)|(wwm(hh,7)==6)
      fprintf(str1,x1)
     else
      fprintf(str1,x1,wwm(hh,9))
     end
    end
   fprintf('\n')
   end
   disp(' ')
   if mesf==1;
    fprintf([ab3,ab4,'.\n'])
   elseif mesf==2
    fprintf([ab3,ab5,'.\n'])
   elseif mesf==3
    fprintf([ab3,ab4,';\n',ab2,ab5,'.\n'])
   end
  end
  disp(' ')
  disp('   **** premere un tasto per proseguire'), pause
  ffp=0; ffq=0;
 elseif izy==5
  figure(nfig), ffp=0;
 elseif izy==7
  if izz==8
   MIDF=abs(IDF); PIDF=angle(IDF)*180/pi; ndf=length(IDF);
   nw=length(w1); ii=find(mag<MIDF(1)); mag=mag(ii(1):nw); phi=phi(ii(1):nw);
   w1=w1(ii(1):nw); np=length(w1);
   RIDF=zeros(1,np-1); RX=zeros(1,np-1);
   for kk=1:(np-1)
    [ddd,ii1]=min(abs(MIDF-mag(kk)));
    if ii1==ndf
     RIDF(kk)=-MIDF(ndf); pidf=PIDF(ndf); RX(kk)=X(ndf);
    else
     if (MIDF(ii1)>mag(kk))&(ii1>1), ii1=ii1-1; end
     ii2=ii1+1;
     midf1=MIDF(ii1); midf2=MIDF(ii2); pidf1=PIDF(ii1); pidf2=PIDF(ii2);
     X1=X(ii1); X2=X(ii2);
     pidf=pidf1; rxf=X1;
     if midf2~=midf1
      pidf=pidf+(mag(kk)-midf1)*(pidf2-pidf1)/(midf2-midf1);
      rxf=rxf+(mag(kk)-midf1)*(X2-X1)/(midf2-midf1); % graduazione di RIDF
     end
     RIDF(kk)=-mag(kk); RX(kk)=rxf;
    end
    phi(kk)=-180-pidf+phi(kk);
   end
   ii=find(RIDF==-MIDF(ndf)); if isempty(ii), ii=np-1; end
   RIDF=RIDF(1:ii(1)); IIDF=zeros(1,ii(1)); X=RX(1:ii(1));
  end
  clc
  fr=mag.*exp(j*phi*pi/180);
  xr=real(fr); yr=imag(fr);
  if izz==7
   shi=IIDF(round(length(IIDF)/2));
   yr=yr-shi;
  end
  delyr=[yr(2:length(yr));yr(length(yr))];
  ii=find((((yr>=0)&(delyr<=0))|((yr<=0)&(delyr>=0)))&(xr<=0)); %5.3
  rr=min(14,length(ii));
  xm=zeros(1,rr); wm=zeros(1,rr);
  for kk=1:rr
   iii=ii(kk); yri=yr(iii); delyri=delyr(iii); xri=xr(iii);
   if delyr(kk)~=0
    xr1=xr(iii); xr2=xr(iii+1); yr1=yr(iii); yr2=yr(iii+1);
    xm(kk)=xr1-yr1*(xr2-xr1)/(yr2-yr1);
    ww1=w1(iii); ww2=w1(iii+1);
    wm(kk)=ww1-yr1*(ww2-ww1)/(yr2-yr1);
   end
  end
  disp(' ')
  if (izz==7)|(izz==8)
   disp(['   INTERSEZIONI DI ',gi,'(j*omega) CON IL GRAFICO DI -1/F(x):'])
  else
   disp(['   INTERSEZIONI DI ',gi,'(j*omega) CON L''ASSE REALE NEGATIVO:'])
  end
  disp(' ')
  if isempty(ii)
   fprintf('   nessuna intersezione\n')
  else
   for kk=1:rr
    fprintf('   intersezione in ')
    fprintf(['Re(',gi,') = %.4g'],xm(kk))
    fprintf(' (pulsazione: %.4g rad/sec)\n',wm(kk))
   end
  end
  disp(' ')
  disp(['   INTERSEZIONI DI ',gi,'(j*omega) CON -1/F(X) (CICLI LIMITE)'])
  disp('   (solo quelle nella figura - cambiare gli assi se necessario):')
  disp(' ')
  Xe=[];
  for kk=1:rr
   for hh=1:length(X)-1
    if ((RIDF(hh)<xm(kk))&(RIDF(hh+1)>xm(kk)))|...
    ((RIDF(hh)>=xm(kk))&(RIDF(hh+1)<xm(kk)))
     Xe=X(hh)+(xm(kk)-RIDF(hh))*(X(hh+1)-X(hh))/(RIDF(hh+1)-RIDF(hh));
     fprintf('   intersezione per X = %.4g',Xe)
     fprintf(' (pulsazione: %.4g rad/sec)\n',wm(kk))
    end
   end
  end
  if isempty(Xe), disp('   nessuna intersezione'), end
  disp(' '), disp(' '), disp(ms2), pause
  ffp=0; ffq=0; % opzioni per i calcoli e la figura
 elseif izy==8
  clf, nargs=0; ffp=1;
  men_opt=uimenu(nfig,'Label','Memo');
  men_gr=uimenu(nfig,'Label','Reticolo on/off','Callback','gridmng(1)');
  men_zoom=uimenu(nfig,'Label','Zoom on/off','Callback','gridmng(7)');
  mess=['NL : ',mess1,' (vedere il grafico)'];
  uimenu(men_opt,'Label',mess,'Callback','gridmng(3)');
 elseif izy==9
  flgde=1;
  while flgde==1
   mess='\n   ritardo finito (sec) - default zero : ';
   to=input(mess); flgde=0;
   if length(to)==0
    to=0;
   elseif to<0
    disp(' **** errore: ritardo negativo'); flgde=1;
   end
  end
  mess=['delay : ',num2str(to)];
  if flguic, delete(dddd), end
  dddd=uimenu(men_opt,'Label',mess); flguic=1;
  ffp=1;
 end
 if gcf~=nfig, fprintf(ms1), return, end
end
% --- last line of descrf ---
