function deftfaux(typ)
%DEFTFAUX Auxiliary file for graphic management related to deftf.
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global nfig pbs VV gr str repco HA HA1 HA2 zcomp pcomp kcomp kcomps...
 TT mens men_gr gj vcol1 vcol2 ncol mess1 mess2 mx1 mx2...
 stkn1 stkd1 stkn2 stkd2 stkn3 stkd3 stkn4 stkd4 stkn5 stkd5 stkn6 stkd6...
 stkn7 stkd7 TSAMP SC

oA=setstr(242); EA=setstr(200);
flg=0;
if ((typ>=1)&(typ<=4))
 set(men_gr,'Enable','off')
 set(mens,'Enable','off')
 set(pbs(12),'Visible','off')
 set(pbs(20),'String',mx2)
end
if typ==1
 mess=['Scegliere la posizione di uno zero reale o una coppia di zeri ',...
 'complessi.'];
 set(pbs(21),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 mess=['Si pu',oA,' ripetere la scelta col pulsante 1 del mouse. ',...
 'Il pulsante 2 la conferma.'];
 set(pbs(22),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 bb=1; hh=0; hold on
 while bb==1
  [x1s,y1s,bb]=ginput(1);
  if isempty(bb), bb=2; end
  if hh==0, bb=1; end
  if bb==1
   x1=x1s; y1=y1s;
   if hh~=0
    for kk=1:length(ha)
     delete(ha(kk))
    end
   end
   set(pbs(20),'Visible','on')
   if y1<=0
    ha=plot(x1,0,'Color',vcol1(ncol,:),'LineStyle','none',...
    'Marker','o','LineWidth',2);
    if str=='s'
     if (abs(x1)<4*10^(-3)*(VV(2)-VV(1))), x1=0; end
    else
     if (abs(x1-1)<4*10^(-3)*(VV(2)-VV(1))), x1=1; end
    end
    zcomp1=x1;
    mess=sprintf('z = %.3g',x1);
    set(pbs(16),'ForegroundColor',vcol2(ncol,:),'Visible','on','String',mess)
    set(pbs(17),'Visible','off')
   else
    ha=plot([x1,x1],[-y1,y1],'Color',vcol1(ncol,:),'LineStyle','none',...
    'Marker','o','LineWidth',2);
    zcomp1=[x1+j*y1;x1-j*y1];
    mess=sprintf('z1 = %.3g',x1); mess=[mess,sprintf('+j*%.3g',y1)];
    set(pbs(16),'ForegroundColor',vcol2(ncol,:),'Visible','on','String',mess)
    mess=sprintf('z2 = %.3g',x1); mess=[mess,sprintf('-j*%.3g',y1)];
    set(pbs(17),'ForegroundColor',vcol2(ncol,:),'Visible','on','String',mess)
   end
  end
  hh=1;
 end
 zcomp=[zcomp;zcomp1]; HA1=[HA1;ha];
 set(pbs(3),'Enable','on')
 set(pbs(21),'String',mess1,'ForegroundColor',vcol2(9,:))
 set(pbs(22),'String',mess2,'ForegroundColor',vcol2(9,:))
 set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
elseif typ==2
 mess=[' Scegliere uno zero reale o una coppia di zeri complessi ',...
 'da eliminare.'];
 set(pbs(21),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 set(pbs(22),'Visible','off')
 xtick=get(gca,'Xtick'); ytick=get(gca,'Ytick');
 bb=1; hh=0; hold on
 [x1s,y1s,bb]=ginput(1);
 if (x1s<VV(1))|(bb~=1)
  set(mens,'Enable','on')
  set(men_gr,'Enable','on')
  set(pbs(21),'String',mess1,'ForegroundColor',vcol2(9,:))
  set(pbs(22),'Visible','on')
  set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
  set(pbs(20),'String',mx1,'ForegroundColor',vcol2(9,:),'Visible','on')
  return
 end
 x1=x1s; y1=y1s;
 zcomp1=x1+j*y1;
 ii=ones(1,length(zcomp));
 [zzz,iim]=min(abs(zcomp-zcomp1)); ii(iim)=0;
 if imag(zcomp(iim))~=0
  [zzz,iim]=min(abs(zcomp-conj(zcomp(iim)))); ii(iim)=0;
 end
 ii=find(ii); zcomp=zcomp(ii);
 for kk=1:length(HA1), eval('delete(HA1(kk))','err=1;'), end
 HA1=[];
 if ~isempty(zcomp)
  ha=plot(real(zcomp),imag(zcomp),'Color',vcol1(ncol,:),'LineStyle','none',...
  'Marker','o','LineWidth',2); HA1=[HA1;ha];
 end
 if ~isempty(pcomp)
  ha=plot(real(pcomp),imag(pcomp),'Color',vcol1(ncol,:),'LineStyle','none',...
  'Marker','x','MarkerSize',10,'LineWidth',2); HA1=[HA1;ha];
 end
 if isempty(zcomp), set(pbs(3),'Enable','off'), end
 set(pbs(21),'String',mess1,'ForegroundColor',vcol2(9,:))
 set(pbs(22),'Visible','on')
 set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
elseif typ==3
 mess=['Scegliere la posizione di un polo reale o una coppia di poli ',...
 'complessi.'];
 set(pbs(21),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 mess=['Si pu',oA,' ripetere la scelta col pulsante 1 del mouse. ',...
 'Il pulsante 2 la conferma.'];
 set(pbs(22),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 bb=1; hh=0; hold on
 while bb==1
  [x1s,y1s,bb]=ginput(1);
  if isempty(bb), bb=2; end
  if hh==0, bb=1; end
  if bb==1
   x1=x1s; y1=y1s;
   if hh~=0
    for kk=1:length(ha)
     delete(ha(kk))
    end
   end
   set(pbs(20),'Visible','on')
   if y1<=0
    ha=plot(x1,0,'Color',vcol1(ncol,:),'LineStyle','none',...
    'Marker','x','MarkerSize',10,'LineWidth',2); y1=0;
    if str=='s'
     if (abs(x1)<10^(-3)*(VV(2)-VV(1))), x1=0; end
    else
     if (abs(x1-1)<10^(-3)*(VV(2)-VV(1))), x1=1; end
    end
    pcomp1=x1;
    mess=sprintf('p = %.3g',x1);
    set(pbs(16),'ForegroundColor',vcol2(ncol,:),'Visible','on','String',mess)
    set(pbs(17),'Visible','off')
   else
    ha=plot([x1,x1],[-y1,y1],'Color',vcol1(ncol,:),'LineStyle','none',...
    'Marker','x','MarkerSize',10,'LineWidth',2);
    pcomp1=[x1+j*y1;x1-j*y1];
    mess=sprintf('p1 = %.3g',x1); mess=[mess,sprintf('+j*%.3g',y1)];
    set(pbs(16),'ForegroundColor',vcol2(ncol,:),'Visible','on','String',mess)
    mess=sprintf('p2 = %.3g',x1); mess=[mess,sprintf('-j*%.3g',y1)];
    set(pbs(17),'ForegroundColor',vcol2(ncol,:),'Visible','on','String',mess)
   end
  end
  hh=1;
 end
 pcomp=[pcomp;pcomp1]; HA1=[HA1;ha];
 set(pbs(5),'Enable','on')
 set(pbs(21),'String',mess1,'ForegroundColor',vcol2(9,:))
 set(pbs(22),'String',mess2,'ForegroundColor',vcol2(9,:))
 set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
elseif typ==4
 mess=[' Scegliere un polo reale o una coppia di poli complessi ',...
 'da eliminare.'];
 set(pbs(21),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 set(pbs(22),'Visible','off')
 xtick=get(gca,'Xtick'); ytick=get(gca,'Ytick');
 bb=1; hh=0; hold on
 [x1s,y1s,bb]=ginput(1);
 if (x1s<VV(1))|(bb~=1)
  set(mens,'Enable','on')
  set(men_gr,'Enable','on')
  set(pbs(21),'String',mess1,'ForegroundColor',vcol2(9,:))
  set(pbs(22),'Visible','on')
  set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
  return
 end
 x1=x1s; y1=y1s;
 pcomp1=x1+j*y1;
 ii=ones(1,length(pcomp));
 [zzz,iim]=min(abs(pcomp-pcomp1)); ii(iim)=0;
 if imag(pcomp(iim))~=0
  [zzz,iim]=min(abs(pcomp-conj(pcomp(iim)))); ii(iim)=0;
 end
 ii=find(ii); pcomp=pcomp(ii);
 for kk=1:length(HA1), eval('delete(HA1(kk))','err=1;'), end
 HA1=[];
 if ~isempty(zcomp)
  ha=plot(real(zcomp),imag(zcomp),'Color',vcol1(ncol,:),'LineStyle','none',...
  'Marker','o','LineWidth',2); HA1=[HA1;ha];
 end
 if ~isempty(pcomp)
  ha=plot(real(pcomp),imag(pcomp),'Color',vcol1(ncol,:),'LineStyle','none',...
  'Marker','x','MarkerSize',10,'LineWidth',2); HA1=[HA1;ha];
 end
 if isempty(pcomp), set(pbs(5),'Enable','off'), end
 set(pbs(21),'String',mess1,'ForegroundColor',vcol2(9,:))
 set(pbs(22),'Visible','on')
 set(pbs(16),'Visible','off'), set(pbs(17),'Visible','off')
end
if ((typ>=1)&(typ<=4))
 kcomps=kcomp;
 if ~isempty(zcomp)
  if str=='s'
   for kk=1:length(zcomp),
    if zcomp(kk)~=0, kcomps=kcomps*(-zcomp(kk)); end
   end
  else
   for kk=1:length(zcomp)
    if zcomp(kk)~=1, kcomps=kcomps*(1-zcomp(kk)); end
   end
  end
 end
 if ~isempty(pcomp)
  if str=='s'
   for kk=1:length(pcomp)
    if pcomp(kk)~=0, kcomps=kcomps/(-pcomp(kk)); end
   end
  else
   for kk=1:length(pcomp)
    if pcomp(kk)~=1, kcomps=kcomps/(1-pcomp(kk)); end
   end
  end
 end
 kcomps=real(kcomps);
% mess=sprintf('K = %.3g',kcomp);
% set(pbs(13),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 mess=sprintf('Ks = %.3g',kcomps);
 set(pbs(14),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 nz=length(zcomp); np=length(pcomp);
 mess=sprintf('nz = %i',nz); mess=[mess,sprintf(', np = %i',np)];
 set(pbs(15),'String',mess)
 [numc,denc]=dezpk(zcomp,pcomp,kcomp);
 eval(['stkn',int2str(ncol),'=numc;'])
 eval(['stkd',int2str(ncol),'=denc;'])
 set(mens,'Enable','on')
 set(men_gr,'Enable','on')
 set(pbs(12),'Visible','on'), set(pbs(20),'Visible','off')
end
if (typ==2)|(typ==4)
 axis(VV); set(gca,'Xtick',xtick), set(gca,'Ytick',ytick)
 figure(gcf)
end
if typ==5 % set Ks to one
 if kcomps~=0
  kcomp=kcomp/kcomps;
 else
  kcomp=Inf;
 end
 kcomps=1;
 mess=sprintf('K = %.3g',kcomp);
 set(pbs(13),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 mess=sprintf('Ks = %.3g',kcomps);
 set(pbs(14),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 [numc,denc]=dezpk(zcomp,pcomp,kcomp);
 eval(['stkn',int2str(ncol),'=numc;'])
 eval(['stkd',int2str(ncol),'=denc;'])
elseif typ==6 % Reset this z/p map
 for kk=1:length(HA1), eval('delete(HA1(kk))','err=1;'), end
 HA1=[];
 zcomp=[]; pcomp=[]; kcomp=1; kcomps=1;
 set(pbs(3),'Enable','off'), set(pbs(5),'Enable','off'),
 mess=sprintf('K = %.3g',kcomp);
 set(pbs(13),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 mess=sprintf('Ks = %.3g',kcomps);
 set(pbs(14),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 nz=length(zcomp); np=length(pcomp);
 mess=sprintf('nz = %i',nz); mess=[mess,sprintf(', np = %i',np)];
 set(pbs(15),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 [numc,denc]=dezpk(zcomp,pcomp,kcomp);
 eval(['stkn',int2str(ncol),'=numc;'])
 eval(['stkd',int2str(ncol),'=denc;'])
elseif typ==7 % Another p/z map
 if ncol<7
  [numc,denc]=dezpk(zcomp,pcomp,kcomp);
  eval(['stkn',int2str(ncol),'=numc;'])
  eval(['stkd',int2str(ncol),'=denc;'])
% for kk=1:length(HA1), eval('delete(HA1(kk))','err=1;'), end
  HA2=[HA2;HA1]; HA1=[];
  ncol=ncol+1;
  zcomp=[]; pcomp=[]; kcomp=1; kcomps=1;
  set(pbs(3),'Enable','off'), set(pbs(5),'Enable','off'),
  mess=sprintf('K = %.3g',kcomp);
  set(pbs(13),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
  mess=sprintf('Ks = %.3g',kcomps);
  set(pbs(14),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
  nz=length(zcomp); np=length(pcomp);
  mess=sprintf('nz = %i',nz); mess=[mess,sprintf(', np = %i',np)];
  set(pbs(15),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 end
end
if typ==8
 nfig1=nfig+1; cc=get(0,'Children');
 if ~any(cc==nfig1)
  disp(' '), disp(['   ',EA,' STATA CANCELLATA UNA FIGURA!']), return
 end
 figure(nfig1), cla, set(gca,'Box','on')
 if pbs(63)==0
  set(pbs(31),'Enable','on'), set(pbs(61),'Enable','on')
  set(pbs(62),'Enable','on'), pbs(63)=1;
 end
 set(pbs(25),'Visible','on'), set(pbs(26),'Visible','on')
 for kk=1:ncol
  rr=pbs(40+kk); eval('delete(rr)','err=1;')
 end
 for kk=1:ncol
  mess=[gj,', colore ',repco(kk)];
  if str=='s'
   cbk=['ccregaux(6,',int2str(kk),',.1)'];
  else
   cbk=['ccregaux(6,',int2str(kk),',.1,1)'];
  end
  pbs(40+kk)=uimenu(pbs(31),'Label',mess,'Callback',cbk);
 end
 drawnow, reset(gca), set(gca,'Box','on'), err=0; NPKK=0;
 if ncol==1
  if str=='s'
   if length(zcomp)<=(length(pcomp)+1)
    [y,t]=trespc(zcomp,[pcomp;0],kcomp,repco(1)); TT=axis;
   else
    err=1;
   end
  else
   if length(zcomp)<=length(pcomp)
    [y,t]=trespd([zcomp;0],[pcomp;1],kcomp,repco(1)); TT=axis;
    TT(2)=TT(2)*TSAMP; axis(TT)
    [y,t]=trespd([zcomp;0],[pcomp;1],kcomp,TSAMP,TT(2),repco(1)); TT=axis;
   else
    err=1;
   end
  end
 else % ncol~=1
  TTM=0; YYm=0; YYM=0; hh=1:ncol;
  for kk=1:ncol
   eval(['numc=stkn',int2str(kk),';'])
   eval(['denc=stkd',int2str(kk),';'])
   [z0,p0,k0]=tozpk(numc,denc);
   if str=='s'
    if length(z0)<=(length(p0)+1)
     [y,t]=trespc(z0,[p0;0],k0,repco(kk)); TT=axis;
     TTM=max([TTM,TT(2)]);
     YYm=min([YYm,TT(3)]); YYM=max([YYM,TT(4)]);
    else
     err=1; hh(kk)=0;
    end
   else
    if length(z0)<=length(p0)
     [y,t]=trespd([z0;0],[p0;1],k0,repco(kk)); TT=axis;
     TTM=max([TTM,TT(2)*TSAMP]);
     YYm=min([YYm,TT(3)]); YYM=max([YYM,TT(4)]);
    else
     err=1; hh(kk)=0;
    end
   end
   reset(gca)
  end
  TT=[0,TTM,YYm,YYM];
  hh=hh(find(hh)); flg1=1;
  for kk=hh
   eval(['num0=stkn',int2str(kk),';'])
   eval(['den0=stkd',int2str(kk),';'])
   [z0,p0,k0]=tozpk(num0,den0);
   if flg1==1, axis(TT), flg1=0; end
   if str=='s'
    [y,t]=trespc(z0,[p0;0],k0,repco(kk)); hold on
   else
    [y,t]=trespd([z0;0],[p0;1],k0,TSAMP,TT(2),repco(kk)); hold on
   end
  end
  hold off
 end
 if err==1
  set(pbs(25),'String','grado relativo non consentito'), pause(1)
  set(pbs(25),'Visible','off')
  set(pbs(25),'String','ATTENDERE, PREGO')
 end
 set(pbs(25),'Visible','off')
elseif typ==9
 nfig2=nfig+2; cc=get(0,'Children');
 if ~any(cc==nfig2)
  disp(' '), disp(['   ',EA,' STATA CANCELLATA UNA FIGURA!']), return
 end
 figure(nfig2)
 if pbs(65)==0
  set(pbs(32),'Enable','on'), set(pbs(64),'Enable','on'), pbs(65)=1;
 end
 set(pbs(27),'Visible','on'), set(pbs(28),'Visible','on')
 subplot(2,1,1), cla, set(gca,'Box','on')
 subplot(2,1,2), cla, set(gca,'Box','on')
 for kk=1:ncol
  rr=pbs(50+kk); eval('delete(rr)','err=1;')
 end
 for kk=1:ncol
  mess=[gj,', colore ',repco(kk)];
  if str=='s'
   cbk=['ccregaux(8,',int2str(kk),',.1)'];
  else
   cbk=['ccregaux(8,',int2str(kk),',.1,1)'];
  end
  pbs(50+kk)=uimenu(pbs(32),'Label',mess,'Callback',cbk);
 end
 drawnow, subplot(2,1,1), reset(gca), subplot(2,1,2), reset(gca)
 if ncol==1
  if str=='s'
   [mag,phi,om]=frespc(zcomp,pcomp,kcomp,3,repco(1));
  else
   [mag,phi,om]=frespd(zcomp,pcomp,kcomp,TSAMP,3,repco(1));
  end
  subplot(2,1,1), GG=axis; GG(1)=om(1); GG(2)=om(length(om)); axis(GG)
  subplot(2,1,2), PP=axis; PP(1)=om(1); PP(2)=om(length(om)); axis(PP)
 else % ncol~=1
  GGm=10^8; GGM=-10^8; PPm=10^8; PPM=-10^8; OMm=10^30; OMM=0;
  for kk=1:ncol
   eval(['num0=stkn',int2str(kk),';'])
   eval(['den0=stkd',int2str(kk),';'])
   [z0,p0,k0]=tozpk(num0,den0);
   if str=='s'
    [mag,phi,om]=frespc(z0,p0,k0,3,repco(1));
   else
    [mag,phi,om]=frespd(z0,p0,k0,TSAMP,3,repco(1));
   end
   subplot(2,1,1), GG=axis; subplot(2,1,2), PP=axis;
   GGm=min([GGm,GG(3)]); GGM=max([GGM,GG(4)]);
   PPm=min([PPm,PP(3)]); PPM=max([PPM,PP(4)]);
   OMm=min([OMm,GG(1)]); OMM=max([OMM,GG(2)]);
   subplot(2,1,1), reset(gca), subplot(2,1,2), reset(gca)
  end
  GG=[OMm,OMM,GGm,GGM]; PP=[OMm,OMM,PPm,PPM];
  for hh=1:2
   for kk=1:ncol
    eval(['num0=stkn',int2str(kk),';'])
    eval(['den0=stkd',int2str(kk),';'])
    [z0,p0,k0]=tozpk(num0,den0);
    if str=='s'
     [mag,phi,om]=frespc(z0,p0,k0,3.5,OMm,OMM,repco(1));
    else
     [mag,phi,om]=frespd(z0,p0,k0,TSAMP,3.5,OMm,repco(1));
    end
    ssn=[0 0]; ss2=[-180 -180];
    aat=setstr(32*ones(1,120)); aam=sprintf('rad/sec');
    mess=[aat(1:120-length(aam)),aam];
    if hh==1
     if kk==1, subplot(2,1,1), end
     mag1=20*log10(mag);
     semilogx(om,mag1,'Color',vcol1(kk,:),'LineStyle','-')
     if kk==1, axis(GG), hold on, end
     if kk==ncol
      rr=[GG(1),GG(2)];
      semilogx(rr,ssn,'Color',vcol1(7,:),'LineStyle','--')
      title('ampiezza'), xlabel(mess)
      aat=setstr(32*ones(1,35)); aam=sprintf('db');
      mesx1=[aat(1:35-length(aam)),aam]; ylabel(mesx1), hold off
     end
    else
     if kk==1, subplot(2,1,2), end
     semilogx(om,phi,'Color',vcol1(kk,:),'LineStyle','-')
     if kk==1, axis(PP), hold on, end
     if kk==ncol
      rr=[PP(1),PP(2)];
      semilogx(rr,ss2,'Color',vcol1(7,:),'LineStyle','--')
      title('fase'), xlabel(mess)
      aat=setstr(32*ones(1,35)); aam=sprintf('gradi');
      mesx1=[aat(1:35-length(aam)),aam]; ylabel(mesx1), hold off
     end
    end
   end
  end
 end
 set(pbs(27),'Visible','off')
elseif typ==10
 for kk=1:ncol
  rr=pbs(40+kk); eval('delete(rr)','err=1;')
  rr=pbs(50+kk); eval('delete(rr)','err=1;')
 end
 ncol=1;
 for kk=1:length(HA2), eval('delete(HA2(kk))','err=1;'), end
 HA2=[];
 for kk=1:length(HA1), eval('delete(HA1(kk))','err=1;'), end
 HA1=[];
 zcomp=[]; pcomp=[]; kcomp=1; kcomps=1;
 set(pbs(3),'Enable','off'), set(pbs(5),'Enable','off'),
 mess=sprintf('K = %.3g',kcomp);
 set(pbs(13),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 mess=sprintf('Ks = %.3g',kcomps);
 set(pbs(14),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 nz=length(zcomp); np=length(pcomp);
 mess=sprintf('nz = %i',nz); mess=[mess,sprintf(', np = %i',np)];
 set(pbs(15),'String',mess,'ForegroundColor',vcol2(ncol,:),'Visible','on')
 [numc,denc]=dezpk(zcomp,pcomp,kcomp);
 eval(['stkn',int2str(ncol),'=numc;'])
 eval(['stkd',int2str(ncol),'=denc;'])
end
if (typ>=11)&(typ<=24)
 if length(HA)~=0
  for kk=1:length(HA), eval('delete(HA(kk))','err=1;'), end
  HA=[]; flg=1;
 end
end
if typ==11
 xtick=get(gca,'Xtick');
 if length(xtick)>2
  dd=xtick(2)-xtick(1); VV(1)=VV(1)-dd;
  xtick=VV(1):dd:VV(2); set(gca,'Xtick',xtick), axis(VV)
 end
elseif typ==12
 xtick=get(gca,'Xtick');
 if length(xtick)>2
  dd=xtick(2)-xtick(1); VV(1)=VV(1)+dd;
  xtick=VV(1):dd:VV(2); set(gca,'Xtick',xtick), axis(VV)
 end
elseif typ==13
 xtick=get(gca,'Xtick');
 if length(xtick)>2
  dd=xtick(2)-xtick(1); VV(2)=VV(2)+dd;
  xtick=VV(1):dd:VV(2); set(gca,'Xtick',xtick), axis(VV)
 end
elseif typ==14
 xtick=get(gca,'Xtick');
 if length(xtick)>2
  dd=xtick(2)-xtick(1); VV(2)=VV(2)-dd;
  xtick=VV(1):dd:VV(2); set(gca,'Xtick',xtick), axis(VV)
 end
elseif typ==15
 ytick=get(gca,'Ytick');
 if length(ytick)>3
  dd=ytick(2)-ytick(1); VV(4)=VV(4)+dd; VV(3)=-VV(4);
  ytick=VV(3):dd:VV(4); set(gca,'Ytick',ytick), axis(VV)
 end
elseif typ==16
 ytick=get(gca,'Ytick');
 if length(ytick)>3
  dd=ytick(2)-ytick(1); VV(4)=VV(4)-dd; VV(3)=-VV(4);
  ytick=VV(3):dd:VV(4); set(gca,'Ytick',ytick), axis(VV)
 end
elseif typ==17
 VVV=VV(1)*2;
 if VVV<VV(2), VV(1)=VVV; set(gca,'XTickMode','auto'), axis(VV), end
elseif typ==18
 VVV=VV(1)/2;
 if VVV<VV(2), VV(1)=VVV; set(gca,'XTickMode','auto'), axis(VV), end
elseif typ==19
 VVV=VV(2)*2;
 if VVV>VV(1), VV(2)=VVV; set(gca,'XTickMode','auto'), axis(VV), end
elseif typ==20
 VVV=VV(2)/2;
 if VVV>VV(1), VV(2)=VVV; set(gca,'XTickMode','auto'), axis(VV), end
elseif typ==21
 VV(4)=VV(4)*2; VV(3)=-VV(4); set(gca,'YTickMode','auto'), axis(VV)
elseif typ==22
 VV(4)=VV(4)/2; VV(3)=-VV(4); set(gca,'YTickMode','auto'), axis(VV)
elseif typ==23
 VV=VV/2; set(gca,'XTickMode','auto'), set(gca,'YTickMode','auto'), axis(VV)
elseif typ==24
 VV=VV*2; set(gca,'XTickMode','auto'), set(gca,'YTickMode','auto'), axis(VV)
end
if (typ>=11)&(typ<=24)
 if flg==1
  if strcmp(str,'s')
   HA=rgrid;
  else
   HA=drgrid;
  end
 end
end
if typ==30
% eval('delete(pbs(23))','err=1;'), eval('delete(pbs(24))','err=1;')
% set(pbs(26),'Visible','off'), set(pbs(28),'Visible','off'),
 figure(nfig)
elseif typ==25
 TT1=TT; TT1(2)=TT1(2)/2+.001*(TT1(2)/2-TT1(1)); axis(TT1)
 set(gca,'XTickMode','auto'), drawnow
elseif typ==26
 TT1=TT; TT1(2)=TT1(2)/5+.001*(TT1(2)/5-TT1(1)); axis(TT1)
 set(gca,'XTickMode','auto'), drawnow
elseif typ==27
 TT1=TT; TT1(2)=TT1(2)/10+.001*(TT1(2)/10-TT1(1)); axis(TT1)
 set(gca,'XTickMode','auto'), drawnow
elseif typ==28
 axis(TT), drawnow
elseif typ==31
 for kk=2:11, set(pbs(kk),'Enable','off'), end
 set(pbs(12),'Visible','off')
 set(pbs(20),'String',mx1,'Visible','on')
end
% --- last line of deftfaux ---
