function deftf(arg1,arg2,arg3,arg4)
%DEFTF	  Definizione di particolari funzioni di trasferimento (TFI).
%   DEFTF,gi - da TFI [DEFTF('gi') da Matlab] fornisce una delle seguenti
%   funzioni di trasferimento:
%      1.  Con qualunque mappa zeri-poli (introdotta con il mouse)
%      2.  Filtro di Bessel
%      3.  Filtro di Butterworth
%      4.  Approssimante di Pade' di exp(-to*s)
%   Tipo e parametri sono scelti in interattivo.
%   Nei casi 2 e 3 si puo' aggiungere in interattivo uno zero opportuno
%   per ottenere un modello di riferimento per un anello di regolazione
%   di tipo 2. Se DEFTF viene chiamato senza alcun argomento, la f.d.t.
%   gi puo' essere specificata in interattivo.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global NPKK HALEG

NPKK=0; HALEG=[]; aA=setstr(224);
flg2=0;
if nargin==0
 flg=0;
 while flg==0
  gi=input('\n   specificare la funzione di trasferimento : ','s');
  if ~isempty(gi)
   if gi=='0', return, end
   flg=1;
  end
 end
else
 gi=arg1;
end
flg1=0; clc
while flg1==0
 fprintf('\n   1) Definire una mappa zeri-poli con il mouse')
 fprintf('\n   2) Filtro di Bessel\n   3) Filtro di Butterworth\n')
 fprintf(['   4) Approssimante di Pad',setstr(233),' di ritardo finito\n'])
 flg=input('\n   operare una scelta (premere invio per uscire) : ');
 if isempty(flg), return, end
 if flg==0, return, end
 if ((flg==1)|(flg==2)|(flg==3)|(flg==4)), flg1=1; end
end
menupointer=[4,1,2,3]; flg=menupointer(flg);
if flg==4
 call=['deftfmou(''',gi,''')'];
 eval(call), return
end
flg1=0;
if flg==1 | flg==2
 while flg1==0
  n=input('\n   ordine del denominatore : ');
  if length(n)~=0 & n>0, flg1=1; end
 end
 while flg1==1
  on=input('\n   pulsazione di rottura : ');
  if length(on)~=0 & on>0, flg1=2; end
 end
 if flg==1
  den=fbessel(on,n);
 else
  den=fbutter(on,n);
 end
 num=1; den(length(den))=1;
 [z1,p1,k1]=tozpk(num,den); p1=[p1;0];
 figure, ordf(2), nfig=gcf; nfigs=int2str(nfig);
 uimenu(gcf,'Label','Reticolo on/off','Callback','grid');
 [y,t]=trespc(z1,p1,k1,'g'); MM=max(y); TT=axis; TT(3)=0; TT(4)=1;
 while MM>=TT(4)
  TT(4)=TT(4)+.2;
 end
 axis(TT), ytick=0:.2:TT(4); set(gca,'Ytick',ytick), drawnow
 title(['la risposta al gradino di ',gi])
 xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
 flg2=input('\n   definire un modello per un sistema di tipo 2 ? (1) : ');
 if isempty(flg2), flg2=4; end
 if flg2==1
  num1=num; den1=den;
  flg3=1;
  while flg3==1
   disp(' ')
   fprintf(['   si inserir',aA,' uno zero e l''ordine'])
   fprintf([' verr',aA,' aumentato di 1\n'])
   flg1=0;
   while flg1==0
    fprintf('   alfa riduce la sovraelongazione e ritarda l''assestamento')
    alpha=input('\n   specificare un valore per alfa (da 1 a 100) : ');
    if isempty(alpha), alpha=0; end
    if (alpha>=1)&(alpha<=100), flg1=1; end
   end
   num=[(den1(n)+alpha/on),1];
   den=conv(den1,[alpha/on,1]);
   [z1,p1,k1]=tozpk(num,den); p1=[p1;0];
   figure(nfig), hold on
   [y,t]=trespc(z1,p1,k1,'c'); MM=max(y);
   while MM>=TT(4)
    TT(4)=TT(4)+.2; ytick=[ytick,TT(4)];
   end
   axis(TT), set(gca,'Ytick',ytick), drawnow, hold off
   xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
   flg3=input('\n   cambiare il valore di alfa ? (1) : ');
   if isempty(flg3), flg3=4; end
   if flg3==0, return, end
  end
 end
else
 while flg1==0
  q=input('\n   ordine del denominatore : ');
  if length(q)~=0 & q>0, flg1=1; end
 end
 while flg1==1
  p=input('\n   ordine del numeratore (default come il denominatore) : ');
  if length(p)==0, p=q; end
  if p>=0, flg1=2; end
 end
 while flg1==2
  to=input('\n   ritardo (sec) : ');
  if length(to)~=0 & to>0, flg1=3; end
 end
 [num,den]=fpade(to,p,q);
 [z1,p1,k1]=tozpk(num,den); p1=[p1;0];
 figure, ordf(2), nfig=gcf; nfigs=int2str(nfig);
 uimenu(gcf,'Label','Reticolo on/off','Callback','grid');
 [y,t]=trespc(z1,p1,k1,'g'); TT=axis;
 axis(TT), drawnow
 title(['la risposta al gradino di ',gi])
 xyx=input(['\n   **** figura ',nfigs,' **** '],'s');
end
delete(nfig)
num=num/den(1); Denc=den/den(1); kc=num(1); Numc=num/kc;
if flg2==1, Denc(n+1)=kc*Numc(1); Denc(n+2)=kc*Numc(2); end
aa=stf(Numc,Denc,kc,'s',gi);
if aa==1, tfg(gi), end
% --- last line of deftf ---
