function [out1,out2,out3]=cvtxz(arg1,arg2,arg3,arg4,arg5,arg6)
%CVTXZ	  Converts from continuous to discrete-time systems.
%   Possible uses:
%   [numd,dend] = CVTXZ(num,den,T,t0,typ)
%   [zd,pd,Kd]= CVTXZ(z,p,k,T,t0,typ) (preferred for multiple poles)
%   T denotes the sampling time, t0 a possible finite delay exp(-t0*s)
%   (set t0=0 if there is no delay), while typ is an integer specifying
%   the type of conversion:
%     1 - Z-transform of the sampled inverse L-transform;
%     2 - zero-order hold equivalence;
%     3 - first-order hold equivalence.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin;
error(nargchk(5,6,nargs));
tol=10^(-8);
%
if nargs==5
 num=arg1; den=arg2; T=arg3; t0=arg4; typ=arg5;
 [z,p,k]=tozpk(num,den);
else
 z=arg1; p=arg2; k=arg3; T=arg4; t0=arg5; typ=arg6;
end
%
if T<=0
 disp('   illegal sampling time in cvt'), return
end
%
flg=typ;
if (flg<1)|(flg>3)
 disp('   illegal flag in cvt'), return
end
%
kh=0;
if t0~=0
 while t0>=T
  t0=t0-T;
  kh=kh+1;
 end
end
if abs(t0)<tol, t0=0; end
%
if flg==2
 p=[p;0];
elseif flg==3
 z=[z;-1/T]; p=[p;0;0];
end
%
[a1,b1,c1,d1]=jorcf(z,p,k);
%
if flg==1 & d1~=0
 disp('   not a purely dynamical system in cvt with option 1'), return
end
n=length(a1);
ad=expm(a1*T);
if t0==0
 bd=ad*b1; cd=c1; dd=c1*b1;
else
 bd=expm(a1*(T-t0))*b1; cd=c1; dd=0;
end
a6=ad; b6=bd; c6=cd; d6=dd;
n6=length(a6);
if n6==0
 nu6=0; de6=1;
else
 de6=poly(a6);
 nu6=ones(1,n6+1);
 nu6=poly(a6-b6*c6)+(d6-1)*de6;
 m6=length(nu6);
 tol=eps*norm(nu6,'fro')*10^6;
 for k6=1:m6
  if abs(nu6(k6))<tol
   nu6(k6)=0;
  end
 end
 k6=1;
 rop=(nu6(k6)==0)&(k6<m6);
 while rop
  k6=k6+1;
  rop=(nu6(k6)==0)&(k6<m6);
 end
 nu6=nu6(k6:m6);
end
numd=nu6; dend=de6;
%
[zd,pd,kd]=tozpk(numd,dend);
pd=eig(ad);
tol1=10^(-4);
[egv,mul]=makest(pd,tol1,0);
% Builds the conjugate eigenvalues
ii=find(abs(imag(egv))>0);
egv=[egv conj(egv(ii))]; mul=[mul mul(ii)];
egvp=egv; mulp=mul;
vv=[];
for i1=1:length(mulp)
 for i2=1:mulp(i1)
  if imag(egvp(i1))==0
   vv=[vv;egvp(i1)];
  elseif imag(egvp(i1))>0
   vv=[vv;egvp(i1);conj(egvp(i1))];
  end
 end
end
pd=vv;
if flg==2
 zd=[zd;1]; pd=[pd;0];
elseif flg==3
 zd=[zd;1;1]; pd=[pd;0;0];
end
while kh>0
 pd=[pd;0];
 kh=kh-1;
end
%   elimination of common zeros and poles
md=length(zd); nd=length(pd);
iz=ones(md,1); ip=ones(nd,1);
for kk=1:md
 for kh=1:nd
  if (abs(zd(kk)-pd(kh))<=tol)&(ip(kh)~=0)
   iz(kk)=0; ip(kh)=0; break
  end
 end
end
zd=zd(find(iz)); pd=pd(find(ip));
if nargs==5
 dend=real(poly(pd)); numd=kd*(real(poly(zd)));
 out1=numd; out2=dend; out3=1;
else
 out1=zd; out2=pd; out3=kd;
end
% --- last line of cvtxz ---
