function convert(arg1,arg2,arg3,arg4)
%CONVERT  Conversione da tempo continuo a tempo discreto (TFI).
%    CONVERT,gi,gj - da TFI [CONVERT('gi,'gj') - da Matlab] converte
%    la funzione di trasferimento a tempo continuo gi alla funzione
%    di trasferimento a tempo discreto gj. Possibili opzioni:
%      1 - Z-trasformata della antitrasformata di Laplace campionata
%      2 - dispositivo di tenuta di ordine zero
%      3 - dispositivo di tenuta di ordine uno
%    In ogni caso si puo' tener conto anche di un ritardo finito.
%    Se CONVERT viene chiamato senza alcun argomento, le f.d.t. gi e gj
%    possono essere specificate in interattivo.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

aA=setstr(224); eA=setstr(232);
if nargin==0
 flg=0;
 while flg==0
  gi=input('\n   funzione di trasferimento gi (ingresso) : ','s');
  if ~isempty(gi)
   if gi=='0', return, end
   if ~exist([gi,'.mat'])
    disp([' **** errore: ',gi,'.mat non esiste'])
   else
    flg=1;
   end
  end
 end
 while flg==1
  gj=input('\n   funzione di trasferimento gj (uscita) : ','s');
  if ~isempty(gj)
   if gj=='0', return, end
   flg=2;
  end
 end
elseif nargin>=2
 if ~exist([arg1,'.mat'])
  disp([' **** errore: ',arg1,'.mat non esiste']), return
 else
  gi=arg1; gj=arg2;
 end
else
 disp(' **** errore: numero di argomenti non sufficiente'), return
end
[z,p,k,str]=exportf(gi,1); if isempty(k), return, end
if length(z)>length(p)
 disp([' **** errore: m > n in ',gi]), return
end
if str=='s'
 flg=0;
 while (flg~=1)&(flg~=2)&(flg~=3)
  disp(' ')
  disp('   1 - Z-trasformata dell''antitrasformata di Laplace campionata')
  disp('   2 - conversione con tenuta di ordine zero')
  disp('   3 - conversione con tenuta di ordine uno')
  flg=input('\n   operare una scelta : ');
  if isempty(flg), flg=4; end
  if flg==0, return, end
 end
 flg1=1;
 while flg1==1
  t0=input('\n   specificare un ritardo finito (default zero) : '); flg1=0;
  if length(t0)==0
   t0=0;
  elseif t0<0
   disp(' **** errore: ritardo negativo'), flg1=1;
  end
 end
 T=lsamp;
 fprintf('\n   conversione da tempo continuo a tempo discreto;\n')
 fprintf(['   il tempo di campionamento ',eA,' %.4g sec\n'],T)
 fprintf(['   il ritardo finito ',eA,' %.4g'],t0)
 if t0>0, fprintf(' sec\n'), else, fprintf('\n'), end
 if (length(z)==length(p))&(flg==1)
  disp([' **** errore: m = n in ',gi,' con l''opzione 1']), return
 end
 [zd,pd,kd]=cvtxz(z,p,k,T,t0,flg);
 aa=importf(zd,pd,kd,gj,1);
 if aa==1, tfg(gj), end
else
 disp(' ')
 disp([' **** attenzione: il sistema ',eA,' gi',aA,' a tempo discreto'])
 tfg(gi)
end
% --- last line of convert ---
