% Transfer Function Interpreter in Italian.
% Version 3.2  22-Jan-1998
% Copyright (c) 1994 by Zanichelli, Bologna, Italy
%
% NOTA: TFI non richiede Control Toolbox.
%
% Abbreviazioni:
% (TFI) Funzioni accessibili dall'Interprete di Funzioni di Trasferimento;
% (MTL) Funzioni accessibili solo da Matlab.
%
% ELENCO ALFABETICO DELLE FUNZIONI ACCESSIBILI DALL'AMBIENTE TFI
%
%    con[vert] : conversione da tempo continuo a tempo discreto
%    defa[ctf],gi,gj : passaggio dalla forma fattorizzata alla polinomiale
%    deft[f],gi : definizione di funzioni di trasferimento
%    delf : cancellazione di tutte le figure
%    des[crf] : analisi con la funzione descrittiva
%    fac[tf],gi,gj : fattorizzazione di una funzione di trasferimento
%    fre[sp],gi : risposta in frequenza (sei opzioni)
%    gpm[arg],gi : margini di ampiezza e fase
%    inv[tr],gi : antitrasformata di Laplace o Z
%    lag[c],gi,gj : rete ritardatrice
%    lea[dc],gi,gj : rete anticipatrice
%    mak[eleg]: creazione o perfezionamento di una legenda
%    nls[im],gi,gj,gk : simulazione di sistema non lineare
%    ord[f] : ordinamento di tutte le figure
%    per[ftra],gi,gj,gk,gw : compensatore digitale per inseguimento perfetto
%    pidc,gi,gj : regolatore PID a tempo continuo
%    pidd,gi,gj : regolatore PID a tempo discreto
%    pidn[ich] : regolatore PD, PI o PID con il diagramma di Nichols
%    regd[ph],gi,gj,gk,gw : allocazione dei poli con l'equazione diofantea
%    regn[ich] : rete anticipatrice o ritardatrice con il diagramma di Nichols
%    regr[ootl]: progetto di regolatore con il luogo delle radici
%    res[figlo]: azzeramento delle posizioni delle figure ai valori di default
%    rob[par],gi,gj,gk,[gw] : analisi di robustezza parametrica
%    roo[tl],gi : luogo delle radici
%    rou[th],gi : intervalli di stabilita' con il criterio di Routh
%    sam[ptime],T : definizione del tempo di campionamento corrente
%    sel[ect],gi,gj : scelta di fattori di una funzione di trasferimento
%    sta[rtint] : configurazione di TFI
%    tfe[val],gi : valutazione di una funzione di trasferimento
%    tre[sp],gi : risposta nel tempo (quattro opzioni)
%    wpl[ane],gi,gj : conversione al piano w e viceversa
%    zpp[lots],gi[,gj,gk,gw] : mappa zeri-poli
%
% Le parentesi quadre specificano la parte opzionale della chiamata.
%
% ELENCO DELLE FUNZIONI DELLA DIRECTORY INTPI
%
% Interfaccia:
%   exportf    - Converte le fdt da TFI a Matlab (MTL).
%   importf    - Converte le fdt da Matlab a TFI (MTL).
%   exportf1   - Converte le fdt di TFI agli LTI systems di Matlab (MTL).
%   importf1   - Converte gli LTI systems di Matlab alle fdt di TFI (MTL).
%
% Elaborazione di funzioni di trasferimento:
%   defactf    - Defattorizza una funzione di trasferimento (TFI).
%   factf      - Fattorizza una funzione di trasferimento (TFI).
%   invtr      - Antitrasformazione, di Laplace e Z (TFI).
%   select     - Seleziona fattori di una funzione di trasferimento (TFI).
%   tfeval     - Valuta una funzione di trasferimento (TFI).
%   zpplots    - Traccia la mappa zeri-poli di una funzione di trasf. (TFI).
%
% Generazione di funzioni di trasferimento:
%   deftf      - Definizione con mouse o di Bessel, Butterworth, Pade' (TFI).
%
% Risposta nel tempo:
%   tresp      - Risposta nel tempo, con comandi in interattivo (TFI).
%
% Risposta in frequenza:
%   fresp      - Risposta in frequenza, con comandi in interattivo (TFI).
%   gpmarg     - Margini di ampiezza e fase generalizzati (TFI).
%
% Luogo delle radici
%   rootl      - Luogo delle radici, con comandi interattivo (TFI).
%
% Conversione da tempo continuo a tempo discreto e viceversa:
%   convert    - Conversione da tempo continuo a tempo discreto (TFI).
%   wplane     - Conversione al piano w, diretta e inversa (TFI).
%
% Criterio di Routh:
%   routh      - Intervalli di stabilita' con il criterio di Routh (TFI).
%
% Sintesi di reti corretrici e regolatori:
%   lagc       - Sintesi di rete ritardatrice (TFI e MTL).
%   leadc      - Sintesi di rete anticipatrice (TFI e MTL).
%   perftra    - Unita' di preazione per inseguimento perf. (TFI and MTL).
%   pidc       - Sintesi di regolatore PID (TFI e MTL).
%   pidd       - Sintesi di regolatore PID a tempo discreto (TFI e MTL).
%   pidnich    - Sintesi di regolatori con diagr. di Nichols (TFI e MTL).
%   regdph     - Sintesi di regolatori con l'equaz. diofantea (TFI e MTL).
%   regnich    - Sintesi di reti corret. con diagr. di Nichols (TFI e MTL).
%   regrootl   - Sintesi di regolatori con il luogo delle radici (TFI e MTL).
%
% Analisi di sistemi non lineari:
%   descrf     - Analisi con la funzione descrittiva (TFI).
%   nlsim      - Simulazione di un sistema in retroaz. non lineare (TFI).
%
% Analisi di robustezza:
%   robpar     - Analisi di robustezza parametrica (TFI).
%
% Cambiamento di configurazioni:
%   samptime   - Visualizza e/o cambia il tempo di campionamento (TFI).
%   startint   - Cambia alcune impostazioni specifiche di TFI (TFI).
%
% Programmi ausiliari (MTL):
%   asymga     - Approssimaz. asintotica del diagr. di Bode delle ampiezze.
%   asymph     - Approssimaz. asintotica del diagr. di Bode delle fasi.
%   bodec      - Diagr. di Bode in una sola figura, tempo continuo.
%   boded      - Diagr. di Bode in una sola figura, tempo discreto.
%   cobin      - Coefficiente bonimiale.
%   cvtxz      - Conversione da tempo continuo a tempo discreto.
%   dezpk      - Trasformazione da [z,p,k] a [num,den].
%   diopha     - Soluzione dell'equazione diofantea.
%   diwplane   - Conevrsione al piano w.
%   drgrid     - Luoghi a delta costante per sistemi a tempo discreto.
%   expgm      - Elevazione a potenza di funzione di trasferimento.
%   fact       - Fattoriale di un numero intero.
%   fbessel    - Funzione di trasferimento del filtro di Bessel.
%   fbutter    - Funzione di trasferimento del filtro di Butterworth.
%   fpade      - Approssimante di Pade' del ritardo finito.
%   frespc     - Risposta in frequenza senza interattivo, tempo continuo.
%   frespd     - Risposta in frequenza senza interattivo, tempo discreto.
%   invtrc     - Antitrasformazione di Laplace.
%   invtrd     - Antitrasformazione Z.
%   inwplane   - Conversione dal piano w.
%   jorcf      - Forma di Jordan reale di una funzione di trasferimento.
%   makeleg    - Crea o perfeziona una legenda.
%   nigrid     - Luoghi a M e N costanti per diagrammi di Nichols.
%   nygrid     - Luoghi a M e N costanti per diagrammi di Nyquist.
%   prodgm     - Prodotto/quoziente di due funzioni di trasferimento.
%   rgrid      - Luoghi a delta costante per sistemi a tempo continuo.
%   rootlc     - Luogo delle radici senza interattivo, tempo continuo.
%   rootld     - Luogo delle radici senza interattivo, tempo discreto.
%   routhc     - Intervalli di stabilita' secondo Routh, tempo continuo.
%   routhd     - Intervalli di stabilita' secondo Routh, tempo discreto.
%   sumgm      - Somma/differenza di due funzioni di trasferimento.
%   tfg        - Visualizzazione di fdt in forma TFI.
%   tfg1       - Visualizzazione di funzione di trasferimento parametrica.
%   tfm        - Visualizzazione di in forma Matlab.
%   trespc     - Risposta nel tempo senza interattivo, tempo continuo.
%   trespd     - Risposta nel tempo senza interattivo, tempo discreto.
%   tozpk      - Trasformazione da [num,den] a [z,p,k].
