function [out1,out2,out3,out4]=coltbl(col)
%COLTBL    Auxiliary file for plot and message color setting.
%    [colp,colm,sty]=COLTBL(col) (one-argument call)
%    col: original color & style string
%    tblp: RGB code for plots
%    tblm: RGB code for messages
%    sty: style of the plot.
%    [vcol1,vcol2,repco]=COLTBL (no-argument call)
%    vcol1: 9x3 matrix of all the colors for plots
%    vcol1: 9x3 matrix of all the colors for messages
%    repco: row vector with the reference letters of colors
%   **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

nargs=nargin; colbg=get(0,'DefaultAxesColor');
% the sequence of colors ('o'=orange)
repco=['g';'r';'c';'y';'m';'b';'w';'k';'o'];
repcos=['verde  ';'rosso  ';'celeste';'giallo ';'magenta';'blu    ';'bianco ';
'nero   ';'arancio'];
% modifying the sequence for white background
if colbg(1)==1
 repco(7,:)='k'; repco(8,:)='w';
 repcos(7,:)='nero   '; repcos(8,:)='bianco ';
end

A1=[0 1 0;
    1 0 0;
    0 1 1;
    1 1 0;
    1 0 1;
    0 0 1;
    1 1 1;
    0 0 0;
    1 .75 0];

A2=[0 1 0;
    1 .25 0;
    0 1 1;
    1 1 0;
    1 0 1;
    .3939 .6061 1;
    1 1 1;
    0 0 0;
    1 .75 0];

A3=[.143 .7 .143;
    1 .142 0;
    .190 .809 1;
    1 .809 .190;
    .936 .063 1;
    0 .302 .849;
    0 0 0;
    1 1 1;
    1 .6 0];

A4=A3;

if nargs==1
 lcol=length(col);
 if lcol==1
  cc=col; out3='-';
 else
  cc=col(1); out3=col(2:lcol);
 end
 if any(repco==cc)==0
  disp(' **** illegal color string in coltbl input'), return
 else
  ii=find(repco==cc);
 end
 if colbg(1)==0
  out1=A1(ii,:); out2=A2(ii,:);
 else
  out1=A3(ii,:); out2=A4(ii,:);
 end
 out4=repcos(ii,:);
else
 out3=repco; out4=repcos;
 if colbg(1)==0
  out1=A1; out2=A2;
 else
  out1=A3; out2=A4;
 end
end
% --- last line of coltbl ---
