function m=cobin(k,n)
%COBIN	  Binomial coefficient.
%   m = COBIN(k,n) provides the binomial coefficient
%
%	    |  k (k-1)...(k-n+1)       k!
%	    |  -----------------  = ---------	for k >= n , n > 0
%     k     |	      n!	    n! (k-n)!
%   (	) = <
%     n     |  1  for k >= n , n = 0
%	    |
%	    |  0  for k < n
%
%   n is necessarily nonnegative.

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

k=fix(k);
n=fix(n);
if n < 0
 error(' n negative in a binomial coefficient');
end
if k < n
 m=0;
else
 if n==0
  m=1;
 else
  m=fact(k)/(fact(n)*fact(k-n));
 end
end
% --- last line of cobin ---
