function ccregaux(typ,nmb,pos,arg4)
%CCREGAUX  Auxiliary file for management of regulator synthesis programs
%   typ=1:leadc; typ=2:lagc; typ=3:pidc; typ=4:pidd;
%   typ=5,7:pidnich; typ=6,8:regnich & regrootl.
%   nmb: number of the transfer function referred to.
%   pos: vertical position od the message in absolute units.
%    **** MODIFIED FOR THE ITALIAN VERSION OF TFI

% TFI Environment (A.Civolani & G.Marro) - 1994-96. Matlab5 version, 1997.

global stknum1 stkden1 stkkc stktaui stktaud repco flpo TT TT1 stkn1 stkd1...
 stkn2 stkd2 stkn3 stkd3 stkn4 stkd4 stkn5 stkd5 stkn6 stkd6 stkn7 stkd7 gj

if nargin<=3, str='s'; else, str='z'; end
VFULL=get(0,'ScreenSize'); % VFULL is a [1 times 4] matrix
if VFULL(3)>700, xx1=.04; else, xx1=-.1; end
RR=1;
%
if typ==1
 num1=stknum1(nmb,:); den1=stkden1(nmb,:);
 tau=num1(1); alpha=den1(1)/tau;
 txt=sprintf('   alfa = %.4g , tau = %.4g sec\n',alpha,tau);
elseif typ==2
 num1=stknum1(nmb,:); den1=stkden1(nmb,:);
 tau=den1(1); alpha=num1(1)/tau;
 txt=sprintf('   alfa = %.4g , tau = %.4g sec\n',alpha,tau);
elseif typ==3
 kc=stkkc(nmb); taui=stktaui(nmb); taud=stktaud(nmb);
 txt=sprintf('   Kc = %.4g',kc);
 if flpo==0
  txt=[txt,sprintf(', Ti = %.4g',taui)];
 end
 txt=[txt,sprintf(', Td = %.4g',taud)];
elseif typ==4
 kc=stkkc(nmb); taui=stktaui(nmb); taud=stktaud(nmb);
 txt=sprintf('   Kc = %.4g',kc);
 if flpo==0
  txt=[txt,sprintf(', Ti = %.4g',taui)];
 end
 txt=[txt,sprintf(', Td = %.4g',taud)];
end
if (typ==5)|(typ==7)
 kc=stkkc(nmb); taui=stktaui(nmb); taud=stktaud(nmb);
 txt=sprintf('   Kc = %.4g',kc);
 if ~isnan(taui)
  txt=[txt,sprintf(', Ti = %.4g',taui)];
 end
 if ~isnan(taud)
  txt=[txt,sprintf(', Td = %.4g',taud)];
 end
 if isnan(taud)
  numc=kc*[taui 1]; denc=[taui 0];
  if ~isfinite(taui), numc=kc; denc=1; end
 elseif isnan(taui)
  numc=kc*[taud 1]; denc=1;
 else
  numc=kc*[taud*taui taui 1]; denc=[taui 0];
 end
 if typ==7, subplot(2,1,1), RR=2.2; end
end
if (typ==6)|(typ==8)
 eval(['numc=stkn',int2str(nmb),';'])
 eval(['denc=stkd',int2str(nmb),';'])
 if typ==8, subplot(2,1,1), RR=2.2; end
end
if (typ>=1)&(typ<=8)
 cc=repco(nmb);
%  color correction table
 [tp1,tbl,tp2]=coltbl(cc);
 if (typ<=4)|(typ==5)|(typ==7)
  hh=text(xx1,pos,txt,'Units','normalized','FontName','Fixedsys');
  set(hh,'Color',tbl,'Interpreter','none');
  if (typ~=5)&(typ~=7), xy=waitforbuttonpress; delete(hh), end
 end
 if (typ>=5)&(typ<=8)
  [z,p,k]=tozpk(numc,denc);
  if (typ==5)|(typ==7), pos1=pos+.04*RR; else, pos1=pos; end
  if str=='s'
%   eval('tt=tfmg(z,p,k,gj,''1'');') % time-constant
   eval('tt=tfmg(z,p,k,gj);')       % pole-zero
  else
%   eval('tt=tfmg(z,p,k,gj,''1'',1);') % time-constant
   eval('tt=tfmg(z,p,k,gj,1);') % pole-zero
  end
  nr=length(find(tt=='|'))+1;
  xx=[]; yy=[]; ud=1;
  for kk=1:nr
   if ud==1
    xx=[xx;xx1]; yy=[yy;pos1+.04*RR*nr-.04*RR*kk];
   else
    xx=[xx;xx1]; yy=[yy;pos1+.04*RR-.04*RR*kk];
   end
  end
  hh1=text(xx,yy,tt,'Units','normalized','FontName','Fixedsys');
  for kk=1:nr
   set(hh1(kk),'Color',tbl,'Interpreter','none')
  end
  xy=waitforbuttonpress;
  if (typ==5)|(typ==7), delete(hh), end
  for kk=1:nr
   delete(hh1(kk));
  end
 end
end
if typ==11
 TTX=TT; TTX(2)=TTX(2)/2+.001*(TTX(2)/2-TTX(1)); axis(TTX)
 set(gca,'XTickMode','auto'), drawnow
elseif typ==12
 TTX=TT; TTX(2)=TTX(2)/5+.001*(TTX(2)/5-TTX(1)); axis(TTX)
 set(gca,'XTickMode','auto'), drawnow
elseif typ==13
 TTX=TT; TTX(2)=TTX(2)/10+.001*(TTX(2)/10-TTX(1)); axis(TTX)
 set(gca,'XTickMode','auto'), drawnow
elseif typ==14
 TTX=TT; TTX(2)=TTX(2)+.001*(TTX(2)-TTX(1)); axis(TTX), drawnow
elseif typ==15
 TTY=TT1; TTY(2)=TTY(2)/2+.001*(TTY(2)/2-TTY(1)); axis(TTY)
 set(gca,'XTickMode','auto'), drawnow
elseif typ==16
 TTY=TT1; TTY(2)=TTY(2)/5+.001*(TTY(2)/5-TTY(1)); axis(TTY)
 set(gca,'XTickMode','auto'), drawnow
elseif typ==17
 TTY=TT1; TTY(2)=TTY(2)/10+.001*(TTY(2)/10-TTY(1)); axis(TTY)
 set(gca,'XTickMode','auto'), drawnow
elseif typ==18
 TTY=TT1; TTY(2)=TTY(2)+.001*(TTY(2)-TTY(1)); axis(TTY), drawnow
end
% --- last line of ccregaux ---
